<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Item_Attribute_Group_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Expense Item Attribute Group data
 * @subpackage Structs
 */
class Expense_Item_Attribute_Group_DataType extends AbstractStructBase
{
    /**
     * The Expense_Item_Attribute_Group_ID
     * Meta information extracted from the WSDL
     * - documentation: Expense Item Attribute Group ID. This is the Expense Item Attribute Group unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Item_Attribute_Group_ID;
    /**
     * The Expense_Item_Attribute_Group_Name
     * Meta information extracted from the WSDL
     * - documentation: Free form text for a meaningful Expense Item Attribute Group Name
     * - maxOccurs: 1
     * @var string
     */
    public $Expense_Item_Attribute_Group_Name;
    /**
     * The Airline_Reference
     * Meta information extracted from the WSDL
     * - documentation: Airline Reference for an Expense Item Attribute Group
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirlineObjectType[]
     */
    public $Airline_Reference;
    /**
     * The Airport_Reference
     * Meta information extracted from the WSDL
     * - documentation: Airport Reference for an Expense Item Attribute Group
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirportObjectType[]
     */
    public $Airport_Reference;
    /**
     * The Car_Rental_Agency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Car Rental Agency Reference for an Expense Item Attribute Group
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Car_Rental_AgencyObjectType[]
     */
    public $Car_Rental_Agency_Reference;
    /**
     * The Hotel_Reference
     * Meta information extracted from the WSDL
     * - documentation: Hotel Reference for an Expense Item Attribute Group
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelObjectType[]
     */
    public $Hotel_Reference;
    /**
     * The Travel_City_Reference
     * Meta information extracted from the WSDL
     * - documentation: Travel City Reference for an Expense Item Attribute Group
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Travel_CityObjectType[]
     */
    public $Travel_City_Reference;
    /**
     * Constructor method for Expense_Item_Attribute_Group_DataType
     * @uses Expense_Item_Attribute_Group_DataType::setExpense_Item_Attribute_Group_ID()
     * @uses Expense_Item_Attribute_Group_DataType::setExpense_Item_Attribute_Group_Name()
     * @uses Expense_Item_Attribute_Group_DataType::setAirline_Reference()
     * @uses Expense_Item_Attribute_Group_DataType::setAirport_Reference()
     * @uses Expense_Item_Attribute_Group_DataType::setCar_Rental_Agency_Reference()
     * @uses Expense_Item_Attribute_Group_DataType::setHotel_Reference()
     * @uses Expense_Item_Attribute_Group_DataType::setTravel_City_Reference()
     * @param string $expense_Item_Attribute_Group_ID
     * @param string $expense_Item_Attribute_Group_Name
     * @param \StructType\AirlineObjectType[] $airline_Reference
     * @param \StructType\AirportObjectType[] $airport_Reference
     * @param \StructType\Car_Rental_AgencyObjectType[] $car_Rental_Agency_Reference
     * @param \StructType\HotelObjectType[] $hotel_Reference
     * @param \StructType\Travel_CityObjectType[] $travel_City_Reference
     */
    public function __construct($expense_Item_Attribute_Group_ID = null, $expense_Item_Attribute_Group_Name = null, array $airline_Reference = array(), array $airport_Reference = array(), array $car_Rental_Agency_Reference = array(), array $hotel_Reference = array(), array $travel_City_Reference = array())
    {
        $this
            ->setExpense_Item_Attribute_Group_ID($expense_Item_Attribute_Group_ID)
            ->setExpense_Item_Attribute_Group_Name($expense_Item_Attribute_Group_Name)
            ->setAirline_Reference($airline_Reference)
            ->setAirport_Reference($airport_Reference)
            ->setCar_Rental_Agency_Reference($car_Rental_Agency_Reference)
            ->setHotel_Reference($hotel_Reference)
            ->setTravel_City_Reference($travel_City_Reference);
    }
    /**
     * Get Expense_Item_Attribute_Group_ID value
     * @return string|null
     */
    public function getExpense_Item_Attribute_Group_ID()
    {
        return $this->Expense_Item_Attribute_Group_ID;
    }
    /**
     * Set Expense_Item_Attribute_Group_ID value
     * @param string $expense_Item_Attribute_Group_ID
     * @return \StructType\Expense_Item_Attribute_Group_DataType
     */
    public function setExpense_Item_Attribute_Group_ID($expense_Item_Attribute_Group_ID = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Item_Attribute_Group_ID) && !is_string($expense_Item_Attribute_Group_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Item_Attribute_Group_ID, true), gettype($expense_Item_Attribute_Group_ID)), __LINE__);
        }
        $this->Expense_Item_Attribute_Group_ID = $expense_Item_Attribute_Group_ID;
        return $this;
    }
    /**
     * Get Expense_Item_Attribute_Group_Name value
     * @return string|null
     */
    public function getExpense_Item_Attribute_Group_Name()
    {
        return $this->Expense_Item_Attribute_Group_Name;
    }
    /**
     * Set Expense_Item_Attribute_Group_Name value
     * @param string $expense_Item_Attribute_Group_Name
     * @return \StructType\Expense_Item_Attribute_Group_DataType
     */
    public function setExpense_Item_Attribute_Group_Name($expense_Item_Attribute_Group_Name = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Item_Attribute_Group_Name) && !is_string($expense_Item_Attribute_Group_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Item_Attribute_Group_Name, true), gettype($expense_Item_Attribute_Group_Name)), __LINE__);
        }
        $this->Expense_Item_Attribute_Group_Name = $expense_Item_Attribute_Group_Name;
        return $this;
    }
    /**
     * Get Airline_Reference value
     * @return \StructType\AirlineObjectType[]|null
     */
    public function getAirline_Reference()
    {
        return $this->Airline_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAirline_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirline_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirline_ReferenceForArrayConstraintsFromSetAirline_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_Attribute_Group_DataTypeAirline_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Item_Attribute_Group_DataTypeAirline_ReferenceItem instanceof \StructType\AirlineObjectType) {
                $invalidValues[] = is_object($expense_Item_Attribute_Group_DataTypeAirline_ReferenceItem) ? get_class($expense_Item_Attribute_Group_DataTypeAirline_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Item_Attribute_Group_DataTypeAirline_ReferenceItem), var_export($expense_Item_Attribute_Group_DataTypeAirline_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Airline_Reference property can only contain items of type \StructType\AirlineObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Airline_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineObjectType[] $airline_Reference
     * @return \StructType\Expense_Item_Attribute_Group_DataType
     */
    public function setAirline_Reference(array $airline_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($airline_ReferenceArrayErrorMessage = self::validateAirline_ReferenceForArrayConstraintsFromSetAirline_Reference($airline_Reference))) {
            throw new \InvalidArgumentException($airline_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Airline_Reference = $airline_Reference;
        return $this;
    }
    /**
     * Add item to Airline_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\AirlineObjectType $item
     * @return \StructType\Expense_Item_Attribute_Group_DataType
     */
    public function addToAirline_Reference(\StructType\AirlineObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirlineObjectType) {
            throw new \InvalidArgumentException(sprintf('The Airline_Reference property can only contain items of type \StructType\AirlineObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Airline_Reference[] = $item;
        return $this;
    }
    /**
     * Get Airport_Reference value
     * @return \StructType\AirportObjectType[]|null
     */
    public function getAirport_Reference()
    {
        return $this->Airport_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAirport_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirport_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirport_ReferenceForArrayConstraintsFromSetAirport_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_Attribute_Group_DataTypeAirport_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Item_Attribute_Group_DataTypeAirport_ReferenceItem instanceof \StructType\AirportObjectType) {
                $invalidValues[] = is_object($expense_Item_Attribute_Group_DataTypeAirport_ReferenceItem) ? get_class($expense_Item_Attribute_Group_DataTypeAirport_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Item_Attribute_Group_DataTypeAirport_ReferenceItem), var_export($expense_Item_Attribute_Group_DataTypeAirport_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Airport_Reference property can only contain items of type \StructType\AirportObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Airport_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\AirportObjectType[] $airport_Reference
     * @return \StructType\Expense_Item_Attribute_Group_DataType
     */
    public function setAirport_Reference(array $airport_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($airport_ReferenceArrayErrorMessage = self::validateAirport_ReferenceForArrayConstraintsFromSetAirport_Reference($airport_Reference))) {
            throw new \InvalidArgumentException($airport_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Airport_Reference = $airport_Reference;
        return $this;
    }
    /**
     * Add item to Airport_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\AirportObjectType $item
     * @return \StructType\Expense_Item_Attribute_Group_DataType
     */
    public function addToAirport_Reference(\StructType\AirportObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirportObjectType) {
            throw new \InvalidArgumentException(sprintf('The Airport_Reference property can only contain items of type \StructType\AirportObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Airport_Reference[] = $item;
        return $this;
    }
    /**
     * Get Car_Rental_Agency_Reference value
     * @return \StructType\Car_Rental_AgencyObjectType[]|null
     */
    public function getCar_Rental_Agency_Reference()
    {
        return $this->Car_Rental_Agency_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCar_Rental_Agency_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCar_Rental_Agency_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCar_Rental_Agency_ReferenceForArrayConstraintsFromSetCar_Rental_Agency_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_Attribute_Group_DataTypeCar_Rental_Agency_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Item_Attribute_Group_DataTypeCar_Rental_Agency_ReferenceItem instanceof \StructType\Car_Rental_AgencyObjectType) {
                $invalidValues[] = is_object($expense_Item_Attribute_Group_DataTypeCar_Rental_Agency_ReferenceItem) ? get_class($expense_Item_Attribute_Group_DataTypeCar_Rental_Agency_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Item_Attribute_Group_DataTypeCar_Rental_Agency_ReferenceItem), var_export($expense_Item_Attribute_Group_DataTypeCar_Rental_Agency_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Car_Rental_Agency_Reference property can only contain items of type \StructType\Car_Rental_AgencyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Car_Rental_Agency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Car_Rental_AgencyObjectType[] $car_Rental_Agency_Reference
     * @return \StructType\Expense_Item_Attribute_Group_DataType
     */
    public function setCar_Rental_Agency_Reference(array $car_Rental_Agency_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($car_Rental_Agency_ReferenceArrayErrorMessage = self::validateCar_Rental_Agency_ReferenceForArrayConstraintsFromSetCar_Rental_Agency_Reference($car_Rental_Agency_Reference))) {
            throw new \InvalidArgumentException($car_Rental_Agency_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Car_Rental_Agency_Reference = $car_Rental_Agency_Reference;
        return $this;
    }
    /**
     * Add item to Car_Rental_Agency_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Car_Rental_AgencyObjectType $item
     * @return \StructType\Expense_Item_Attribute_Group_DataType
     */
    public function addToCar_Rental_Agency_Reference(\StructType\Car_Rental_AgencyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Car_Rental_AgencyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Car_Rental_Agency_Reference property can only contain items of type \StructType\Car_Rental_AgencyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Car_Rental_Agency_Reference[] = $item;
        return $this;
    }
    /**
     * Get Hotel_Reference value
     * @return \StructType\HotelObjectType[]|null
     */
    public function getHotel_Reference()
    {
        return $this->Hotel_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setHotel_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotel_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotel_ReferenceForArrayConstraintsFromSetHotel_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_Attribute_Group_DataTypeHotel_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Item_Attribute_Group_DataTypeHotel_ReferenceItem instanceof \StructType\HotelObjectType) {
                $invalidValues[] = is_object($expense_Item_Attribute_Group_DataTypeHotel_ReferenceItem) ? get_class($expense_Item_Attribute_Group_DataTypeHotel_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Item_Attribute_Group_DataTypeHotel_ReferenceItem), var_export($expense_Item_Attribute_Group_DataTypeHotel_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Hotel_Reference property can only contain items of type \StructType\HotelObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Hotel_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelObjectType[] $hotel_Reference
     * @return \StructType\Expense_Item_Attribute_Group_DataType
     */
    public function setHotel_Reference(array $hotel_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($hotel_ReferenceArrayErrorMessage = self::validateHotel_ReferenceForArrayConstraintsFromSetHotel_Reference($hotel_Reference))) {
            throw new \InvalidArgumentException($hotel_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Hotel_Reference = $hotel_Reference;
        return $this;
    }
    /**
     * Add item to Hotel_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelObjectType $item
     * @return \StructType\Expense_Item_Attribute_Group_DataType
     */
    public function addToHotel_Reference(\StructType\HotelObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelObjectType) {
            throw new \InvalidArgumentException(sprintf('The Hotel_Reference property can only contain items of type \StructType\HotelObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Hotel_Reference[] = $item;
        return $this;
    }
    /**
     * Get Travel_City_Reference value
     * @return \StructType\Travel_CityObjectType[]|null
     */
    public function getTravel_City_Reference()
    {
        return $this->Travel_City_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setTravel_City_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravel_City_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravel_City_ReferenceForArrayConstraintsFromSetTravel_City_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_Attribute_Group_DataTypeTravel_City_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Item_Attribute_Group_DataTypeTravel_City_ReferenceItem instanceof \StructType\Travel_CityObjectType) {
                $invalidValues[] = is_object($expense_Item_Attribute_Group_DataTypeTravel_City_ReferenceItem) ? get_class($expense_Item_Attribute_Group_DataTypeTravel_City_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Item_Attribute_Group_DataTypeTravel_City_ReferenceItem), var_export($expense_Item_Attribute_Group_DataTypeTravel_City_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Travel_City_Reference property can only contain items of type \StructType\Travel_CityObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Travel_City_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_CityObjectType[] $travel_City_Reference
     * @return \StructType\Expense_Item_Attribute_Group_DataType
     */
    public function setTravel_City_Reference(array $travel_City_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($travel_City_ReferenceArrayErrorMessage = self::validateTravel_City_ReferenceForArrayConstraintsFromSetTravel_City_Reference($travel_City_Reference))) {
            throw new \InvalidArgumentException($travel_City_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Travel_City_Reference = $travel_City_Reference;
        return $this;
    }
    /**
     * Add item to Travel_City_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_CityObjectType $item
     * @return \StructType\Expense_Item_Attribute_Group_DataType
     */
    public function addToTravel_City_Reference(\StructType\Travel_CityObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Travel_CityObjectType) {
            throw new \InvalidArgumentException(sprintf('The Travel_City_Reference property can only contain items of type \StructType\Travel_CityObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Travel_City_Reference[] = $item;
        return $this;
    }
}
