<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Credit_Card_Transaction_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Expense Credit Card Transaction Reference element contains the specific instance set containing the requested Expense Credit Card Transaction.
 * @subpackage Structs
 */
class Expense_Credit_Card_Transaction_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Expense_Credit_Card_Transaction_Reference
     * Meta information extracted from the WSDL
     * - documentation: Instance set containing the Expense Credit Card Transaction object.
     * - maxOccurs: unbounded
     * @var \StructType\Credit_Card_TransactionObjectType[]
     */
    public $Expense_Credit_Card_Transaction_Reference;
    /**
     * Constructor method for Expense_Credit_Card_Transaction_Request_ReferencesType
     * @uses Expense_Credit_Card_Transaction_Request_ReferencesType::setExpense_Credit_Card_Transaction_Reference()
     * @param \StructType\Credit_Card_TransactionObjectType[] $expense_Credit_Card_Transaction_Reference
     */
    public function __construct(array $expense_Credit_Card_Transaction_Reference = array())
    {
        $this
            ->setExpense_Credit_Card_Transaction_Reference($expense_Credit_Card_Transaction_Reference);
    }
    /**
     * Get Expense_Credit_Card_Transaction_Reference value
     * @return \StructType\Credit_Card_TransactionObjectType[]|null
     */
    public function getExpense_Credit_Card_Transaction_Reference()
    {
        return $this->Expense_Credit_Card_Transaction_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Credit_Card_Transaction_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Credit_Card_Transaction_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Credit_Card_Transaction_ReferenceForArrayConstraintsFromSetExpense_Credit_Card_Transaction_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Credit_Card_Transaction_Request_ReferencesTypeExpense_Credit_Card_Transaction_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Credit_Card_Transaction_Request_ReferencesTypeExpense_Credit_Card_Transaction_ReferenceItem instanceof \StructType\Credit_Card_TransactionObjectType) {
                $invalidValues[] = is_object($expense_Credit_Card_Transaction_Request_ReferencesTypeExpense_Credit_Card_Transaction_ReferenceItem) ? get_class($expense_Credit_Card_Transaction_Request_ReferencesTypeExpense_Credit_Card_Transaction_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Credit_Card_Transaction_Request_ReferencesTypeExpense_Credit_Card_Transaction_ReferenceItem), var_export($expense_Credit_Card_Transaction_Request_ReferencesTypeExpense_Credit_Card_Transaction_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Credit_Card_Transaction_Reference property can only contain items of type \StructType\Credit_Card_TransactionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Credit_Card_Transaction_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card_TransactionObjectType[] $expense_Credit_Card_Transaction_Reference
     * @return \StructType\Expense_Credit_Card_Transaction_Request_ReferencesType
     */
    public function setExpense_Credit_Card_Transaction_Reference(array $expense_Credit_Card_Transaction_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Credit_Card_Transaction_ReferenceArrayErrorMessage = self::validateExpense_Credit_Card_Transaction_ReferenceForArrayConstraintsFromSetExpense_Credit_Card_Transaction_Reference($expense_Credit_Card_Transaction_Reference))) {
            throw new \InvalidArgumentException($expense_Credit_Card_Transaction_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Credit_Card_Transaction_Reference = $expense_Credit_Card_Transaction_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Credit_Card_Transaction_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card_TransactionObjectType $item
     * @return \StructType\Expense_Credit_Card_Transaction_Request_ReferencesType
     */
    public function addToExpense_Credit_Card_Transaction_Reference(\StructType\Credit_Card_TransactionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Credit_Card_TransactionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Credit_Card_Transaction_Reference property can only contain items of type \StructType\Credit_Card_TransactionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Credit_Card_Transaction_Reference[] = $item;
        return $this;
    }
}
