<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Company_Default_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Expense Company Default
 * @subpackage Structs
 */
class Expense_Company_Default_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Expense_Company_Default_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Company Default
     * - maxOccurs: unbounded
     * @var \StructType\CompanyObjectType[]
     */
    public $Expense_Company_Default_Reference;
    /**
     * Constructor method for Expense_Company_Default_Request_ReferencesType
     * @uses Expense_Company_Default_Request_ReferencesType::setExpense_Company_Default_Reference()
     * @param \StructType\CompanyObjectType[] $expense_Company_Default_Reference
     */
    public function __construct(array $expense_Company_Default_Reference = array())
    {
        $this
            ->setExpense_Company_Default_Reference($expense_Company_Default_Reference);
    }
    /**
     * Get Expense_Company_Default_Reference value
     * @return \StructType\CompanyObjectType[]|null
     */
    public function getExpense_Company_Default_Reference()
    {
        return $this->Expense_Company_Default_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Company_Default_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Company_Default_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Company_Default_ReferenceForArrayConstraintsFromSetExpense_Company_Default_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Company_Default_Request_ReferencesTypeExpense_Company_Default_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Company_Default_Request_ReferencesTypeExpense_Company_Default_ReferenceItem instanceof \StructType\CompanyObjectType) {
                $invalidValues[] = is_object($expense_Company_Default_Request_ReferencesTypeExpense_Company_Default_ReferenceItem) ? get_class($expense_Company_Default_Request_ReferencesTypeExpense_Company_Default_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Company_Default_Request_ReferencesTypeExpense_Company_Default_ReferenceItem), var_export($expense_Company_Default_Request_ReferencesTypeExpense_Company_Default_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Company_Default_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Company_Default_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType[] $expense_Company_Default_Reference
     * @return \StructType\Expense_Company_Default_Request_ReferencesType
     */
    public function setExpense_Company_Default_Reference(array $expense_Company_Default_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Company_Default_ReferenceArrayErrorMessage = self::validateExpense_Company_Default_ReferenceForArrayConstraintsFromSetExpense_Company_Default_Reference($expense_Company_Default_Reference))) {
            throw new \InvalidArgumentException($expense_Company_Default_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Company_Default_Reference = $expense_Company_Default_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Company_Default_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $item
     * @return \StructType\Expense_Company_Default_Request_ReferencesType
     */
    public function addToExpense_Company_Default_Reference(\StructType\CompanyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Company_Default_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Company_Default_Reference[] = $item;
        return $this;
    }
}
