<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Project-Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Project-Based Order Line Data
 * @subpackage Structs
 */
class Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Line_Canceled
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Purchase Order Line is Canceled.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Purchase_Order_Line_Canceled;
    /**
     * The Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Reference
     * - minOccurs: 0
     * @var \StructType\ProjectObjectType
     */
    public $Project_Reference;
    /**
     * The Project_Activities_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Activities Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Plan_TaskObjectType[]
     */
    public $Project_Activities_Reference;
    /**
     * The State_Date
     * Meta information extracted from the WSDL
     * - documentation: State Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The UNSPSC_Code
     * Meta information extracted from the WSDL
     * - documentation: UNSPSC Code | Catalog Item UNSPSC code for Spend Category | UNSPSC code as provided by the Supplier or if missing, the start UNSPSC code on the Spend Category UNSPSC range.cXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/Classification@domain[UNSPSC]
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $UNSPSC_Code;
    /**
     * The Line_Number
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Line_Number;
    /**
     * Constructor method for
     * Project-Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     * @uses Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setPurchase_Order_Line_Canceled()
     * @uses Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setProject_Reference()
     * @uses Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setProject_Activities_Reference()
     * @uses Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setState_Date()
     * @uses Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setEnd_Date()
     * @uses Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setUNSPSC_Code()
     * @uses Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType::setLine_Number()
     * @param bool $purchase_Order_Line_Canceled
     * @param \StructType\ProjectObjectType $project_Reference
     * @param \StructType\Project_Plan_TaskObjectType[] $project_Activities_Reference
     * @param string $state_Date
     * @param string $end_Date
     * @param float $uNSPSC_Code
     * @param float $line_Number
     */
    public function __construct($purchase_Order_Line_Canceled = null, \StructType\ProjectObjectType $project_Reference = null, array $project_Activities_Reference = array(), $state_Date = null, $end_Date = null, $uNSPSC_Code = null, $line_Number = null)
    {
        $this
            ->setPurchase_Order_Line_Canceled($purchase_Order_Line_Canceled)
            ->setProject_Reference($project_Reference)
            ->setProject_Activities_Reference($project_Activities_Reference)
            ->setState_Date($state_Date)
            ->setEnd_Date($end_Date)
            ->setUNSPSC_Code($uNSPSC_Code)
            ->setLine_Number($line_Number);
    }
    /**
     * Get Purchase_Order_Line_Canceled value
     * @return bool|null
     */
    public function getPurchase_Order_Line_Canceled()
    {
        return $this->Purchase_Order_Line_Canceled;
    }
    /**
     * Set Purchase_Order_Line_Canceled value
     * @param bool $purchase_Order_Line_Canceled
     * @return \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setPurchase_Order_Line_Canceled($purchase_Order_Line_Canceled = null)
    {
        // validation for constraint: boolean
        if (!is_null($purchase_Order_Line_Canceled) && !is_bool($purchase_Order_Line_Canceled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($purchase_Order_Line_Canceled, true), gettype($purchase_Order_Line_Canceled)), __LINE__);
        }
        $this->Purchase_Order_Line_Canceled = $purchase_Order_Line_Canceled;
        return $this;
    }
    /**
     * Get Project_Reference value
     * @return \StructType\ProjectObjectType|null
     */
    public function getProject_Reference()
    {
        return $this->Project_Reference;
    }
    /**
     * Set Project_Reference value
     * @param \StructType\ProjectObjectType $project_Reference
     * @return \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setProject_Reference(\StructType\ProjectObjectType $project_Reference = null)
    {
        $this->Project_Reference = $project_Reference;
        return $this;
    }
    /**
     * Get Project_Activities_Reference value
     * @return \StructType\Project_Plan_TaskObjectType[]|null
     */
    public function getProject_Activities_Reference()
    {
        return $this->Project_Activities_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Activities_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Activities_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Activities_ReferenceForArrayConstraintsFromSetProject_Activities_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeProject_Activities_ReferenceItem) {
            // validation for constraint: itemType
            if (!$project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeProject_Activities_ReferenceItem instanceof \StructType\Project_Plan_TaskObjectType) {
                $invalidValues[] = is_object($project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeProject_Activities_ReferenceItem) ? get_class($project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeProject_Activities_ReferenceItem) : sprintf('%s(%s)', gettype($project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeProject_Activities_ReferenceItem), var_export($project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewTypeProject_Activities_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Activities_Reference property can only contain items of type \StructType\Project_Plan_TaskObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Activities_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_TaskObjectType[] $project_Activities_Reference
     * @return \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setProject_Activities_Reference(array $project_Activities_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Activities_ReferenceArrayErrorMessage = self::validateProject_Activities_ReferenceForArrayConstraintsFromSetProject_Activities_Reference($project_Activities_Reference))) {
            throw new \InvalidArgumentException($project_Activities_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Project_Activities_Reference = $project_Activities_Reference;
        return $this;
    }
    /**
     * Add item to Project_Activities_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Plan_TaskObjectType $item
     * @return \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function addToProject_Activities_Reference(\StructType\Project_Plan_TaskObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Plan_TaskObjectType) {
            throw new \InvalidArgumentException(sprintf('The Project_Activities_Reference property can only contain items of type \StructType\Project_Plan_TaskObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Activities_Reference[] = $item;
        return $this;
    }
    /**
     * Get State_Date value
     * @return string|null
     */
    public function getState_Date()
    {
        return $this->State_Date;
    }
    /**
     * Set State_Date value
     * @param string $state_Date
     * @return \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setState_Date($state_Date = null)
    {
        // validation for constraint: string
        if (!is_null($state_Date) && !is_string($state_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state_Date, true), gettype($state_Date)), __LINE__);
        }
        $this->State_Date = $state_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get UNSPSC_Code value
     * @return float|null
     */
    public function getUNSPSC_Code()
    {
        return $this->UNSPSC_Code;
    }
    /**
     * Set UNSPSC_Code value
     * @param float $uNSPSC_Code
     * @return \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setUNSPSC_Code($uNSPSC_Code = null)
    {
        // validation for constraint: float
        if (!is_null($uNSPSC_Code) && !(is_float($uNSPSC_Code) || is_numeric($uNSPSC_Code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($uNSPSC_Code, true), gettype($uNSPSC_Code)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($uNSPSC_Code) && mb_strlen(mb_substr($uNSPSC_Code, false !== mb_strpos($uNSPSC_Code, '.') ? mb_strpos($uNSPSC_Code, '.') + 1 : mb_strlen($uNSPSC_Code))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($uNSPSC_Code, true), mb_strlen(mb_substr($uNSPSC_Code, mb_strpos($uNSPSC_Code, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($uNSPSC_Code) && $uNSPSC_Code < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($uNSPSC_Code, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($uNSPSC_Code) && mb_strlen(preg_replace('/(\D)/', '', $uNSPSC_Code)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($uNSPSC_Code, true), mb_strlen(preg_replace('/(\D)/', '', $uNSPSC_Code))), __LINE__);
        }
        $this->UNSPSC_Code = $uNSPSC_Code;
        return $this;
    }
    /**
     * Get Line_Number value
     * @return float|null
     */
    public function getLine_Number()
    {
        return $this->Line_Number;
    }
    /**
     * Set Line_Number value
     * @param float $line_Number
     * @return \StructType\Project_Based_Order_Line_for_Issue_Purchase_Order_Outbound_Sub_ViewType
     */
    public function setLine_Number($line_Number = null)
    {
        // validation for constraint: float
        if (!is_null($line_Number) && !(is_float($line_Number) || is_numeric($line_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($line_Number, true), gettype($line_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($line_Number) && mb_strlen(mb_substr($line_Number, false !== mb_strpos($line_Number, '.') ? mb_strpos($line_Number, '.') + 1 : mb_strlen($line_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($line_Number, true), mb_strlen(mb_substr($line_Number, mb_strpos($line_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($line_Number) && $line_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($line_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($line_Number) && mb_strlen(preg_replace('/(\D)/', '', $line_Number)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($line_Number, true), mb_strlen(preg_replace('/(\D)/', '', $line_Number))), __LINE__);
        }
        $this->Line_Number = $line_Number;
        return $this;
    }
}
