<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Item_Distance_Calculation_Configuration_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: The configuration data for the distance calculation of expense items.
 * @subpackage Structs
 */
class Expense_Item_Distance_Calculation_Configuration_DataType extends AbstractStructBase
{
    /**
     * The Require_Distance_Calculation_Attributes_on_Expense_Reports
     * Meta information extracted from the WSDL
     * - documentation: True if distance calculation attributes are required on expense reports.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Require_Distance_Calculation_Attributes_on_Expense_Reports;
    /**
     * The Require_Distance_Calculation_Attributes_on_Spend_Authorizations
     * Meta information extracted from the WSDL
     * - documentation: True if distance calculation attributes are required on spend authorizations.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Require_Distance_Calculation_Attributes_on_Spend_Authorizations;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: You must enter miles or kilometers for this distance-based expense item. (Not case-sensitive)
     * - minOccurs: 0
     * @var \StructType\Expense_Item_Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Distance_Calculation_Attribute_Configuration_Data
     * Meta information extracted from the WSDL
     * - documentation: The configuration data for the distance calculation attributes
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Distance_Calculation_Attribute_Configuration_DataType[]
     */
    public $Distance_Calculation_Attribute_Configuration_Data;
    /**
     * Constructor method for Expense_Item_Distance_Calculation_Configuration_DataType
     * @uses Expense_Item_Distance_Calculation_Configuration_DataType::setRequire_Distance_Calculation_Attributes_on_Expense_Reports()
     * @uses Expense_Item_Distance_Calculation_Configuration_DataType::setRequire_Distance_Calculation_Attributes_on_Spend_Authorizations()
     * @uses Expense_Item_Distance_Calculation_Configuration_DataType::setUnit_of_Measure_Reference()
     * @uses Expense_Item_Distance_Calculation_Configuration_DataType::setDistance_Calculation_Attribute_Configuration_Data()
     * @param bool $require_Distance_Calculation_Attributes_on_Expense_Reports
     * @param bool $require_Distance_Calculation_Attributes_on_Spend_Authorizations
     * @param \StructType\Expense_Item_Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param \StructType\Distance_Calculation_Attribute_Configuration_DataType[] $distance_Calculation_Attribute_Configuration_Data
     */
    public function __construct($require_Distance_Calculation_Attributes_on_Expense_Reports = null, $require_Distance_Calculation_Attributes_on_Spend_Authorizations = null, \StructType\Expense_Item_Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, array $distance_Calculation_Attribute_Configuration_Data = array())
    {
        $this
            ->setRequire_Distance_Calculation_Attributes_on_Expense_Reports($require_Distance_Calculation_Attributes_on_Expense_Reports)
            ->setRequire_Distance_Calculation_Attributes_on_Spend_Authorizations($require_Distance_Calculation_Attributes_on_Spend_Authorizations)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setDistance_Calculation_Attribute_Configuration_Data($distance_Calculation_Attribute_Configuration_Data);
    }
    /**
     * Get Require_Distance_Calculation_Attributes_on_Expense_Reports value
     * @return bool|null
     */
    public function getRequire_Distance_Calculation_Attributes_on_Expense_Reports()
    {
        return $this->Require_Distance_Calculation_Attributes_on_Expense_Reports;
    }
    /**
     * Set Require_Distance_Calculation_Attributes_on_Expense_Reports value
     * @param bool $require_Distance_Calculation_Attributes_on_Expense_Reports
     * @return \StructType\Expense_Item_Distance_Calculation_Configuration_DataType
     */
    public function setRequire_Distance_Calculation_Attributes_on_Expense_Reports($require_Distance_Calculation_Attributes_on_Expense_Reports = null)
    {
        // validation for constraint: boolean
        if (!is_null($require_Distance_Calculation_Attributes_on_Expense_Reports) && !is_bool($require_Distance_Calculation_Attributes_on_Expense_Reports)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($require_Distance_Calculation_Attributes_on_Expense_Reports, true), gettype($require_Distance_Calculation_Attributes_on_Expense_Reports)), __LINE__);
        }
        $this->Require_Distance_Calculation_Attributes_on_Expense_Reports = $require_Distance_Calculation_Attributes_on_Expense_Reports;
        return $this;
    }
    /**
     * Get Require_Distance_Calculation_Attributes_on_Spend_Authorizations value
     * @return bool|null
     */
    public function getRequire_Distance_Calculation_Attributes_on_Spend_Authorizations()
    {
        return $this->Require_Distance_Calculation_Attributes_on_Spend_Authorizations;
    }
    /**
     * Set Require_Distance_Calculation_Attributes_on_Spend_Authorizations value
     * @param bool $require_Distance_Calculation_Attributes_on_Spend_Authorizations
     * @return \StructType\Expense_Item_Distance_Calculation_Configuration_DataType
     */
    public function setRequire_Distance_Calculation_Attributes_on_Spend_Authorizations($require_Distance_Calculation_Attributes_on_Spend_Authorizations = null)
    {
        // validation for constraint: boolean
        if (!is_null($require_Distance_Calculation_Attributes_on_Spend_Authorizations) && !is_bool($require_Distance_Calculation_Attributes_on_Spend_Authorizations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($require_Distance_Calculation_Attributes_on_Spend_Authorizations, true), gettype($require_Distance_Calculation_Attributes_on_Spend_Authorizations)), __LINE__);
        }
        $this->Require_Distance_Calculation_Attributes_on_Spend_Authorizations = $require_Distance_Calculation_Attributes_on_Spend_Authorizations;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Expense_Item_Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Expense_Item_Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Expense_Item_Distance_Calculation_Configuration_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Expense_Item_Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Distance_Calculation_Attribute_Configuration_Data value
     * @return \StructType\Distance_Calculation_Attribute_Configuration_DataType[]|null
     */
    public function getDistance_Calculation_Attribute_Configuration_Data()
    {
        return $this->Distance_Calculation_Attribute_Configuration_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setDistance_Calculation_Attribute_Configuration_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDistance_Calculation_Attribute_Configuration_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDistance_Calculation_Attribute_Configuration_DataForArrayConstraintsFromSetDistance_Calculation_Attribute_Configuration_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Item_Distance_Calculation_Configuration_DataTypeDistance_Calculation_Attribute_Configuration_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Item_Distance_Calculation_Configuration_DataTypeDistance_Calculation_Attribute_Configuration_DataItem instanceof \StructType\Distance_Calculation_Attribute_Configuration_DataType) {
                $invalidValues[] = is_object($expense_Item_Distance_Calculation_Configuration_DataTypeDistance_Calculation_Attribute_Configuration_DataItem) ? get_class($expense_Item_Distance_Calculation_Configuration_DataTypeDistance_Calculation_Attribute_Configuration_DataItem) : sprintf('%s(%s)', gettype($expense_Item_Distance_Calculation_Configuration_DataTypeDistance_Calculation_Attribute_Configuration_DataItem), var_export($expense_Item_Distance_Calculation_Configuration_DataTypeDistance_Calculation_Attribute_Configuration_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Distance_Calculation_Attribute_Configuration_Data property can only contain items of type \StructType\Distance_Calculation_Attribute_Configuration_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Distance_Calculation_Attribute_Configuration_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Distance_Calculation_Attribute_Configuration_DataType[] $distance_Calculation_Attribute_Configuration_Data
     * @return \StructType\Expense_Item_Distance_Calculation_Configuration_DataType
     */
    public function setDistance_Calculation_Attribute_Configuration_Data(array $distance_Calculation_Attribute_Configuration_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($distance_Calculation_Attribute_Configuration_DataArrayErrorMessage = self::validateDistance_Calculation_Attribute_Configuration_DataForArrayConstraintsFromSetDistance_Calculation_Attribute_Configuration_Data($distance_Calculation_Attribute_Configuration_Data))) {
            throw new \InvalidArgumentException($distance_Calculation_Attribute_Configuration_DataArrayErrorMessage, __LINE__);
        }
        $this->Distance_Calculation_Attribute_Configuration_Data = $distance_Calculation_Attribute_Configuration_Data;
        return $this;
    }
    /**
     * Add item to Distance_Calculation_Attribute_Configuration_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Distance_Calculation_Attribute_Configuration_DataType $item
     * @return \StructType\Expense_Item_Distance_Calculation_Configuration_DataType
     */
    public function addToDistance_Calculation_Attribute_Configuration_Data(\StructType\Distance_Calculation_Attribute_Configuration_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Distance_Calculation_Attribute_Configuration_DataType) {
            throw new \InvalidArgumentException(sprintf('The Distance_Calculation_Attribute_Configuration_Data property can only contain items of type \StructType\Distance_Calculation_Attribute_Configuration_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Distance_Calculation_Attribute_Configuration_Data[] = $item;
        return $this;
    }
}
