<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Register ServiceType
 * @subpackage Services
 */
class Register extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Register_Asset
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will add or update Business Assets. Workday Business Assets allows you to perform a basic accounting flow of fixed assets (capitalization and depreciation) and to track custodianship of a asset regardless of
     * its accounting treatment. In Workday, a business asset is anything you track from tractors to software licenses. Business Asset data includes but is not limited to Business Asset ID, Company, Spend Category, Acquisition Method, Depreciation Method,
     * Asset Name, Description, PO Number, Useful Life, Remaining Depreciation Periods, Serial Number, Date Acquired, Date Placed in Service, Last Issue Date, Depreciation Start Date. The request criteria can be for a single transaction based on Reference,
     * or all transactions can be retrieved if no criteria is specified.Business Asset and Resource are synonymous and refer to the same business object. Spend Category and Resource Category are synonymous and refer to the same business object.This web
     * service enables Workday to automatically populate related worktags.The public Get Resources web service may be used to export current business asset information and obtain references.Not Applicable
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Register_Asset_RequestRootType $body
     * @return \StructType\Register_Asset_ResponseType|bool
     */
    public function Register_Asset(\StructType\Register_Asset_RequestRootType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Register_Asset($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Register_Asset_ResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
