<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Invoice Prepaid Spend Amortization Schedule
 * @subpackage Structs
 */
class Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType extends AbstractStructBase
{
    /**
     * The Prepaid_Spend_Amortization_Schedule_ID
     * Meta information extracted from the WSDL
     * - documentation: This Prepaid Spend Amortization Schedule ID is already in use on another supplier invoice. Use a unique ID. | Prepaid Spend Amortization Schedule ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Prepaid_Spend_Amortization_Schedule_ID;
    /**
     * The Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Frequency to be used when generating the next prepaid accounting entry.
     * @var \StructType\Frequency_BehaviorObjectType
     */
    public $Frequency_Reference;
    /**
     * The Number_of_Installments
     * Meta information extracted from the WSDL
     * - documentation: Number of installments. The system generates installments based on this value. | The Number of Installments to use when accounting for the Prepaid Amortization.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Installments;
    /**
     * The Use_Invoice_Date
     * Meta information extracted from the WSDL
     * - documentation: Use the Invoice Date as the starting date for the first installment
     * - choice: Use_Invoice_Date | From_Date
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var bool
     */
    public $Use_Invoice_Date;
    /**
     * The From_Date
     * Meta information extracted from the WSDL
     * - documentation: Use the Specified Date as the starting date for the first installment
     * - choice: Use_Invoice_Date | From_Date
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var string
     */
    public $From_Date;
    /**
     * The Include_All_Available_Prepaid_Lines
     * Meta information extracted from the WSDL
     * - documentation: Flag to include all remaining prepaid Purchase Order Lines in this schedule
     * - choice: Include_All_Available_Prepaid_Lines | Prepaid_Supplier_Invoice_Lines
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_All_Available_Prepaid_Lines;
    /**
     * The Prepaid_Supplier_Invoice_Lines
     * Meta information extracted from the WSDL
     * - choice: Include_All_Available_Prepaid_Lines | Prepaid_Supplier_Invoice_Lines
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Lines_For_Amortization_Schedule_DataType[]
     */
    public $Prepaid_Supplier_Invoice_Lines;
    /**
     * Constructor method for
     * Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType
     * @uses Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType::setPrepaid_Spend_Amortization_Schedule_ID()
     * @uses Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType::setFrequency_Reference()
     * @uses Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType::setNumber_of_Installments()
     * @uses Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType::setUse_Invoice_Date()
     * @uses Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType::setFrom_Date()
     * @uses Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType::setInclude_All_Available_Prepaid_Lines()
     * @uses Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType::setPrepaid_Supplier_Invoice_Lines()
     * @param string $prepaid_Spend_Amortization_Schedule_ID
     * @param \StructType\Frequency_BehaviorObjectType $frequency_Reference
     * @param float $number_of_Installments
     * @param bool $use_Invoice_Date
     * @param string $from_Date
     * @param bool $include_All_Available_Prepaid_Lines
     * @param \StructType\Supplier_Invoice_Lines_For_Amortization_Schedule_DataType[] $prepaid_Supplier_Invoice_Lines
     */
    public function __construct($prepaid_Spend_Amortization_Schedule_ID = null, \StructType\Frequency_BehaviorObjectType $frequency_Reference = null, $number_of_Installments = null, $use_Invoice_Date = null, $from_Date = null, $include_All_Available_Prepaid_Lines = null, array $prepaid_Supplier_Invoice_Lines = array())
    {
        $this
            ->setPrepaid_Spend_Amortization_Schedule_ID($prepaid_Spend_Amortization_Schedule_ID)
            ->setFrequency_Reference($frequency_Reference)
            ->setNumber_of_Installments($number_of_Installments)
            ->setUse_Invoice_Date($use_Invoice_Date)
            ->setFrom_Date($from_Date)
            ->setInclude_All_Available_Prepaid_Lines($include_All_Available_Prepaid_Lines)
            ->setPrepaid_Supplier_Invoice_Lines($prepaid_Supplier_Invoice_Lines);
    }
    /**
     * Get Prepaid_Spend_Amortization_Schedule_ID value
     * @return string|null
     */
    public function getPrepaid_Spend_Amortization_Schedule_ID()
    {
        return $this->Prepaid_Spend_Amortization_Schedule_ID;
    }
    /**
     * Set Prepaid_Spend_Amortization_Schedule_ID value
     * @param string $prepaid_Spend_Amortization_Schedule_ID
     * @return \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType
     */
    public function setPrepaid_Spend_Amortization_Schedule_ID($prepaid_Spend_Amortization_Schedule_ID = null)
    {
        // validation for constraint: string
        if (!is_null($prepaid_Spend_Amortization_Schedule_ID) && !is_string($prepaid_Spend_Amortization_Schedule_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prepaid_Spend_Amortization_Schedule_ID, true), gettype($prepaid_Spend_Amortization_Schedule_ID)), __LINE__);
        }
        $this->Prepaid_Spend_Amortization_Schedule_ID = $prepaid_Spend_Amortization_Schedule_ID;
        return $this;
    }
    /**
     * Get Frequency_Reference value
     * @return \StructType\Frequency_BehaviorObjectType|null
     */
    public function getFrequency_Reference()
    {
        return $this->Frequency_Reference;
    }
    /**
     * Set Frequency_Reference value
     * @param \StructType\Frequency_BehaviorObjectType $frequency_Reference
     * @return \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType
     */
    public function setFrequency_Reference(\StructType\Frequency_BehaviorObjectType $frequency_Reference = null)
    {
        $this->Frequency_Reference = $frequency_Reference;
        return $this;
    }
    /**
     * Get Number_of_Installments value
     * @return float|null
     */
    public function getNumber_of_Installments()
    {
        return $this->Number_of_Installments;
    }
    /**
     * Set Number_of_Installments value
     * @param float $number_of_Installments
     * @return \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType
     */
    public function setNumber_of_Installments($number_of_Installments = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Installments) && !(is_float($number_of_Installments) || is_numeric($number_of_Installments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Installments, true), gettype($number_of_Installments)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Installments) && mb_strlen(mb_substr($number_of_Installments, false !== mb_strpos($number_of_Installments, '.') ? mb_strpos($number_of_Installments, '.') + 1 : mb_strlen($number_of_Installments))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Installments, true), mb_strlen(mb_substr($number_of_Installments, mb_strpos($number_of_Installments, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Installments) && $number_of_Installments < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Installments, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Installments) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Installments)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Installments, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Installments))), __LINE__);
        }
        $this->Number_of_Installments = $number_of_Installments;
        return $this;
    }
    /**
     * Get Use_Invoice_Date value
     * @return bool|null
     */
    public function getUse_Invoice_Date()
    {
        return isset($this->Use_Invoice_Date) ? $this->Use_Invoice_Date : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUse_Invoice_Date method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUse_Invoice_Date method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUse_Invoice_DateForChoiceConstraintsFromSetUse_Invoice_Date($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'From_Date',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Use_Invoice_Date can\'t be set as the property %s is already set. Only one property must be set among these properties: Use_Invoice_Date, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Use_Invoice_Date value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $use_Invoice_Date
     * @return \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType
     */
    public function setUse_Invoice_Date($use_Invoice_Date = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Invoice_Date) && !is_bool($use_Invoice_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Invoice_Date, true), gettype($use_Invoice_Date)), __LINE__);
        }
        // validation for constraint: choice(Use_Invoice_Date, From_Date)
        if ('' !== ($use_Invoice_DateChoiceErrorMessage = self::validateUse_Invoice_DateForChoiceConstraintsFromSetUse_Invoice_Date($use_Invoice_Date))) {
            throw new \InvalidArgumentException($use_Invoice_DateChoiceErrorMessage, __LINE__);
        }
        if (is_null($use_Invoice_Date) || (is_array($use_Invoice_Date) && empty($use_Invoice_Date))) {
            unset($this->Use_Invoice_Date);
        } else {
            $this->Use_Invoice_Date = $use_Invoice_Date;
        }
        return $this;
    }
    /**
     * Get From_Date value
     * @return string|null
     */
    public function getFrom_Date()
    {
        return isset($this->From_Date) ? $this->From_Date : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFrom_Date method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFrom_Date method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFrom_DateForChoiceConstraintsFromSetFrom_Date($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Use_Invoice_Date',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property From_Date can\'t be set as the property %s is already set. Only one property must be set among these properties: From_Date, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set From_Date value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $from_Date
     * @return \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType
     */
    public function setFrom_Date($from_Date = null)
    {
        // validation for constraint: string
        if (!is_null($from_Date) && !is_string($from_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from_Date, true), gettype($from_Date)), __LINE__);
        }
        // validation for constraint: choice(Use_Invoice_Date, From_Date)
        if ('' !== ($from_DateChoiceErrorMessage = self::validateFrom_DateForChoiceConstraintsFromSetFrom_Date($from_Date))) {
            throw new \InvalidArgumentException($from_DateChoiceErrorMessage, __LINE__);
        }
        if (is_null($from_Date) || (is_array($from_Date) && empty($from_Date))) {
            unset($this->From_Date);
        } else {
            $this->From_Date = $from_Date;
        }
        return $this;
    }
    /**
     * Get Include_All_Available_Prepaid_Lines value
     * @return bool|null
     */
    public function getInclude_All_Available_Prepaid_Lines()
    {
        return isset($this->Include_All_Available_Prepaid_Lines) ? $this->Include_All_Available_Prepaid_Lines : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInclude_All_Available_Prepaid_Lines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInclude_All_Available_Prepaid_Lines method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInclude_All_Available_Prepaid_LinesForChoiceConstraintsFromSetInclude_All_Available_Prepaid_Lines($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Prepaid_Supplier_Invoice_Lines',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Include_All_Available_Prepaid_Lines can\'t be set as the property %s is already set. Only one property must be set among these properties: Include_All_Available_Prepaid_Lines, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Include_All_Available_Prepaid_Lines value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $include_All_Available_Prepaid_Lines
     * @return \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType
     */
    public function setInclude_All_Available_Prepaid_Lines($include_All_Available_Prepaid_Lines = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_All_Available_Prepaid_Lines) && !is_bool($include_All_Available_Prepaid_Lines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_All_Available_Prepaid_Lines, true), gettype($include_All_Available_Prepaid_Lines)), __LINE__);
        }
        // validation for constraint: choice(Include_All_Available_Prepaid_Lines, Prepaid_Supplier_Invoice_Lines)
        if ('' !== ($include_All_Available_Prepaid_LinesChoiceErrorMessage = self::validateInclude_All_Available_Prepaid_LinesForChoiceConstraintsFromSetInclude_All_Available_Prepaid_Lines($include_All_Available_Prepaid_Lines))) {
            throw new \InvalidArgumentException($include_All_Available_Prepaid_LinesChoiceErrorMessage, __LINE__);
        }
        if (is_null($include_All_Available_Prepaid_Lines) || (is_array($include_All_Available_Prepaid_Lines) && empty($include_All_Available_Prepaid_Lines))) {
            unset($this->Include_All_Available_Prepaid_Lines);
        } else {
            $this->Include_All_Available_Prepaid_Lines = $include_All_Available_Prepaid_Lines;
        }
        return $this;
    }
    /**
     * Get Prepaid_Supplier_Invoice_Lines value
     * @return \StructType\Supplier_Invoice_Lines_For_Amortization_Schedule_DataType[]|null
     */
    public function getPrepaid_Supplier_Invoice_Lines()
    {
        return isset($this->Prepaid_Supplier_Invoice_Lines) ? $this->Prepaid_Supplier_Invoice_Lines : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPrepaid_Supplier_Invoice_Lines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrepaid_Supplier_Invoice_Lines method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrepaid_Supplier_Invoice_LinesForArrayConstraintsFromSetPrepaid_Supplier_Invoice_Lines(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataTypePrepaid_Supplier_Invoice_LinesItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataTypePrepaid_Supplier_Invoice_LinesItem instanceof \StructType\Supplier_Invoice_Lines_For_Amortization_Schedule_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataTypePrepaid_Supplier_Invoice_LinesItem) ? get_class($supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataTypePrepaid_Supplier_Invoice_LinesItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataTypePrepaid_Supplier_Invoice_LinesItem), var_export($supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataTypePrepaid_Supplier_Invoice_LinesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Prepaid_Supplier_Invoice_Lines property can only contain items of type \StructType\Supplier_Invoice_Lines_For_Amortization_Schedule_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPrepaid_Supplier_Invoice_Lines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrepaid_Supplier_Invoice_Lines method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePrepaid_Supplier_Invoice_LinesForChoiceConstraintsFromSetPrepaid_Supplier_Invoice_Lines($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Include_All_Available_Prepaid_Lines',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Prepaid_Supplier_Invoice_Lines can\'t be set as the property %s is already set. Only one property must be set among these properties: Prepaid_Supplier_Invoice_Lines, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Prepaid_Supplier_Invoice_Lines value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Lines_For_Amortization_Schedule_DataType[] $prepaid_Supplier_Invoice_Lines
     * @return \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType
     */
    public function setPrepaid_Supplier_Invoice_Lines(array $prepaid_Supplier_Invoice_Lines = array())
    {
        // validation for constraint: array
        if ('' !== ($prepaid_Supplier_Invoice_LinesArrayErrorMessage = self::validatePrepaid_Supplier_Invoice_LinesForArrayConstraintsFromSetPrepaid_Supplier_Invoice_Lines($prepaid_Supplier_Invoice_Lines))) {
            throw new \InvalidArgumentException($prepaid_Supplier_Invoice_LinesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(Include_All_Available_Prepaid_Lines, Prepaid_Supplier_Invoice_Lines)
        if ('' !== ($prepaid_Supplier_Invoice_LinesChoiceErrorMessage = self::validatePrepaid_Supplier_Invoice_LinesForChoiceConstraintsFromSetPrepaid_Supplier_Invoice_Lines($prepaid_Supplier_Invoice_Lines))) {
            throw new \InvalidArgumentException($prepaid_Supplier_Invoice_LinesChoiceErrorMessage, __LINE__);
        }
        if (is_null($prepaid_Supplier_Invoice_Lines) || (is_array($prepaid_Supplier_Invoice_Lines) && empty($prepaid_Supplier_Invoice_Lines))) {
            unset($this->Prepaid_Supplier_Invoice_Lines);
        } else {
            $this->Prepaid_Supplier_Invoice_Lines = $prepaid_Supplier_Invoice_Lines;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToPrepaid_Supplier_Invoice_Lines method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToPrepaid_Supplier_Invoice_Lines method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToPrepaid_Supplier_Invoice_Lines($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Include_All_Available_Prepaid_Lines',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Prepaid_Supplier_Invoice_Lines can\'t be set as the property %s is already set. Only one property must be set among these properties: Prepaid_Supplier_Invoice_Lines, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Prepaid_Supplier_Invoice_Lines value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Lines_For_Amortization_Schedule_DataType $item
     * @return \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType
     */
    public function addToPrepaid_Supplier_Invoice_Lines(\StructType\Supplier_Invoice_Lines_For_Amortization_Schedule_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Lines_For_Amortization_Schedule_DataType) {
            throw new \InvalidArgumentException(sprintf('The Prepaid_Supplier_Invoice_Lines property can only contain items of type \StructType\Supplier_Invoice_Lines_For_Amortization_Schedule_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(Include_All_Available_Prepaid_Lines, Prepaid_Supplier_Invoice_Lines)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToPrepaid_Supplier_Invoice_Lines($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Prepaid_Supplier_Invoice_Lines[] = $item;
        return $this;
    }
}
