<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Financials_Attachment_with_Attachment_Category_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element containing all Business Document Attachment data and Attachment Category data.
 * @subpackage Structs
 */
class Financials_Attachment_with_Attachment_Category_DataType extends AbstractStructBase
{
    /**
     * The File_Content
     * Meta information extracted from the WSDL
     * - documentation: File content in binary format.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $File_Content;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Comment
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Attachment_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Element containing Attachment Category
     * - minOccurs: 0
     * @var \StructType\Attachment_CategoryObjectType
     */
    public $Attachment_Category_Reference;
    /**
     * The Content_Type
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 80
     * @var string
     */
    public $Content_Type;
    /**
     * The Filename
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * @var string
     */
    public $Filename;
    /**
     * The Encoding
     * Meta information extracted from the WSDL
     * - documentation: Text attribute identifying Encoding of the Attachment.
     * @var string
     */
    public $Encoding;
    /**
     * The Compressed
     * Meta information extracted from the WSDL
     * - documentation: Boolean attribute identifying whether the Attachment is compressed.
     * @var bool
     */
    public $Compressed;
    /**
     * Constructor method for Financials_Attachment_with_Attachment_Category_DataType
     * @uses Financials_Attachment_with_Attachment_Category_DataType::setFile_Content()
     * @uses Financials_Attachment_with_Attachment_Category_DataType::setComment()
     * @uses Financials_Attachment_with_Attachment_Category_DataType::setAttachment_Category_Reference()
     * @uses Financials_Attachment_with_Attachment_Category_DataType::setContent_Type()
     * @uses Financials_Attachment_with_Attachment_Category_DataType::setFilename()
     * @uses Financials_Attachment_with_Attachment_Category_DataType::setEncoding()
     * @uses Financials_Attachment_with_Attachment_Category_DataType::setCompressed()
     * @param string $file_Content
     * @param string $comment
     * @param \StructType\Attachment_CategoryObjectType $attachment_Category_Reference
     * @param string $content_Type
     * @param string $filename
     * @param string $encoding
     * @param bool $compressed
     */
    public function __construct($file_Content = null, $comment = null, \StructType\Attachment_CategoryObjectType $attachment_Category_Reference = null, $content_Type = null, $filename = null, $encoding = null, $compressed = null)
    {
        $this
            ->setFile_Content($file_Content)
            ->setComment($comment)
            ->setAttachment_Category_Reference($attachment_Category_Reference)
            ->setContent_Type($content_Type)
            ->setFilename($filename)
            ->setEncoding($encoding)
            ->setCompressed($compressed);
    }
    /**
     * Get File_Content value
     * @return string|null
     */
    public function getFile_Content()
    {
        return $this->File_Content;
    }
    /**
     * Set File_Content value
     * @param string $file_Content
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType
     */
    public function setFile_Content($file_Content = null)
    {
        // validation for constraint: string
        if (!is_null($file_Content) && !is_string($file_Content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file_Content, true), gettype($file_Content)), __LINE__);
        }
        $this->File_Content = $file_Content;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Attachment_Category_Reference value
     * @return \StructType\Attachment_CategoryObjectType|null
     */
    public function getAttachment_Category_Reference()
    {
        return $this->Attachment_Category_Reference;
    }
    /**
     * Set Attachment_Category_Reference value
     * @param \StructType\Attachment_CategoryObjectType $attachment_Category_Reference
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType
     */
    public function setAttachment_Category_Reference(\StructType\Attachment_CategoryObjectType $attachment_Category_Reference = null)
    {
        $this->Attachment_Category_Reference = $attachment_Category_Reference;
        return $this;
    }
    /**
     * Get Content_Type value
     * @return string|null
     */
    public function getContent_Type()
    {
        return $this->Content_Type;
    }
    /**
     * Set Content_Type value
     * @param string $content_Type
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType
     */
    public function setContent_Type($content_Type = null)
    {
        // validation for constraint: string
        if (!is_null($content_Type) && !is_string($content_Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($content_Type, true), gettype($content_Type)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($content_Type) && mb_strlen($content_Type) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($content_Type)), __LINE__);
        }
        $this->Content_Type = $content_Type;
        return $this;
    }
    /**
     * Get Filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->Filename;
    }
    /**
     * Set Filename value
     * @param string $filename
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($filename) && mb_strlen($filename) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($filename)), __LINE__);
        }
        $this->Filename = $filename;
        return $this;
    }
    /**
     * Get Encoding value
     * @return string|null
     */
    public function getEncoding()
    {
        return $this->Encoding;
    }
    /**
     * Set Encoding value
     * @param string $encoding
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType
     */
    public function setEncoding($encoding = null)
    {
        // validation for constraint: string
        if (!is_null($encoding) && !is_string($encoding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($encoding, true), gettype($encoding)), __LINE__);
        }
        $this->Encoding = $encoding;
        return $this;
    }
    /**
     * Get Compressed value
     * @return bool|null
     */
    public function getCompressed()
    {
        return $this->Compressed;
    }
    /**
     * Set Compressed value
     * @param bool $compressed
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType
     */
    public function setCompressed($compressed = null)
    {
        // validation for constraint: boolean
        if (!is_null($compressed) && !is_bool($compressed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($compressed, true), gettype($compressed)), __LINE__);
        }
        $this->Compressed = $compressed;
        return $this;
    }
}
