<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for External_Business_Entity_Contact_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: External Business Entity Contact Data
 * @subpackage Structs
 */
class External_Business_Entity_Contact_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: External Business Entity Contact ID. This is the External Business Entity Contact unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier that the contact is for
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The External_Business_Entity_Contact_Personal_Data
     * Meta information extracted from the WSDL
     * - documentation: External Business Entity Contact Personal Data
     * @var \StructType\Business_Entity_Contact_Personal_DataType
     */
    public $External_Business_Entity_Contact_Personal_Data;
    /**
     * The External_ID_Data
     * Meta information extracted from the WSDL
     * - documentation: External ID Data
     * - minOccurs: 0
     * @var \StructType\External_Integration_ID_DataType
     */
    public $External_ID_Data;
    /**
     * The Workday_Account_Creation_Options_Data
     * Meta information extracted from the WSDL
     * - documentation: Workday Account Creation Options Data
     * - minOccurs: 0
     * @var \StructType\Workday_Account_Creation_Options_DataType
     */
    public $Workday_Account_Creation_Options_Data;
    /**
     * Constructor method for External_Business_Entity_Contact_DataType
     * @uses External_Business_Entity_Contact_DataType::setID()
     * @uses External_Business_Entity_Contact_DataType::setSupplier_Reference()
     * @uses External_Business_Entity_Contact_DataType::setExternal_Business_Entity_Contact_Personal_Data()
     * @uses External_Business_Entity_Contact_DataType::setExternal_ID_Data()
     * @uses External_Business_Entity_Contact_DataType::setWorkday_Account_Creation_Options_Data()
     * @param string $iD
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\Business_Entity_Contact_Personal_DataType $external_Business_Entity_Contact_Personal_Data
     * @param \StructType\External_Integration_ID_DataType $external_ID_Data
     * @param \StructType\Workday_Account_Creation_Options_DataType $workday_Account_Creation_Options_Data
     */
    public function __construct($iD = null, \StructType\SupplierObjectType $supplier_Reference = null, \StructType\Business_Entity_Contact_Personal_DataType $external_Business_Entity_Contact_Personal_Data = null, \StructType\External_Integration_ID_DataType $external_ID_Data = null, \StructType\Workday_Account_Creation_Options_DataType $workday_Account_Creation_Options_Data = null)
    {
        $this
            ->setID($iD)
            ->setSupplier_Reference($supplier_Reference)
            ->setExternal_Business_Entity_Contact_Personal_Data($external_Business_Entity_Contact_Personal_Data)
            ->setExternal_ID_Data($external_ID_Data)
            ->setWorkday_Account_Creation_Options_Data($workday_Account_Creation_Options_Data);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\External_Business_Entity_Contact_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\External_Business_Entity_Contact_DataType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get External_Business_Entity_Contact_Personal_Data value
     * @return \StructType\Business_Entity_Contact_Personal_DataType|null
     */
    public function getExternal_Business_Entity_Contact_Personal_Data()
    {
        return $this->External_Business_Entity_Contact_Personal_Data;
    }
    /**
     * Set External_Business_Entity_Contact_Personal_Data value
     * @param \StructType\Business_Entity_Contact_Personal_DataType $external_Business_Entity_Contact_Personal_Data
     * @return \StructType\External_Business_Entity_Contact_DataType
     */
    public function setExternal_Business_Entity_Contact_Personal_Data(\StructType\Business_Entity_Contact_Personal_DataType $external_Business_Entity_Contact_Personal_Data = null)
    {
        $this->External_Business_Entity_Contact_Personal_Data = $external_Business_Entity_Contact_Personal_Data;
        return $this;
    }
    /**
     * Get External_ID_Data value
     * @return \StructType\External_Integration_ID_DataType|null
     */
    public function getExternal_ID_Data()
    {
        return $this->External_ID_Data;
    }
    /**
     * Set External_ID_Data value
     * @param \StructType\External_Integration_ID_DataType $external_ID_Data
     * @return \StructType\External_Business_Entity_Contact_DataType
     */
    public function setExternal_ID_Data(\StructType\External_Integration_ID_DataType $external_ID_Data = null)
    {
        $this->External_ID_Data = $external_ID_Data;
        return $this;
    }
    /**
     * Get Workday_Account_Creation_Options_Data value
     * @return \StructType\Workday_Account_Creation_Options_DataType|null
     */
    public function getWorkday_Account_Creation_Options_Data()
    {
        return $this->Workday_Account_Creation_Options_Data;
    }
    /**
     * Set Workday_Account_Creation_Options_Data value
     * @param \StructType\Workday_Account_Creation_Options_DataType $workday_Account_Creation_Options_Data
     * @return \StructType\External_Business_Entity_Contact_DataType
     */
    public function setWorkday_Account_Creation_Options_Data(\StructType\Workday_Account_Creation_Options_DataType $workday_Account_Creation_Options_Data = null)
    {
        $this->Workday_Account_Creation_Options_Data = $workday_Account_Creation_Options_Data;
        return $this;
    }
}
