<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Rate_Table_Header__HV__RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Web Service is set to Add Only; but the Expense Rate Table already exists. | Element containing Expense Rate Table reference for update and all Expense Rate Table data items
 * @subpackage Structs
 */
class Expense_Rate_Table_Header__HV__RequestType extends AbstractStructBase
{
    /**
     * The Expense_Rate_Table_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Rate Table for update only purposes
     * - minOccurs: 0
     * @var \StructType\Expense_Rate_TableObjectType
     */
    public $Expense_Rate_Table_Reference;
    /**
     * The Expense_Rate_Table_Data
     * @var \StructType\Expense_Rate_Table__HV__DataType
     */
    public $Expense_Rate_Table_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update. If an existing instance is found and this flag is set there will be an error.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Expense_Rate_Table_Header__HV__RequestType
     * @uses Expense_Rate_Table_Header__HV__RequestType::setExpense_Rate_Table_Reference()
     * @uses Expense_Rate_Table_Header__HV__RequestType::setExpense_Rate_Table_Data()
     * @uses Expense_Rate_Table_Header__HV__RequestType::setAdd_Only()
     * @uses Expense_Rate_Table_Header__HV__RequestType::setVersion()
     * @param \StructType\Expense_Rate_TableObjectType $expense_Rate_Table_Reference
     * @param \StructType\Expense_Rate_Table__HV__DataType $expense_Rate_Table_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Expense_Rate_TableObjectType $expense_Rate_Table_Reference = null, \StructType\Expense_Rate_Table__HV__DataType $expense_Rate_Table_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setExpense_Rate_Table_Reference($expense_Rate_Table_Reference)
            ->setExpense_Rate_Table_Data($expense_Rate_Table_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Expense_Rate_Table_Reference value
     * @return \StructType\Expense_Rate_TableObjectType|null
     */
    public function getExpense_Rate_Table_Reference()
    {
        return $this->Expense_Rate_Table_Reference;
    }
    /**
     * Set Expense_Rate_Table_Reference value
     * @param \StructType\Expense_Rate_TableObjectType $expense_Rate_Table_Reference
     * @return \StructType\Expense_Rate_Table_Header__HV__RequestType
     */
    public function setExpense_Rate_Table_Reference(\StructType\Expense_Rate_TableObjectType $expense_Rate_Table_Reference = null)
    {
        $this->Expense_Rate_Table_Reference = $expense_Rate_Table_Reference;
        return $this;
    }
    /**
     * Get Expense_Rate_Table_Data value
     * @return \StructType\Expense_Rate_Table__HV__DataType|null
     */
    public function getExpense_Rate_Table_Data()
    {
        return $this->Expense_Rate_Table_Data;
    }
    /**
     * Set Expense_Rate_Table_Data value
     * @param \StructType\Expense_Rate_Table__HV__DataType $expense_Rate_Table_Data
     * @return \StructType\Expense_Rate_Table_Header__HV__RequestType
     */
    public function setExpense_Rate_Table_Data(\StructType\Expense_Rate_Table__HV__DataType $expense_Rate_Table_Data = null)
    {
        $this->Expense_Rate_Table_Data = $expense_Rate_Table_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Expense_Rate_Table_Header__HV__RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Expense_Rate_Table_Header__HV__RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
