<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Distance_Calculation_Attribute_Configuration_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: You can't select Distance to Expense on expense items manually. We add Distance to Expense on expense items automatically when you select One-Way Daily Commute or Round Trip. | The configuration data for the distance calculation
 * attributes
 * @subpackage Structs
 */
class Distance_Calculation_Attribute_Configuration_DataType extends AbstractStructBase
{
    /**
     * The Distance_Calculation_Attribute_Reference
     * Meta information extracted from the WSDL
     * - documentation: Distance Calculation Attribute Type Reference defines the type of attribute to be collected for the Expense Item.
     * - minOccurs: 0
     * @var \StructType\Expense_Item_Attribute_TypeObjectType
     */
    public $Distance_Calculation_Attribute_Reference;
    /**
     * The Enable_for_Expense_Reports
     * Meta information extracted from the WSDL
     * - documentation: True if manual calculation attributes are required on expense reports.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Enable_for_Expense_Reports;
    /**
     * The Enable_for_Spend_Authorizations
     * Meta information extracted from the WSDL
     * - documentation: True if manual calculation attributes are required on spend authorizations.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Enable_for_Spend_Authorizations;
    /**
     * Constructor method for Distance_Calculation_Attribute_Configuration_DataType
     * @uses Distance_Calculation_Attribute_Configuration_DataType::setDistance_Calculation_Attribute_Reference()
     * @uses Distance_Calculation_Attribute_Configuration_DataType::setEnable_for_Expense_Reports()
     * @uses Distance_Calculation_Attribute_Configuration_DataType::setEnable_for_Spend_Authorizations()
     * @param \StructType\Expense_Item_Attribute_TypeObjectType $distance_Calculation_Attribute_Reference
     * @param bool $enable_for_Expense_Reports
     * @param bool $enable_for_Spend_Authorizations
     */
    public function __construct(\StructType\Expense_Item_Attribute_TypeObjectType $distance_Calculation_Attribute_Reference = null, $enable_for_Expense_Reports = null, $enable_for_Spend_Authorizations = null)
    {
        $this
            ->setDistance_Calculation_Attribute_Reference($distance_Calculation_Attribute_Reference)
            ->setEnable_for_Expense_Reports($enable_for_Expense_Reports)
            ->setEnable_for_Spend_Authorizations($enable_for_Spend_Authorizations);
    }
    /**
     * Get Distance_Calculation_Attribute_Reference value
     * @return \StructType\Expense_Item_Attribute_TypeObjectType|null
     */
    public function getDistance_Calculation_Attribute_Reference()
    {
        return $this->Distance_Calculation_Attribute_Reference;
    }
    /**
     * Set Distance_Calculation_Attribute_Reference value
     * @param \StructType\Expense_Item_Attribute_TypeObjectType $distance_Calculation_Attribute_Reference
     * @return \StructType\Distance_Calculation_Attribute_Configuration_DataType
     */
    public function setDistance_Calculation_Attribute_Reference(\StructType\Expense_Item_Attribute_TypeObjectType $distance_Calculation_Attribute_Reference = null)
    {
        $this->Distance_Calculation_Attribute_Reference = $distance_Calculation_Attribute_Reference;
        return $this;
    }
    /**
     * Get Enable_for_Expense_Reports value
     * @return bool|null
     */
    public function getEnable_for_Expense_Reports()
    {
        return $this->Enable_for_Expense_Reports;
    }
    /**
     * Set Enable_for_Expense_Reports value
     * @param bool $enable_for_Expense_Reports
     * @return \StructType\Distance_Calculation_Attribute_Configuration_DataType
     */
    public function setEnable_for_Expense_Reports($enable_for_Expense_Reports = null)
    {
        // validation for constraint: boolean
        if (!is_null($enable_for_Expense_Reports) && !is_bool($enable_for_Expense_Reports)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enable_for_Expense_Reports, true), gettype($enable_for_Expense_Reports)), __LINE__);
        }
        $this->Enable_for_Expense_Reports = $enable_for_Expense_Reports;
        return $this;
    }
    /**
     * Get Enable_for_Spend_Authorizations value
     * @return bool|null
     */
    public function getEnable_for_Spend_Authorizations()
    {
        return $this->Enable_for_Spend_Authorizations;
    }
    /**
     * Set Enable_for_Spend_Authorizations value
     * @param bool $enable_for_Spend_Authorizations
     * @return \StructType\Distance_Calculation_Attribute_Configuration_DataType
     */
    public function setEnable_for_Spend_Authorizations($enable_for_Spend_Authorizations = null)
    {
        // validation for constraint: boolean
        if (!is_null($enable_for_Spend_Authorizations) && !is_bool($enable_for_Spend_Authorizations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enable_for_Spend_Authorizations, true), gettype($enable_for_Spend_Authorizations)), __LINE__);
        }
        $this->Enable_for_Spend_Authorizations = $enable_for_Spend_Authorizations;
        return $this;
    }
}
