<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Refund_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: This web service request reference includes instances for Supplier Refunds.
 * @subpackage Structs
 */
class Supplier_Refund_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Supplier_Refund_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Refund.
     * - maxOccurs: unbounded
     * @var \StructType\Supplier_RefundObjectType[]
     */
    public $Supplier_Refund_Reference;
    /**
     * Constructor method for Supplier_Refund_Request_ReferencesType
     * @uses Supplier_Refund_Request_ReferencesType::setSupplier_Refund_Reference()
     * @param \StructType\Supplier_RefundObjectType[] $supplier_Refund_Reference
     */
    public function __construct(array $supplier_Refund_Reference = array())
    {
        $this
            ->setSupplier_Refund_Reference($supplier_Refund_Reference);
    }
    /**
     * Get Supplier_Refund_Reference value
     * @return \StructType\Supplier_RefundObjectType[]|null
     */
    public function getSupplier_Refund_Reference()
    {
        return $this->Supplier_Refund_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Refund_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Refund_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Refund_ReferenceForArrayConstraintsFromSetSupplier_Refund_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Refund_Request_ReferencesTypeSupplier_Refund_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Refund_Request_ReferencesTypeSupplier_Refund_ReferenceItem instanceof \StructType\Supplier_RefundObjectType) {
                $invalidValues[] = is_object($supplier_Refund_Request_ReferencesTypeSupplier_Refund_ReferenceItem) ? get_class($supplier_Refund_Request_ReferencesTypeSupplier_Refund_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Refund_Request_ReferencesTypeSupplier_Refund_ReferenceItem), var_export($supplier_Refund_Request_ReferencesTypeSupplier_Refund_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Refund_Reference property can only contain items of type \StructType\Supplier_RefundObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Refund_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_RefundObjectType[] $supplier_Refund_Reference
     * @return \StructType\Supplier_Refund_Request_ReferencesType
     */
    public function setSupplier_Refund_Reference(array $supplier_Refund_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Refund_ReferenceArrayErrorMessage = self::validateSupplier_Refund_ReferenceForArrayConstraintsFromSetSupplier_Refund_Reference($supplier_Refund_Reference))) {
            throw new \InvalidArgumentException($supplier_Refund_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Refund_Reference = $supplier_Refund_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Refund_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_RefundObjectType $item
     * @return \StructType\Supplier_Refund_Request_ReferencesType
     */
    public function addToSupplier_Refund_Reference(\StructType\Supplier_RefundObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_RefundObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Refund_Reference property can only contain items of type \StructType\Supplier_RefundObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Refund_Reference[] = $item;
        return $this;
    }
}
