<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Contract_Line_Replacement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Only one worktag for each type is allowed for each document line. | Can not have any combination of Project, Project Phase or Project Task worktags for the same line. | Supplier Contract Line Replacement Data
 * @subpackage Structs
 */
class Supplier_Contract_Line_Replacement_DataType extends AbstractStructBase
{
    /**
     * The Line_Number
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Line NumbercXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@lineNumber | Purchase Order Line Number from which the business asset was ordered | This is the Supplier Contract Line Number for the Supplier
     * Contract Line you wish to put on Hold. | RFQ Line Number | The line number of the Purchase Order. | Line Number
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * @var string
     */
    public $Line_Number;
    /**
     * The Company_for_Invoices_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company for Invoices Reference
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_for_Invoices_Reference;
    /**
     * The Line_On_Hold
     * Meta information extracted from the WSDL
     * - documentation: Contract Line On Hold
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Line_On_Hold;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Reference
     * - minOccurs: 0
     * @var \StructType\Procurement_ItemObjectType
     */
    public $Item_Reference;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Item Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Category Reference
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Tax_Applicability_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Applicability Reference
     * - minOccurs: 0
     * @var \StructType\Tax_ApplicabilityObjectType
     */
    public $Tax_Applicability_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Code Reference
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Tax_Point_Date_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Point Date Type for a Goods Line on a Supplier Contract.
     * - minOccurs: 0
     * @var \StructType\Tax_Point_Date_TypeObjectType
     */
    public $Tax_Point_Date_Type_Reference;
    /**
     * The Tax_Rate_Recoverabilities_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Tax_Rate_Options_DataType
     */
    public $Tax_Rate_Recoverabilities_Data;
    /**
     * The Percentage
     * Meta information extracted from the WSDL
     * - documentation: Percentage for supplier contract line. Used to calculate the extended amount on the supplier contract line. Only used for Finance Lease and Operating Lease Contract Types.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 3
     * @var float
     */
    public $Percentage;
    /**
     * The Packaging_String
     * Meta information extracted from the WSDL
     * - documentation: Packaging String associated with the Item specified on the Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Packaging_String;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Consigned_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Consigned quantity represents the maximum quantity available to be on hand at a given moment for the consigned product.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Consigned_Quantity;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit of Measure Reference
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Conversion_Factor
     * Meta information extracted from the WSDL
     * - documentation: The conversion factor to be used when converting the unit of measure to the base unit of measure for the catalog item. | Conversion Factor for the ordering unit of measure to the base unit of measure of the catalog item. | Purchase
     * Item stocking Unit of measure Conversion factor | Positive numeric value used to calculate the Ordered Quantity that is shipped from Shipped Quantity provided at Advance Shipment Line. If Shipped Quantity is five and Conversion Factor is two , then
     * Quantity shipped is calculated as Ten. Default value for Conversion Factor is one. | Conversion Factor between the Ordering Unit of Measure and the Base Unit of Measure of Catalog Load Item. | Conversion factor to the base UOM. | Conversion Factor
     * from Ordering Unit of Measure to Purchase Item's Base Unit of Measure. | Conversion Factor for the JIT UOM of the Catalog or Supplier Item. | Conversion Factor for the Bulk UOM of the Catalog or Supplier Item. | The conversion factor of the web
     * item's ordering unit of measure to the linked purchase item's base unit of measure.
     * - base: xsd:decimal
     * - fractionDigits: 9
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Conversion_Factor;
    /**
     * The Unit_Residual_Value
     * Meta information extracted from the WSDL
     * - documentation: Residual Value of the item selected per unit
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Residual_Value;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Charge_Control_Data
     * Meta information extracted from the WSDL
     * - documentation: Goods line charge control amounts
     * - minOccurs: 0
     * @var \StructType\Charge_Control_DataType
     */
    public $Charge_Control_Data;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The In_Service_Date_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contract Signed Date must be present if selected as In Service Date Option. | In Service Date Options are not allowed when Spend Category does not track Intangible Assets. | This is the In Service Date Option. Please choose from one
     * of the following options:Supplier Contract cannot be updated using this Web Service. It has either already been Amended, or there are related Schedules or Business Documents using the Contract. Or the Contract has been denied, closed or canceled.In
     * Service Dates are only available for Spend Categories tracking Intangible Assets.
     * - choice: In_Service_Date_Option_Reference | Specified_In_Service_Date
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Procurement_Date_OptionObjectType
     */
    public $In_Service_Date_Option_Reference;
    /**
     * The Specified_In_Service_Date
     * Meta information extracted from the WSDL
     * - documentation: In Service Date Options are not allowed when Spend Category does not track Intangible Assets. | Specified In Service Date must be greater than or equal to the Contract Start Date. | Specified In Service Date. Use this field when you
     * wish to specify an In Service Date that isn't one of the available options in the In Service Date Option. In Service Dates are only available for Spend Categories tracking Intangible Assets.
     * - choice: In_Service_Date_Option_Reference | Specified_In_Service_Date
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Specified_In_Service_Date;
    /**
     * The Supplier_Contract_Line_Renewal_Data
     * Meta information extracted from the WSDL
     * - documentation: Renewal Data for Contract Line. Only used on Contracts supporting Renewals and Contracts and has Contract Line End Date.
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_Line_Renewal_DataType
     */
    public $Supplier_Contract_Line_Renewal_Data;
    /**
     * The Retention
     * Meta information extracted from the WSDL
     * - documentation: Retention flag at the Line level
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Retention;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Address Reference for an existing Ship-To Address. If not specified for a Supplier Contract Line that supports Scheduled PO contract type, Workday will default the Purchase Order Ship-To Address specified on the Contract Header.
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Worker, who will be the designated Ship-To Contact.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Location Reference
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Location_Reference;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktag Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The Related_Document_Lines_Reference
     * Meta information extracted from the WSDL
     * - documentation: Represents all the lines this contract line is related to. This field is used for view purposes only.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_LineObjectType[]
     */
    public $Related_Document_Lines_Reference;
    /**
     * The Interest_Line
     * Meta information extracted from the WSDL
     * - documentation: You selected the Interest Line field. You can retrieve interest lines using the Get web service, but you can't set them using the Submit web service. | Indicates that there is an interest line on the supplier contract. You can use
     * the Get web service to retrieve interest lines, but you can't use the Submit web service to select them.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Interest_Line;
    /**
     * Constructor method for Supplier_Contract_Line_Replacement_DataType
     * @uses Supplier_Contract_Line_Replacement_DataType::setLine_Number()
     * @uses Supplier_Contract_Line_Replacement_DataType::setCompany_for_Invoices_Reference()
     * @uses Supplier_Contract_Line_Replacement_DataType::setLine_On_Hold()
     * @uses Supplier_Contract_Line_Replacement_DataType::setItem_Reference()
     * @uses Supplier_Contract_Line_Replacement_DataType::setDescription()
     * @uses Supplier_Contract_Line_Replacement_DataType::setSpend_Category_Reference()
     * @uses Supplier_Contract_Line_Replacement_DataType::setTax_Applicability_Reference()
     * @uses Supplier_Contract_Line_Replacement_DataType::setTax_Code_Reference()
     * @uses Supplier_Contract_Line_Replacement_DataType::setTax_Point_Date_Type_Reference()
     * @uses Supplier_Contract_Line_Replacement_DataType::setTax_Rate_Recoverabilities_Data()
     * @uses Supplier_Contract_Line_Replacement_DataType::setPercentage()
     * @uses Supplier_Contract_Line_Replacement_DataType::setPackaging_String()
     * @uses Supplier_Contract_Line_Replacement_DataType::setQuantity()
     * @uses Supplier_Contract_Line_Replacement_DataType::setConsigned_Quantity()
     * @uses Supplier_Contract_Line_Replacement_DataType::setUnit_of_Measure_Reference()
     * @uses Supplier_Contract_Line_Replacement_DataType::setConversion_Factor()
     * @uses Supplier_Contract_Line_Replacement_DataType::setUnit_Residual_Value()
     * @uses Supplier_Contract_Line_Replacement_DataType::setUnit_Cost()
     * @uses Supplier_Contract_Line_Replacement_DataType::setExtended_Amount()
     * @uses Supplier_Contract_Line_Replacement_DataType::setCharge_Control_Data()
     * @uses Supplier_Contract_Line_Replacement_DataType::setStart_Date()
     * @uses Supplier_Contract_Line_Replacement_DataType::setEnd_Date()
     * @uses Supplier_Contract_Line_Replacement_DataType::setIn_Service_Date_Option_Reference()
     * @uses Supplier_Contract_Line_Replacement_DataType::setSpecified_In_Service_Date()
     * @uses Supplier_Contract_Line_Replacement_DataType::setSupplier_Contract_Line_Renewal_Data()
     * @uses Supplier_Contract_Line_Replacement_DataType::setRetention()
     * @uses Supplier_Contract_Line_Replacement_DataType::setShip_To_Address_Reference()
     * @uses Supplier_Contract_Line_Replacement_DataType::setShip_To_Contact_Reference()
     * @uses Supplier_Contract_Line_Replacement_DataType::setMemo()
     * @uses Supplier_Contract_Line_Replacement_DataType::setLocation_Reference()
     * @uses Supplier_Contract_Line_Replacement_DataType::setWorktag_Reference()
     * @uses Supplier_Contract_Line_Replacement_DataType::setRelated_Document_Lines_Reference()
     * @uses Supplier_Contract_Line_Replacement_DataType::setInterest_Line()
     * @param string $line_Number
     * @param \StructType\CompanyObjectType $company_for_Invoices_Reference
     * @param bool $line_On_Hold
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @param string $description
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Tax_Point_Date_TypeObjectType $tax_Point_Date_Type_Reference
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data
     * @param float $percentage
     * @param string $packaging_String
     * @param float $quantity
     * @param float $consigned_Quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $conversion_Factor
     * @param float $unit_Residual_Value
     * @param float $unit_Cost
     * @param float $extended_Amount
     * @param \StructType\Charge_Control_DataType $charge_Control_Data
     * @param string $start_Date
     * @param string $end_Date
     * @param \StructType\Procurement_Date_OptionObjectType $in_Service_Date_Option_Reference
     * @param string $specified_In_Service_Date
     * @param \StructType\Supplier_Contract_Line_Renewal_DataType $supplier_Contract_Line_Renewal_Data
     * @param bool $retention
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param string $memo
     * @param \StructType\LocationObjectType $location_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @param \StructType\Business_Document_LineObjectType[] $related_Document_Lines_Reference
     * @param bool $interest_Line
     */
    public function __construct($line_Number = null, \StructType\CompanyObjectType $company_for_Invoices_Reference = null, $line_On_Hold = null, \StructType\Procurement_ItemObjectType $item_Reference = null, $description = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, \StructType\Tax_Point_Date_TypeObjectType $tax_Point_Date_Type_Reference = null, \StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data = null, $percentage = null, $packaging_String = null, $quantity = null, $consigned_Quantity = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $conversion_Factor = null, $unit_Residual_Value = null, $unit_Cost = null, $extended_Amount = null, \StructType\Charge_Control_DataType $charge_Control_Data = null, $start_Date = null, $end_Date = null, \StructType\Procurement_Date_OptionObjectType $in_Service_Date_Option_Reference = null, $specified_In_Service_Date = null, \StructType\Supplier_Contract_Line_Renewal_DataType $supplier_Contract_Line_Renewal_Data = null, $retention = null, \StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, $memo = null, \StructType\LocationObjectType $location_Reference = null, array $worktag_Reference = array(), array $related_Document_Lines_Reference = array(), $interest_Line = null)
    {
        $this
            ->setLine_Number($line_Number)
            ->setCompany_for_Invoices_Reference($company_for_Invoices_Reference)
            ->setLine_On_Hold($line_On_Hold)
            ->setItem_Reference($item_Reference)
            ->setDescription($description)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setTax_Applicability_Reference($tax_Applicability_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setTax_Point_Date_Type_Reference($tax_Point_Date_Type_Reference)
            ->setTax_Rate_Recoverabilities_Data($tax_Rate_Recoverabilities_Data)
            ->setPercentage($percentage)
            ->setPackaging_String($packaging_String)
            ->setQuantity($quantity)
            ->setConsigned_Quantity($consigned_Quantity)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setConversion_Factor($conversion_Factor)
            ->setUnit_Residual_Value($unit_Residual_Value)
            ->setUnit_Cost($unit_Cost)
            ->setExtended_Amount($extended_Amount)
            ->setCharge_Control_Data($charge_Control_Data)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setIn_Service_Date_Option_Reference($in_Service_Date_Option_Reference)
            ->setSpecified_In_Service_Date($specified_In_Service_Date)
            ->setSupplier_Contract_Line_Renewal_Data($supplier_Contract_Line_Renewal_Data)
            ->setRetention($retention)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setMemo($memo)
            ->setLocation_Reference($location_Reference)
            ->setWorktag_Reference($worktag_Reference)
            ->setRelated_Document_Lines_Reference($related_Document_Lines_Reference)
            ->setInterest_Line($interest_Line);
    }
    /**
     * Get Line_Number value
     * @return string|null
     */
    public function getLine_Number()
    {
        return $this->Line_Number;
    }
    /**
     * Set Line_Number value
     * @param string $line_Number
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setLine_Number($line_Number = null)
    {
        // validation for constraint: string
        if (!is_null($line_Number) && !is_string($line_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_Number, true), gettype($line_Number)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($line_Number) && mb_strlen($line_Number) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($line_Number)), __LINE__);
        }
        $this->Line_Number = $line_Number;
        return $this;
    }
    /**
     * Get Company_for_Invoices_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_for_Invoices_Reference()
    {
        return $this->Company_for_Invoices_Reference;
    }
    /**
     * Set Company_for_Invoices_Reference value
     * @param \StructType\CompanyObjectType $company_for_Invoices_Reference
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setCompany_for_Invoices_Reference(\StructType\CompanyObjectType $company_for_Invoices_Reference = null)
    {
        $this->Company_for_Invoices_Reference = $company_for_Invoices_Reference;
        return $this;
    }
    /**
     * Get Line_On_Hold value
     * @return bool|null
     */
    public function getLine_On_Hold()
    {
        return $this->Line_On_Hold;
    }
    /**
     * Set Line_On_Hold value
     * @param bool $line_On_Hold
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setLine_On_Hold($line_On_Hold = null)
    {
        // validation for constraint: boolean
        if (!is_null($line_On_Hold) && !is_bool($line_On_Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($line_On_Hold, true), gettype($line_On_Hold)), __LINE__);
        }
        $this->Line_On_Hold = $line_On_Hold;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Procurement_ItemObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setItem_Reference(\StructType\Procurement_ItemObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Tax_Applicability_Reference value
     * @return \StructType\Tax_ApplicabilityObjectType|null
     */
    public function getTax_Applicability_Reference()
    {
        return $this->Tax_Applicability_Reference;
    }
    /**
     * Set Tax_Applicability_Reference value
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setTax_Applicability_Reference(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null)
    {
        $this->Tax_Applicability_Reference = $tax_Applicability_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Tax_Point_Date_Type_Reference value
     * @return \StructType\Tax_Point_Date_TypeObjectType|null
     */
    public function getTax_Point_Date_Type_Reference()
    {
        return $this->Tax_Point_Date_Type_Reference;
    }
    /**
     * Set Tax_Point_Date_Type_Reference value
     * @param \StructType\Tax_Point_Date_TypeObjectType $tax_Point_Date_Type_Reference
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setTax_Point_Date_Type_Reference(\StructType\Tax_Point_Date_TypeObjectType $tax_Point_Date_Type_Reference = null)
    {
        $this->Tax_Point_Date_Type_Reference = $tax_Point_Date_Type_Reference;
        return $this;
    }
    /**
     * Get Tax_Rate_Recoverabilities_Data value
     * @return \StructType\Tax_Rate_Options_DataType|null
     */
    public function getTax_Rate_Recoverabilities_Data()
    {
        return $this->Tax_Rate_Recoverabilities_Data;
    }
    /**
     * Set Tax_Rate_Recoverabilities_Data value
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setTax_Rate_Recoverabilities_Data(\StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data = null)
    {
        $this->Tax_Rate_Recoverabilities_Data = $tax_Rate_Recoverabilities_Data;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setPercentage($percentage = null)
    {
        // validation for constraint: float
        if (!is_null($percentage) && !(is_float($percentage) || is_numeric($percentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentage, true), gettype($percentage)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($percentage) && mb_strlen(mb_substr($percentage, false !== mb_strpos($percentage, '.') ? mb_strpos($percentage, '.') + 1 : mb_strlen($percentage))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($percentage, true), mb_strlen(mb_substr($percentage, mb_strpos($percentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($percentage) && $percentage < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($percentage, true)), __LINE__);
        }
        // validation for constraint: totalDigits(3)
        if (!is_null($percentage) && mb_strlen(preg_replace('/(\D)/', '', $percentage)) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 3 digits, "%d" given', var_export($percentage, true), mb_strlen(preg_replace('/(\D)/', '', $percentage))), __LINE__);
        }
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Get Packaging_String value
     * @return string|null
     */
    public function getPackaging_String()
    {
        return $this->Packaging_String;
    }
    /**
     * Set Packaging_String value
     * @param string $packaging_String
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setPackaging_String($packaging_String = null)
    {
        // validation for constraint: string
        if (!is_null($packaging_String) && !is_string($packaging_String)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packaging_String, true), gettype($packaging_String)), __LINE__);
        }
        $this->Packaging_String = $packaging_String;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Consigned_Quantity value
     * @return float|null
     */
    public function getConsigned_Quantity()
    {
        return $this->Consigned_Quantity;
    }
    /**
     * Set Consigned_Quantity value
     * @param float $consigned_Quantity
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setConsigned_Quantity($consigned_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($consigned_Quantity) && !(is_float($consigned_Quantity) || is_numeric($consigned_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($consigned_Quantity, true), gettype($consigned_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($consigned_Quantity) && mb_strlen(mb_substr($consigned_Quantity, false !== mb_strpos($consigned_Quantity, '.') ? mb_strpos($consigned_Quantity, '.') + 1 : mb_strlen($consigned_Quantity))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($consigned_Quantity, true), mb_strlen(mb_substr($consigned_Quantity, mb_strpos($consigned_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($consigned_Quantity) && $consigned_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($consigned_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($consigned_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $consigned_Quantity)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($consigned_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $consigned_Quantity))), __LINE__);
        }
        $this->Consigned_Quantity = $consigned_Quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Conversion_Factor value
     * @return float|null
     */
    public function getConversion_Factor()
    {
        return $this->Conversion_Factor;
    }
    /**
     * Set Conversion_Factor value
     * @param float $conversion_Factor
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setConversion_Factor($conversion_Factor = null)
    {
        // validation for constraint: float
        if (!is_null($conversion_Factor) && !(is_float($conversion_Factor) || is_numeric($conversion_Factor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversion_Factor, true), gettype($conversion_Factor)), __LINE__);
        }
        // validation for constraint: fractionDigits(9)
        if (!is_null($conversion_Factor) && mb_strlen(mb_substr($conversion_Factor, false !== mb_strpos($conversion_Factor, '.') ? mb_strpos($conversion_Factor, '.') + 1 : mb_strlen($conversion_Factor))) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 9 fraction digits, %d given', var_export($conversion_Factor, true), mb_strlen(mb_substr($conversion_Factor, mb_strpos($conversion_Factor, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($conversion_Factor) && $conversion_Factor < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($conversion_Factor, true)), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($conversion_Factor) && mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($conversion_Factor, true), mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor))), __LINE__);
        }
        $this->Conversion_Factor = $conversion_Factor;
        return $this;
    }
    /**
     * Get Unit_Residual_Value value
     * @return float|null
     */
    public function getUnit_Residual_Value()
    {
        return $this->Unit_Residual_Value;
    }
    /**
     * Set Unit_Residual_Value value
     * @param float $unit_Residual_Value
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setUnit_Residual_Value($unit_Residual_Value = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Residual_Value) && !(is_float($unit_Residual_Value) || is_numeric($unit_Residual_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Residual_Value, true), gettype($unit_Residual_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Residual_Value) && mb_strlen(mb_substr($unit_Residual_Value, false !== mb_strpos($unit_Residual_Value, '.') ? mb_strpos($unit_Residual_Value, '.') + 1 : mb_strlen($unit_Residual_Value))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Residual_Value, true), mb_strlen(mb_substr($unit_Residual_Value, mb_strpos($unit_Residual_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Residual_Value) && mb_strlen(preg_replace('/(\D)/', '', $unit_Residual_Value)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Residual_Value, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Residual_Value))), __LINE__);
        }
        $this->Unit_Residual_Value = $unit_Residual_Value;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Charge_Control_Data value
     * @return \StructType\Charge_Control_DataType|null
     */
    public function getCharge_Control_Data()
    {
        return $this->Charge_Control_Data;
    }
    /**
     * Set Charge_Control_Data value
     * @param \StructType\Charge_Control_DataType $charge_Control_Data
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setCharge_Control_Data(\StructType\Charge_Control_DataType $charge_Control_Data = null)
    {
        $this->Charge_Control_Data = $charge_Control_Data;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get In_Service_Date_Option_Reference value
     * @return \StructType\Procurement_Date_OptionObjectType|null
     */
    public function getIn_Service_Date_Option_Reference()
    {
        return isset($this->In_Service_Date_Option_Reference) ? $this->In_Service_Date_Option_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setIn_Service_Date_Option_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIn_Service_Date_Option_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIn_Service_Date_Option_ReferenceForChoiceConstraintsFromSetIn_Service_Date_Option_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Specified_In_Service_Date',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property In_Service_Date_Option_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: In_Service_Date_Option_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set In_Service_Date_Option_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Date_OptionObjectType $in_Service_Date_Option_Reference
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setIn_Service_Date_Option_Reference(\StructType\Procurement_Date_OptionObjectType $in_Service_Date_Option_Reference = null)
    {
        // validation for constraint: choice(In_Service_Date_Option_Reference, Specified_In_Service_Date)
        if ('' !== ($in_Service_Date_Option_ReferenceChoiceErrorMessage = self::validateIn_Service_Date_Option_ReferenceForChoiceConstraintsFromSetIn_Service_Date_Option_Reference($in_Service_Date_Option_Reference))) {
            throw new \InvalidArgumentException($in_Service_Date_Option_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($in_Service_Date_Option_Reference) || (is_array($in_Service_Date_Option_Reference) && empty($in_Service_Date_Option_Reference))) {
            unset($this->In_Service_Date_Option_Reference);
        } else {
            $this->In_Service_Date_Option_Reference = $in_Service_Date_Option_Reference;
        }
        return $this;
    }
    /**
     * Get Specified_In_Service_Date value
     * @return string|null
     */
    public function getSpecified_In_Service_Date()
    {
        return isset($this->Specified_In_Service_Date) ? $this->Specified_In_Service_Date : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSpecified_In_Service_Date method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecified_In_Service_Date method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSpecified_In_Service_DateForChoiceConstraintsFromSetSpecified_In_Service_Date($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'In_Service_Date_Option_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Specified_In_Service_Date can\'t be set as the property %s is already set. Only one property must be set among these properties: Specified_In_Service_Date, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Specified_In_Service_Date value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $specified_In_Service_Date
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setSpecified_In_Service_Date($specified_In_Service_Date = null)
    {
        // validation for constraint: string
        if (!is_null($specified_In_Service_Date) && !is_string($specified_In_Service_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specified_In_Service_Date, true), gettype($specified_In_Service_Date)), __LINE__);
        }
        // validation for constraint: choice(In_Service_Date_Option_Reference, Specified_In_Service_Date)
        if ('' !== ($specified_In_Service_DateChoiceErrorMessage = self::validateSpecified_In_Service_DateForChoiceConstraintsFromSetSpecified_In_Service_Date($specified_In_Service_Date))) {
            throw new \InvalidArgumentException($specified_In_Service_DateChoiceErrorMessage, __LINE__);
        }
        if (is_null($specified_In_Service_Date) || (is_array($specified_In_Service_Date) && empty($specified_In_Service_Date))) {
            unset($this->Specified_In_Service_Date);
        } else {
            $this->Specified_In_Service_Date = $specified_In_Service_Date;
        }
        return $this;
    }
    /**
     * Get Supplier_Contract_Line_Renewal_Data value
     * @return \StructType\Supplier_Contract_Line_Renewal_DataType|null
     */
    public function getSupplier_Contract_Line_Renewal_Data()
    {
        return $this->Supplier_Contract_Line_Renewal_Data;
    }
    /**
     * Set Supplier_Contract_Line_Renewal_Data value
     * @param \StructType\Supplier_Contract_Line_Renewal_DataType $supplier_Contract_Line_Renewal_Data
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setSupplier_Contract_Line_Renewal_Data(\StructType\Supplier_Contract_Line_Renewal_DataType $supplier_Contract_Line_Renewal_Data = null)
    {
        $this->Supplier_Contract_Line_Renewal_Data = $supplier_Contract_Line_Renewal_Data;
        return $this;
    }
    /**
     * Get Retention value
     * @return bool|null
     */
    public function getRetention()
    {
        return $this->Retention;
    }
    /**
     * Set Retention value
     * @param bool $retention
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setRetention($retention = null)
    {
        // validation for constraint: boolean
        if (!is_null($retention) && !is_bool($retention)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retention, true), gettype($retention)), __LINE__);
        }
        $this->Retention = $retention;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->Ship_To_Address_Reference;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->Ship_To_Contact_Reference;
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * Set Location_Reference value
     * @param \StructType\LocationObjectType $location_Reference
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setLocation_Reference(\StructType\LocationObjectType $location_Reference = null)
    {
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Line_Replacement_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Line_Replacement_DataTypeWorktag_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($supplier_Contract_Line_Replacement_DataTypeWorktag_ReferenceItem) ? get_class($supplier_Contract_Line_Replacement_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Contract_Line_Replacement_DataTypeWorktag_ReferenceItem), var_export($supplier_Contract_Line_Replacement_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function addToWorktag_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Related_Document_Lines_Reference value
     * @return \StructType\Business_Document_LineObjectType[]|null
     */
    public function getRelated_Document_Lines_Reference()
    {
        return $this->Related_Document_Lines_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRelated_Document_Lines_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelated_Document_Lines_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelated_Document_Lines_ReferenceForArrayConstraintsFromSetRelated_Document_Lines_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Contract_Line_Replacement_DataTypeRelated_Document_Lines_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Contract_Line_Replacement_DataTypeRelated_Document_Lines_ReferenceItem instanceof \StructType\Business_Document_LineObjectType) {
                $invalidValues[] = is_object($supplier_Contract_Line_Replacement_DataTypeRelated_Document_Lines_ReferenceItem) ? get_class($supplier_Contract_Line_Replacement_DataTypeRelated_Document_Lines_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Contract_Line_Replacement_DataTypeRelated_Document_Lines_ReferenceItem), var_export($supplier_Contract_Line_Replacement_DataTypeRelated_Document_Lines_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Related_Document_Lines_Reference property can only contain items of type \StructType\Business_Document_LineObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Related_Document_Lines_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_LineObjectType[] $related_Document_Lines_Reference
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setRelated_Document_Lines_Reference(array $related_Document_Lines_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($related_Document_Lines_ReferenceArrayErrorMessage = self::validateRelated_Document_Lines_ReferenceForArrayConstraintsFromSetRelated_Document_Lines_Reference($related_Document_Lines_Reference))) {
            throw new \InvalidArgumentException($related_Document_Lines_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Related_Document_Lines_Reference = $related_Document_Lines_Reference;
        return $this;
    }
    /**
     * Add item to Related_Document_Lines_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_LineObjectType $item
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function addToRelated_Document_Lines_Reference(\StructType\Business_Document_LineObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_LineObjectType) {
            throw new \InvalidArgumentException(sprintf('The Related_Document_Lines_Reference property can only contain items of type \StructType\Business_Document_LineObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Related_Document_Lines_Reference[] = $item;
        return $this;
    }
    /**
     * Get Interest_Line value
     * @return bool|null
     */
    public function getInterest_Line()
    {
        return $this->Interest_Line;
    }
    /**
     * Set Interest_Line value
     * @param bool $interest_Line
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType
     */
    public function setInterest_Line($interest_Line = null)
    {
        // validation for constraint: boolean
        if (!is_null($interest_Line) && !is_bool($interest_Line)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($interest_Line, true), gettype($interest_Line)), __LINE__);
        }
        $this->Interest_Line = $interest_Line;
        return $this;
    }
}
