<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hotel_Itemization_Mapping_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You can’t specify distance-based expense items on hotel itemizations. | An Expense Item entered in the Hotel Itemization Mapping is either based on an Allowance Plan, a Fixed Expense, Inactive, or Hotel Itemized, and therefore
 * invalid. | Hotel Itemization Mapping Data element is used for the Hotel Itemization Mapping table.
 * @subpackage Structs
 */
class Hotel_Itemization_Mapping_DataType extends AbstractStructBase
{
    /**
     * The Hotel_Charge_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Hotel Charge Type field used in the Hotel Itemization Mapping table.
     * - minOccurs: 0
     * @var \StructType\Hotel_Charge_TypeObjectType
     */
    public $Hotel_Charge_Type_Reference;
    /**
     * The Expense_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Expense Item field used in the Hotel Itemization Mapping table.
     * - minOccurs: 0
     * @var \StructType\Expense_ItemObjectType
     */
    public $Expense_Item_Reference;
    /**
     * The Hotel_Mapping_Field_Required
     * Meta information extracted from the WSDL
     * - documentation: Hotel Mapping Field Required boolean used in the Hotel Itemization Mapping table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Hotel_Mapping_Field_Required;
    /**
     * Constructor method for Hotel_Itemization_Mapping_DataType
     * @uses Hotel_Itemization_Mapping_DataType::setHotel_Charge_Type_Reference()
     * @uses Hotel_Itemization_Mapping_DataType::setExpense_Item_Reference()
     * @uses Hotel_Itemization_Mapping_DataType::setHotel_Mapping_Field_Required()
     * @param \StructType\Hotel_Charge_TypeObjectType $hotel_Charge_Type_Reference
     * @param \StructType\Expense_ItemObjectType $expense_Item_Reference
     * @param bool $hotel_Mapping_Field_Required
     */
    public function __construct(\StructType\Hotel_Charge_TypeObjectType $hotel_Charge_Type_Reference = null, \StructType\Expense_ItemObjectType $expense_Item_Reference = null, $hotel_Mapping_Field_Required = null)
    {
        $this
            ->setHotel_Charge_Type_Reference($hotel_Charge_Type_Reference)
            ->setExpense_Item_Reference($expense_Item_Reference)
            ->setHotel_Mapping_Field_Required($hotel_Mapping_Field_Required);
    }
    /**
     * Get Hotel_Charge_Type_Reference value
     * @return \StructType\Hotel_Charge_TypeObjectType|null
     */
    public function getHotel_Charge_Type_Reference()
    {
        return $this->Hotel_Charge_Type_Reference;
    }
    /**
     * Set Hotel_Charge_Type_Reference value
     * @param \StructType\Hotel_Charge_TypeObjectType $hotel_Charge_Type_Reference
     * @return \StructType\Hotel_Itemization_Mapping_DataType
     */
    public function setHotel_Charge_Type_Reference(\StructType\Hotel_Charge_TypeObjectType $hotel_Charge_Type_Reference = null)
    {
        $this->Hotel_Charge_Type_Reference = $hotel_Charge_Type_Reference;
        return $this;
    }
    /**
     * Get Expense_Item_Reference value
     * @return \StructType\Expense_ItemObjectType|null
     */
    public function getExpense_Item_Reference()
    {
        return $this->Expense_Item_Reference;
    }
    /**
     * Set Expense_Item_Reference value
     * @param \StructType\Expense_ItemObjectType $expense_Item_Reference
     * @return \StructType\Hotel_Itemization_Mapping_DataType
     */
    public function setExpense_Item_Reference(\StructType\Expense_ItemObjectType $expense_Item_Reference = null)
    {
        $this->Expense_Item_Reference = $expense_Item_Reference;
        return $this;
    }
    /**
     * Get Hotel_Mapping_Field_Required value
     * @return bool|null
     */
    public function getHotel_Mapping_Field_Required()
    {
        return $this->Hotel_Mapping_Field_Required;
    }
    /**
     * Set Hotel_Mapping_Field_Required value
     * @param bool $hotel_Mapping_Field_Required
     * @return \StructType\Hotel_Itemization_Mapping_DataType
     */
    public function setHotel_Mapping_Field_Required($hotel_Mapping_Field_Required = null)
    {
        // validation for constraint: boolean
        if (!is_null($hotel_Mapping_Field_Required) && !is_bool($hotel_Mapping_Field_Required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hotel_Mapping_Field_Required, true), gettype($hotel_Mapping_Field_Required)), __LINE__);
        }
        $this->Hotel_Mapping_Field_Required = $hotel_Mapping_Field_Required;
        return $this;
    }
}
