<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Catalog_ItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Catalog Item Response Data
 * @subpackage Structs
 */
class Catalog_ItemType extends AbstractStructBase
{
    /**
     * The Catalog_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: The ID of the Catalog Item
     * - minOccurs: 0
     * @var \StructType\Catalog_ItemObjectType
     */
    public $Catalog_Item_Reference;
    /**
     * The Catalog_Item_Data
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Catalog_Item_DataType[]
     */
    public $Catalog_Item_Data;
    /**
     * Constructor method for Catalog_ItemType
     * @uses Catalog_ItemType::setCatalog_Item_Reference()
     * @uses Catalog_ItemType::setCatalog_Item_Data()
     * @param \StructType\Catalog_ItemObjectType $catalog_Item_Reference
     * @param \StructType\Catalog_Item_DataType[] $catalog_Item_Data
     */
    public function __construct(\StructType\Catalog_ItemObjectType $catalog_Item_Reference = null, array $catalog_Item_Data = array())
    {
        $this
            ->setCatalog_Item_Reference($catalog_Item_Reference)
            ->setCatalog_Item_Data($catalog_Item_Data);
    }
    /**
     * Get Catalog_Item_Reference value
     * @return \StructType\Catalog_ItemObjectType|null
     */
    public function getCatalog_Item_Reference()
    {
        return $this->Catalog_Item_Reference;
    }
    /**
     * Set Catalog_Item_Reference value
     * @param \StructType\Catalog_ItemObjectType $catalog_Item_Reference
     * @return \StructType\Catalog_ItemType
     */
    public function setCatalog_Item_Reference(\StructType\Catalog_ItemObjectType $catalog_Item_Reference = null)
    {
        $this->Catalog_Item_Reference = $catalog_Item_Reference;
        return $this;
    }
    /**
     * Get Catalog_Item_Data value
     * @return \StructType\Catalog_Item_DataType[]|null
     */
    public function getCatalog_Item_Data()
    {
        return $this->Catalog_Item_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCatalog_Item_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatalog_Item_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCatalog_Item_DataForArrayConstraintsFromSetCatalog_Item_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_ItemTypeCatalog_Item_DataItem) {
            // validation for constraint: itemType
            if (!$catalog_ItemTypeCatalog_Item_DataItem instanceof \StructType\Catalog_Item_DataType) {
                $invalidValues[] = is_object($catalog_ItemTypeCatalog_Item_DataItem) ? get_class($catalog_ItemTypeCatalog_Item_DataItem) : sprintf('%s(%s)', gettype($catalog_ItemTypeCatalog_Item_DataItem), var_export($catalog_ItemTypeCatalog_Item_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Catalog_Item_Data property can only contain items of type \StructType\Catalog_Item_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Catalog_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Item_DataType[] $catalog_Item_Data
     * @return \StructType\Catalog_ItemType
     */
    public function setCatalog_Item_Data(array $catalog_Item_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($catalog_Item_DataArrayErrorMessage = self::validateCatalog_Item_DataForArrayConstraintsFromSetCatalog_Item_Data($catalog_Item_Data))) {
            throw new \InvalidArgumentException($catalog_Item_DataArrayErrorMessage, __LINE__);
        }
        $this->Catalog_Item_Data = $catalog_Item_Data;
        return $this;
    }
    /**
     * Add item to Catalog_Item_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Item_DataType $item
     * @return \StructType\Catalog_ItemType
     */
    public function addToCatalog_Item_Data(\StructType\Catalog_Item_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Catalog_Item_DataType) {
            throw new \InvalidArgumentException(sprintf('The Catalog_Item_Data property can only contain items of type \StructType\Catalog_Item_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Catalog_Item_Data[] = $item;
        return $this;
    }
}
