<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Business_Entity_ContactType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Business Entity Contact reference and data
 * @subpackage Structs
 */
class Business_Entity_ContactType extends AbstractStructBase
{
    /**
     * The Business_Entity_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Business Entity Contact
     * - minOccurs: 0
     * @var \StructType\Business_Entity_ContactObjectType
     */
    public $Business_Entity_Contact_Reference;
    /**
     * The Business_Entity_Contact_Data
     * Meta information extracted from the WSDL
     * - documentation: Business Entity Contact Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Entity_Contact_DataType[]
     */
    public $Business_Entity_Contact_Data;
    /**
     * Constructor method for Business_Entity_ContactType
     * @uses Business_Entity_ContactType::setBusiness_Entity_Contact_Reference()
     * @uses Business_Entity_ContactType::setBusiness_Entity_Contact_Data()
     * @param \StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference
     * @param \StructType\Business_Entity_Contact_DataType[] $business_Entity_Contact_Data
     */
    public function __construct(\StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference = null, array $business_Entity_Contact_Data = array())
    {
        $this
            ->setBusiness_Entity_Contact_Reference($business_Entity_Contact_Reference)
            ->setBusiness_Entity_Contact_Data($business_Entity_Contact_Data);
    }
    /**
     * Get Business_Entity_Contact_Reference value
     * @return \StructType\Business_Entity_ContactObjectType|null
     */
    public function getBusiness_Entity_Contact_Reference()
    {
        return $this->Business_Entity_Contact_Reference;
    }
    /**
     * Set Business_Entity_Contact_Reference value
     * @param \StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference
     * @return \StructType\Business_Entity_ContactType
     */
    public function setBusiness_Entity_Contact_Reference(\StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference = null)
    {
        $this->Business_Entity_Contact_Reference = $business_Entity_Contact_Reference;
        return $this;
    }
    /**
     * Get Business_Entity_Contact_Data value
     * @return \StructType\Business_Entity_Contact_DataType[]|null
     */
    public function getBusiness_Entity_Contact_Data()
    {
        return $this->Business_Entity_Contact_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Entity_Contact_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Entity_Contact_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Entity_Contact_DataForArrayConstraintsFromSetBusiness_Entity_Contact_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $business_Entity_ContactTypeBusiness_Entity_Contact_DataItem) {
            // validation for constraint: itemType
            if (!$business_Entity_ContactTypeBusiness_Entity_Contact_DataItem instanceof \StructType\Business_Entity_Contact_DataType) {
                $invalidValues[] = is_object($business_Entity_ContactTypeBusiness_Entity_Contact_DataItem) ? get_class($business_Entity_ContactTypeBusiness_Entity_Contact_DataItem) : sprintf('%s(%s)', gettype($business_Entity_ContactTypeBusiness_Entity_Contact_DataItem), var_export($business_Entity_ContactTypeBusiness_Entity_Contact_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Entity_Contact_Data property can only contain items of type \StructType\Business_Entity_Contact_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Entity_Contact_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Entity_Contact_DataType[] $business_Entity_Contact_Data
     * @return \StructType\Business_Entity_ContactType
     */
    public function setBusiness_Entity_Contact_Data(array $business_Entity_Contact_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Entity_Contact_DataArrayErrorMessage = self::validateBusiness_Entity_Contact_DataForArrayConstraintsFromSetBusiness_Entity_Contact_Data($business_Entity_Contact_Data))) {
            throw new \InvalidArgumentException($business_Entity_Contact_DataArrayErrorMessage, __LINE__);
        }
        $this->Business_Entity_Contact_Data = $business_Entity_Contact_Data;
        return $this;
    }
    /**
     * Add item to Business_Entity_Contact_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Entity_Contact_DataType $item
     * @return \StructType\Business_Entity_ContactType
     */
    public function addToBusiness_Entity_Contact_Data(\StructType\Business_Entity_Contact_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Entity_Contact_DataType) {
            throw new \InvalidArgumentException(sprintf('The Business_Entity_Contact_Data property can only contain items of type \StructType\Business_Entity_Contact_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Entity_Contact_Data[] = $item;
        return $this;
    }
}
