<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bulk_Import_Adjust_Asset_Cost_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for processing many instances of Asset Cost.
 * @subpackage Structs
 */
class Bulk_Import_Adjust_Asset_Cost_RequestType extends AbstractStructBase
{
    /**
     * The Adjust_Asset_Cost_Request
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Adjust_Asset_Cost_RequestType[]
     */
    public $Adjust_Asset_Cost_Request;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Bulk_Import_Adjust_Asset_Cost_RequestType
     * @uses Bulk_Import_Adjust_Asset_Cost_RequestType::setAdjust_Asset_Cost_Request()
     * @uses Bulk_Import_Adjust_Asset_Cost_RequestType::setVersion()
     * @param \StructType\Adjust_Asset_Cost_RequestType[] $adjust_Asset_Cost_Request
     * @param string $version
     */
    public function __construct(array $adjust_Asset_Cost_Request = array(), $version = null)
    {
        $this
            ->setAdjust_Asset_Cost_Request($adjust_Asset_Cost_Request)
            ->setVersion($version);
    }
    /**
     * Get Adjust_Asset_Cost_Request value
     * @return \StructType\Adjust_Asset_Cost_RequestType[]|null
     */
    public function getAdjust_Asset_Cost_Request()
    {
        return $this->Adjust_Asset_Cost_Request;
    }
    /**
     * This method is responsible for validating the values passed to the setAdjust_Asset_Cost_Request method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdjust_Asset_Cost_Request method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdjust_Asset_Cost_RequestForArrayConstraintsFromSetAdjust_Asset_Cost_Request(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bulk_Import_Adjust_Asset_Cost_RequestTypeAdjust_Asset_Cost_RequestItem) {
            // validation for constraint: itemType
            if (!$bulk_Import_Adjust_Asset_Cost_RequestTypeAdjust_Asset_Cost_RequestItem instanceof \StructType\Adjust_Asset_Cost_RequestType) {
                $invalidValues[] = is_object($bulk_Import_Adjust_Asset_Cost_RequestTypeAdjust_Asset_Cost_RequestItem) ? get_class($bulk_Import_Adjust_Asset_Cost_RequestTypeAdjust_Asset_Cost_RequestItem) : sprintf('%s(%s)', gettype($bulk_Import_Adjust_Asset_Cost_RequestTypeAdjust_Asset_Cost_RequestItem), var_export($bulk_Import_Adjust_Asset_Cost_RequestTypeAdjust_Asset_Cost_RequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Adjust_Asset_Cost_Request property can only contain items of type \StructType\Adjust_Asset_Cost_RequestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Adjust_Asset_Cost_Request value
     * @throws \InvalidArgumentException
     * @param \StructType\Adjust_Asset_Cost_RequestType[] $adjust_Asset_Cost_Request
     * @return \StructType\Bulk_Import_Adjust_Asset_Cost_RequestType
     */
    public function setAdjust_Asset_Cost_Request(array $adjust_Asset_Cost_Request = array())
    {
        // validation for constraint: array
        if ('' !== ($adjust_Asset_Cost_RequestArrayErrorMessage = self::validateAdjust_Asset_Cost_RequestForArrayConstraintsFromSetAdjust_Asset_Cost_Request($adjust_Asset_Cost_Request))) {
            throw new \InvalidArgumentException($adjust_Asset_Cost_RequestArrayErrorMessage, __LINE__);
        }
        $this->Adjust_Asset_Cost_Request = $adjust_Asset_Cost_Request;
        return $this;
    }
    /**
     * Add item to Adjust_Asset_Cost_Request value
     * @throws \InvalidArgumentException
     * @param \StructType\Adjust_Asset_Cost_RequestType $item
     * @return \StructType\Bulk_Import_Adjust_Asset_Cost_RequestType
     */
    public function addToAdjust_Asset_Cost_Request(\StructType\Adjust_Asset_Cost_RequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Adjust_Asset_Cost_RequestType) {
            throw new \InvalidArgumentException(sprintf('The Adjust_Asset_Cost_Request property can only contain items of type \StructType\Adjust_Asset_Cost_RequestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Adjust_Asset_Cost_Request[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Bulk_Import_Adjust_Asset_Cost_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
