<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Timesheet_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulating element including the information for identifying the Timesheet.
 * @subpackage Structs
 */
class Timesheet_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Timesheet_Reference
     * Meta information extracted from the WSDL
     * - documentation: Timesheets being requested. The values are either Workday IDs or Timesheet Reference IDs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TimesheetObjectType[]
     */
    public $Timesheet_Reference;
    /**
     * Constructor method for Timesheet_Request_ReferencesType
     * @uses Timesheet_Request_ReferencesType::setTimesheet_Reference()
     * @param \StructType\TimesheetObjectType[] $timesheet_Reference
     */
    public function __construct(array $timesheet_Reference = array())
    {
        $this
            ->setTimesheet_Reference($timesheet_Reference);
    }
    /**
     * Get Timesheet_Reference value
     * @return \StructType\TimesheetObjectType[]|null
     */
    public function getTimesheet_Reference()
    {
        return $this->Timesheet_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setTimesheet_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTimesheet_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTimesheet_ReferenceForArrayConstraintsFromSetTimesheet_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timesheet_Request_ReferencesTypeTimesheet_ReferenceItem) {
            // validation for constraint: itemType
            if (!$timesheet_Request_ReferencesTypeTimesheet_ReferenceItem instanceof \StructType\TimesheetObjectType) {
                $invalidValues[] = is_object($timesheet_Request_ReferencesTypeTimesheet_ReferenceItem) ? get_class($timesheet_Request_ReferencesTypeTimesheet_ReferenceItem) : sprintf('%s(%s)', gettype($timesheet_Request_ReferencesTypeTimesheet_ReferenceItem), var_export($timesheet_Request_ReferencesTypeTimesheet_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Timesheet_Reference property can only contain items of type \StructType\TimesheetObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Timesheet_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\TimesheetObjectType[] $timesheet_Reference
     * @return \StructType\Timesheet_Request_ReferencesType
     */
    public function setTimesheet_Reference(array $timesheet_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($timesheet_ReferenceArrayErrorMessage = self::validateTimesheet_ReferenceForArrayConstraintsFromSetTimesheet_Reference($timesheet_Reference))) {
            throw new \InvalidArgumentException($timesheet_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Timesheet_Reference = $timesheet_Reference;
        return $this;
    }
    /**
     * Add item to Timesheet_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\TimesheetObjectType $item
     * @return \StructType\Timesheet_Request_ReferencesType
     */
    public function addToTimesheet_Reference(\StructType\TimesheetObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TimesheetObjectType) {
            throw new \InvalidArgumentException(sprintf('The Timesheet_Reference property can only contain items of type \StructType\TimesheetObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Timesheet_Reference[] = $item;
        return $this;
    }
}
