<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_List_Entry_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Multi-Supplier Data
 * @subpackage Structs
 */
class Supplier_List_Entry_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier List Entry.for Supplier
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Inactive_as_List_Entry
     * Meta information extracted from the WSDL
     * - documentation: Inactive as List Entry
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive_as_List_Entry;
    /**
     * The Markup_Percent
     * Meta information extracted from the WSDL
     * - documentation: You can use this field to submit the markup percentage for the pricing of goods provided by a supplier on a multi-supplier contract. Enter a negative percentage to apply a discount. Markups aren't applied to service and project-based
     * contract lines.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 5
     * @var float
     */
    public $Markup_Percent;
    /**
     * Constructor method for Supplier_List_Entry_DataType
     * @uses Supplier_List_Entry_DataType::setSupplier_Reference()
     * @uses Supplier_List_Entry_DataType::setInactive_as_List_Entry()
     * @uses Supplier_List_Entry_DataType::setMarkup_Percent()
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param bool $inactive_as_List_Entry
     * @param float $markup_Percent
     */
    public function __construct(\StructType\SupplierObjectType $supplier_Reference = null, $inactive_as_List_Entry = null, $markup_Percent = null)
    {
        $this
            ->setSupplier_Reference($supplier_Reference)
            ->setInactive_as_List_Entry($inactive_as_List_Entry)
            ->setMarkup_Percent($markup_Percent);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Supplier_List_Entry_DataType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Inactive_as_List_Entry value
     * @return bool|null
     */
    public function getInactive_as_List_Entry()
    {
        return $this->Inactive_as_List_Entry;
    }
    /**
     * Set Inactive_as_List_Entry value
     * @param bool $inactive_as_List_Entry
     * @return \StructType\Supplier_List_Entry_DataType
     */
    public function setInactive_as_List_Entry($inactive_as_List_Entry = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive_as_List_Entry) && !is_bool($inactive_as_List_Entry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive_as_List_Entry, true), gettype($inactive_as_List_Entry)), __LINE__);
        }
        $this->Inactive_as_List_Entry = $inactive_as_List_Entry;
        return $this;
    }
    /**
     * Get Markup_Percent value
     * @return float|null
     */
    public function getMarkup_Percent()
    {
        return $this->Markup_Percent;
    }
    /**
     * Set Markup_Percent value
     * @param float $markup_Percent
     * @return \StructType\Supplier_List_Entry_DataType
     */
    public function setMarkup_Percent($markup_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($markup_Percent) && !(is_float($markup_Percent) || is_numeric($markup_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($markup_Percent, true), gettype($markup_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($markup_Percent) && mb_strlen(mb_substr($markup_Percent, false !== mb_strpos($markup_Percent, '.') ? mb_strpos($markup_Percent, '.') + 1 : mb_strlen($markup_Percent))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($markup_Percent, true), mb_strlen(mb_substr($markup_Percent, mb_strpos($markup_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($markup_Percent) && mb_strlen(preg_replace('/(\D)/', '', $markup_Percent)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($markup_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $markup_Percent))), __LINE__);
        }
        $this->Markup_Percent = $markup_Percent;
        return $this;
    }
}
