<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Supplier_Contact_Information_ResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Submit Supplier Contact Information Response Data
 * @subpackage Structs
 */
class Submit_Supplier_Contact_Information_ResponseType extends AbstractStructBase
{
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier for the Contact Information Event
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Supplier_Contact_Info_Change_Event_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contact Info Change Event created from the Submit web service
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Supplier_Contact_Info_Change_Event_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Supplier_Contact_Information_ResponseType
     * @uses Submit_Supplier_Contact_Information_ResponseType::setSupplier_Reference()
     * @uses Submit_Supplier_Contact_Information_ResponseType::setSupplier_Contact_Info_Change_Event_Reference()
     * @uses Submit_Supplier_Contact_Information_ResponseType::setVersion()
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\Unique_IdentifierObjectType $supplier_Contact_Info_Change_Event_Reference
     * @param string $version
     */
    public function __construct(\StructType\SupplierObjectType $supplier_Reference = null, \StructType\Unique_IdentifierObjectType $supplier_Contact_Info_Change_Event_Reference = null, $version = null)
    {
        $this
            ->setSupplier_Reference($supplier_Reference)
            ->setSupplier_Contact_Info_Change_Event_Reference($supplier_Contact_Info_Change_Event_Reference)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Submit_Supplier_Contact_Information_ResponseType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contact_Info_Change_Event_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getSupplier_Contact_Info_Change_Event_Reference()
    {
        return $this->Supplier_Contact_Info_Change_Event_Reference;
    }
    /**
     * Set Supplier_Contact_Info_Change_Event_Reference value
     * @param \StructType\Unique_IdentifierObjectType $supplier_Contact_Info_Change_Event_Reference
     * @return \StructType\Submit_Supplier_Contact_Information_ResponseType
     */
    public function setSupplier_Contact_Info_Change_Event_Reference(\StructType\Unique_IdentifierObjectType $supplier_Contact_Info_Change_Event_Reference = null)
    {
        $this->Supplier_Contact_Info_Change_Event_Reference = $supplier_Contact_Info_Change_Event_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Supplier_Contact_Information_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
