<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You need to enable a payment purpose code during tenant set up to add a payment purpose code to the invoice or adjustment | The alternate ledger currency override you entered must be unique. Enter a unique override currency. | Clear
 * the value. You can't submit the value because the sequence generator automatically creates the Tax Certificate Number in Workday. | You selected an invalid supplier contract for this supplier invoice. Select a supplier contract that's valid for the
 * company, supplier, and document date; not undergoing an amendment; and supports manual supplier invoices. | Enter a valid URL or update link types on the Maintain External Link validation task. Links must have a valid Uniform Resource Identifier
 * (URI) pattern defined by your security administrator. | Enter a tax applicability that is taxable, non-recoverable, and allocates non-recoverable tax at the negative or zero dollar lines. | Enter 1 or more negative or zero dollar amount lines with
 * tax applicability for an invoice with a negative tax amount. | You can't specify a third party tax code in the transaction tax code reference. | If Other Charges is negative, then there must be at least one negative or zero line with a Spend Category
 * that has Allocate Other Charges. | If there are Other Charges, then there must be at least one line with a Spend Category that has Allocate Other Charges. | If there are negative Freight Charges, then there must be at least one negative line or one
 * zero line with a Spend Category that has Allocate Freight. | If there are Freight Charges, then there must be at least one line with a Spend Category that has Allocate Freight. | You can't associate invoices to Consignment type Contracts. | You can't
 * associate invoices to both Bill and Replace or non-Bill and Replace purchase orders. | The accounting journal associated with this operational transaction is in a closed period, so you can't change this document. | Please enter just one Ship-To
 * Address. | Payment Practices flag cannot be used with this company. Please Enable Payment Practices Flag under edit supplier accounts options on company. | Tax Amount at the header should be entered on a Tax Only Invoice when Enter Tax Due to
 * Supplier tax option is selected. | Tax Option is required on a Tax Only Invoice. | Referenced invoices cannot be Cancelled or Denied | Referenced invoices must match the header company | Withholding Tax Codes that has Withholding Tax Rate(s) with Tax
 * Base Type of Tax can only be selected for a Tax Only Invoice Type. | You can't submit a tax-only invoice if the invoice is related to any other business document, such as a purchase order, receipt, supplier contract, and more. | The Prepaid flag
 * cannot be checked for a Tax Only Invoice Type. | Freight or Other Charges cannot be entered if the invoice is Tax Only. | The header company and line company must be the same for a Tax Only Invoice Type. | An Invoice Document cannot have a Reference
 * Type without a Reference Number or a Reference Number without a Reference Type. The document must contain both or neither. | You can't change the Currency if the supplier invoice is related to a purchase order. | You can't change the Supplier if the
 * supplier invoice is related to a purchase order. | You can't change the Company if the supplier invoice is related to a purchase order. | Suppliers that are restricted to company must be restricted to either the document header company or the Company
 * Hierarchy for which it is a subordinate. | 'Allow Accounting in Arrears' is not permitted for this company. | Accounting Date is required for this Company. Enter an Accounting Date. | Enter an Accounting Date in an Open Period | External Document
 * Links are currently not enabled. | Supplier reference is for a supplier that can be used as a basic worktag only. | Please enter at least one invoice line. | Element containing all Supplier Invoice data
 * @subpackage Structs
 */
class Supplier_Invoice_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice ID. This is the Supplier Invoice unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit for Approval is a boolean flag indicating if the transaction is to be submitted or saved in draft mode. If this flag is set, the transaction will be submitted, otherwise the transaction is saved in draft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Locked_in_Workday
     * Meta information extracted from the WSDL
     * - documentation: Set to True to disable editing and canceling the invoice inside the Workday application. Invoice can only be updated from the web service.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Locked_in_Workday;
    /**
     * The Invoice_Number
     * Meta information extracted from the WSDL
     * - documentation: If adding a new invoice, then make the Invoice Number the same value as Reference ID. If updating an existing invoice, then make it the same value as the Reference ID of that invoice. If you do not make the Invoice Number the same as
     * Reference ID, then duplicate Invoice Numbers for different invoices may be created. The Reference ID is the only value checked as a unique identifier. Note that the name of the Reference ID is different for each invoice type: e.g. Supplier Invoice
     * ID, Supplier Invoice Adjustment ID, Customer Invoice Adjustment ID, and Customer Invoice ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Number;
    /**
     * The Gapless_Document_Number
     * Meta information extracted from the WSDL
     * - documentation: Gapless Document Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Gapless_Document_Number;
    /**
     * The Invoice_Document_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: A Reference to the Document Status for this invoice. This field is read-only, and will be ignored on a Put or Submit.
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Invoice_Document_Status_Reference;
    /**
     * The Invoice_Cancel_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Invoice Cancel Reason. This field is read-only, and will be ignored on a Put or Submit.
     * - minOccurs: 0
     * @var \StructType\Invoice_Cancel_Reason__All_ObjectType
     */
    public $Invoice_Cancel_Reason_Reference;
    /**
     * The External_Supplier_Invoice_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: The External Supplier Invoice Source. Defaults to Web Service, but you can override it.
     * - minOccurs: 0
     * @var \StructType\External_Transaction_Source__All_ObjectType
     */
    public $External_Supplier_Invoice_Source_Reference;
    /**
     * The Cancel_Accounting_Date
     * Meta information extracted from the WSDL
     * - documentation: Cancel Accounting Date is only populated when a Supplier Invoice is Cancelled.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Cancel_Accounting_Date;
    /**
     * The Invoice_Accounting_Date
     * Meta information extracted from the WSDL
     * - documentation: Invoice Accounting Date for a Supplier Invoice.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Accounting_Date;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the company that tranasction is for. This is the reference id value of the company.
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Payment_Practices
     * Meta information extracted from the WSDL
     * - documentation: Payment Practice field to flag a Supplier Invoice for Payment Practices Reporting
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Payment_Practices;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter a Currency. The Supplier, Company, or Remit to Connection don't have a default currency. | Currency entered is not listed as an Accepted Currency by Supplier. | This is the reference id of currency of the transaction If no
     * currency is specified, Workday will first look to see if the payer/payee has a preferred currency and if not, currency will be populated with the company base currency. If the company base currency is not allowed currency for payer/payee then
     * transaction will not be able to be submitted for approval.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference is the reference to the Supplier the invoice is from.
     * - choice: Supplier_Reference | Contingent_Worker_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Contingent_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Contingent Worker
     * - choice: Supplier_Reference | Contingent_Worker_Reference
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Contingent_WorkerObjectType
     */
    public $Contingent_Worker_Reference;
    /**
     * The Supplier_Connection_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Business Connection.
     * - choice: Supplier_Connection_Reference | Use_Default_Supplier_Connection
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Remit_To_Supplier_ConnectionObjectType
     */
    public $Supplier_Connection_Reference;
    /**
     * The Use_Default_Supplier_Connection
     * Meta information extracted from the WSDL
     * - documentation: TRUE or FALSEIf this is set to 'TRUE' the default supplier connection will be derived.
     * - choice: Supplier_Connection_Reference | Use_Default_Supplier_Connection
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Default_Supplier_Connection;
    /**
     * The Default_Tax_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Tax Option. If left blank, will default from the Company.
     * - minOccurs: 0
     * @var \StructType\Tax_OptionObjectType
     */
    public $Default_Tax_Option_Reference;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Ship-To address.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Address_ID_Reference
     * Meta information extracted from the WSDL
     * - documentation: We update these web services to enable you to submit a ship-to address using the Address Reference ID field:* Import Supplier Invoice* Submit Supplier Invoice
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_ID_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: You can't submit a Tax Code at the header when the Company has a third party tax integration enabled for Supplier Invoices. | This is the reference id value of the tax code. If not submitted, Workday will use the payee default the
     * tax code.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Default_Withholding_Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference id value of the default withholding tax code. If not submitted, Workday will use the payee default the withholding tax code.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Default_Withholding_Tax_Code_Reference;
    /**
     * The Invoice_Date
     * Meta information extracted from the WSDL
     * - documentation: Format is MM/DD/YYYY.If this is left blank, Workday will populate invoice date with the current date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Date;
    /**
     * The Invoice_Received_Date
     * Meta information extracted from the WSDL
     * - documentation: Field to store the Invoice Received Date value
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Received_Date;
    /**
     * The Due_Date_Override
     * Meta information extracted from the WSDL
     * - documentation: Due Date must not be earlier than Invoice Date | Format is MM/DD/YYYY.If a date is provided, it will override the due date that Workday automatically determines based on the invoice date and payment terms.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Due_Date_Override;
    /**
     * The Accounting_Date_Override
     * Meta information extracted from the WSDL
     * - documentation: Override date for Accounting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Accounting_Date_Override;
    /**
     * The Budget_Date
     * Meta information extracted from the WSDL
     * - documentation: Use this field to override the Budget Date on all supplier invoice lines and splits.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Budget_Date;
    /**
     * The On_Hold
     * Meta information extracted from the WSDL
     * - documentation: TRUE or FALSEIf this is set to 'TRUE' the invoice will be put on hold.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $On_Hold;
    /**
     * The Control_Amount_Total
     * Meta information extracted from the WSDL
     * - documentation: This is the expected invoice total including tax. It is optional. An invoice cannot be submittted for approval if it has a non-zero control total that does not equal the sum of the extended amount for all invoice lines plus tax.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Control_Amount_Total;
    /**
     * The Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Enter 1 or more lines with tax applicability on an invoice with Tax Amount. This tax applicability must be taxable, non-recoverable, and allocate non-recoverable tax. | Total Tax Amount for Tax Code and Tax Applicability | Tax Amount
     * for Expense Line | The tax amount to report for the expense. The tax code is defined on the itemized line. | Total Tax Amount for Tax Rate | Tax can only be entered if the Tax Option is Enter Tax Due to Supplier. | Expense Credit Card Extended Tax
     * Amount | Tax Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Tax_Amount;
    /**
     * The Withholding_Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Withholding Tax Amount | Total Tax Amount for Withholding Tax Code
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Withholding_Tax_Amount;
    /**
     * The Freight_Amount
     * Meta information extracted from the WSDL
     * - documentation: An optional addition of Freight Amount for the Requisition. | Freight charges incurred. | Freight Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Freight_Amount;
    /**
     * The Other_Charges
     * Meta information extracted from the WSDL
     * - documentation: If there are Other Charges, then there must be at least one line with a Spend Category that has Allocate Other Charges. | An optional addition of Other Charges for the Requisition. | Other Charges
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Other_Charges;
    /**
     * The Worktag_Split_Template_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktag Split Allocation Template for Supplier Invoice
     * - minOccurs: 0
     * @var \StructType\Worktag_Split_TemplateObjectType
     */
    public $Worktag_Split_Template_Reference;
    /**
     * The Tax_Only
     * Meta information extracted from the WSDL
     * - documentation: Tax Only Boolean to indicate if the Supplier Invoice is Tax Only
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Tax_Only;
    /**
     * The Referenced_Invoices_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Only invoice Workset for adding Referenced Invoices
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_InvoiceObjectType[]
     */
    public $Referenced_Invoices_Reference;
    /**
     * The Supplier_Document_Received
     * Meta information extracted from the WSDL
     * - documentation: Boolean attribute indicating if the Supplier Paper Document was received (possibly through mail or fax) . If this is set then a Supplier Reference is required that will provide information for locating that document.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Supplier_Document_Received;
    /**
     * The Suppliers_Invoice_Number
     * Meta information extracted from the WSDL
     * - documentation: Enter a Supplier's Invoice Number that isn't already in use on another supplier invoice, invoice adjustment, or invoice request for this supplier. | If Supplier Document Received is true, a Supplier's Invoice Number must also be
     * submitted. | Free form text field to provide a Supplier's Invoice Number memo. The Supplier's Invoice Number is not a Workday Reference ID, but a text field for providing additional information about the Supplier Invoice.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Suppliers_Invoice_Number;
    /**
     * The External_PO_Number
     * Meta information extracted from the WSDL
     * - documentation: Free form text field for providing addition information on the Purchase Order that the Supplier Invoice is for. This is not a Workday Purchase Order Reference ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_PO_Number;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: The supplied Supplier Contract is Closed or Pending Close. | Reference to an existing Supplier Contract
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_BaseObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Document_Link
     * Meta information extracted from the WSDL
     * - documentation: Link to a scanned image of the paper invoice
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Link;
    /**
     * The Supplier_Invoice_Request_Reference
     * Meta information extracted from the WSDL
     * - documentation: You can only retrieve a supplier invoice request on the Get Supplier Invoice web service response. The Submit Supplier Invoice web service ignores this field.
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_RequestObjectType
     */
    public $Supplier_Invoice_Request_Reference;
    /**
     * The Requester_Reference
     * Meta information extracted from the WSDL
     * - documentation: Requester for Supplier Invoice created from Supplier Invoice Request.This information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Requester_Reference;
    /**
     * The Statutory_Invoice_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Invoice Type for Supplier Invoice.
     * - minOccurs: 0
     * @var \StructType\Invoice_TypeObjectType
     */
    public $Statutory_Invoice_Type_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: This transaction header memo will print on the delivered transaction. It is optional freeform text
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Approver_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Approver for Supplier Invoice
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Approver_Reference;
    /**
     * The Payment_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter Payment Terms. You can also select a Remit to Connection or Supplier that already has default payment terms configured. | This is the reference id of the payment terms for the invoice. Payment Terms are the rules for
     * establishing when a invoice payment is due and whether discounts are eligible to be taken or given for early payment. This is a required field, but if no payment terms are specified, Workday will populate this with the customer's default payment
     * terms if one is defined. Workday will automatically determine the due date and discount date based on the invoice date and payment terms.
     * - minOccurs: 0
     * @var \StructType\Payment_TermsObjectType
     */
    public $Payment_Terms_Reference;
    /**
     * The Discount_Date
     * Meta information extracted from the WSDL
     * - documentation: The date on which you must pay an invoice to receive the discount. This field is empty if there is no discount. This field is read-only.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Discount_Date;
    /**
     * The Discount_Taken
     * Meta information extracted from the WSDL
     * - documentation: The discount amount on this supplier invoice. This field is read-only.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Discount_Taken;
    /**
     * The Discounts_Not_Taken
     * Meta information extracted from the WSDL
     * - documentation: The discount amount you lose when you don't take the discount by the discount date. The invoice is paid in full. If any discount is taken, or if there is no discount available, this field is blank. This field is read-only.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 17
     * @var float
     */
    public $Discounts_Not_Taken;
    /**
     * The Override_Payment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Override Payment Type cannot be used if a Supplier is not provided. | If Override Payment Type is provided, it must be one of the accepted Payment Types for the Supplier provided. | A reference to a Payment Type. If one is provided,
     * it will be used in processing the Payment instead of the Supplier's default payment type.
     * - minOccurs: 0
     * @var \StructType\Payment_TypeObjectType
     */
    public $Override_Payment_Type_Reference;
    /**
     * The Additional_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The type of reference used to encode key payment information on the invoice document.
     * - minOccurs: 0
     * @var \StructType\Additional_Reference_TypeObjectType
     */
    public $Additional_Type_Reference;
    /**
     * The Additional_Reference_Number
     * Meta information extracted from the WSDL
     * - documentation: The reference number that is encoded with key payment information on the invoice document.
     * - base: xsd:string
     * - maxLength: 140
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Additional_Reference_Number;
    /**
     * The Originating_Country_Payment_Purpose_Reference
     * Meta information extracted from the WSDL
     * - documentation: Originating Country Payment Purpose Code. This code is used to identify the purpose of the payment from the originating country.
     * - minOccurs: 0
     * @var \StructType\Payment_Purpose_CodeObjectType
     */
    public $Originating_Country_Payment_Purpose_Reference;
    /**
     * The Receiving_Country_Payment_Purpose_Reference
     * Meta information extracted from the WSDL
     * - documentation: Receiving Country Payment Purpose Code. This code is used to identify the purpose of the payment from the receiving country.
     * - minOccurs: 0
     * @var \StructType\Payment_Purpose_CodeObjectType
     */
    public $Receiving_Country_Payment_Purpose_Reference;
    /**
     * The Handling_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the reference code of the payment handling instructions for the supplier invoice or supplier invoice adjustment.
     * - minOccurs: 0
     * @var \StructType\Payment_Handling_InstructionObjectType
     */
    public $Handling_Code_Reference;
    /**
     * The Prepaid
     * Meta information extracted from the WSDL
     * - documentation: Set the Prepaid value to true for Prepaid Invoices where all lines are Prepaid. If set, the lines cannot be also set to Prepaid individually.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Prepaid;
    /**
     * The Prepayment_Release_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Prepaid Amortization Type
     * - minOccurs: 0
     * @var \StructType\Prepaid_Amortization_TypeObjectType
     */
    public $Prepayment_Release_Type_Reference;
    /**
     * The Release_Date
     * Meta information extracted from the WSDL
     * - documentation: Prepaid Amortization Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Release_Date;
    /**
     * The Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Frequency to be used when generating the next prepaid accounting entry.
     * - minOccurs: 0
     * @var \StructType\Frequency_BehaviorObjectType
     */
    public $Frequency_Reference;
    /**
     * The Number_of_Installments
     * Meta information extracted from the WSDL
     * - documentation: Number of installments. The system generates installments based on this value. | The Number of Installments to use when accounting for the Prepaid Amortization.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Installments;
    /**
     * The Use_Invoice_Date
     * Meta information extracted from the WSDL
     * - documentation: Use the Invoice Date as the starting date for the first installment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Use_Invoice_Date;
    /**
     * The From_Date
     * Meta information extracted from the WSDL
     * - documentation: Use the Specified Date as the starting date for the first installment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $From_Date;
    /**
     * The Gross_Invoice_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Gross Invoice Amount includes the Invoice Line Extended Amount plus Tax, Retention, and Release Amount. This field only returns values.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Gross_Invoice_Amount;
    /**
     * The Total_Amount_Retained
     * Meta information extracted from the WSDL
     * - documentation: The total amount retained for this invoice. This field only returns values.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Amount_Retained;
    /**
     * The Total_Amount_Released
     * Meta information extracted from the WSDL
     * - documentation: The total amount of retention released for this invoice. This field only returns values.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Total_Amount_Released;
    /**
     * The Retention_Memo
     * Meta information extracted from the WSDL
     * - documentation: The retention memo.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Retention_Memo;
    /**
     * The Currency_Rate_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Currency_Rate_DataType[]
     */
    public $Currency_Rate_Data;
    /**
     * The Additional_Fields_Data_Reference
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing additional fields data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Configurable_Attributes_DataType[]
     */
    public $Additional_Fields_Data_Reference;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - documentation: Attachment Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * The Tax_Code_Data
     * Meta information extracted from the WSDL
     * - documentation: Tax Data by Tax Authority and Tax Code. For Customer Invoice Documents and Cash Sales tax data will always be calculated from the line data regardless of what is populated in Tax Rate Application Data. For Purchase Orders, Supplier
     * Invoice Documents and Ad hoc Payments, if data is in Tax Rate Application Data, then that will be the tax information that is saved. Otherwise, the tax will be calculated from the lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Taxable_Code_Application_DataType[]
     */
    public $Tax_Code_Data;
    /**
     * The Withholding_Tax_Code_Data
     * Meta information extracted from the WSDL
     * - documentation: Withholding Tax Data by Tax Authority and Withholding Tax Code. For Customer Invoice Documents and Cash Sales tax data will always be calculated from the line data regardless of what is populated in Tax Rate Application Data. For
     * Purchase Orders, Supplier Invoice Documents and Ad hoc Payments, if data is in Tax Rate Application Data, then that will be the tax information that is saved. Otherwise, the tax will be calculated from the lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Withholding_Tax_Code_Application_DataType[]
     */
    public $Withholding_Tax_Code_Data;
    /**
     * The Invoice_Line_Replacement_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Line Data. A Supplier Invoice may have multiple lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Line_Replacement_DataType[]
     */
    public $Invoice_Line_Replacement_Data;
    /**
     * The Retention_Release_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Encapsulating element containing Supplier Invoice Retention Release Line data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType[]
     */
    public $Retention_Release_Line_Data;
    /**
     * The Supplier_Invoice_Intercompany_Sub_Process
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Intercompany_Sub_ProcessType
     */
    public $Supplier_Invoice_Intercompany_Sub_Process;
    /**
     * The Supplier_Invoice_Prepaid_Amortization_Schedule
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType[]
     */
    public $Supplier_Invoice_Prepaid_Amortization_Schedule;
    /**
     * The Tax_Certificate_Number
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tax_Certificate_Numbers_DataType[]
     */
    public $Tax_Certificate_Number;
    /**
     * The Work_Queue_Information_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Work_Queue_Information_DataType[]
     */
    public $Work_Queue_Information_Data;
    /**
     * Constructor method for Supplier_Invoice_DataType
     * @uses Supplier_Invoice_DataType::setSupplier_Invoice_ID()
     * @uses Supplier_Invoice_DataType::setSubmit()
     * @uses Supplier_Invoice_DataType::setLocked_in_Workday()
     * @uses Supplier_Invoice_DataType::setInvoice_Number()
     * @uses Supplier_Invoice_DataType::setGapless_Document_Number()
     * @uses Supplier_Invoice_DataType::setInvoice_Document_Status_Reference()
     * @uses Supplier_Invoice_DataType::setInvoice_Cancel_Reason_Reference()
     * @uses Supplier_Invoice_DataType::setExternal_Supplier_Invoice_Source_Reference()
     * @uses Supplier_Invoice_DataType::setCancel_Accounting_Date()
     * @uses Supplier_Invoice_DataType::setInvoice_Accounting_Date()
     * @uses Supplier_Invoice_DataType::setCompany_Reference()
     * @uses Supplier_Invoice_DataType::setPayment_Practices()
     * @uses Supplier_Invoice_DataType::setCurrency_Reference()
     * @uses Supplier_Invoice_DataType::setSupplier_Reference()
     * @uses Supplier_Invoice_DataType::setContingent_Worker_Reference()
     * @uses Supplier_Invoice_DataType::setSupplier_Connection_Reference()
     * @uses Supplier_Invoice_DataType::setUse_Default_Supplier_Connection()
     * @uses Supplier_Invoice_DataType::setDefault_Tax_Option_Reference()
     * @uses Supplier_Invoice_DataType::setShip_To_Address_Reference()
     * @uses Supplier_Invoice_DataType::setShip_To_Address_ID_Reference()
     * @uses Supplier_Invoice_DataType::setTax_Code_Reference()
     * @uses Supplier_Invoice_DataType::setDefault_Withholding_Tax_Code_Reference()
     * @uses Supplier_Invoice_DataType::setInvoice_Date()
     * @uses Supplier_Invoice_DataType::setInvoice_Received_Date()
     * @uses Supplier_Invoice_DataType::setDue_Date_Override()
     * @uses Supplier_Invoice_DataType::setAccounting_Date_Override()
     * @uses Supplier_Invoice_DataType::setBudget_Date()
     * @uses Supplier_Invoice_DataType::setOn_Hold()
     * @uses Supplier_Invoice_DataType::setControl_Amount_Total()
     * @uses Supplier_Invoice_DataType::setTax_Amount()
     * @uses Supplier_Invoice_DataType::setWithholding_Tax_Amount()
     * @uses Supplier_Invoice_DataType::setFreight_Amount()
     * @uses Supplier_Invoice_DataType::setOther_Charges()
     * @uses Supplier_Invoice_DataType::setWorktag_Split_Template_Reference()
     * @uses Supplier_Invoice_DataType::setTax_Only()
     * @uses Supplier_Invoice_DataType::setReferenced_Invoices_Reference()
     * @uses Supplier_Invoice_DataType::setSupplier_Document_Received()
     * @uses Supplier_Invoice_DataType::setSuppliers_Invoice_Number()
     * @uses Supplier_Invoice_DataType::setExternal_PO_Number()
     * @uses Supplier_Invoice_DataType::setSupplier_Contract_Reference()
     * @uses Supplier_Invoice_DataType::setDocument_Link()
     * @uses Supplier_Invoice_DataType::setSupplier_Invoice_Request_Reference()
     * @uses Supplier_Invoice_DataType::setRequester_Reference()
     * @uses Supplier_Invoice_DataType::setStatutory_Invoice_Type_Reference()
     * @uses Supplier_Invoice_DataType::setMemo()
     * @uses Supplier_Invoice_DataType::setApprover_Reference()
     * @uses Supplier_Invoice_DataType::setPayment_Terms_Reference()
     * @uses Supplier_Invoice_DataType::setDiscount_Date()
     * @uses Supplier_Invoice_DataType::setDiscount_Taken()
     * @uses Supplier_Invoice_DataType::setDiscounts_Not_Taken()
     * @uses Supplier_Invoice_DataType::setOverride_Payment_Type_Reference()
     * @uses Supplier_Invoice_DataType::setAdditional_Type_Reference()
     * @uses Supplier_Invoice_DataType::setAdditional_Reference_Number()
     * @uses Supplier_Invoice_DataType::setOriginating_Country_Payment_Purpose_Reference()
     * @uses Supplier_Invoice_DataType::setReceiving_Country_Payment_Purpose_Reference()
     * @uses Supplier_Invoice_DataType::setHandling_Code_Reference()
     * @uses Supplier_Invoice_DataType::setPrepaid()
     * @uses Supplier_Invoice_DataType::setPrepayment_Release_Type_Reference()
     * @uses Supplier_Invoice_DataType::setRelease_Date()
     * @uses Supplier_Invoice_DataType::setFrequency_Reference()
     * @uses Supplier_Invoice_DataType::setNumber_of_Installments()
     * @uses Supplier_Invoice_DataType::setUse_Invoice_Date()
     * @uses Supplier_Invoice_DataType::setFrom_Date()
     * @uses Supplier_Invoice_DataType::setGross_Invoice_Amount()
     * @uses Supplier_Invoice_DataType::setTotal_Amount_Retained()
     * @uses Supplier_Invoice_DataType::setTotal_Amount_Released()
     * @uses Supplier_Invoice_DataType::setRetention_Memo()
     * @uses Supplier_Invoice_DataType::setCurrency_Rate_Data()
     * @uses Supplier_Invoice_DataType::setAdditional_Fields_Data_Reference()
     * @uses Supplier_Invoice_DataType::setAttachment_Data()
     * @uses Supplier_Invoice_DataType::setTax_Code_Data()
     * @uses Supplier_Invoice_DataType::setWithholding_Tax_Code_Data()
     * @uses Supplier_Invoice_DataType::setInvoice_Line_Replacement_Data()
     * @uses Supplier_Invoice_DataType::setRetention_Release_Line_Data()
     * @uses Supplier_Invoice_DataType::setSupplier_Invoice_Intercompany_Sub_Process()
     * @uses Supplier_Invoice_DataType::setSupplier_Invoice_Prepaid_Amortization_Schedule()
     * @uses Supplier_Invoice_DataType::setTax_Certificate_Number()
     * @uses Supplier_Invoice_DataType::setWork_Queue_Information_Data()
     * @param string $supplier_Invoice_ID
     * @param bool $submit
     * @param bool $locked_in_Workday
     * @param string $invoice_Number
     * @param string $gapless_Document_Number
     * @param \StructType\Document_StatusObjectType $invoice_Document_Status_Reference
     * @param \StructType\Invoice_Cancel_Reason__All_ObjectType $invoice_Cancel_Reason_Reference
     * @param \StructType\External_Transaction_Source__All_ObjectType $external_Supplier_Invoice_Source_Reference
     * @param string $cancel_Accounting_Date
     * @param string $invoice_Accounting_Date
     * @param \StructType\CompanyObjectType $company_Reference
     * @param bool $payment_Practices
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\Contingent_WorkerObjectType $contingent_Worker_Reference
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference
     * @param bool $use_Default_Supplier_Connection
     * @param \StructType\Tax_OptionObjectType $default_Tax_Option_Reference
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_ID_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Tax_CodeObjectType $default_Withholding_Tax_Code_Reference
     * @param string $invoice_Date
     * @param string $invoice_Received_Date
     * @param string $due_Date_Override
     * @param string $accounting_Date_Override
     * @param string $budget_Date
     * @param bool $on_Hold
     * @param float $control_Amount_Total
     * @param float $tax_Amount
     * @param float $withholding_Tax_Amount
     * @param float $freight_Amount
     * @param float $other_Charges
     * @param \StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference
     * @param bool $tax_Only
     * @param \StructType\Supplier_InvoiceObjectType[] $referenced_Invoices_Reference
     * @param bool $supplier_Document_Received
     * @param string $suppliers_Invoice_Number
     * @param string $external_PO_Number
     * @param \StructType\Supplier_Contract_BaseObjectType $supplier_Contract_Reference
     * @param string $document_Link
     * @param \StructType\Supplier_Invoice_RequestObjectType $supplier_Invoice_Request_Reference
     * @param \StructType\WorkerObjectType $requester_Reference
     * @param \StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference
     * @param string $memo
     * @param \StructType\WorkerObjectType $approver_Reference
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @param string $discount_Date
     * @param float $discount_Taken
     * @param float $discounts_Not_Taken
     * @param \StructType\Payment_TypeObjectType $override_Payment_Type_Reference
     * @param \StructType\Additional_Reference_TypeObjectType $additional_Type_Reference
     * @param string $additional_Reference_Number
     * @param \StructType\Payment_Purpose_CodeObjectType $originating_Country_Payment_Purpose_Reference
     * @param \StructType\Payment_Purpose_CodeObjectType $receiving_Country_Payment_Purpose_Reference
     * @param \StructType\Payment_Handling_InstructionObjectType $handling_Code_Reference
     * @param bool $prepaid
     * @param \StructType\Prepaid_Amortization_TypeObjectType $prepayment_Release_Type_Reference
     * @param string $release_Date
     * @param \StructType\Frequency_BehaviorObjectType $frequency_Reference
     * @param float $number_of_Installments
     * @param bool $use_Invoice_Date
     * @param string $from_Date
     * @param float $gross_Invoice_Amount
     * @param float $total_Amount_Retained
     * @param float $total_Amount_Released
     * @param string $retention_Memo
     * @param \StructType\Currency_Rate_DataType[] $currency_Rate_Data
     * @param \StructType\Configurable_Attributes_DataType[] $additional_Fields_Data_Reference
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @param \StructType\Taxable_Code_Application_DataType[] $tax_Code_Data
     * @param \StructType\Withholding_Tax_Code_Application_DataType[] $withholding_Tax_Code_Data
     * @param \StructType\Supplier_Invoice_Line_Replacement_DataType[] $invoice_Line_Replacement_Data
     * @param \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType[] $retention_Release_Line_Data
     * @param \StructType\Supplier_Invoice_Intercompany_Sub_ProcessType $supplier_Invoice_Intercompany_Sub_Process
     * @param \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType[] $supplier_Invoice_Prepaid_Amortization_Schedule
     * @param \StructType\Tax_Certificate_Numbers_DataType[] $tax_Certificate_Number
     * @param \StructType\Supplier_Invoice_Work_Queue_Information_DataType[] $work_Queue_Information_Data
     */
    public function __construct($supplier_Invoice_ID = null, $submit = null, $locked_in_Workday = null, $invoice_Number = null, $gapless_Document_Number = null, \StructType\Document_StatusObjectType $invoice_Document_Status_Reference = null, \StructType\Invoice_Cancel_Reason__All_ObjectType $invoice_Cancel_Reason_Reference = null, \StructType\External_Transaction_Source__All_ObjectType $external_Supplier_Invoice_Source_Reference = null, $cancel_Accounting_Date = null, $invoice_Accounting_Date = null, \StructType\CompanyObjectType $company_Reference = null, $payment_Practices = null, \StructType\CurrencyObjectType $currency_Reference = null, \StructType\SupplierObjectType $supplier_Reference = null, \StructType\Contingent_WorkerObjectType $contingent_Worker_Reference = null, \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference = null, $use_Default_Supplier_Connection = null, \StructType\Tax_OptionObjectType $default_Tax_Option_Reference = null, \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null, \StructType\Address_ReferenceObjectType $ship_To_Address_ID_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, \StructType\Tax_CodeObjectType $default_Withholding_Tax_Code_Reference = null, $invoice_Date = null, $invoice_Received_Date = null, $due_Date_Override = null, $accounting_Date_Override = null, $budget_Date = null, $on_Hold = null, $control_Amount_Total = null, $tax_Amount = null, $withholding_Tax_Amount = null, $freight_Amount = null, $other_Charges = null, \StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference = null, $tax_Only = null, array $referenced_Invoices_Reference = array(), $supplier_Document_Received = null, $suppliers_Invoice_Number = null, $external_PO_Number = null, \StructType\Supplier_Contract_BaseObjectType $supplier_Contract_Reference = null, $document_Link = null, \StructType\Supplier_Invoice_RequestObjectType $supplier_Invoice_Request_Reference = null, \StructType\WorkerObjectType $requester_Reference = null, \StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference = null, $memo = null, \StructType\WorkerObjectType $approver_Reference = null, \StructType\Payment_TermsObjectType $payment_Terms_Reference = null, $discount_Date = null, $discount_Taken = null, $discounts_Not_Taken = null, \StructType\Payment_TypeObjectType $override_Payment_Type_Reference = null, \StructType\Additional_Reference_TypeObjectType $additional_Type_Reference = null, $additional_Reference_Number = null, \StructType\Payment_Purpose_CodeObjectType $originating_Country_Payment_Purpose_Reference = null, \StructType\Payment_Purpose_CodeObjectType $receiving_Country_Payment_Purpose_Reference = null, \StructType\Payment_Handling_InstructionObjectType $handling_Code_Reference = null, $prepaid = null, \StructType\Prepaid_Amortization_TypeObjectType $prepayment_Release_Type_Reference = null, $release_Date = null, \StructType\Frequency_BehaviorObjectType $frequency_Reference = null, $number_of_Installments = null, $use_Invoice_Date = null, $from_Date = null, $gross_Invoice_Amount = null, $total_Amount_Retained = null, $total_Amount_Released = null, $retention_Memo = null, array $currency_Rate_Data = array(), array $additional_Fields_Data_Reference = array(), array $attachment_Data = array(), array $tax_Code_Data = array(), array $withholding_Tax_Code_Data = array(), array $invoice_Line_Replacement_Data = array(), array $retention_Release_Line_Data = array(), \StructType\Supplier_Invoice_Intercompany_Sub_ProcessType $supplier_Invoice_Intercompany_Sub_Process = null, array $supplier_Invoice_Prepaid_Amortization_Schedule = array(), array $tax_Certificate_Number = array(), array $work_Queue_Information_Data = array())
    {
        $this
            ->setSupplier_Invoice_ID($supplier_Invoice_ID)
            ->setSubmit($submit)
            ->setLocked_in_Workday($locked_in_Workday)
            ->setInvoice_Number($invoice_Number)
            ->setGapless_Document_Number($gapless_Document_Number)
            ->setInvoice_Document_Status_Reference($invoice_Document_Status_Reference)
            ->setInvoice_Cancel_Reason_Reference($invoice_Cancel_Reason_Reference)
            ->setExternal_Supplier_Invoice_Source_Reference($external_Supplier_Invoice_Source_Reference)
            ->setCancel_Accounting_Date($cancel_Accounting_Date)
            ->setInvoice_Accounting_Date($invoice_Accounting_Date)
            ->setCompany_Reference($company_Reference)
            ->setPayment_Practices($payment_Practices)
            ->setCurrency_Reference($currency_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setContingent_Worker_Reference($contingent_Worker_Reference)
            ->setSupplier_Connection_Reference($supplier_Connection_Reference)
            ->setUse_Default_Supplier_Connection($use_Default_Supplier_Connection)
            ->setDefault_Tax_Option_Reference($default_Tax_Option_Reference)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Address_ID_Reference($ship_To_Address_ID_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setDefault_Withholding_Tax_Code_Reference($default_Withholding_Tax_Code_Reference)
            ->setInvoice_Date($invoice_Date)
            ->setInvoice_Received_Date($invoice_Received_Date)
            ->setDue_Date_Override($due_Date_Override)
            ->setAccounting_Date_Override($accounting_Date_Override)
            ->setBudget_Date($budget_Date)
            ->setOn_Hold($on_Hold)
            ->setControl_Amount_Total($control_Amount_Total)
            ->setTax_Amount($tax_Amount)
            ->setWithholding_Tax_Amount($withholding_Tax_Amount)
            ->setFreight_Amount($freight_Amount)
            ->setOther_Charges($other_Charges)
            ->setWorktag_Split_Template_Reference($worktag_Split_Template_Reference)
            ->setTax_Only($tax_Only)
            ->setReferenced_Invoices_Reference($referenced_Invoices_Reference)
            ->setSupplier_Document_Received($supplier_Document_Received)
            ->setSuppliers_Invoice_Number($suppliers_Invoice_Number)
            ->setExternal_PO_Number($external_PO_Number)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setDocument_Link($document_Link)
            ->setSupplier_Invoice_Request_Reference($supplier_Invoice_Request_Reference)
            ->setRequester_Reference($requester_Reference)
            ->setStatutory_Invoice_Type_Reference($statutory_Invoice_Type_Reference)
            ->setMemo($memo)
            ->setApprover_Reference($approver_Reference)
            ->setPayment_Terms_Reference($payment_Terms_Reference)
            ->setDiscount_Date($discount_Date)
            ->setDiscount_Taken($discount_Taken)
            ->setDiscounts_Not_Taken($discounts_Not_Taken)
            ->setOverride_Payment_Type_Reference($override_Payment_Type_Reference)
            ->setAdditional_Type_Reference($additional_Type_Reference)
            ->setAdditional_Reference_Number($additional_Reference_Number)
            ->setOriginating_Country_Payment_Purpose_Reference($originating_Country_Payment_Purpose_Reference)
            ->setReceiving_Country_Payment_Purpose_Reference($receiving_Country_Payment_Purpose_Reference)
            ->setHandling_Code_Reference($handling_Code_Reference)
            ->setPrepaid($prepaid)
            ->setPrepayment_Release_Type_Reference($prepayment_Release_Type_Reference)
            ->setRelease_Date($release_Date)
            ->setFrequency_Reference($frequency_Reference)
            ->setNumber_of_Installments($number_of_Installments)
            ->setUse_Invoice_Date($use_Invoice_Date)
            ->setFrom_Date($from_Date)
            ->setGross_Invoice_Amount($gross_Invoice_Amount)
            ->setTotal_Amount_Retained($total_Amount_Retained)
            ->setTotal_Amount_Released($total_Amount_Released)
            ->setRetention_Memo($retention_Memo)
            ->setCurrency_Rate_Data($currency_Rate_Data)
            ->setAdditional_Fields_Data_Reference($additional_Fields_Data_Reference)
            ->setAttachment_Data($attachment_Data)
            ->setTax_Code_Data($tax_Code_Data)
            ->setWithholding_Tax_Code_Data($withholding_Tax_Code_Data)
            ->setInvoice_Line_Replacement_Data($invoice_Line_Replacement_Data)
            ->setRetention_Release_Line_Data($retention_Release_Line_Data)
            ->setSupplier_Invoice_Intercompany_Sub_Process($supplier_Invoice_Intercompany_Sub_Process)
            ->setSupplier_Invoice_Prepaid_Amortization_Schedule($supplier_Invoice_Prepaid_Amortization_Schedule)
            ->setTax_Certificate_Number($tax_Certificate_Number)
            ->setWork_Queue_Information_Data($work_Queue_Information_Data);
    }
    /**
     * Get Supplier_Invoice_ID value
     * @return string|null
     */
    public function getSupplier_Invoice_ID()
    {
        return $this->Supplier_Invoice_ID;
    }
    /**
     * Set Supplier_Invoice_ID value
     * @param string $supplier_Invoice_ID
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setSupplier_Invoice_ID($supplier_Invoice_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_ID) && !is_string($supplier_Invoice_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_ID, true), gettype($supplier_Invoice_ID)), __LINE__);
        }
        $this->Supplier_Invoice_ID = $supplier_Invoice_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Locked_in_Workday value
     * @return bool|null
     */
    public function getLocked_in_Workday()
    {
        return $this->Locked_in_Workday;
    }
    /**
     * Set Locked_in_Workday value
     * @param bool $locked_in_Workday
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setLocked_in_Workday($locked_in_Workday = null)
    {
        // validation for constraint: boolean
        if (!is_null($locked_in_Workday) && !is_bool($locked_in_Workday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($locked_in_Workday, true), gettype($locked_in_Workday)), __LINE__);
        }
        $this->Locked_in_Workday = $locked_in_Workday;
        return $this;
    }
    /**
     * Get Invoice_Number value
     * @return string|null
     */
    public function getInvoice_Number()
    {
        return $this->Invoice_Number;
    }
    /**
     * Set Invoice_Number value
     * @param string $invoice_Number
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setInvoice_Number($invoice_Number = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Number) && !is_string($invoice_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Number, true), gettype($invoice_Number)), __LINE__);
        }
        $this->Invoice_Number = $invoice_Number;
        return $this;
    }
    /**
     * Get Gapless_Document_Number value
     * @return string|null
     */
    public function getGapless_Document_Number()
    {
        return $this->Gapless_Document_Number;
    }
    /**
     * Set Gapless_Document_Number value
     * @param string $gapless_Document_Number
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setGapless_Document_Number($gapless_Document_Number = null)
    {
        // validation for constraint: string
        if (!is_null($gapless_Document_Number) && !is_string($gapless_Document_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gapless_Document_Number, true), gettype($gapless_Document_Number)), __LINE__);
        }
        $this->Gapless_Document_Number = $gapless_Document_Number;
        return $this;
    }
    /**
     * Get Invoice_Document_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getInvoice_Document_Status_Reference()
    {
        return $this->Invoice_Document_Status_Reference;
    }
    /**
     * Set Invoice_Document_Status_Reference value
     * @param \StructType\Document_StatusObjectType $invoice_Document_Status_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setInvoice_Document_Status_Reference(\StructType\Document_StatusObjectType $invoice_Document_Status_Reference = null)
    {
        $this->Invoice_Document_Status_Reference = $invoice_Document_Status_Reference;
        return $this;
    }
    /**
     * Get Invoice_Cancel_Reason_Reference value
     * @return \StructType\Invoice_Cancel_Reason__All_ObjectType|null
     */
    public function getInvoice_Cancel_Reason_Reference()
    {
        return $this->Invoice_Cancel_Reason_Reference;
    }
    /**
     * Set Invoice_Cancel_Reason_Reference value
     * @param \StructType\Invoice_Cancel_Reason__All_ObjectType $invoice_Cancel_Reason_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setInvoice_Cancel_Reason_Reference(\StructType\Invoice_Cancel_Reason__All_ObjectType $invoice_Cancel_Reason_Reference = null)
    {
        $this->Invoice_Cancel_Reason_Reference = $invoice_Cancel_Reason_Reference;
        return $this;
    }
    /**
     * Get External_Supplier_Invoice_Source_Reference value
     * @return \StructType\External_Transaction_Source__All_ObjectType|null
     */
    public function getExternal_Supplier_Invoice_Source_Reference()
    {
        return $this->External_Supplier_Invoice_Source_Reference;
    }
    /**
     * Set External_Supplier_Invoice_Source_Reference value
     * @param \StructType\External_Transaction_Source__All_ObjectType $external_Supplier_Invoice_Source_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setExternal_Supplier_Invoice_Source_Reference(\StructType\External_Transaction_Source__All_ObjectType $external_Supplier_Invoice_Source_Reference = null)
    {
        $this->External_Supplier_Invoice_Source_Reference = $external_Supplier_Invoice_Source_Reference;
        return $this;
    }
    /**
     * Get Cancel_Accounting_Date value
     * @return string|null
     */
    public function getCancel_Accounting_Date()
    {
        return $this->Cancel_Accounting_Date;
    }
    /**
     * Set Cancel_Accounting_Date value
     * @param string $cancel_Accounting_Date
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setCancel_Accounting_Date($cancel_Accounting_Date = null)
    {
        // validation for constraint: string
        if (!is_null($cancel_Accounting_Date) && !is_string($cancel_Accounting_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancel_Accounting_Date, true), gettype($cancel_Accounting_Date)), __LINE__);
        }
        $this->Cancel_Accounting_Date = $cancel_Accounting_Date;
        return $this;
    }
    /**
     * Get Invoice_Accounting_Date value
     * @return string|null
     */
    public function getInvoice_Accounting_Date()
    {
        return $this->Invoice_Accounting_Date;
    }
    /**
     * Set Invoice_Accounting_Date value
     * @param string $invoice_Accounting_Date
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setInvoice_Accounting_Date($invoice_Accounting_Date = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Accounting_Date) && !is_string($invoice_Accounting_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Accounting_Date, true), gettype($invoice_Accounting_Date)), __LINE__);
        }
        $this->Invoice_Accounting_Date = $invoice_Accounting_Date;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Payment_Practices value
     * @return bool|null
     */
    public function getPayment_Practices()
    {
        return $this->Payment_Practices;
    }
    /**
     * Set Payment_Practices value
     * @param bool $payment_Practices
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setPayment_Practices($payment_Practices = null)
    {
        // validation for constraint: boolean
        if (!is_null($payment_Practices) && !is_bool($payment_Practices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($payment_Practices, true), gettype($payment_Practices)), __LINE__);
        }
        $this->Payment_Practices = $payment_Practices;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return isset($this->Supplier_Reference) ? $this->Supplier_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSupplier_ReferenceForChoiceConstraintsFromSetSupplier_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Contingent_Worker_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Supplier_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Supplier_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        // validation for constraint: choice(Supplier_Reference, Contingent_Worker_Reference)
        if ('' !== ($supplier_ReferenceChoiceErrorMessage = self::validateSupplier_ReferenceForChoiceConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($supplier_Reference) || (is_array($supplier_Reference) && empty($supplier_Reference))) {
            unset($this->Supplier_Reference);
        } else {
            $this->Supplier_Reference = $supplier_Reference;
        }
        return $this;
    }
    /**
     * Get Contingent_Worker_Reference value
     * @return \StructType\Contingent_WorkerObjectType|null
     */
    public function getContingent_Worker_Reference()
    {
        return isset($this->Contingent_Worker_Reference) ? $this->Contingent_Worker_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setContingent_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContingent_Worker_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateContingent_Worker_ReferenceForChoiceConstraintsFromSetContingent_Worker_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Supplier_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Contingent_Worker_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Contingent_Worker_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Contingent_Worker_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Contingent_WorkerObjectType $contingent_Worker_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setContingent_Worker_Reference(\StructType\Contingent_WorkerObjectType $contingent_Worker_Reference = null)
    {
        // validation for constraint: choice(Supplier_Reference, Contingent_Worker_Reference)
        if ('' !== ($contingent_Worker_ReferenceChoiceErrorMessage = self::validateContingent_Worker_ReferenceForChoiceConstraintsFromSetContingent_Worker_Reference($contingent_Worker_Reference))) {
            throw new \InvalidArgumentException($contingent_Worker_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($contingent_Worker_Reference) || (is_array($contingent_Worker_Reference) && empty($contingent_Worker_Reference))) {
            unset($this->Contingent_Worker_Reference);
        } else {
            $this->Contingent_Worker_Reference = $contingent_Worker_Reference;
        }
        return $this;
    }
    /**
     * Get Supplier_Connection_Reference value
     * @return \StructType\Remit_To_Supplier_ConnectionObjectType|null
     */
    public function getSupplier_Connection_Reference()
    {
        return isset($this->Supplier_Connection_Reference) ? $this->Supplier_Connection_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSupplier_Connection_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Connection_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSupplier_Connection_ReferenceForChoiceConstraintsFromSetSupplier_Connection_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Use_Default_Supplier_Connection',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Supplier_Connection_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Supplier_Connection_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Supplier_Connection_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setSupplier_Connection_Reference(\StructType\Remit_To_Supplier_ConnectionObjectType $supplier_Connection_Reference = null)
    {
        // validation for constraint: choice(Supplier_Connection_Reference, Use_Default_Supplier_Connection)
        if ('' !== ($supplier_Connection_ReferenceChoiceErrorMessage = self::validateSupplier_Connection_ReferenceForChoiceConstraintsFromSetSupplier_Connection_Reference($supplier_Connection_Reference))) {
            throw new \InvalidArgumentException($supplier_Connection_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($supplier_Connection_Reference) || (is_array($supplier_Connection_Reference) && empty($supplier_Connection_Reference))) {
            unset($this->Supplier_Connection_Reference);
        } else {
            $this->Supplier_Connection_Reference = $supplier_Connection_Reference;
        }
        return $this;
    }
    /**
     * Get Use_Default_Supplier_Connection value
     * @return bool|null
     */
    public function getUse_Default_Supplier_Connection()
    {
        return isset($this->Use_Default_Supplier_Connection) ? $this->Use_Default_Supplier_Connection : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUse_Default_Supplier_Connection method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUse_Default_Supplier_Connection method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUse_Default_Supplier_ConnectionForChoiceConstraintsFromSetUse_Default_Supplier_Connection($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Supplier_Connection_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Use_Default_Supplier_Connection can\'t be set as the property %s is already set. Only one property must be set among these properties: Use_Default_Supplier_Connection, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Use_Default_Supplier_Connection value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $use_Default_Supplier_Connection
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setUse_Default_Supplier_Connection($use_Default_Supplier_Connection = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Default_Supplier_Connection) && !is_bool($use_Default_Supplier_Connection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Default_Supplier_Connection, true), gettype($use_Default_Supplier_Connection)), __LINE__);
        }
        // validation for constraint: choice(Supplier_Connection_Reference, Use_Default_Supplier_Connection)
        if ('' !== ($use_Default_Supplier_ConnectionChoiceErrorMessage = self::validateUse_Default_Supplier_ConnectionForChoiceConstraintsFromSetUse_Default_Supplier_Connection($use_Default_Supplier_Connection))) {
            throw new \InvalidArgumentException($use_Default_Supplier_ConnectionChoiceErrorMessage, __LINE__);
        }
        if (is_null($use_Default_Supplier_Connection) || (is_array($use_Default_Supplier_Connection) && empty($use_Default_Supplier_Connection))) {
            unset($this->Use_Default_Supplier_Connection);
        } else {
            $this->Use_Default_Supplier_Connection = $use_Default_Supplier_Connection;
        }
        return $this;
    }
    /**
     * Get Default_Tax_Option_Reference value
     * @return \StructType\Tax_OptionObjectType|null
     */
    public function getDefault_Tax_Option_Reference()
    {
        return $this->Default_Tax_Option_Reference;
    }
    /**
     * Set Default_Tax_Option_Reference value
     * @param \StructType\Tax_OptionObjectType $default_Tax_Option_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setDefault_Tax_Option_Reference(\StructType\Tax_OptionObjectType $default_Tax_Option_Reference = null)
    {
        $this->Default_Tax_Option_Reference = $default_Tax_Option_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Address_ID_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_ID_Reference()
    {
        return $this->{'Ship-To_Address_ID_Reference'};
    }
    /**
     * Set Ship_To_Address_ID_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_ID_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setShip_To_Address_ID_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_ID_Reference = null)
    {
        $this->Ship_To_Address_ID_Reference = $this->{'Ship-To_Address_ID_Reference'} = $ship_To_Address_ID_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Default_Withholding_Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getDefault_Withholding_Tax_Code_Reference()
    {
        return $this->Default_Withholding_Tax_Code_Reference;
    }
    /**
     * Set Default_Withholding_Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $default_Withholding_Tax_Code_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setDefault_Withholding_Tax_Code_Reference(\StructType\Tax_CodeObjectType $default_Withholding_Tax_Code_Reference = null)
    {
        $this->Default_Withholding_Tax_Code_Reference = $default_Withholding_Tax_Code_Reference;
        return $this;
    }
    /**
     * Get Invoice_Date value
     * @return string|null
     */
    public function getInvoice_Date()
    {
        return $this->Invoice_Date;
    }
    /**
     * Set Invoice_Date value
     * @param string $invoice_Date
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setInvoice_Date($invoice_Date = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Date) && !is_string($invoice_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Date, true), gettype($invoice_Date)), __LINE__);
        }
        $this->Invoice_Date = $invoice_Date;
        return $this;
    }
    /**
     * Get Invoice_Received_Date value
     * @return string|null
     */
    public function getInvoice_Received_Date()
    {
        return $this->Invoice_Received_Date;
    }
    /**
     * Set Invoice_Received_Date value
     * @param string $invoice_Received_Date
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setInvoice_Received_Date($invoice_Received_Date = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Received_Date) && !is_string($invoice_Received_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Received_Date, true), gettype($invoice_Received_Date)), __LINE__);
        }
        $this->Invoice_Received_Date = $invoice_Received_Date;
        return $this;
    }
    /**
     * Get Due_Date_Override value
     * @return string|null
     */
    public function getDue_Date_Override()
    {
        return $this->Due_Date_Override;
    }
    /**
     * Set Due_Date_Override value
     * @param string $due_Date_Override
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setDue_Date_Override($due_Date_Override = null)
    {
        // validation for constraint: string
        if (!is_null($due_Date_Override) && !is_string($due_Date_Override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($due_Date_Override, true), gettype($due_Date_Override)), __LINE__);
        }
        $this->Due_Date_Override = $due_Date_Override;
        return $this;
    }
    /**
     * Get Accounting_Date_Override value
     * @return string|null
     */
    public function getAccounting_Date_Override()
    {
        return $this->Accounting_Date_Override;
    }
    /**
     * Set Accounting_Date_Override value
     * @param string $accounting_Date_Override
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setAccounting_Date_Override($accounting_Date_Override = null)
    {
        // validation for constraint: string
        if (!is_null($accounting_Date_Override) && !is_string($accounting_Date_Override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounting_Date_Override, true), gettype($accounting_Date_Override)), __LINE__);
        }
        $this->Accounting_Date_Override = $accounting_Date_Override;
        return $this;
    }
    /**
     * Get Budget_Date value
     * @return string|null
     */
    public function getBudget_Date()
    {
        return $this->Budget_Date;
    }
    /**
     * Set Budget_Date value
     * @param string $budget_Date
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setBudget_Date($budget_Date = null)
    {
        // validation for constraint: string
        if (!is_null($budget_Date) && !is_string($budget_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budget_Date, true), gettype($budget_Date)), __LINE__);
        }
        $this->Budget_Date = $budget_Date;
        return $this;
    }
    /**
     * Get On_Hold value
     * @return bool|null
     */
    public function getOn_Hold()
    {
        return $this->On_Hold;
    }
    /**
     * Set On_Hold value
     * @param bool $on_Hold
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setOn_Hold($on_Hold = null)
    {
        // validation for constraint: boolean
        if (!is_null($on_Hold) && !is_bool($on_Hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($on_Hold, true), gettype($on_Hold)), __LINE__);
        }
        $this->On_Hold = $on_Hold;
        return $this;
    }
    /**
     * Get Control_Amount_Total value
     * @return float|null
     */
    public function getControl_Amount_Total()
    {
        return $this->Control_Amount_Total;
    }
    /**
     * Set Control_Amount_Total value
     * @param float $control_Amount_Total
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setControl_Amount_Total($control_Amount_Total = null)
    {
        // validation for constraint: float
        if (!is_null($control_Amount_Total) && !(is_float($control_Amount_Total) || is_numeric($control_Amount_Total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($control_Amount_Total, true), gettype($control_Amount_Total)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($control_Amount_Total) && mb_strlen(mb_substr($control_Amount_Total, false !== mb_strpos($control_Amount_Total, '.') ? mb_strpos($control_Amount_Total, '.') + 1 : mb_strlen($control_Amount_Total))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($control_Amount_Total, true), mb_strlen(mb_substr($control_Amount_Total, mb_strpos($control_Amount_Total, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($control_Amount_Total) && mb_strlen(preg_replace('/(\D)/', '', $control_Amount_Total)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($control_Amount_Total, true), mb_strlen(preg_replace('/(\D)/', '', $control_Amount_Total))), __LINE__);
        }
        $this->Control_Amount_Total = $control_Amount_Total;
        return $this;
    }
    /**
     * Get Tax_Amount value
     * @return float|null
     */
    public function getTax_Amount()
    {
        return $this->Tax_Amount;
    }
    /**
     * Set Tax_Amount value
     * @param float $tax_Amount
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setTax_Amount($tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($tax_Amount) && !(is_float($tax_Amount) || is_numeric($tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax_Amount, true), gettype($tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($tax_Amount) && mb_strlen(mb_substr($tax_Amount, false !== mb_strpos($tax_Amount, '.') ? mb_strpos($tax_Amount, '.') + 1 : mb_strlen($tax_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($tax_Amount, true), mb_strlen(mb_substr($tax_Amount, mb_strpos($tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $tax_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $tax_Amount))), __LINE__);
        }
        $this->Tax_Amount = $tax_Amount;
        return $this;
    }
    /**
     * Get Withholding_Tax_Amount value
     * @return float|null
     */
    public function getWithholding_Tax_Amount()
    {
        return $this->Withholding_Tax_Amount;
    }
    /**
     * Set Withholding_Tax_Amount value
     * @param float $withholding_Tax_Amount
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setWithholding_Tax_Amount($withholding_Tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($withholding_Tax_Amount) && !(is_float($withholding_Tax_Amount) || is_numeric($withholding_Tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($withholding_Tax_Amount, true), gettype($withholding_Tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($withholding_Tax_Amount) && mb_strlen(mb_substr($withholding_Tax_Amount, false !== mb_strpos($withholding_Tax_Amount, '.') ? mb_strpos($withholding_Tax_Amount, '.') + 1 : mb_strlen($withholding_Tax_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($withholding_Tax_Amount, true), mb_strlen(mb_substr($withholding_Tax_Amount, mb_strpos($withholding_Tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($withholding_Tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $withholding_Tax_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($withholding_Tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $withholding_Tax_Amount))), __LINE__);
        }
        $this->Withholding_Tax_Amount = $withholding_Tax_Amount;
        return $this;
    }
    /**
     * Get Freight_Amount value
     * @return float|null
     */
    public function getFreight_Amount()
    {
        return $this->Freight_Amount;
    }
    /**
     * Set Freight_Amount value
     * @param float $freight_Amount
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setFreight_Amount($freight_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($freight_Amount) && !(is_float($freight_Amount) || is_numeric($freight_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($freight_Amount, true), gettype($freight_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($freight_Amount) && mb_strlen(mb_substr($freight_Amount, false !== mb_strpos($freight_Amount, '.') ? mb_strpos($freight_Amount, '.') + 1 : mb_strlen($freight_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($freight_Amount, true), mb_strlen(mb_substr($freight_Amount, mb_strpos($freight_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($freight_Amount) && mb_strlen(preg_replace('/(\D)/', '', $freight_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($freight_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $freight_Amount))), __LINE__);
        }
        $this->Freight_Amount = $freight_Amount;
        return $this;
    }
    /**
     * Get Other_Charges value
     * @return float|null
     */
    public function getOther_Charges()
    {
        return $this->Other_Charges;
    }
    /**
     * Set Other_Charges value
     * @param float $other_Charges
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setOther_Charges($other_Charges = null)
    {
        // validation for constraint: float
        if (!is_null($other_Charges) && !(is_float($other_Charges) || is_numeric($other_Charges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($other_Charges, true), gettype($other_Charges)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($other_Charges) && mb_strlen(mb_substr($other_Charges, false !== mb_strpos($other_Charges, '.') ? mb_strpos($other_Charges, '.') + 1 : mb_strlen($other_Charges))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($other_Charges, true), mb_strlen(mb_substr($other_Charges, mb_strpos($other_Charges, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($other_Charges) && mb_strlen(preg_replace('/(\D)/', '', $other_Charges)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($other_Charges, true), mb_strlen(preg_replace('/(\D)/', '', $other_Charges))), __LINE__);
        }
        $this->Other_Charges = $other_Charges;
        return $this;
    }
    /**
     * Get Worktag_Split_Template_Reference value
     * @return \StructType\Worktag_Split_TemplateObjectType|null
     */
    public function getWorktag_Split_Template_Reference()
    {
        return $this->Worktag_Split_Template_Reference;
    }
    /**
     * Set Worktag_Split_Template_Reference value
     * @param \StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setWorktag_Split_Template_Reference(\StructType\Worktag_Split_TemplateObjectType $worktag_Split_Template_Reference = null)
    {
        $this->Worktag_Split_Template_Reference = $worktag_Split_Template_Reference;
        return $this;
    }
    /**
     * Get Tax_Only value
     * @return bool|null
     */
    public function getTax_Only()
    {
        return $this->Tax_Only;
    }
    /**
     * Set Tax_Only value
     * @param bool $tax_Only
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setTax_Only($tax_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($tax_Only) && !is_bool($tax_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tax_Only, true), gettype($tax_Only)), __LINE__);
        }
        $this->Tax_Only = $tax_Only;
        return $this;
    }
    /**
     * Get Referenced_Invoices_Reference value
     * @return \StructType\Supplier_InvoiceObjectType[]|null
     */
    public function getReferenced_Invoices_Reference()
    {
        return $this->Referenced_Invoices_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenced_Invoices_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenced_Invoices_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenced_Invoices_ReferenceForArrayConstraintsFromSetReferenced_Invoices_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_DataTypeReferenced_Invoices_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_DataTypeReferenced_Invoices_ReferenceItem instanceof \StructType\Supplier_InvoiceObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_DataTypeReferenced_Invoices_ReferenceItem) ? get_class($supplier_Invoice_DataTypeReferenced_Invoices_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_DataTypeReferenced_Invoices_ReferenceItem), var_export($supplier_Invoice_DataTypeReferenced_Invoices_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Referenced_Invoices_Reference property can only contain items of type \StructType\Supplier_InvoiceObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Referenced_Invoices_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_InvoiceObjectType[] $referenced_Invoices_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setReferenced_Invoices_Reference(array $referenced_Invoices_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($referenced_Invoices_ReferenceArrayErrorMessage = self::validateReferenced_Invoices_ReferenceForArrayConstraintsFromSetReferenced_Invoices_Reference($referenced_Invoices_Reference))) {
            throw new \InvalidArgumentException($referenced_Invoices_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Referenced_Invoices_Reference = $referenced_Invoices_Reference;
        return $this;
    }
    /**
     * Add item to Referenced_Invoices_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_InvoiceObjectType $item
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function addToReferenced_Invoices_Reference(\StructType\Supplier_InvoiceObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_InvoiceObjectType) {
            throw new \InvalidArgumentException(sprintf('The Referenced_Invoices_Reference property can only contain items of type \StructType\Supplier_InvoiceObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Referenced_Invoices_Reference[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Document_Received value
     * @return bool|null
     */
    public function getSupplier_Document_Received()
    {
        return $this->Supplier_Document_Received;
    }
    /**
     * Set Supplier_Document_Received value
     * @param bool $supplier_Document_Received
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setSupplier_Document_Received($supplier_Document_Received = null)
    {
        // validation for constraint: boolean
        if (!is_null($supplier_Document_Received) && !is_bool($supplier_Document_Received)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($supplier_Document_Received, true), gettype($supplier_Document_Received)), __LINE__);
        }
        $this->Supplier_Document_Received = $supplier_Document_Received;
        return $this;
    }
    /**
     * Get Suppliers_Invoice_Number value
     * @return string|null
     */
    public function getSuppliers_Invoice_Number()
    {
        return $this->Suppliers_Invoice_Number;
    }
    /**
     * Set Suppliers_Invoice_Number value
     * @param string $suppliers_Invoice_Number
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setSuppliers_Invoice_Number($suppliers_Invoice_Number = null)
    {
        // validation for constraint: string
        if (!is_null($suppliers_Invoice_Number) && !is_string($suppliers_Invoice_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suppliers_Invoice_Number, true), gettype($suppliers_Invoice_Number)), __LINE__);
        }
        $this->Suppliers_Invoice_Number = $suppliers_Invoice_Number;
        return $this;
    }
    /**
     * Get External_PO_Number value
     * @return string|null
     */
    public function getExternal_PO_Number()
    {
        return $this->External_PO_Number;
    }
    /**
     * Set External_PO_Number value
     * @param string $external_PO_Number
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setExternal_PO_Number($external_PO_Number = null)
    {
        // validation for constraint: string
        if (!is_null($external_PO_Number) && !is_string($external_PO_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_PO_Number, true), gettype($external_PO_Number)), __LINE__);
        }
        $this->External_PO_Number = $external_PO_Number;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_Contract_BaseObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_Contract_BaseObjectType $supplier_Contract_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_Contract_BaseObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Document_Link value
     * @return string|null
     */
    public function getDocument_Link()
    {
        return $this->Document_Link;
    }
    /**
     * Set Document_Link value
     * @param string $document_Link
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setDocument_Link($document_Link = null)
    {
        // validation for constraint: string
        if (!is_null($document_Link) && !is_string($document_Link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Link, true), gettype($document_Link)), __LINE__);
        }
        $this->Document_Link = $document_Link;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Request_Reference value
     * @return \StructType\Supplier_Invoice_RequestObjectType|null
     */
    public function getSupplier_Invoice_Request_Reference()
    {
        return $this->Supplier_Invoice_Request_Reference;
    }
    /**
     * Set Supplier_Invoice_Request_Reference value
     * @param \StructType\Supplier_Invoice_RequestObjectType $supplier_Invoice_Request_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setSupplier_Invoice_Request_Reference(\StructType\Supplier_Invoice_RequestObjectType $supplier_Invoice_Request_Reference = null)
    {
        $this->Supplier_Invoice_Request_Reference = $supplier_Invoice_Request_Reference;
        return $this;
    }
    /**
     * Get Requester_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getRequester_Reference()
    {
        return $this->Requester_Reference;
    }
    /**
     * Set Requester_Reference value
     * @param \StructType\WorkerObjectType $requester_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setRequester_Reference(\StructType\WorkerObjectType $requester_Reference = null)
    {
        $this->Requester_Reference = $requester_Reference;
        return $this;
    }
    /**
     * Get Statutory_Invoice_Type_Reference value
     * @return \StructType\Invoice_TypeObjectType|null
     */
    public function getStatutory_Invoice_Type_Reference()
    {
        return $this->Statutory_Invoice_Type_Reference;
    }
    /**
     * Set Statutory_Invoice_Type_Reference value
     * @param \StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setStatutory_Invoice_Type_Reference(\StructType\Invoice_TypeObjectType $statutory_Invoice_Type_Reference = null)
    {
        $this->Statutory_Invoice_Type_Reference = $statutory_Invoice_Type_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Approver_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getApprover_Reference()
    {
        return $this->Approver_Reference;
    }
    /**
     * Set Approver_Reference value
     * @param \StructType\WorkerObjectType $approver_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setApprover_Reference(\StructType\WorkerObjectType $approver_Reference = null)
    {
        $this->Approver_Reference = $approver_Reference;
        return $this;
    }
    /**
     * Get Payment_Terms_Reference value
     * @return \StructType\Payment_TermsObjectType|null
     */
    public function getPayment_Terms_Reference()
    {
        return $this->Payment_Terms_Reference;
    }
    /**
     * Set Payment_Terms_Reference value
     * @param \StructType\Payment_TermsObjectType $payment_Terms_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setPayment_Terms_Reference(\StructType\Payment_TermsObjectType $payment_Terms_Reference = null)
    {
        $this->Payment_Terms_Reference = $payment_Terms_Reference;
        return $this;
    }
    /**
     * Get Discount_Date value
     * @return string|null
     */
    public function getDiscount_Date()
    {
        return $this->Discount_Date;
    }
    /**
     * Set Discount_Date value
     * @param string $discount_Date
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setDiscount_Date($discount_Date = null)
    {
        // validation for constraint: string
        if (!is_null($discount_Date) && !is_string($discount_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($discount_Date, true), gettype($discount_Date)), __LINE__);
        }
        $this->Discount_Date = $discount_Date;
        return $this;
    }
    /**
     * Get Discount_Taken value
     * @return float|null
     */
    public function getDiscount_Taken()
    {
        return $this->Discount_Taken;
    }
    /**
     * Set Discount_Taken value
     * @param float $discount_Taken
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setDiscount_Taken($discount_Taken = null)
    {
        // validation for constraint: float
        if (!is_null($discount_Taken) && !(is_float($discount_Taken) || is_numeric($discount_Taken))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount_Taken, true), gettype($discount_Taken)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($discount_Taken) && mb_strlen(mb_substr($discount_Taken, false !== mb_strpos($discount_Taken, '.') ? mb_strpos($discount_Taken, '.') + 1 : mb_strlen($discount_Taken))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($discount_Taken, true), mb_strlen(mb_substr($discount_Taken, mb_strpos($discount_Taken, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($discount_Taken) && mb_strlen(preg_replace('/(\D)/', '', $discount_Taken)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($discount_Taken, true), mb_strlen(preg_replace('/(\D)/', '', $discount_Taken))), __LINE__);
        }
        $this->Discount_Taken = $discount_Taken;
        return $this;
    }
    /**
     * Get Discounts_Not_Taken value
     * @return float|null
     */
    public function getDiscounts_Not_Taken()
    {
        return $this->Discounts_Not_Taken;
    }
    /**
     * Set Discounts_Not_Taken value
     * @param float $discounts_Not_Taken
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setDiscounts_Not_Taken($discounts_Not_Taken = null)
    {
        // validation for constraint: float
        if (!is_null($discounts_Not_Taken) && !(is_float($discounts_Not_Taken) || is_numeric($discounts_Not_Taken))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discounts_Not_Taken, true), gettype($discounts_Not_Taken)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($discounts_Not_Taken) && mb_strlen(mb_substr($discounts_Not_Taken, false !== mb_strpos($discounts_Not_Taken, '.') ? mb_strpos($discounts_Not_Taken, '.') + 1 : mb_strlen($discounts_Not_Taken))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($discounts_Not_Taken, true), mb_strlen(mb_substr($discounts_Not_Taken, mb_strpos($discounts_Not_Taken, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($discounts_Not_Taken) && $discounts_Not_Taken < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($discounts_Not_Taken, true)), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($discounts_Not_Taken) && mb_strlen(preg_replace('/(\D)/', '', $discounts_Not_Taken)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($discounts_Not_Taken, true), mb_strlen(preg_replace('/(\D)/', '', $discounts_Not_Taken))), __LINE__);
        }
        $this->Discounts_Not_Taken = $discounts_Not_Taken;
        return $this;
    }
    /**
     * Get Override_Payment_Type_Reference value
     * @return \StructType\Payment_TypeObjectType|null
     */
    public function getOverride_Payment_Type_Reference()
    {
        return $this->Override_Payment_Type_Reference;
    }
    /**
     * Set Override_Payment_Type_Reference value
     * @param \StructType\Payment_TypeObjectType $override_Payment_Type_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setOverride_Payment_Type_Reference(\StructType\Payment_TypeObjectType $override_Payment_Type_Reference = null)
    {
        $this->Override_Payment_Type_Reference = $override_Payment_Type_Reference;
        return $this;
    }
    /**
     * Get Additional_Type_Reference value
     * @return \StructType\Additional_Reference_TypeObjectType|null
     */
    public function getAdditional_Type_Reference()
    {
        return $this->Additional_Type_Reference;
    }
    /**
     * Set Additional_Type_Reference value
     * @param \StructType\Additional_Reference_TypeObjectType $additional_Type_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setAdditional_Type_Reference(\StructType\Additional_Reference_TypeObjectType $additional_Type_Reference = null)
    {
        $this->Additional_Type_Reference = $additional_Type_Reference;
        return $this;
    }
    /**
     * Get Additional_Reference_Number value
     * @return string|null
     */
    public function getAdditional_Reference_Number()
    {
        return $this->Additional_Reference_Number;
    }
    /**
     * Set Additional_Reference_Number value
     * @param string $additional_Reference_Number
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setAdditional_Reference_Number($additional_Reference_Number = null)
    {
        // validation for constraint: string
        if (!is_null($additional_Reference_Number) && !is_string($additional_Reference_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additional_Reference_Number, true), gettype($additional_Reference_Number)), __LINE__);
        }
        // validation for constraint: maxLength(140)
        if (!is_null($additional_Reference_Number) && mb_strlen($additional_Reference_Number) > 140) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 140', mb_strlen($additional_Reference_Number)), __LINE__);
        }
        $this->Additional_Reference_Number = $additional_Reference_Number;
        return $this;
    }
    /**
     * Get Originating_Country_Payment_Purpose_Reference value
     * @return \StructType\Payment_Purpose_CodeObjectType|null
     */
    public function getOriginating_Country_Payment_Purpose_Reference()
    {
        return $this->Originating_Country_Payment_Purpose_Reference;
    }
    /**
     * Set Originating_Country_Payment_Purpose_Reference value
     * @param \StructType\Payment_Purpose_CodeObjectType $originating_Country_Payment_Purpose_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setOriginating_Country_Payment_Purpose_Reference(\StructType\Payment_Purpose_CodeObjectType $originating_Country_Payment_Purpose_Reference = null)
    {
        $this->Originating_Country_Payment_Purpose_Reference = $originating_Country_Payment_Purpose_Reference;
        return $this;
    }
    /**
     * Get Receiving_Country_Payment_Purpose_Reference value
     * @return \StructType\Payment_Purpose_CodeObjectType|null
     */
    public function getReceiving_Country_Payment_Purpose_Reference()
    {
        return $this->Receiving_Country_Payment_Purpose_Reference;
    }
    /**
     * Set Receiving_Country_Payment_Purpose_Reference value
     * @param \StructType\Payment_Purpose_CodeObjectType $receiving_Country_Payment_Purpose_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setReceiving_Country_Payment_Purpose_Reference(\StructType\Payment_Purpose_CodeObjectType $receiving_Country_Payment_Purpose_Reference = null)
    {
        $this->Receiving_Country_Payment_Purpose_Reference = $receiving_Country_Payment_Purpose_Reference;
        return $this;
    }
    /**
     * Get Handling_Code_Reference value
     * @return \StructType\Payment_Handling_InstructionObjectType|null
     */
    public function getHandling_Code_Reference()
    {
        return $this->Handling_Code_Reference;
    }
    /**
     * Set Handling_Code_Reference value
     * @param \StructType\Payment_Handling_InstructionObjectType $handling_Code_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setHandling_Code_Reference(\StructType\Payment_Handling_InstructionObjectType $handling_Code_Reference = null)
    {
        $this->Handling_Code_Reference = $handling_Code_Reference;
        return $this;
    }
    /**
     * Get Prepaid value
     * @return bool|null
     */
    public function getPrepaid()
    {
        return $this->Prepaid;
    }
    /**
     * Set Prepaid value
     * @param bool $prepaid
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setPrepaid($prepaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($prepaid) && !is_bool($prepaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prepaid, true), gettype($prepaid)), __LINE__);
        }
        $this->Prepaid = $prepaid;
        return $this;
    }
    /**
     * Get Prepayment_Release_Type_Reference value
     * @return \StructType\Prepaid_Amortization_TypeObjectType|null
     */
    public function getPrepayment_Release_Type_Reference()
    {
        return $this->Prepayment_Release_Type_Reference;
    }
    /**
     * Set Prepayment_Release_Type_Reference value
     * @param \StructType\Prepaid_Amortization_TypeObjectType $prepayment_Release_Type_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setPrepayment_Release_Type_Reference(\StructType\Prepaid_Amortization_TypeObjectType $prepayment_Release_Type_Reference = null)
    {
        $this->Prepayment_Release_Type_Reference = $prepayment_Release_Type_Reference;
        return $this;
    }
    /**
     * Get Release_Date value
     * @return string|null
     */
    public function getRelease_Date()
    {
        return $this->Release_Date;
    }
    /**
     * Set Release_Date value
     * @param string $release_Date
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setRelease_Date($release_Date = null)
    {
        // validation for constraint: string
        if (!is_null($release_Date) && !is_string($release_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($release_Date, true), gettype($release_Date)), __LINE__);
        }
        $this->Release_Date = $release_Date;
        return $this;
    }
    /**
     * Get Frequency_Reference value
     * @return \StructType\Frequency_BehaviorObjectType|null
     */
    public function getFrequency_Reference()
    {
        return $this->Frequency_Reference;
    }
    /**
     * Set Frequency_Reference value
     * @param \StructType\Frequency_BehaviorObjectType $frequency_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setFrequency_Reference(\StructType\Frequency_BehaviorObjectType $frequency_Reference = null)
    {
        $this->Frequency_Reference = $frequency_Reference;
        return $this;
    }
    /**
     * Get Number_of_Installments value
     * @return float|null
     */
    public function getNumber_of_Installments()
    {
        return $this->Number_of_Installments;
    }
    /**
     * Set Number_of_Installments value
     * @param float $number_of_Installments
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setNumber_of_Installments($number_of_Installments = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Installments) && !(is_float($number_of_Installments) || is_numeric($number_of_Installments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Installments, true), gettype($number_of_Installments)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Installments) && mb_strlen(mb_substr($number_of_Installments, false !== mb_strpos($number_of_Installments, '.') ? mb_strpos($number_of_Installments, '.') + 1 : mb_strlen($number_of_Installments))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Installments, true), mb_strlen(mb_substr($number_of_Installments, mb_strpos($number_of_Installments, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Installments) && $number_of_Installments < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Installments, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Installments) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Installments)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Installments, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Installments))), __LINE__);
        }
        $this->Number_of_Installments = $number_of_Installments;
        return $this;
    }
    /**
     * Get Use_Invoice_Date value
     * @return bool|null
     */
    public function getUse_Invoice_Date()
    {
        return $this->Use_Invoice_Date;
    }
    /**
     * Set Use_Invoice_Date value
     * @param bool $use_Invoice_Date
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setUse_Invoice_Date($use_Invoice_Date = null)
    {
        // validation for constraint: boolean
        if (!is_null($use_Invoice_Date) && !is_bool($use_Invoice_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($use_Invoice_Date, true), gettype($use_Invoice_Date)), __LINE__);
        }
        $this->Use_Invoice_Date = $use_Invoice_Date;
        return $this;
    }
    /**
     * Get From_Date value
     * @return string|null
     */
    public function getFrom_Date()
    {
        return $this->From_Date;
    }
    /**
     * Set From_Date value
     * @param string $from_Date
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setFrom_Date($from_Date = null)
    {
        // validation for constraint: string
        if (!is_null($from_Date) && !is_string($from_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($from_Date, true), gettype($from_Date)), __LINE__);
        }
        $this->From_Date = $from_Date;
        return $this;
    }
    /**
     * Get Gross_Invoice_Amount value
     * @return float|null
     */
    public function getGross_Invoice_Amount()
    {
        return $this->Gross_Invoice_Amount;
    }
    /**
     * Set Gross_Invoice_Amount value
     * @param float $gross_Invoice_Amount
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setGross_Invoice_Amount($gross_Invoice_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($gross_Invoice_Amount) && !(is_float($gross_Invoice_Amount) || is_numeric($gross_Invoice_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gross_Invoice_Amount, true), gettype($gross_Invoice_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($gross_Invoice_Amount) && mb_strlen(mb_substr($gross_Invoice_Amount, false !== mb_strpos($gross_Invoice_Amount, '.') ? mb_strpos($gross_Invoice_Amount, '.') + 1 : mb_strlen($gross_Invoice_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($gross_Invoice_Amount, true), mb_strlen(mb_substr($gross_Invoice_Amount, mb_strpos($gross_Invoice_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($gross_Invoice_Amount) && mb_strlen(preg_replace('/(\D)/', '', $gross_Invoice_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($gross_Invoice_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $gross_Invoice_Amount))), __LINE__);
        }
        $this->Gross_Invoice_Amount = $gross_Invoice_Amount;
        return $this;
    }
    /**
     * Get Total_Amount_Retained value
     * @return float|null
     */
    public function getTotal_Amount_Retained()
    {
        return $this->Total_Amount_Retained;
    }
    /**
     * Set Total_Amount_Retained value
     * @param float $total_Amount_Retained
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setTotal_Amount_Retained($total_Amount_Retained = null)
    {
        // validation for constraint: float
        if (!is_null($total_Amount_Retained) && !(is_float($total_Amount_Retained) || is_numeric($total_Amount_Retained))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Amount_Retained, true), gettype($total_Amount_Retained)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Amount_Retained) && mb_strlen(mb_substr($total_Amount_Retained, false !== mb_strpos($total_Amount_Retained, '.') ? mb_strpos($total_Amount_Retained, '.') + 1 : mb_strlen($total_Amount_Retained))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Amount_Retained, true), mb_strlen(mb_substr($total_Amount_Retained, mb_strpos($total_Amount_Retained, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Amount_Retained) && mb_strlen(preg_replace('/(\D)/', '', $total_Amount_Retained)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Amount_Retained, true), mb_strlen(preg_replace('/(\D)/', '', $total_Amount_Retained))), __LINE__);
        }
        $this->Total_Amount_Retained = $total_Amount_Retained;
        return $this;
    }
    /**
     * Get Total_Amount_Released value
     * @return float|null
     */
    public function getTotal_Amount_Released()
    {
        return $this->Total_Amount_Released;
    }
    /**
     * Set Total_Amount_Released value
     * @param float $total_Amount_Released
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setTotal_Amount_Released($total_Amount_Released = null)
    {
        // validation for constraint: float
        if (!is_null($total_Amount_Released) && !(is_float($total_Amount_Released) || is_numeric($total_Amount_Released))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total_Amount_Released, true), gettype($total_Amount_Released)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($total_Amount_Released) && mb_strlen(mb_substr($total_Amount_Released, false !== mb_strpos($total_Amount_Released, '.') ? mb_strpos($total_Amount_Released, '.') + 1 : mb_strlen($total_Amount_Released))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($total_Amount_Released, true), mb_strlen(mb_substr($total_Amount_Released, mb_strpos($total_Amount_Released, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($total_Amount_Released) && mb_strlen(preg_replace('/(\D)/', '', $total_Amount_Released)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($total_Amount_Released, true), mb_strlen(preg_replace('/(\D)/', '', $total_Amount_Released))), __LINE__);
        }
        $this->Total_Amount_Released = $total_Amount_Released;
        return $this;
    }
    /**
     * Get Retention_Memo value
     * @return string|null
     */
    public function getRetention_Memo()
    {
        return $this->Retention_Memo;
    }
    /**
     * Set Retention_Memo value
     * @param string $retention_Memo
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setRetention_Memo($retention_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($retention_Memo) && !is_string($retention_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($retention_Memo, true), gettype($retention_Memo)), __LINE__);
        }
        $this->Retention_Memo = $retention_Memo;
        return $this;
    }
    /**
     * Get Currency_Rate_Data value
     * @return \StructType\Currency_Rate_DataType[]|null
     */
    public function getCurrency_Rate_Data()
    {
        return $this->Currency_Rate_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCurrency_Rate_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCurrency_Rate_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCurrency_Rate_DataForArrayConstraintsFromSetCurrency_Rate_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_DataTypeCurrency_Rate_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_DataTypeCurrency_Rate_DataItem instanceof \StructType\Currency_Rate_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_DataTypeCurrency_Rate_DataItem) ? get_class($supplier_Invoice_DataTypeCurrency_Rate_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_DataTypeCurrency_Rate_DataItem), var_export($supplier_Invoice_DataTypeCurrency_Rate_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Currency_Rate_Data property can only contain items of type \StructType\Currency_Rate_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Currency_Rate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Currency_Rate_DataType[] $currency_Rate_Data
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setCurrency_Rate_Data(array $currency_Rate_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($currency_Rate_DataArrayErrorMessage = self::validateCurrency_Rate_DataForArrayConstraintsFromSetCurrency_Rate_Data($currency_Rate_Data))) {
            throw new \InvalidArgumentException($currency_Rate_DataArrayErrorMessage, __LINE__);
        }
        $this->Currency_Rate_Data = $currency_Rate_Data;
        return $this;
    }
    /**
     * Add item to Currency_Rate_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Currency_Rate_DataType $item
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function addToCurrency_Rate_Data(\StructType\Currency_Rate_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Currency_Rate_DataType) {
            throw new \InvalidArgumentException(sprintf('The Currency_Rate_Data property can only contain items of type \StructType\Currency_Rate_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Currency_Rate_Data[] = $item;
        return $this;
    }
    /**
     * Get Additional_Fields_Data_Reference value
     * @return \StructType\Configurable_Attributes_DataType[]|null
     */
    public function getAdditional_Fields_Data_Reference()
    {
        return $this->Additional_Fields_Data_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Fields_Data_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Fields_Data_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_Fields_Data_ReferenceForArrayConstraintsFromSetAdditional_Fields_Data_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_DataTypeAdditional_Fields_Data_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_DataTypeAdditional_Fields_Data_ReferenceItem instanceof \StructType\Configurable_Attributes_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_DataTypeAdditional_Fields_Data_ReferenceItem) ? get_class($supplier_Invoice_DataTypeAdditional_Fields_Data_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_DataTypeAdditional_Fields_Data_ReferenceItem), var_export($supplier_Invoice_DataTypeAdditional_Fields_Data_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Fields_Data_Reference property can only contain items of type \StructType\Configurable_Attributes_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Fields_Data_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Configurable_Attributes_DataType[] $additional_Fields_Data_Reference
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setAdditional_Fields_Data_Reference(array $additional_Fields_Data_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_Fields_Data_ReferenceArrayErrorMessage = self::validateAdditional_Fields_Data_ReferenceForArrayConstraintsFromSetAdditional_Fields_Data_Reference($additional_Fields_Data_Reference))) {
            throw new \InvalidArgumentException($additional_Fields_Data_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Additional_Fields_Data_Reference = $additional_Fields_Data_Reference;
        return $this;
    }
    /**
     * Add item to Additional_Fields_Data_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Configurable_Attributes_DataType $item
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function addToAdditional_Fields_Data_Reference(\StructType\Configurable_Attributes_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Configurable_Attributes_DataType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Fields_Data_Reference property can only contain items of type \StructType\Configurable_Attributes_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Fields_Data_Reference[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_DataTypeAttachment_DataItem) ? get_class($supplier_Invoice_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_DataTypeAttachment_DataItem), var_export($supplier_Invoice_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Tax_Code_Data value
     * @return \StructType\Taxable_Code_Application_DataType[]|null
     */
    public function getTax_Code_Data()
    {
        return $this->Tax_Code_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTax_Code_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax_Code_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTax_Code_DataForArrayConstraintsFromSetTax_Code_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_DataTypeTax_Code_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_DataTypeTax_Code_DataItem instanceof \StructType\Taxable_Code_Application_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_DataTypeTax_Code_DataItem) ? get_class($supplier_Invoice_DataTypeTax_Code_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_DataTypeTax_Code_DataItem), var_export($supplier_Invoice_DataTypeTax_Code_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax_Code_Data property can only contain items of type \StructType\Taxable_Code_Application_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Taxable_Code_Application_DataType[] $tax_Code_Data
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setTax_Code_Data(array $tax_Code_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($tax_Code_DataArrayErrorMessage = self::validateTax_Code_DataForArrayConstraintsFromSetTax_Code_Data($tax_Code_Data))) {
            throw new \InvalidArgumentException($tax_Code_DataArrayErrorMessage, __LINE__);
        }
        $this->Tax_Code_Data = $tax_Code_Data;
        return $this;
    }
    /**
     * Add item to Tax_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Taxable_Code_Application_DataType $item
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function addToTax_Code_Data(\StructType\Taxable_Code_Application_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Taxable_Code_Application_DataType) {
            throw new \InvalidArgumentException(sprintf('The Tax_Code_Data property can only contain items of type \StructType\Taxable_Code_Application_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax_Code_Data[] = $item;
        return $this;
    }
    /**
     * Get Withholding_Tax_Code_Data value
     * @return \StructType\Withholding_Tax_Code_Application_DataType[]|null
     */
    public function getWithholding_Tax_Code_Data()
    {
        return $this->Withholding_Tax_Code_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setWithholding_Tax_Code_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWithholding_Tax_Code_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWithholding_Tax_Code_DataForArrayConstraintsFromSetWithholding_Tax_Code_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_DataTypeWithholding_Tax_Code_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_DataTypeWithholding_Tax_Code_DataItem instanceof \StructType\Withholding_Tax_Code_Application_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_DataTypeWithholding_Tax_Code_DataItem) ? get_class($supplier_Invoice_DataTypeWithholding_Tax_Code_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_DataTypeWithholding_Tax_Code_DataItem), var_export($supplier_Invoice_DataTypeWithholding_Tax_Code_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Withholding_Tax_Code_Data property can only contain items of type \StructType\Withholding_Tax_Code_Application_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Withholding_Tax_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Withholding_Tax_Code_Application_DataType[] $withholding_Tax_Code_Data
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setWithholding_Tax_Code_Data(array $withholding_Tax_Code_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($withholding_Tax_Code_DataArrayErrorMessage = self::validateWithholding_Tax_Code_DataForArrayConstraintsFromSetWithholding_Tax_Code_Data($withholding_Tax_Code_Data))) {
            throw new \InvalidArgumentException($withholding_Tax_Code_DataArrayErrorMessage, __LINE__);
        }
        $this->Withholding_Tax_Code_Data = $withholding_Tax_Code_Data;
        return $this;
    }
    /**
     * Add item to Withholding_Tax_Code_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Withholding_Tax_Code_Application_DataType $item
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function addToWithholding_Tax_Code_Data(\StructType\Withholding_Tax_Code_Application_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Withholding_Tax_Code_Application_DataType) {
            throw new \InvalidArgumentException(sprintf('The Withholding_Tax_Code_Data property can only contain items of type \StructType\Withholding_Tax_Code_Application_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Withholding_Tax_Code_Data[] = $item;
        return $this;
    }
    /**
     * Get Invoice_Line_Replacement_Data value
     * @return \StructType\Supplier_Invoice_Line_Replacement_DataType[]|null
     */
    public function getInvoice_Line_Replacement_Data()
    {
        return $this->Invoice_Line_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInvoice_Line_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInvoice_Line_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInvoice_Line_Replacement_DataForArrayConstraintsFromSetInvoice_Line_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_DataTypeInvoice_Line_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_DataTypeInvoice_Line_Replacement_DataItem instanceof \StructType\Supplier_Invoice_Line_Replacement_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_DataTypeInvoice_Line_Replacement_DataItem) ? get_class($supplier_Invoice_DataTypeInvoice_Line_Replacement_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_DataTypeInvoice_Line_Replacement_DataItem), var_export($supplier_Invoice_DataTypeInvoice_Line_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Invoice_Line_Replacement_Data property can only contain items of type \StructType\Supplier_Invoice_Line_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Invoice_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Line_Replacement_DataType[] $invoice_Line_Replacement_Data
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setInvoice_Line_Replacement_Data(array $invoice_Line_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($invoice_Line_Replacement_DataArrayErrorMessage = self::validateInvoice_Line_Replacement_DataForArrayConstraintsFromSetInvoice_Line_Replacement_Data($invoice_Line_Replacement_Data))) {
            throw new \InvalidArgumentException($invoice_Line_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Invoice_Line_Replacement_Data = $invoice_Line_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Invoice_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Line_Replacement_DataType $item
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function addToInvoice_Line_Replacement_Data(\StructType\Supplier_Invoice_Line_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Line_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Invoice_Line_Replacement_Data property can only contain items of type \StructType\Supplier_Invoice_Line_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Invoice_Line_Replacement_Data[] = $item;
        return $this;
    }
    /**
     * Get Retention_Release_Line_Data value
     * @return \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType[]|null
     */
    public function getRetention_Release_Line_Data()
    {
        return $this->Retention_Release_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRetention_Release_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRetention_Release_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRetention_Release_Line_DataForArrayConstraintsFromSetRetention_Release_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_DataTypeRetention_Release_Line_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_DataTypeRetention_Release_Line_DataItem instanceof \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_DataTypeRetention_Release_Line_DataItem) ? get_class($supplier_Invoice_DataTypeRetention_Release_Line_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_DataTypeRetention_Release_Line_DataItem), var_export($supplier_Invoice_DataTypeRetention_Release_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Retention_Release_Line_Data property can only contain items of type \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Retention_Release_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType[] $retention_Release_Line_Data
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setRetention_Release_Line_Data(array $retention_Release_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($retention_Release_Line_DataArrayErrorMessage = self::validateRetention_Release_Line_DataForArrayConstraintsFromSetRetention_Release_Line_Data($retention_Release_Line_Data))) {
            throw new \InvalidArgumentException($retention_Release_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Retention_Release_Line_Data = $retention_Release_Line_Data;
        return $this;
    }
    /**
     * Add item to Retention_Release_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType $item
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function addToRetention_Release_Line_Data(\StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Retention_Release_Line_Data property can only contain items of type \StructType\Supplier_Invoice_Retention_Release_Line_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Retention_Release_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Intercompany_Sub_Process value
     * @return \StructType\Supplier_Invoice_Intercompany_Sub_ProcessType|null
     */
    public function getSupplier_Invoice_Intercompany_Sub_Process()
    {
        return $this->Supplier_Invoice_Intercompany_Sub_Process;
    }
    /**
     * Set Supplier_Invoice_Intercompany_Sub_Process value
     * @param \StructType\Supplier_Invoice_Intercompany_Sub_ProcessType $supplier_Invoice_Intercompany_Sub_Process
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setSupplier_Invoice_Intercompany_Sub_Process(\StructType\Supplier_Invoice_Intercompany_Sub_ProcessType $supplier_Invoice_Intercompany_Sub_Process = null)
    {
        $this->Supplier_Invoice_Intercompany_Sub_Process = $supplier_Invoice_Intercompany_Sub_Process;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Prepaid_Amortization_Schedule value
     * @return \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType[]|null
     */
    public function getSupplier_Invoice_Prepaid_Amortization_Schedule()
    {
        return $this->Supplier_Invoice_Prepaid_Amortization_Schedule;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Prepaid_Amortization_Schedule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Prepaid_Amortization_Schedule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Prepaid_Amortization_ScheduleForArrayConstraintsFromSetSupplier_Invoice_Prepaid_Amortization_Schedule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_DataTypeSupplier_Invoice_Prepaid_Amortization_ScheduleItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_DataTypeSupplier_Invoice_Prepaid_Amortization_ScheduleItem instanceof \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_DataTypeSupplier_Invoice_Prepaid_Amortization_ScheduleItem) ? get_class($supplier_Invoice_DataTypeSupplier_Invoice_Prepaid_Amortization_ScheduleItem) : sprintf('%s(%s)', gettype($supplier_Invoice_DataTypeSupplier_Invoice_Prepaid_Amortization_ScheduleItem), var_export($supplier_Invoice_DataTypeSupplier_Invoice_Prepaid_Amortization_ScheduleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Prepaid_Amortization_Schedule property can only contain items of type \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Prepaid_Amortization_Schedule value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType[] $supplier_Invoice_Prepaid_Amortization_Schedule
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setSupplier_Invoice_Prepaid_Amortization_Schedule(array $supplier_Invoice_Prepaid_Amortization_Schedule = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Prepaid_Amortization_ScheduleArrayErrorMessage = self::validateSupplier_Invoice_Prepaid_Amortization_ScheduleForArrayConstraintsFromSetSupplier_Invoice_Prepaid_Amortization_Schedule($supplier_Invoice_Prepaid_Amortization_Schedule))) {
            throw new \InvalidArgumentException($supplier_Invoice_Prepaid_Amortization_ScheduleArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Prepaid_Amortization_Schedule = $supplier_Invoice_Prepaid_Amortization_Schedule;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Prepaid_Amortization_Schedule value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType $item
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function addToSupplier_Invoice_Prepaid_Amortization_Schedule(\StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Prepaid_Amortization_Schedule property can only contain items of type \StructType\Supplier_Invoice_Prepaid_Amortization_Schedule_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Prepaid_Amortization_Schedule[] = $item;
        return $this;
    }
    /**
     * Get Tax_Certificate_Number value
     * @return \StructType\Tax_Certificate_Numbers_DataType[]|null
     */
    public function getTax_Certificate_Number()
    {
        return $this->Tax_Certificate_Number;
    }
    /**
     * This method is responsible for validating the values passed to the setTax_Certificate_Number method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax_Certificate_Number method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTax_Certificate_NumberForArrayConstraintsFromSetTax_Certificate_Number(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_DataTypeTax_Certificate_NumberItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_DataTypeTax_Certificate_NumberItem instanceof \StructType\Tax_Certificate_Numbers_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_DataTypeTax_Certificate_NumberItem) ? get_class($supplier_Invoice_DataTypeTax_Certificate_NumberItem) : sprintf('%s(%s)', gettype($supplier_Invoice_DataTypeTax_Certificate_NumberItem), var_export($supplier_Invoice_DataTypeTax_Certificate_NumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax_Certificate_Number property can only contain items of type \StructType\Tax_Certificate_Numbers_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tax_Certificate_Number value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Certificate_Numbers_DataType[] $tax_Certificate_Number
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setTax_Certificate_Number(array $tax_Certificate_Number = array())
    {
        // validation for constraint: array
        if ('' !== ($tax_Certificate_NumberArrayErrorMessage = self::validateTax_Certificate_NumberForArrayConstraintsFromSetTax_Certificate_Number($tax_Certificate_Number))) {
            throw new \InvalidArgumentException($tax_Certificate_NumberArrayErrorMessage, __LINE__);
        }
        $this->Tax_Certificate_Number = $tax_Certificate_Number;
        return $this;
    }
    /**
     * Add item to Tax_Certificate_Number value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_Certificate_Numbers_DataType $item
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function addToTax_Certificate_Number(\StructType\Tax_Certificate_Numbers_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax_Certificate_Numbers_DataType) {
            throw new \InvalidArgumentException(sprintf('The Tax_Certificate_Number property can only contain items of type \StructType\Tax_Certificate_Numbers_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax_Certificate_Number[] = $item;
        return $this;
    }
    /**
     * Get Work_Queue_Information_Data value
     * @return \StructType\Supplier_Invoice_Work_Queue_Information_DataType[]|null
     */
    public function getWork_Queue_Information_Data()
    {
        return $this->Work_Queue_Information_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setWork_Queue_Information_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWork_Queue_Information_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWork_Queue_Information_DataForArrayConstraintsFromSetWork_Queue_Information_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_DataTypeWork_Queue_Information_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_DataTypeWork_Queue_Information_DataItem instanceof \StructType\Supplier_Invoice_Work_Queue_Information_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_DataTypeWork_Queue_Information_DataItem) ? get_class($supplier_Invoice_DataTypeWork_Queue_Information_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_DataTypeWork_Queue_Information_DataItem), var_export($supplier_Invoice_DataTypeWork_Queue_Information_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Work_Queue_Information_Data property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_Information_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Work_Queue_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_Information_DataType[] $work_Queue_Information_Data
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function setWork_Queue_Information_Data(array $work_Queue_Information_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($work_Queue_Information_DataArrayErrorMessage = self::validateWork_Queue_Information_DataForArrayConstraintsFromSetWork_Queue_Information_Data($work_Queue_Information_Data))) {
            throw new \InvalidArgumentException($work_Queue_Information_DataArrayErrorMessage, __LINE__);
        }
        $this->Work_Queue_Information_Data = $work_Queue_Information_Data;
        return $this;
    }
    /**
     * Add item to Work_Queue_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_Information_DataType $item
     * @return \StructType\Supplier_Invoice_DataType
     */
    public function addToWork_Queue_Information_Data(\StructType\Supplier_Invoice_Work_Queue_Information_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Work_Queue_Information_DataType) {
            throw new \InvalidArgumentException(sprintf('The Work_Queue_Information_Data property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_Information_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Work_Queue_Information_Data[] = $item;
        return $this;
    }
}
