<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_PhaseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all project phase information requested
 * @subpackage Structs
 */
class Project_PhaseType extends AbstractStructBase
{
    /**
     * The Project_Phase_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Phase Reference
     * - minOccurs: 0
     * @var \StructType\Project_PhaseObjectType
     */
    public $Project_Phase_Reference;
    /**
     * The Project_Phase_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Phase_DataType[]
     */
    public $Project_Phase_Data;
    /**
     * Constructor method for Project_PhaseType
     * @uses Project_PhaseType::setProject_Phase_Reference()
     * @uses Project_PhaseType::setProject_Phase_Data()
     * @param \StructType\Project_PhaseObjectType $project_Phase_Reference
     * @param \StructType\Project_Phase_DataType[] $project_Phase_Data
     */
    public function __construct(\StructType\Project_PhaseObjectType $project_Phase_Reference = null, array $project_Phase_Data = array())
    {
        $this
            ->setProject_Phase_Reference($project_Phase_Reference)
            ->setProject_Phase_Data($project_Phase_Data);
    }
    /**
     * Get Project_Phase_Reference value
     * @return \StructType\Project_PhaseObjectType|null
     */
    public function getProject_Phase_Reference()
    {
        return $this->Project_Phase_Reference;
    }
    /**
     * Set Project_Phase_Reference value
     * @param \StructType\Project_PhaseObjectType $project_Phase_Reference
     * @return \StructType\Project_PhaseType
     */
    public function setProject_Phase_Reference(\StructType\Project_PhaseObjectType $project_Phase_Reference = null)
    {
        $this->Project_Phase_Reference = $project_Phase_Reference;
        return $this;
    }
    /**
     * Get Project_Phase_Data value
     * @return \StructType\Project_Phase_DataType[]|null
     */
    public function getProject_Phase_Data()
    {
        return $this->Project_Phase_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Phase_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Phase_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Phase_DataForArrayConstraintsFromSetProject_Phase_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_PhaseTypeProject_Phase_DataItem) {
            // validation for constraint: itemType
            if (!$project_PhaseTypeProject_Phase_DataItem instanceof \StructType\Project_Phase_DataType) {
                $invalidValues[] = is_object($project_PhaseTypeProject_Phase_DataItem) ? get_class($project_PhaseTypeProject_Phase_DataItem) : sprintf('%s(%s)', gettype($project_PhaseTypeProject_Phase_DataItem), var_export($project_PhaseTypeProject_Phase_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Phase_Data property can only contain items of type \StructType\Project_Phase_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Phase_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Phase_DataType[] $project_Phase_Data
     * @return \StructType\Project_PhaseType
     */
    public function setProject_Phase_Data(array $project_Phase_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Phase_DataArrayErrorMessage = self::validateProject_Phase_DataForArrayConstraintsFromSetProject_Phase_Data($project_Phase_Data))) {
            throw new \InvalidArgumentException($project_Phase_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Phase_Data = $project_Phase_Data;
        return $this;
    }
    /**
     * Add item to Project_Phase_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Phase_DataType $item
     * @return \StructType\Project_PhaseType
     */
    public function addToProject_Phase_Data(\StructType\Project_Phase_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Phase_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Phase_Data property can only contain items of type \StructType\Project_Phase_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Phase_Data[] = $item;
        return $this;
    }
}
