<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worker_Travel_Profile_Listing_File__HV__DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Worker Travel Profile Listing File data.
 * @subpackage Structs
 */
class Worker_Travel_Profile_Listing_File__HV__DataType extends AbstractStructBase
{
    /**
     * The Travel_Profile_Listing_File_Number
     * Meta information extracted from the WSDL
     * - documentation: Worker Travel Profile Listing File Number. This is the Worker Travel Profile Listing File unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Travel_Profile_Listing_File_Number;
    /**
     * The Travel_Profile_Listing_File_Name
     * Meta information extracted from the WSDL
     * - documentation: Worker Travel Profile Listing File Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Travel_Profile_Listing_File_Name;
    /**
     * The Travel_Profile_Listing_File_Date
     * Meta information extracted from the WSDL
     * - documentation: Worker Travel Profile Listing File Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Travel_Profile_Listing_File_Date;
    /**
     * The Travel_Profile_Data
     * Meta information extracted from the WSDL
     * - documentation: Worker Travel Profile Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Travel__Profile__HV__DataType[]
     */
    public $Travel_Profile_Data;
    /**
     * Constructor method for Worker_Travel_Profile_Listing_File__HV__DataType
     * @uses Worker_Travel_Profile_Listing_File__HV__DataType::setTravel_Profile_Listing_File_Number()
     * @uses Worker_Travel_Profile_Listing_File__HV__DataType::setTravel_Profile_Listing_File_Name()
     * @uses Worker_Travel_Profile_Listing_File__HV__DataType::setTravel_Profile_Listing_File_Date()
     * @uses Worker_Travel_Profile_Listing_File__HV__DataType::setTravel_Profile_Data()
     * @param string $travel_Profile_Listing_File_Number
     * @param string $travel_Profile_Listing_File_Name
     * @param string $travel_Profile_Listing_File_Date
     * @param \StructType\Travel__Profile__HV__DataType[] $travel_Profile_Data
     */
    public function __construct($travel_Profile_Listing_File_Number = null, $travel_Profile_Listing_File_Name = null, $travel_Profile_Listing_File_Date = null, array $travel_Profile_Data = array())
    {
        $this
            ->setTravel_Profile_Listing_File_Number($travel_Profile_Listing_File_Number)
            ->setTravel_Profile_Listing_File_Name($travel_Profile_Listing_File_Name)
            ->setTravel_Profile_Listing_File_Date($travel_Profile_Listing_File_Date)
            ->setTravel_Profile_Data($travel_Profile_Data);
    }
    /**
     * Get Travel_Profile_Listing_File_Number value
     * @return string|null
     */
    public function getTravel_Profile_Listing_File_Number()
    {
        return $this->Travel_Profile_Listing_File_Number;
    }
    /**
     * Set Travel_Profile_Listing_File_Number value
     * @param string $travel_Profile_Listing_File_Number
     * @return \StructType\Worker_Travel_Profile_Listing_File__HV__DataType
     */
    public function setTravel_Profile_Listing_File_Number($travel_Profile_Listing_File_Number = null)
    {
        // validation for constraint: string
        if (!is_null($travel_Profile_Listing_File_Number) && !is_string($travel_Profile_Listing_File_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_Profile_Listing_File_Number, true), gettype($travel_Profile_Listing_File_Number)), __LINE__);
        }
        $this->Travel_Profile_Listing_File_Number = $travel_Profile_Listing_File_Number;
        return $this;
    }
    /**
     * Get Travel_Profile_Listing_File_Name value
     * @return string|null
     */
    public function getTravel_Profile_Listing_File_Name()
    {
        return $this->Travel_Profile_Listing_File_Name;
    }
    /**
     * Set Travel_Profile_Listing_File_Name value
     * @param string $travel_Profile_Listing_File_Name
     * @return \StructType\Worker_Travel_Profile_Listing_File__HV__DataType
     */
    public function setTravel_Profile_Listing_File_Name($travel_Profile_Listing_File_Name = null)
    {
        // validation for constraint: string
        if (!is_null($travel_Profile_Listing_File_Name) && !is_string($travel_Profile_Listing_File_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_Profile_Listing_File_Name, true), gettype($travel_Profile_Listing_File_Name)), __LINE__);
        }
        $this->Travel_Profile_Listing_File_Name = $travel_Profile_Listing_File_Name;
        return $this;
    }
    /**
     * Get Travel_Profile_Listing_File_Date value
     * @return string|null
     */
    public function getTravel_Profile_Listing_File_Date()
    {
        return $this->Travel_Profile_Listing_File_Date;
    }
    /**
     * Set Travel_Profile_Listing_File_Date value
     * @param string $travel_Profile_Listing_File_Date
     * @return \StructType\Worker_Travel_Profile_Listing_File__HV__DataType
     */
    public function setTravel_Profile_Listing_File_Date($travel_Profile_Listing_File_Date = null)
    {
        // validation for constraint: string
        if (!is_null($travel_Profile_Listing_File_Date) && !is_string($travel_Profile_Listing_File_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_Profile_Listing_File_Date, true), gettype($travel_Profile_Listing_File_Date)), __LINE__);
        }
        $this->Travel_Profile_Listing_File_Date = $travel_Profile_Listing_File_Date;
        return $this;
    }
    /**
     * Get Travel_Profile_Data value
     * @return \StructType\Travel__Profile__HV__DataType[]|null
     */
    public function getTravel_Profile_Data()
    {
        return $this->Travel_Profile_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTravel_Profile_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravel_Profile_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravel_Profile_DataForArrayConstraintsFromSetTravel_Profile_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worker_Travel_Profile_Listing_File_HV_DataTypeTravel_Profile_DataItem) {
            // validation for constraint: itemType
            if (!$worker_Travel_Profile_Listing_File_HV_DataTypeTravel_Profile_DataItem instanceof \StructType\Travel__Profile__HV__DataType) {
                $invalidValues[] = is_object($worker_Travel_Profile_Listing_File_HV_DataTypeTravel_Profile_DataItem) ? get_class($worker_Travel_Profile_Listing_File_HV_DataTypeTravel_Profile_DataItem) : sprintf('%s(%s)', gettype($worker_Travel_Profile_Listing_File_HV_DataTypeTravel_Profile_DataItem), var_export($worker_Travel_Profile_Listing_File_HV_DataTypeTravel_Profile_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Travel_Profile_Data property can only contain items of type \StructType\Travel__Profile__HV__DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Travel_Profile_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel__Profile__HV__DataType[] $travel_Profile_Data
     * @return \StructType\Worker_Travel_Profile_Listing_File__HV__DataType
     */
    public function setTravel_Profile_Data(array $travel_Profile_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($travel_Profile_DataArrayErrorMessage = self::validateTravel_Profile_DataForArrayConstraintsFromSetTravel_Profile_Data($travel_Profile_Data))) {
            throw new \InvalidArgumentException($travel_Profile_DataArrayErrorMessage, __LINE__);
        }
        $this->Travel_Profile_Data = $travel_Profile_Data;
        return $this;
    }
    /**
     * Add item to Travel_Profile_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel__Profile__HV__DataType $item
     * @return \StructType\Worker_Travel_Profile_Listing_File__HV__DataType
     */
    public function addToTravel_Profile_Data(\StructType\Travel__Profile__HV__DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Travel__Profile__HV__DataType) {
            throw new \InvalidArgumentException(sprintf('The Travel_Profile_Data property can only contain items of type \StructType\Travel__Profile__HV__DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Travel_Profile_Data[] = $item;
        return $this;
    }
}
