<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Item_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element including Supplier Item Instance and data
 * @subpackage Structs
 */
class Supplier_Item_Response_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Item
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_ItemType[]
     */
    public $Supplier_Item;
    /**
     * Constructor method for Supplier_Item_Response_DataType
     * @uses Supplier_Item_Response_DataType::setSupplier_Item()
     * @param \StructType\Supplier_ItemType[] $supplier_Item
     */
    public function __construct(array $supplier_Item = array())
    {
        $this
            ->setSupplier_Item($supplier_Item);
    }
    /**
     * Get Supplier_Item value
     * @return \StructType\Supplier_ItemType[]|null
     */
    public function getSupplier_Item()
    {
        return $this->Supplier_Item;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Item method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Item method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ItemForArrayConstraintsFromSetSupplier_Item(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Item_Response_DataTypeSupplier_ItemItem) {
            // validation for constraint: itemType
            if (!$supplier_Item_Response_DataTypeSupplier_ItemItem instanceof \StructType\Supplier_ItemType) {
                $invalidValues[] = is_object($supplier_Item_Response_DataTypeSupplier_ItemItem) ? get_class($supplier_Item_Response_DataTypeSupplier_ItemItem) : sprintf('%s(%s)', gettype($supplier_Item_Response_DataTypeSupplier_ItemItem), var_export($supplier_Item_Response_DataTypeSupplier_ItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Item property can only contain items of type \StructType\Supplier_ItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ItemType[] $supplier_Item
     * @return \StructType\Supplier_Item_Response_DataType
     */
    public function setSupplier_Item(array $supplier_Item = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ItemArrayErrorMessage = self::validateSupplier_ItemForArrayConstraintsFromSetSupplier_Item($supplier_Item))) {
            throw new \InvalidArgumentException($supplier_ItemArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Item = $supplier_Item;
        return $this;
    }
    /**
     * Add item to Supplier_Item value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ItemType $item
     * @return \StructType\Supplier_Item_Response_DataType
     */
    public function addToSupplier_Item(\StructType\Supplier_ItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_ItemType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Item property can only contain items of type \StructType\Supplier_ItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Item[] = $item;
        return $this;
    }
}
