<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Worker_Utilization_Target_Sheet_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element Container for Worker Utilization Target Sheet Data
 * @subpackage Structs
 */
class Worker_Utilization_Target_Sheet_DataType extends AbstractStructBase
{
    /**
     * The Worker_Utilization_Target_Sheet_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Utilization Target Sheet ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Worker_Utilization_Target_Sheet_Reference_ID;
    /**
     * The Worker_Utilization_Target_Sheet_Name
     * Meta information extracted from the WSDL
     * - documentation: Utilization Target Sheet Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Worker_Utilization_Target_Sheet_Name;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Utilization Target Sheet Inactive
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Worker_Utilization_Target_Snapshot_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Worker_Utilization_Target_Snapshot_DataType[]
     */
    public $Worker_Utilization_Target_Snapshot_Data;
    /**
     * Constructor method for Worker_Utilization_Target_Sheet_DataType
     * @uses Worker_Utilization_Target_Sheet_DataType::setWorker_Utilization_Target_Sheet_Reference_ID()
     * @uses Worker_Utilization_Target_Sheet_DataType::setWorker_Utilization_Target_Sheet_Name()
     * @uses Worker_Utilization_Target_Sheet_DataType::setInactive()
     * @uses Worker_Utilization_Target_Sheet_DataType::setWorker_Utilization_Target_Snapshot_Data()
     * @param string $worker_Utilization_Target_Sheet_Reference_ID
     * @param string $worker_Utilization_Target_Sheet_Name
     * @param bool $inactive
     * @param \StructType\Worker_Utilization_Target_Snapshot_DataType[] $worker_Utilization_Target_Snapshot_Data
     */
    public function __construct($worker_Utilization_Target_Sheet_Reference_ID = null, $worker_Utilization_Target_Sheet_Name = null, $inactive = null, array $worker_Utilization_Target_Snapshot_Data = array())
    {
        $this
            ->setWorker_Utilization_Target_Sheet_Reference_ID($worker_Utilization_Target_Sheet_Reference_ID)
            ->setWorker_Utilization_Target_Sheet_Name($worker_Utilization_Target_Sheet_Name)
            ->setInactive($inactive)
            ->setWorker_Utilization_Target_Snapshot_Data($worker_Utilization_Target_Snapshot_Data);
    }
    /**
     * Get Worker_Utilization_Target_Sheet_Reference_ID value
     * @return string|null
     */
    public function getWorker_Utilization_Target_Sheet_Reference_ID()
    {
        return $this->Worker_Utilization_Target_Sheet_Reference_ID;
    }
    /**
     * Set Worker_Utilization_Target_Sheet_Reference_ID value
     * @param string $worker_Utilization_Target_Sheet_Reference_ID
     * @return \StructType\Worker_Utilization_Target_Sheet_DataType
     */
    public function setWorker_Utilization_Target_Sheet_Reference_ID($worker_Utilization_Target_Sheet_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($worker_Utilization_Target_Sheet_Reference_ID) && !is_string($worker_Utilization_Target_Sheet_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($worker_Utilization_Target_Sheet_Reference_ID, true), gettype($worker_Utilization_Target_Sheet_Reference_ID)), __LINE__);
        }
        $this->Worker_Utilization_Target_Sheet_Reference_ID = $worker_Utilization_Target_Sheet_Reference_ID;
        return $this;
    }
    /**
     * Get Worker_Utilization_Target_Sheet_Name value
     * @return string|null
     */
    public function getWorker_Utilization_Target_Sheet_Name()
    {
        return $this->Worker_Utilization_Target_Sheet_Name;
    }
    /**
     * Set Worker_Utilization_Target_Sheet_Name value
     * @param string $worker_Utilization_Target_Sheet_Name
     * @return \StructType\Worker_Utilization_Target_Sheet_DataType
     */
    public function setWorker_Utilization_Target_Sheet_Name($worker_Utilization_Target_Sheet_Name = null)
    {
        // validation for constraint: string
        if (!is_null($worker_Utilization_Target_Sheet_Name) && !is_string($worker_Utilization_Target_Sheet_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($worker_Utilization_Target_Sheet_Name, true), gettype($worker_Utilization_Target_Sheet_Name)), __LINE__);
        }
        $this->Worker_Utilization_Target_Sheet_Name = $worker_Utilization_Target_Sheet_Name;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Worker_Utilization_Target_Sheet_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Worker_Utilization_Target_Snapshot_Data value
     * @return \StructType\Worker_Utilization_Target_Snapshot_DataType[]|null
     */
    public function getWorker_Utilization_Target_Snapshot_Data()
    {
        return $this->Worker_Utilization_Target_Snapshot_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setWorker_Utilization_Target_Snapshot_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorker_Utilization_Target_Snapshot_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorker_Utilization_Target_Snapshot_DataForArrayConstraintsFromSetWorker_Utilization_Target_Snapshot_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $worker_Utilization_Target_Sheet_DataTypeWorker_Utilization_Target_Snapshot_DataItem) {
            // validation for constraint: itemType
            if (!$worker_Utilization_Target_Sheet_DataTypeWorker_Utilization_Target_Snapshot_DataItem instanceof \StructType\Worker_Utilization_Target_Snapshot_DataType) {
                $invalidValues[] = is_object($worker_Utilization_Target_Sheet_DataTypeWorker_Utilization_Target_Snapshot_DataItem) ? get_class($worker_Utilization_Target_Sheet_DataTypeWorker_Utilization_Target_Snapshot_DataItem) : sprintf('%s(%s)', gettype($worker_Utilization_Target_Sheet_DataTypeWorker_Utilization_Target_Snapshot_DataItem), var_export($worker_Utilization_Target_Sheet_DataTypeWorker_Utilization_Target_Snapshot_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worker_Utilization_Target_Snapshot_Data property can only contain items of type \StructType\Worker_Utilization_Target_Snapshot_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worker_Utilization_Target_Snapshot_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Worker_Utilization_Target_Snapshot_DataType[] $worker_Utilization_Target_Snapshot_Data
     * @return \StructType\Worker_Utilization_Target_Sheet_DataType
     */
    public function setWorker_Utilization_Target_Snapshot_Data(array $worker_Utilization_Target_Snapshot_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($worker_Utilization_Target_Snapshot_DataArrayErrorMessage = self::validateWorker_Utilization_Target_Snapshot_DataForArrayConstraintsFromSetWorker_Utilization_Target_Snapshot_Data($worker_Utilization_Target_Snapshot_Data))) {
            throw new \InvalidArgumentException($worker_Utilization_Target_Snapshot_DataArrayErrorMessage, __LINE__);
        }
        $this->Worker_Utilization_Target_Snapshot_Data = $worker_Utilization_Target_Snapshot_Data;
        return $this;
    }
    /**
     * Add item to Worker_Utilization_Target_Snapshot_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Worker_Utilization_Target_Snapshot_DataType $item
     * @return \StructType\Worker_Utilization_Target_Sheet_DataType
     */
    public function addToWorker_Utilization_Target_Snapshot_Data(\StructType\Worker_Utilization_Target_Snapshot_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Worker_Utilization_Target_Snapshot_DataType) {
            throw new \InvalidArgumentException(sprintf('The Worker_Utilization_Target_Snapshot_Data property can only contain items of type \StructType\Worker_Utilization_Target_Snapshot_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worker_Utilization_Target_Snapshot_Data[] = $item;
        return $this;
    }
}
