<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Travel_Booking_Record_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element is the wrapper around a list of elements representing the Travel Booking Record Request specific criteria needed to search for instances. All of the elements are "AND" conditions.
 * @subpackage Structs
 */
class Travel_Booking_Record_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Load_Date_Starting_Range
     * Meta information extracted from the WSDL
     * - documentation: The starting point of the range on the Load Date field, from which travel booking records are retrieved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Load_Date_Starting_Range;
    /**
     * The Load_Date_Ending_Range
     * Meta information extracted from the WSDL
     * - documentation: The ending point of the range on the Load Date field, from which travel booking records are retrieved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Load_Date_Ending_Range;
    /**
     * The Travel_Booking_File_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the files used to load the travel booking records.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Travel_Booking_FileObjectType[]
     */
    public $Travel_Booking_File_Reference;
    /**
     * The Transaction_Date_Starting_Range
     * Meta information extracted from the WSDL
     * - documentation: The starting point of the range for the transaction date, from which travel booking records are retrieved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transaction_Date_Starting_Range;
    /**
     * The Transaction_Date_Ending_Range
     * Meta information extracted from the WSDL
     * - documentation: The ending point of the range for the transaction date, from which travel booking records are retrieved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transaction_Date_Ending_Range;
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: The employee on the travel booking record.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Worker_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company of the Employee on the Travel Booking Record
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Travel_Provider
     * Meta information extracted from the WSDL
     * - documentation: Identifying name of the Travel management provider.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Travel_Provider;
    /**
     * The Start_Date_Starting_Range
     * Meta information extracted from the WSDL
     * - documentation: The starting point of the range for the travel start date, from which travel booking records are retrieved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date_Starting_Range;
    /**
     * The Start_Date_Ending_Range
     * Meta information extracted from the WSDL
     * - documentation: The ending point of the range for the travel start date, from which travel booking records are retrieved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date_Ending_Range;
    /**
     * The End_Date_Starting_Range
     * Meta information extracted from the WSDL
     * - documentation: The starting point of the range for the travel end date, from which travel booking records are retrieved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date_Starting_Range;
    /**
     * The End_Date_Ending_Range
     * Meta information extracted from the WSDL
     * - documentation: The ending point of the range for the travel end date, from which travel booking records are retrieved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date_Ending_Range;
    /**
     * The Travel_Record_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Type of the Travel Booking Record.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Travel_Booking_Record_TypeObjectType[]
     */
    public $Travel_Record_Type_Reference;
    /**
     * The Purchased
     * Meta information extracted from the WSDL
     * - documentation: Purchase Status of Travel Booking Record.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Purchased;
    /**
     * The Expense_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: The expense status on the travel booking record.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_StatusObjectType[]
     */
    public $Expense_Status_Reference;
    /**
     * The Booking_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Booking Status of Travel Booking Record.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Booking_StatusObjectType[]
     */
    public $Booking_Status_Reference;
    /**
     * The Merchant_Reference
     * Meta information extracted from the WSDL
     * - documentation: Merchant matching the merchant listed on the Travel Booking Record.
     * - minOccurs: 0
     * @var \StructType\Abstract_Spend_Data_NameObjectType
     */
    public $Merchant_Reference;
    /**
     * The Merchant_Code
     * Meta information extracted from the WSDL
     * - documentation: Merchant Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_Code;
    /**
     * The Merchant_Name
     * Meta information extracted from the WSDL
     * - documentation: Merchant Name for Travel Booking.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_Name;
    /**
     * The Destination_Travel_City_Reference
     * Meta information extracted from the WSDL
     * - documentation: Workday Destination City matching the destination city on the Travel Booking Record.
     * - minOccurs: 0
     * @var \StructType\Abstract_Spend_Data_NameObjectType
     */
    public $Destination_Travel_City_Reference;
    /**
     * The Expense_Report_Reference
     * Meta information extracted from the WSDL
     * - documentation: The expense reports that include lines linked to travel booking records.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_ReportObjectType[]
     */
    public $Expense_Report_Reference;
    /**
     * Constructor method for Travel_Booking_Record_Request_CriteriaType
     * @uses Travel_Booking_Record_Request_CriteriaType::setLoad_Date_Starting_Range()
     * @uses Travel_Booking_Record_Request_CriteriaType::setLoad_Date_Ending_Range()
     * @uses Travel_Booking_Record_Request_CriteriaType::setTravel_Booking_File_Reference()
     * @uses Travel_Booking_Record_Request_CriteriaType::setTransaction_Date_Starting_Range()
     * @uses Travel_Booking_Record_Request_CriteriaType::setTransaction_Date_Ending_Range()
     * @uses Travel_Booking_Record_Request_CriteriaType::setWorker_Reference()
     * @uses Travel_Booking_Record_Request_CriteriaType::setCompany_Reference()
     * @uses Travel_Booking_Record_Request_CriteriaType::setTravel_Provider()
     * @uses Travel_Booking_Record_Request_CriteriaType::setStart_Date_Starting_Range()
     * @uses Travel_Booking_Record_Request_CriteriaType::setStart_Date_Ending_Range()
     * @uses Travel_Booking_Record_Request_CriteriaType::setEnd_Date_Starting_Range()
     * @uses Travel_Booking_Record_Request_CriteriaType::setEnd_Date_Ending_Range()
     * @uses Travel_Booking_Record_Request_CriteriaType::setTravel_Record_Type_Reference()
     * @uses Travel_Booking_Record_Request_CriteriaType::setPurchased()
     * @uses Travel_Booking_Record_Request_CriteriaType::setExpense_Status_Reference()
     * @uses Travel_Booking_Record_Request_CriteriaType::setBooking_Status_Reference()
     * @uses Travel_Booking_Record_Request_CriteriaType::setMerchant_Reference()
     * @uses Travel_Booking_Record_Request_CriteriaType::setMerchant_Code()
     * @uses Travel_Booking_Record_Request_CriteriaType::setMerchant_Name()
     * @uses Travel_Booking_Record_Request_CriteriaType::setDestination_Travel_City_Reference()
     * @uses Travel_Booking_Record_Request_CriteriaType::setExpense_Report_Reference()
     * @param string $load_Date_Starting_Range
     * @param string $load_Date_Ending_Range
     * @param \StructType\Travel_Booking_FileObjectType[] $travel_Booking_File_Reference
     * @param string $transaction_Date_Starting_Range
     * @param string $transaction_Date_Ending_Range
     * @param \StructType\WorkerObjectType[] $worker_Reference
     * @param \StructType\CompanyObjectType $company_Reference
     * @param string $travel_Provider
     * @param string $start_Date_Starting_Range
     * @param string $start_Date_Ending_Range
     * @param string $end_Date_Starting_Range
     * @param string $end_Date_Ending_Range
     * @param \StructType\Travel_Booking_Record_TypeObjectType[] $travel_Record_Type_Reference
     * @param bool $purchased
     * @param \StructType\Expense_StatusObjectType[] $expense_Status_Reference
     * @param \StructType\Booking_StatusObjectType[] $booking_Status_Reference
     * @param \StructType\Abstract_Spend_Data_NameObjectType $merchant_Reference
     * @param string $merchant_Code
     * @param string $merchant_Name
     * @param \StructType\Abstract_Spend_Data_NameObjectType $destination_Travel_City_Reference
     * @param \StructType\Expense_ReportObjectType[] $expense_Report_Reference
     */
    public function __construct($load_Date_Starting_Range = null, $load_Date_Ending_Range = null, array $travel_Booking_File_Reference = array(), $transaction_Date_Starting_Range = null, $transaction_Date_Ending_Range = null, array $worker_Reference = array(), \StructType\CompanyObjectType $company_Reference = null, $travel_Provider = null, $start_Date_Starting_Range = null, $start_Date_Ending_Range = null, $end_Date_Starting_Range = null, $end_Date_Ending_Range = null, array $travel_Record_Type_Reference = array(), $purchased = null, array $expense_Status_Reference = array(), array $booking_Status_Reference = array(), \StructType\Abstract_Spend_Data_NameObjectType $merchant_Reference = null, $merchant_Code = null, $merchant_Name = null, \StructType\Abstract_Spend_Data_NameObjectType $destination_Travel_City_Reference = null, array $expense_Report_Reference = array())
    {
        $this
            ->setLoad_Date_Starting_Range($load_Date_Starting_Range)
            ->setLoad_Date_Ending_Range($load_Date_Ending_Range)
            ->setTravel_Booking_File_Reference($travel_Booking_File_Reference)
            ->setTransaction_Date_Starting_Range($transaction_Date_Starting_Range)
            ->setTransaction_Date_Ending_Range($transaction_Date_Ending_Range)
            ->setWorker_Reference($worker_Reference)
            ->setCompany_Reference($company_Reference)
            ->setTravel_Provider($travel_Provider)
            ->setStart_Date_Starting_Range($start_Date_Starting_Range)
            ->setStart_Date_Ending_Range($start_Date_Ending_Range)
            ->setEnd_Date_Starting_Range($end_Date_Starting_Range)
            ->setEnd_Date_Ending_Range($end_Date_Ending_Range)
            ->setTravel_Record_Type_Reference($travel_Record_Type_Reference)
            ->setPurchased($purchased)
            ->setExpense_Status_Reference($expense_Status_Reference)
            ->setBooking_Status_Reference($booking_Status_Reference)
            ->setMerchant_Reference($merchant_Reference)
            ->setMerchant_Code($merchant_Code)
            ->setMerchant_Name($merchant_Name)
            ->setDestination_Travel_City_Reference($destination_Travel_City_Reference)
            ->setExpense_Report_Reference($expense_Report_Reference);
    }
    /**
     * Get Load_Date_Starting_Range value
     * @return string|null
     */
    public function getLoad_Date_Starting_Range()
    {
        return $this->Load_Date_Starting_Range;
    }
    /**
     * Set Load_Date_Starting_Range value
     * @param string $load_Date_Starting_Range
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setLoad_Date_Starting_Range($load_Date_Starting_Range = null)
    {
        // validation for constraint: string
        if (!is_null($load_Date_Starting_Range) && !is_string($load_Date_Starting_Range)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($load_Date_Starting_Range, true), gettype($load_Date_Starting_Range)), __LINE__);
        }
        $this->Load_Date_Starting_Range = $load_Date_Starting_Range;
        return $this;
    }
    /**
     * Get Load_Date_Ending_Range value
     * @return string|null
     */
    public function getLoad_Date_Ending_Range()
    {
        return $this->Load_Date_Ending_Range;
    }
    /**
     * Set Load_Date_Ending_Range value
     * @param string $load_Date_Ending_Range
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setLoad_Date_Ending_Range($load_Date_Ending_Range = null)
    {
        // validation for constraint: string
        if (!is_null($load_Date_Ending_Range) && !is_string($load_Date_Ending_Range)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($load_Date_Ending_Range, true), gettype($load_Date_Ending_Range)), __LINE__);
        }
        $this->Load_Date_Ending_Range = $load_Date_Ending_Range;
        return $this;
    }
    /**
     * Get Travel_Booking_File_Reference value
     * @return \StructType\Travel_Booking_FileObjectType[]|null
     */
    public function getTravel_Booking_File_Reference()
    {
        return $this->Travel_Booking_File_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setTravel_Booking_File_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravel_Booking_File_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravel_Booking_File_ReferenceForArrayConstraintsFromSetTravel_Booking_File_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Booking_Record_Request_CriteriaTypeTravel_Booking_File_ReferenceItem) {
            // validation for constraint: itemType
            if (!$travel_Booking_Record_Request_CriteriaTypeTravel_Booking_File_ReferenceItem instanceof \StructType\Travel_Booking_FileObjectType) {
                $invalidValues[] = is_object($travel_Booking_Record_Request_CriteriaTypeTravel_Booking_File_ReferenceItem) ? get_class($travel_Booking_Record_Request_CriteriaTypeTravel_Booking_File_ReferenceItem) : sprintf('%s(%s)', gettype($travel_Booking_Record_Request_CriteriaTypeTravel_Booking_File_ReferenceItem), var_export($travel_Booking_Record_Request_CriteriaTypeTravel_Booking_File_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Travel_Booking_File_Reference property can only contain items of type \StructType\Travel_Booking_FileObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Travel_Booking_File_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_Booking_FileObjectType[] $travel_Booking_File_Reference
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setTravel_Booking_File_Reference(array $travel_Booking_File_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($travel_Booking_File_ReferenceArrayErrorMessage = self::validateTravel_Booking_File_ReferenceForArrayConstraintsFromSetTravel_Booking_File_Reference($travel_Booking_File_Reference))) {
            throw new \InvalidArgumentException($travel_Booking_File_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Travel_Booking_File_Reference = $travel_Booking_File_Reference;
        return $this;
    }
    /**
     * Add item to Travel_Booking_File_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_Booking_FileObjectType $item
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function addToTravel_Booking_File_Reference(\StructType\Travel_Booking_FileObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Travel_Booking_FileObjectType) {
            throw new \InvalidArgumentException(sprintf('The Travel_Booking_File_Reference property can only contain items of type \StructType\Travel_Booking_FileObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Travel_Booking_File_Reference[] = $item;
        return $this;
    }
    /**
     * Get Transaction_Date_Starting_Range value
     * @return string|null
     */
    public function getTransaction_Date_Starting_Range()
    {
        return $this->Transaction_Date_Starting_Range;
    }
    /**
     * Set Transaction_Date_Starting_Range value
     * @param string $transaction_Date_Starting_Range
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setTransaction_Date_Starting_Range($transaction_Date_Starting_Range = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Date_Starting_Range) && !is_string($transaction_Date_Starting_Range)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Date_Starting_Range, true), gettype($transaction_Date_Starting_Range)), __LINE__);
        }
        $this->Transaction_Date_Starting_Range = $transaction_Date_Starting_Range;
        return $this;
    }
    /**
     * Get Transaction_Date_Ending_Range value
     * @return string|null
     */
    public function getTransaction_Date_Ending_Range()
    {
        return $this->Transaction_Date_Ending_Range;
    }
    /**
     * Set Transaction_Date_Ending_Range value
     * @param string $transaction_Date_Ending_Range
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setTransaction_Date_Ending_Range($transaction_Date_Ending_Range = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Date_Ending_Range) && !is_string($transaction_Date_Ending_Range)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Date_Ending_Range, true), gettype($transaction_Date_Ending_Range)), __LINE__);
        }
        $this->Transaction_Date_Ending_Range = $transaction_Date_Ending_Range;
        return $this;
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorker_ReferenceForArrayConstraintsFromSetWorker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Booking_Record_Request_CriteriaTypeWorker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$travel_Booking_Record_Request_CriteriaTypeWorker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($travel_Booking_Record_Request_CriteriaTypeWorker_ReferenceItem) ? get_class($travel_Booking_Record_Request_CriteriaTypeWorker_ReferenceItem) : sprintf('%s(%s)', gettype($travel_Booking_Record_Request_CriteriaTypeWorker_ReferenceItem), var_export($travel_Booking_Record_Request_CriteriaTypeWorker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $worker_Reference
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setWorker_Reference(array $worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worker_ReferenceArrayErrorMessage = self::validateWorker_ReferenceForArrayConstraintsFromSetWorker_Reference($worker_Reference))) {
            throw new \InvalidArgumentException($worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Add item to Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function addToWorker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Travel_Provider value
     * @return string|null
     */
    public function getTravel_Provider()
    {
        return $this->Travel_Provider;
    }
    /**
     * Set Travel_Provider value
     * @param string $travel_Provider
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setTravel_Provider($travel_Provider = null)
    {
        // validation for constraint: string
        if (!is_null($travel_Provider) && !is_string($travel_Provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($travel_Provider, true), gettype($travel_Provider)), __LINE__);
        }
        $this->Travel_Provider = $travel_Provider;
        return $this;
    }
    /**
     * Get Start_Date_Starting_Range value
     * @return string|null
     */
    public function getStart_Date_Starting_Range()
    {
        return $this->Start_Date_Starting_Range;
    }
    /**
     * Set Start_Date_Starting_Range value
     * @param string $start_Date_Starting_Range
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setStart_Date_Starting_Range($start_Date_Starting_Range = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date_Starting_Range) && !is_string($start_Date_Starting_Range)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date_Starting_Range, true), gettype($start_Date_Starting_Range)), __LINE__);
        }
        $this->Start_Date_Starting_Range = $start_Date_Starting_Range;
        return $this;
    }
    /**
     * Get Start_Date_Ending_Range value
     * @return string|null
     */
    public function getStart_Date_Ending_Range()
    {
        return $this->Start_Date_Ending_Range;
    }
    /**
     * Set Start_Date_Ending_Range value
     * @param string $start_Date_Ending_Range
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setStart_Date_Ending_Range($start_Date_Ending_Range = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date_Ending_Range) && !is_string($start_Date_Ending_Range)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date_Ending_Range, true), gettype($start_Date_Ending_Range)), __LINE__);
        }
        $this->Start_Date_Ending_Range = $start_Date_Ending_Range;
        return $this;
    }
    /**
     * Get End_Date_Starting_Range value
     * @return string|null
     */
    public function getEnd_Date_Starting_Range()
    {
        return $this->End_Date_Starting_Range;
    }
    /**
     * Set End_Date_Starting_Range value
     * @param string $end_Date_Starting_Range
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setEnd_Date_Starting_Range($end_Date_Starting_Range = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date_Starting_Range) && !is_string($end_Date_Starting_Range)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date_Starting_Range, true), gettype($end_Date_Starting_Range)), __LINE__);
        }
        $this->End_Date_Starting_Range = $end_Date_Starting_Range;
        return $this;
    }
    /**
     * Get End_Date_Ending_Range value
     * @return string|null
     */
    public function getEnd_Date_Ending_Range()
    {
        return $this->End_Date_Ending_Range;
    }
    /**
     * Set End_Date_Ending_Range value
     * @param string $end_Date_Ending_Range
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setEnd_Date_Ending_Range($end_Date_Ending_Range = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date_Ending_Range) && !is_string($end_Date_Ending_Range)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date_Ending_Range, true), gettype($end_Date_Ending_Range)), __LINE__);
        }
        $this->End_Date_Ending_Range = $end_Date_Ending_Range;
        return $this;
    }
    /**
     * Get Travel_Record_Type_Reference value
     * @return \StructType\Travel_Booking_Record_TypeObjectType[]|null
     */
    public function getTravel_Record_Type_Reference()
    {
        return $this->Travel_Record_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setTravel_Record_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravel_Record_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravel_Record_Type_ReferenceForArrayConstraintsFromSetTravel_Record_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Booking_Record_Request_CriteriaTypeTravel_Record_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$travel_Booking_Record_Request_CriteriaTypeTravel_Record_Type_ReferenceItem instanceof \StructType\Travel_Booking_Record_TypeObjectType) {
                $invalidValues[] = is_object($travel_Booking_Record_Request_CriteriaTypeTravel_Record_Type_ReferenceItem) ? get_class($travel_Booking_Record_Request_CriteriaTypeTravel_Record_Type_ReferenceItem) : sprintf('%s(%s)', gettype($travel_Booking_Record_Request_CriteriaTypeTravel_Record_Type_ReferenceItem), var_export($travel_Booking_Record_Request_CriteriaTypeTravel_Record_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Travel_Record_Type_Reference property can only contain items of type \StructType\Travel_Booking_Record_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Travel_Record_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_Booking_Record_TypeObjectType[] $travel_Record_Type_Reference
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setTravel_Record_Type_Reference(array $travel_Record_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($travel_Record_Type_ReferenceArrayErrorMessage = self::validateTravel_Record_Type_ReferenceForArrayConstraintsFromSetTravel_Record_Type_Reference($travel_Record_Type_Reference))) {
            throw new \InvalidArgumentException($travel_Record_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Travel_Record_Type_Reference = $travel_Record_Type_Reference;
        return $this;
    }
    /**
     * Add item to Travel_Record_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Travel_Booking_Record_TypeObjectType $item
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function addToTravel_Record_Type_Reference(\StructType\Travel_Booking_Record_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Travel_Booking_Record_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Travel_Record_Type_Reference property can only contain items of type \StructType\Travel_Booking_Record_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Travel_Record_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Purchased value
     * @return bool|null
     */
    public function getPurchased()
    {
        return $this->Purchased;
    }
    /**
     * Set Purchased value
     * @param bool $purchased
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setPurchased($purchased = null)
    {
        // validation for constraint: boolean
        if (!is_null($purchased) && !is_bool($purchased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($purchased, true), gettype($purchased)), __LINE__);
        }
        $this->Purchased = $purchased;
        return $this;
    }
    /**
     * Get Expense_Status_Reference value
     * @return \StructType\Expense_StatusObjectType[]|null
     */
    public function getExpense_Status_Reference()
    {
        return $this->Expense_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Status_ReferenceForArrayConstraintsFromSetExpense_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Booking_Record_Request_CriteriaTypeExpense_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$travel_Booking_Record_Request_CriteriaTypeExpense_Status_ReferenceItem instanceof \StructType\Expense_StatusObjectType) {
                $invalidValues[] = is_object($travel_Booking_Record_Request_CriteriaTypeExpense_Status_ReferenceItem) ? get_class($travel_Booking_Record_Request_CriteriaTypeExpense_Status_ReferenceItem) : sprintf('%s(%s)', gettype($travel_Booking_Record_Request_CriteriaTypeExpense_Status_ReferenceItem), var_export($travel_Booking_Record_Request_CriteriaTypeExpense_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Status_Reference property can only contain items of type \StructType\Expense_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_StatusObjectType[] $expense_Status_Reference
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setExpense_Status_Reference(array $expense_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Status_ReferenceArrayErrorMessage = self::validateExpense_Status_ReferenceForArrayConstraintsFromSetExpense_Status_Reference($expense_Status_Reference))) {
            throw new \InvalidArgumentException($expense_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Status_Reference = $expense_Status_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_StatusObjectType $item
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function addToExpense_Status_Reference(\StructType\Expense_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Status_Reference property can only contain items of type \StructType\Expense_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Booking_Status_Reference value
     * @return \StructType\Booking_StatusObjectType[]|null
     */
    public function getBooking_Status_Reference()
    {
        return $this->Booking_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setBooking_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBooking_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBooking_Status_ReferenceForArrayConstraintsFromSetBooking_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Booking_Record_Request_CriteriaTypeBooking_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$travel_Booking_Record_Request_CriteriaTypeBooking_Status_ReferenceItem instanceof \StructType\Booking_StatusObjectType) {
                $invalidValues[] = is_object($travel_Booking_Record_Request_CriteriaTypeBooking_Status_ReferenceItem) ? get_class($travel_Booking_Record_Request_CriteriaTypeBooking_Status_ReferenceItem) : sprintf('%s(%s)', gettype($travel_Booking_Record_Request_CriteriaTypeBooking_Status_ReferenceItem), var_export($travel_Booking_Record_Request_CriteriaTypeBooking_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Booking_Status_Reference property can only contain items of type \StructType\Booking_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Booking_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Booking_StatusObjectType[] $booking_Status_Reference
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setBooking_Status_Reference(array $booking_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($booking_Status_ReferenceArrayErrorMessage = self::validateBooking_Status_ReferenceForArrayConstraintsFromSetBooking_Status_Reference($booking_Status_Reference))) {
            throw new \InvalidArgumentException($booking_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Booking_Status_Reference = $booking_Status_Reference;
        return $this;
    }
    /**
     * Add item to Booking_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Booking_StatusObjectType $item
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function addToBooking_Status_Reference(\StructType\Booking_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Booking_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Booking_Status_Reference property can only contain items of type \StructType\Booking_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Booking_Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Merchant_Reference value
     * @return \StructType\Abstract_Spend_Data_NameObjectType|null
     */
    public function getMerchant_Reference()
    {
        return $this->Merchant_Reference;
    }
    /**
     * Set Merchant_Reference value
     * @param \StructType\Abstract_Spend_Data_NameObjectType $merchant_Reference
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setMerchant_Reference(\StructType\Abstract_Spend_Data_NameObjectType $merchant_Reference = null)
    {
        $this->Merchant_Reference = $merchant_Reference;
        return $this;
    }
    /**
     * Get Merchant_Code value
     * @return string|null
     */
    public function getMerchant_Code()
    {
        return $this->Merchant_Code;
    }
    /**
     * Set Merchant_Code value
     * @param string $merchant_Code
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setMerchant_Code($merchant_Code = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_Code) && !is_string($merchant_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_Code, true), gettype($merchant_Code)), __LINE__);
        }
        $this->Merchant_Code = $merchant_Code;
        return $this;
    }
    /**
     * Get Merchant_Name value
     * @return string|null
     */
    public function getMerchant_Name()
    {
        return $this->Merchant_Name;
    }
    /**
     * Set Merchant_Name value
     * @param string $merchant_Name
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setMerchant_Name($merchant_Name = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_Name) && !is_string($merchant_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_Name, true), gettype($merchant_Name)), __LINE__);
        }
        $this->Merchant_Name = $merchant_Name;
        return $this;
    }
    /**
     * Get Destination_Travel_City_Reference value
     * @return \StructType\Abstract_Spend_Data_NameObjectType|null
     */
    public function getDestination_Travel_City_Reference()
    {
        return $this->Destination_Travel_City_Reference;
    }
    /**
     * Set Destination_Travel_City_Reference value
     * @param \StructType\Abstract_Spend_Data_NameObjectType $destination_Travel_City_Reference
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setDestination_Travel_City_Reference(\StructType\Abstract_Spend_Data_NameObjectType $destination_Travel_City_Reference = null)
    {
        $this->Destination_Travel_City_Reference = $destination_Travel_City_Reference;
        return $this;
    }
    /**
     * Get Expense_Report_Reference value
     * @return \StructType\Expense_ReportObjectType[]|null
     */
    public function getExpense_Report_Reference()
    {
        return $this->Expense_Report_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Report_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Report_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Report_ReferenceForArrayConstraintsFromSetExpense_Report_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $travel_Booking_Record_Request_CriteriaTypeExpense_Report_ReferenceItem) {
            // validation for constraint: itemType
            if (!$travel_Booking_Record_Request_CriteriaTypeExpense_Report_ReferenceItem instanceof \StructType\Expense_ReportObjectType) {
                $invalidValues[] = is_object($travel_Booking_Record_Request_CriteriaTypeExpense_Report_ReferenceItem) ? get_class($travel_Booking_Record_Request_CriteriaTypeExpense_Report_ReferenceItem) : sprintf('%s(%s)', gettype($travel_Booking_Record_Request_CriteriaTypeExpense_Report_ReferenceItem), var_export($travel_Booking_Record_Request_CriteriaTypeExpense_Report_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Report_Reference property can only contain items of type \StructType\Expense_ReportObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Report_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_ReportObjectType[] $expense_Report_Reference
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function setExpense_Report_Reference(array $expense_Report_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Report_ReferenceArrayErrorMessage = self::validateExpense_Report_ReferenceForArrayConstraintsFromSetExpense_Report_Reference($expense_Report_Reference))) {
            throw new \InvalidArgumentException($expense_Report_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Report_Reference = $expense_Report_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Report_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_ReportObjectType $item
     * @return \StructType\Travel_Booking_Record_Request_CriteriaType
     */
    public function addToExpense_Report_Reference(\StructType\Expense_ReportObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_ReportObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Report_Reference property can only contain items of type \StructType\Expense_ReportObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Report_Reference[] = $item;
        return $this;
    }
}
