<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_ClassificationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Supplier Classification Instance and Data
 * @subpackage Structs
 */
class Supplier_ClassificationType extends AbstractStructBase
{
    /**
     * The Supplier_Classification_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Classification
     * - minOccurs: 0
     * @var \StructType\Custom_Supplier_ClassificationObjectType
     */
    public $Supplier_Classification_Reference;
    /**
     * The Supplier_Classification_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Classification Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Classification_DataType[]
     */
    public $Supplier_Classification_Data;
    /**
     * Constructor method for Supplier_ClassificationType
     * @uses Supplier_ClassificationType::setSupplier_Classification_Reference()
     * @uses Supplier_ClassificationType::setSupplier_Classification_Data()
     * @param \StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference
     * @param \StructType\Supplier_Classification_DataType[] $supplier_Classification_Data
     */
    public function __construct(\StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference = null, array $supplier_Classification_Data = array())
    {
        $this
            ->setSupplier_Classification_Reference($supplier_Classification_Reference)
            ->setSupplier_Classification_Data($supplier_Classification_Data);
    }
    /**
     * Get Supplier_Classification_Reference value
     * @return \StructType\Custom_Supplier_ClassificationObjectType|null
     */
    public function getSupplier_Classification_Reference()
    {
        return $this->Supplier_Classification_Reference;
    }
    /**
     * Set Supplier_Classification_Reference value
     * @param \StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference
     * @return \StructType\Supplier_ClassificationType
     */
    public function setSupplier_Classification_Reference(\StructType\Custom_Supplier_ClassificationObjectType $supplier_Classification_Reference = null)
    {
        $this->Supplier_Classification_Reference = $supplier_Classification_Reference;
        return $this;
    }
    /**
     * Get Supplier_Classification_Data value
     * @return \StructType\Supplier_Classification_DataType[]|null
     */
    public function getSupplier_Classification_Data()
    {
        return $this->Supplier_Classification_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Classification_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Classification_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Classification_DataForArrayConstraintsFromSetSupplier_Classification_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_ClassificationTypeSupplier_Classification_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_ClassificationTypeSupplier_Classification_DataItem instanceof \StructType\Supplier_Classification_DataType) {
                $invalidValues[] = is_object($supplier_ClassificationTypeSupplier_Classification_DataItem) ? get_class($supplier_ClassificationTypeSupplier_Classification_DataItem) : sprintf('%s(%s)', gettype($supplier_ClassificationTypeSupplier_Classification_DataItem), var_export($supplier_ClassificationTypeSupplier_Classification_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Classification_Data property can only contain items of type \StructType\Supplier_Classification_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Classification_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Classification_DataType[] $supplier_Classification_Data
     * @return \StructType\Supplier_ClassificationType
     */
    public function setSupplier_Classification_Data(array $supplier_Classification_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Classification_DataArrayErrorMessage = self::validateSupplier_Classification_DataForArrayConstraintsFromSetSupplier_Classification_Data($supplier_Classification_Data))) {
            throw new \InvalidArgumentException($supplier_Classification_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Classification_Data = $supplier_Classification_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Classification_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Classification_DataType $item
     * @return \StructType\Supplier_ClassificationType
     */
    public function addToSupplier_Classification_Data(\StructType\Supplier_Classification_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Classification_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Classification_Data property can only contain items of type \StructType\Supplier_Classification_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Classification_Data[] = $item;
        return $this;
    }
}
