<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Return_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Return
 * @subpackage Structs
 */
class Return_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Return_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Return
     * - maxOccurs: unbounded
     * @var \StructType\Return_to_SupplierObjectType[]
     */
    public $Return_Reference;
    /**
     * Constructor method for Return_Request_ReferencesType
     * @uses Return_Request_ReferencesType::setReturn_Reference()
     * @param \StructType\Return_to_SupplierObjectType[] $return_Reference
     */
    public function __construct(array $return_Reference = array())
    {
        $this
            ->setReturn_Reference($return_Reference);
    }
    /**
     * Get Return_Reference value
     * @return \StructType\Return_to_SupplierObjectType[]|null
     */
    public function getReturn_Reference()
    {
        return $this->Return_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReturn_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturn_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturn_ReferenceForArrayConstraintsFromSetReturn_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $return_Request_ReferencesTypeReturn_ReferenceItem) {
            // validation for constraint: itemType
            if (!$return_Request_ReferencesTypeReturn_ReferenceItem instanceof \StructType\Return_to_SupplierObjectType) {
                $invalidValues[] = is_object($return_Request_ReferencesTypeReturn_ReferenceItem) ? get_class($return_Request_ReferencesTypeReturn_ReferenceItem) : sprintf('%s(%s)', gettype($return_Request_ReferencesTypeReturn_ReferenceItem), var_export($return_Request_ReferencesTypeReturn_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Return_Reference property can only contain items of type \StructType\Return_to_SupplierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Return_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Return_to_SupplierObjectType[] $return_Reference
     * @return \StructType\Return_Request_ReferencesType
     */
    public function setReturn_Reference(array $return_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($return_ReferenceArrayErrorMessage = self::validateReturn_ReferenceForArrayConstraintsFromSetReturn_Reference($return_Reference))) {
            throw new \InvalidArgumentException($return_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Return_Reference = $return_Reference;
        return $this;
    }
    /**
     * Add item to Return_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Return_to_SupplierObjectType $item
     * @return \StructType\Return_Request_ReferencesType
     */
    public function addToReturn_Reference(\StructType\Return_to_SupplierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Return_to_SupplierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Return_Reference property can only contain items of type \StructType\Return_to_SupplierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Return_Reference[] = $item;
        return $this;
    }
}
