<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Purchase_Item_Group_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Purchase Item Group reference for update and all Purchase Item Group data items
 * @subpackage Structs
 */
class Put_Purchase_Item_Group_RequestType extends AbstractStructBase
{
    /**
     * The Purchase_Item_Group_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Item Group for update only purposes
     * - minOccurs: 0
     * @var \StructType\Purchase_Item_GroupObjectType
     */
    public $Purchase_Item_Group_Reference;
    /**
     * The Purchase_Item_Group_Data
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item Group Data
     * @var \StructType\Purchase_Item_Group_DataType
     */
    public $Purchase_Item_Group_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Purchase_Item_Group_RequestType
     * @uses Put_Purchase_Item_Group_RequestType::setPurchase_Item_Group_Reference()
     * @uses Put_Purchase_Item_Group_RequestType::setPurchase_Item_Group_Data()
     * @uses Put_Purchase_Item_Group_RequestType::setAdd_Only()
     * @uses Put_Purchase_Item_Group_RequestType::setVersion()
     * @param \StructType\Purchase_Item_GroupObjectType $purchase_Item_Group_Reference
     * @param \StructType\Purchase_Item_Group_DataType $purchase_Item_Group_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Purchase_Item_GroupObjectType $purchase_Item_Group_Reference = null, \StructType\Purchase_Item_Group_DataType $purchase_Item_Group_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setPurchase_Item_Group_Reference($purchase_Item_Group_Reference)
            ->setPurchase_Item_Group_Data($purchase_Item_Group_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Purchase_Item_Group_Reference value
     * @return \StructType\Purchase_Item_GroupObjectType|null
     */
    public function getPurchase_Item_Group_Reference()
    {
        return $this->Purchase_Item_Group_Reference;
    }
    /**
     * Set Purchase_Item_Group_Reference value
     * @param \StructType\Purchase_Item_GroupObjectType $purchase_Item_Group_Reference
     * @return \StructType\Put_Purchase_Item_Group_RequestType
     */
    public function setPurchase_Item_Group_Reference(\StructType\Purchase_Item_GroupObjectType $purchase_Item_Group_Reference = null)
    {
        $this->Purchase_Item_Group_Reference = $purchase_Item_Group_Reference;
        return $this;
    }
    /**
     * Get Purchase_Item_Group_Data value
     * @return \StructType\Purchase_Item_Group_DataType|null
     */
    public function getPurchase_Item_Group_Data()
    {
        return $this->Purchase_Item_Group_Data;
    }
    /**
     * Set Purchase_Item_Group_Data value
     * @param \StructType\Purchase_Item_Group_DataType $purchase_Item_Group_Data
     * @return \StructType\Put_Purchase_Item_Group_RequestType
     */
    public function setPurchase_Item_Group_Data(\StructType\Purchase_Item_Group_DataType $purchase_Item_Group_Data = null)
    {
        $this->Purchase_Item_Group_Data = $purchase_Item_Group_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Purchase_Item_Group_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Purchase_Item_Group_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
