<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Associated Ordering Pricing Data for Catalog or Supplier Item.
 * @subpackage Structs
 */
class Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Item_Pricing_Data_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Item Ordering Pricing Data
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Supplier_Item_Pricing_Data_Reference;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Bulk Unit of Measure Reference for the Catalog or Supplier Item.
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Conversion_Factor
     * Meta information extracted from the WSDL
     * - documentation: The conversion factor to be used when converting the unit of measure to the base unit of measure for the catalog item. | Conversion Factor for the ordering unit of measure to the base unit of measure of the catalog item. | Purchase
     * Item stocking Unit of measure Conversion factor | Positive numeric value used to calculate the Ordered Quantity that is shipped from Shipped Quantity provided at Advance Shipment Line. If Shipped Quantity is five and Conversion Factor is two , then
     * Quantity shipped is calculated as Ten. Default value for Conversion Factor is one. | Conversion Factor between the Ordering Unit of Measure and the Base Unit of Measure of Catalog Load Item. | Conversion factor to the base UOM. | Conversion Factor
     * from Ordering Unit of Measure to Purchase Item's Base Unit of Measure. | Conversion Factor for the JIT UOM of the Catalog or Supplier Item. | Conversion Factor for the Bulk UOM of the Catalog or Supplier Item. | The conversion factor of the web
     * item's ordering unit of measure to the linked purchase item's base unit of measure.
     * - base: xsd:decimal
     * - fractionDigits: 9
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Conversion_Factor;
    /**
     * The Unit_Price
     * Meta information extracted from the WSDL
     * - documentation: Price of Catalog Item starting on the Effective Date. | Item Unit Price | Unit Cost of Purchase Item for the corresponding UOM. | Unit Price. | Unit Price for Advanced Pricing Rule. The currency is the same as the supplier
     * information detail. | Unit Price for the JIT UOM of the Catalog or Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your
     * purchase items. | Unit Price of the Ordering UOM of the Catalog or Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your
     * purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Price;
    /**
     * The Contract_Price
     * Meta information extracted from the WSDL
     * - documentation: Contract Price of the Catalog or Supplier Item. This is for informational purposes when using Get Purchase Item web service.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Contract_Price;
    /**
     * The Lead_Time
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Lead Time | Catalog or Supplier Item Lead Time | Lead time for the UOM of the Catalog Item. | Lead time for the UOM of the supplier item. | Lead time for the supplier item | Lead time for the JIT UOM of the Catalog or
     * Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items. | Lead time for the Bulk UOM of the Catalog or Supplier
     * Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Lead_Time;
    /**
     * The Default
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether this Unit of Measure is the default UOM. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase
     * items.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Default;
    /**
     * The Minimum_Order_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Minimum Order Quantity for the UOM for this Catalog Item | The Minimum Order Quantity for a given UOM for the Catalog Item Pricing History. | The minimum quantity per unit of measure for Item. A value of zero means that there is no
     * minimum order quantity. | Supplier requires this minimum quantity to be met when you order in this unit of measure to avoid penalties. If this is for a Just in Time unit of measure, no minimum quantity is allowed. | Minimum order quantity. This field
     * can only be updated for catalog items when you enable catalog data and pricing for your purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Minimum_Order_Quantity;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Unit of Measure is inactive. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for
     * Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType
     * @uses Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType::setSupplier_Item_Pricing_Data_Reference()
     * @uses Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType::setUnit_of_Measure_Reference()
     * @uses Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType::setConversion_Factor()
     * @uses Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType::setUnit_Price()
     * @uses Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType::setContract_Price()
     * @uses Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType::setLead_Time()
     * @uses Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType::setDefault()
     * @uses Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType::setMinimum_Order_Quantity()
     * @uses Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType::setInactive()
     * @param \StructType\Unique_IdentifierObjectType $supplier_Item_Pricing_Data_Reference
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $conversion_Factor
     * @param float $unit_Price
     * @param float $contract_Price
     * @param float $lead_Time
     * @param bool $default
     * @param float $minimum_Order_Quantity
     * @param bool $inactive
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $supplier_Item_Pricing_Data_Reference = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $conversion_Factor = null, $unit_Price = null, $contract_Price = null, $lead_Time = null, $default = null, $minimum_Order_Quantity = null, $inactive = null)
    {
        $this
            ->setSupplier_Item_Pricing_Data_Reference($supplier_Item_Pricing_Data_Reference)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setConversion_Factor($conversion_Factor)
            ->setUnit_Price($unit_Price)
            ->setContract_Price($contract_Price)
            ->setLead_Time($lead_Time)
            ->setDefault($default)
            ->setMinimum_Order_Quantity($minimum_Order_Quantity)
            ->setInactive($inactive);
    }
    /**
     * Get Supplier_Item_Pricing_Data_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getSupplier_Item_Pricing_Data_Reference()
    {
        return $this->Supplier_Item_Pricing_Data_Reference;
    }
    /**
     * Set Supplier_Item_Pricing_Data_Reference value
     * @param \StructType\Unique_IdentifierObjectType $supplier_Item_Pricing_Data_Reference
     * @return \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType
     */
    public function setSupplier_Item_Pricing_Data_Reference(\StructType\Unique_IdentifierObjectType $supplier_Item_Pricing_Data_Reference = null)
    {
        $this->Supplier_Item_Pricing_Data_Reference = $supplier_Item_Pricing_Data_Reference;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Conversion_Factor value
     * @return float|null
     */
    public function getConversion_Factor()
    {
        return $this->Conversion_Factor;
    }
    /**
     * Set Conversion_Factor value
     * @param float $conversion_Factor
     * @return \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType
     */
    public function setConversion_Factor($conversion_Factor = null)
    {
        // validation for constraint: float
        if (!is_null($conversion_Factor) && !(is_float($conversion_Factor) || is_numeric($conversion_Factor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversion_Factor, true), gettype($conversion_Factor)), __LINE__);
        }
        // validation for constraint: fractionDigits(9)
        if (!is_null($conversion_Factor) && mb_strlen(mb_substr($conversion_Factor, false !== mb_strpos($conversion_Factor, '.') ? mb_strpos($conversion_Factor, '.') + 1 : mb_strlen($conversion_Factor))) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 9 fraction digits, %d given', var_export($conversion_Factor, true), mb_strlen(mb_substr($conversion_Factor, mb_strpos($conversion_Factor, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($conversion_Factor) && $conversion_Factor < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($conversion_Factor, true)), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($conversion_Factor) && mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($conversion_Factor, true), mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor))), __LINE__);
        }
        $this->Conversion_Factor = $conversion_Factor;
        return $this;
    }
    /**
     * Get Unit_Price value
     * @return float|null
     */
    public function getUnit_Price()
    {
        return $this->Unit_Price;
    }
    /**
     * Set Unit_Price value
     * @param float $unit_Price
     * @return \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType
     */
    public function setUnit_Price($unit_Price = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Price) && !(is_float($unit_Price) || is_numeric($unit_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Price, true), gettype($unit_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Price) && mb_strlen(mb_substr($unit_Price, false !== mb_strpos($unit_Price, '.') ? mb_strpos($unit_Price, '.') + 1 : mb_strlen($unit_Price))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Price, true), mb_strlen(mb_substr($unit_Price, mb_strpos($unit_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Price) && mb_strlen(preg_replace('/(\D)/', '', $unit_Price)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Price, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Price))), __LINE__);
        }
        $this->Unit_Price = $unit_Price;
        return $this;
    }
    /**
     * Get Contract_Price value
     * @return float|null
     */
    public function getContract_Price()
    {
        return $this->Contract_Price;
    }
    /**
     * Set Contract_Price value
     * @param float $contract_Price
     * @return \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType
     */
    public function setContract_Price($contract_Price = null)
    {
        // validation for constraint: float
        if (!is_null($contract_Price) && !(is_float($contract_Price) || is_numeric($contract_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($contract_Price, true), gettype($contract_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($contract_Price) && mb_strlen(mb_substr($contract_Price, false !== mb_strpos($contract_Price, '.') ? mb_strpos($contract_Price, '.') + 1 : mb_strlen($contract_Price))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($contract_Price, true), mb_strlen(mb_substr($contract_Price, mb_strpos($contract_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($contract_Price) && mb_strlen(preg_replace('/(\D)/', '', $contract_Price)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($contract_Price, true), mb_strlen(preg_replace('/(\D)/', '', $contract_Price))), __LINE__);
        }
        $this->Contract_Price = $contract_Price;
        return $this;
    }
    /**
     * Get Lead_Time value
     * @return float|null
     */
    public function getLead_Time()
    {
        return $this->Lead_Time;
    }
    /**
     * Set Lead_Time value
     * @param float $lead_Time
     * @return \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType
     */
    public function setLead_Time($lead_Time = null)
    {
        // validation for constraint: float
        if (!is_null($lead_Time) && !(is_float($lead_Time) || is_numeric($lead_Time))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lead_Time, true), gettype($lead_Time)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($lead_Time) && mb_strlen(mb_substr($lead_Time, false !== mb_strpos($lead_Time, '.') ? mb_strpos($lead_Time, '.') + 1 : mb_strlen($lead_Time))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($lead_Time, true), mb_strlen(mb_substr($lead_Time, mb_strpos($lead_Time, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($lead_Time) && $lead_Time < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($lead_Time, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($lead_Time) && mb_strlen(preg_replace('/(\D)/', '', $lead_Time)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($lead_Time, true), mb_strlen(preg_replace('/(\D)/', '', $lead_Time))), __LINE__);
        }
        $this->Lead_Time = $lead_Time;
        return $this;
    }
    /**
     * Get Default value
     * @return bool|null
     */
    public function getDefault()
    {
        return $this->Default;
    }
    /**
     * Set Default value
     * @param bool $default
     * @return \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType
     */
    public function setDefault($default = null)
    {
        // validation for constraint: boolean
        if (!is_null($default) && !is_bool($default)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($default, true), gettype($default)), __LINE__);
        }
        $this->Default = $default;
        return $this;
    }
    /**
     * Get Minimum_Order_Quantity value
     * @return float|null
     */
    public function getMinimum_Order_Quantity()
    {
        return $this->Minimum_Order_Quantity;
    }
    /**
     * Set Minimum_Order_Quantity value
     * @param float $minimum_Order_Quantity
     * @return \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType
     */
    public function setMinimum_Order_Quantity($minimum_Order_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($minimum_Order_Quantity) && !(is_float($minimum_Order_Quantity) || is_numeric($minimum_Order_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimum_Order_Quantity, true), gettype($minimum_Order_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($minimum_Order_Quantity) && mb_strlen(mb_substr($minimum_Order_Quantity, false !== mb_strpos($minimum_Order_Quantity, '.') ? mb_strpos($minimum_Order_Quantity, '.') + 1 : mb_strlen($minimum_Order_Quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($minimum_Order_Quantity, true), mb_strlen(mb_substr($minimum_Order_Quantity, mb_strpos($minimum_Order_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($minimum_Order_Quantity) && $minimum_Order_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($minimum_Order_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($minimum_Order_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $minimum_Order_Quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($minimum_Order_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $minimum_Order_Quantity))), __LINE__);
        }
        $this->Minimum_Order_Quantity = $minimum_Order_Quantity;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Priority_Ranked_Supplier_Catalog_Item_Ordering_Pricing_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
