<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Credit_Card_Transaction_Request_CriteriaType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: This element is the wrapper around a list of elements representing the Expense Credit Card Transaction Request specific criteria needed to search for instances. All of the elements are "AND" conditions. There are currently no
 * elements.
 * @subpackage Structs
 */
class Expense_Credit_Card_Transaction_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Corporate_Account_Reference
     * Meta information extracted from the WSDL
     * - documentation: Corporate credit card account of the credit card transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Corporate_Credit_Card_AccountObjectType[]
     */
    public $Corporate_Account_Reference;
    /**
     * The Usage_Indicator_Reference
     * Meta information extracted from the WSDL
     * - documentation: Usage indicator of the credit card transaction (Expense or Procurement)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Credit_Card_Account_Usage_IndicatorObjectType[]
     */
    public $Usage_Indicator_Reference;
    /**
     * The Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Status of the credit card transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_StatusObjectType[]
     */
    public $Status_Reference;
    /**
     * The Date_Loaded_From_Date
     * Meta information extracted from the WSDL
     * - documentation: Date loaded on or after selected date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date_Loaded_From_Date;
    /**
     * The Date_Loaded_To_Date
     * Meta information extracted from the WSDL
     * - documentation: Date loaded on or before selected date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Date_Loaded_To_Date;
    /**
     * The Charge_Date_From_Date
     * Meta information extracted from the WSDL
     * - documentation: Charge date on or after selected date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Charge_Date_From_Date;
    /**
     * The Charge_Date_To_Date
     * Meta information extracted from the WSDL
     * - documentation: Charge date on or before selected date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Charge_Date_To_Date;
    /**
     * Constructor method for Expense_Credit_Card_Transaction_Request_CriteriaType
     * @uses Expense_Credit_Card_Transaction_Request_CriteriaType::setCorporate_Account_Reference()
     * @uses Expense_Credit_Card_Transaction_Request_CriteriaType::setUsage_Indicator_Reference()
     * @uses Expense_Credit_Card_Transaction_Request_CriteriaType::setStatus_Reference()
     * @uses Expense_Credit_Card_Transaction_Request_CriteriaType::setDate_Loaded_From_Date()
     * @uses Expense_Credit_Card_Transaction_Request_CriteriaType::setDate_Loaded_To_Date()
     * @uses Expense_Credit_Card_Transaction_Request_CriteriaType::setCharge_Date_From_Date()
     * @uses Expense_Credit_Card_Transaction_Request_CriteriaType::setCharge_Date_To_Date()
     * @param \StructType\Corporate_Credit_Card_AccountObjectType[] $corporate_Account_Reference
     * @param \StructType\Credit_Card_Account_Usage_IndicatorObjectType[] $usage_Indicator_Reference
     * @param \StructType\Expense_StatusObjectType[] $status_Reference
     * @param string $date_Loaded_From_Date
     * @param string $date_Loaded_To_Date
     * @param string $charge_Date_From_Date
     * @param string $charge_Date_To_Date
     */
    public function __construct(array $corporate_Account_Reference = array(), array $usage_Indicator_Reference = array(), array $status_Reference = array(), $date_Loaded_From_Date = null, $date_Loaded_To_Date = null, $charge_Date_From_Date = null, $charge_Date_To_Date = null)
    {
        $this
            ->setCorporate_Account_Reference($corporate_Account_Reference)
            ->setUsage_Indicator_Reference($usage_Indicator_Reference)
            ->setStatus_Reference($status_Reference)
            ->setDate_Loaded_From_Date($date_Loaded_From_Date)
            ->setDate_Loaded_To_Date($date_Loaded_To_Date)
            ->setCharge_Date_From_Date($charge_Date_From_Date)
            ->setCharge_Date_To_Date($charge_Date_To_Date);
    }
    /**
     * Get Corporate_Account_Reference value
     * @return \StructType\Corporate_Credit_Card_AccountObjectType[]|null
     */
    public function getCorporate_Account_Reference()
    {
        return $this->Corporate_Account_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCorporate_Account_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCorporate_Account_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCorporate_Account_ReferenceForArrayConstraintsFromSetCorporate_Account_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Credit_Card_Transaction_Request_CriteriaTypeCorporate_Account_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Credit_Card_Transaction_Request_CriteriaTypeCorporate_Account_ReferenceItem instanceof \StructType\Corporate_Credit_Card_AccountObjectType) {
                $invalidValues[] = is_object($expense_Credit_Card_Transaction_Request_CriteriaTypeCorporate_Account_ReferenceItem) ? get_class($expense_Credit_Card_Transaction_Request_CriteriaTypeCorporate_Account_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Credit_Card_Transaction_Request_CriteriaTypeCorporate_Account_ReferenceItem), var_export($expense_Credit_Card_Transaction_Request_CriteriaTypeCorporate_Account_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Corporate_Account_Reference property can only contain items of type \StructType\Corporate_Credit_Card_AccountObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Corporate_Account_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Corporate_Credit_Card_AccountObjectType[] $corporate_Account_Reference
     * @return \StructType\Expense_Credit_Card_Transaction_Request_CriteriaType
     */
    public function setCorporate_Account_Reference(array $corporate_Account_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($corporate_Account_ReferenceArrayErrorMessage = self::validateCorporate_Account_ReferenceForArrayConstraintsFromSetCorporate_Account_Reference($corporate_Account_Reference))) {
            throw new \InvalidArgumentException($corporate_Account_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Corporate_Account_Reference = $corporate_Account_Reference;
        return $this;
    }
    /**
     * Add item to Corporate_Account_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $item
     * @return \StructType\Expense_Credit_Card_Transaction_Request_CriteriaType
     */
    public function addToCorporate_Account_Reference(\StructType\Corporate_Credit_Card_AccountObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Corporate_Credit_Card_AccountObjectType) {
            throw new \InvalidArgumentException(sprintf('The Corporate_Account_Reference property can only contain items of type \StructType\Corporate_Credit_Card_AccountObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Corporate_Account_Reference[] = $item;
        return $this;
    }
    /**
     * Get Usage_Indicator_Reference value
     * @return \StructType\Credit_Card_Account_Usage_IndicatorObjectType[]|null
     */
    public function getUsage_Indicator_Reference()
    {
        return $this->Usage_Indicator_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setUsage_Indicator_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUsage_Indicator_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUsage_Indicator_ReferenceForArrayConstraintsFromSetUsage_Indicator_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Credit_Card_Transaction_Request_CriteriaTypeUsage_Indicator_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Credit_Card_Transaction_Request_CriteriaTypeUsage_Indicator_ReferenceItem instanceof \StructType\Credit_Card_Account_Usage_IndicatorObjectType) {
                $invalidValues[] = is_object($expense_Credit_Card_Transaction_Request_CriteriaTypeUsage_Indicator_ReferenceItem) ? get_class($expense_Credit_Card_Transaction_Request_CriteriaTypeUsage_Indicator_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Credit_Card_Transaction_Request_CriteriaTypeUsage_Indicator_ReferenceItem), var_export($expense_Credit_Card_Transaction_Request_CriteriaTypeUsage_Indicator_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Usage_Indicator_Reference property can only contain items of type \StructType\Credit_Card_Account_Usage_IndicatorObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Usage_Indicator_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card_Account_Usage_IndicatorObjectType[] $usage_Indicator_Reference
     * @return \StructType\Expense_Credit_Card_Transaction_Request_CriteriaType
     */
    public function setUsage_Indicator_Reference(array $usage_Indicator_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($usage_Indicator_ReferenceArrayErrorMessage = self::validateUsage_Indicator_ReferenceForArrayConstraintsFromSetUsage_Indicator_Reference($usage_Indicator_Reference))) {
            throw new \InvalidArgumentException($usage_Indicator_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Usage_Indicator_Reference = $usage_Indicator_Reference;
        return $this;
    }
    /**
     * Add item to Usage_Indicator_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card_Account_Usage_IndicatorObjectType $item
     * @return \StructType\Expense_Credit_Card_Transaction_Request_CriteriaType
     */
    public function addToUsage_Indicator_Reference(\StructType\Credit_Card_Account_Usage_IndicatorObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Credit_Card_Account_Usage_IndicatorObjectType) {
            throw new \InvalidArgumentException(sprintf('The Usage_Indicator_Reference property can only contain items of type \StructType\Credit_Card_Account_Usage_IndicatorObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Usage_Indicator_Reference[] = $item;
        return $this;
    }
    /**
     * Get Status_Reference value
     * @return \StructType\Expense_StatusObjectType[]|null
     */
    public function getStatus_Reference()
    {
        return $this->Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setStatus_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatus_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatus_ReferenceForArrayConstraintsFromSetStatus_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Credit_Card_Transaction_Request_CriteriaTypeStatus_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Credit_Card_Transaction_Request_CriteriaTypeStatus_ReferenceItem instanceof \StructType\Expense_StatusObjectType) {
                $invalidValues[] = is_object($expense_Credit_Card_Transaction_Request_CriteriaTypeStatus_ReferenceItem) ? get_class($expense_Credit_Card_Transaction_Request_CriteriaTypeStatus_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Credit_Card_Transaction_Request_CriteriaTypeStatus_ReferenceItem), var_export($expense_Credit_Card_Transaction_Request_CriteriaTypeStatus_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Status_Reference property can only contain items of type \StructType\Expense_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_StatusObjectType[] $status_Reference
     * @return \StructType\Expense_Credit_Card_Transaction_Request_CriteriaType
     */
    public function setStatus_Reference(array $status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($status_ReferenceArrayErrorMessage = self::validateStatus_ReferenceForArrayConstraintsFromSetStatus_Reference($status_Reference))) {
            throw new \InvalidArgumentException($status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Status_Reference = $status_Reference;
        return $this;
    }
    /**
     * Add item to Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_StatusObjectType $item
     * @return \StructType\Expense_Credit_Card_Transaction_Request_CriteriaType
     */
    public function addToStatus_Reference(\StructType\Expense_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The Status_Reference property can only contain items of type \StructType\Expense_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Status_Reference[] = $item;
        return $this;
    }
    /**
     * Get Date_Loaded_From_Date value
     * @return string|null
     */
    public function getDate_Loaded_From_Date()
    {
        return $this->Date_Loaded_From_Date;
    }
    /**
     * Set Date_Loaded_From_Date value
     * @param string $date_Loaded_From_Date
     * @return \StructType\Expense_Credit_Card_Transaction_Request_CriteriaType
     */
    public function setDate_Loaded_From_Date($date_Loaded_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($date_Loaded_From_Date) && !is_string($date_Loaded_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_Loaded_From_Date, true), gettype($date_Loaded_From_Date)), __LINE__);
        }
        $this->Date_Loaded_From_Date = $date_Loaded_From_Date;
        return $this;
    }
    /**
     * Get Date_Loaded_To_Date value
     * @return string|null
     */
    public function getDate_Loaded_To_Date()
    {
        return $this->Date_Loaded_To_Date;
    }
    /**
     * Set Date_Loaded_To_Date value
     * @param string $date_Loaded_To_Date
     * @return \StructType\Expense_Credit_Card_Transaction_Request_CriteriaType
     */
    public function setDate_Loaded_To_Date($date_Loaded_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($date_Loaded_To_Date) && !is_string($date_Loaded_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date_Loaded_To_Date, true), gettype($date_Loaded_To_Date)), __LINE__);
        }
        $this->Date_Loaded_To_Date = $date_Loaded_To_Date;
        return $this;
    }
    /**
     * Get Charge_Date_From_Date value
     * @return string|null
     */
    public function getCharge_Date_From_Date()
    {
        return $this->Charge_Date_From_Date;
    }
    /**
     * Set Charge_Date_From_Date value
     * @param string $charge_Date_From_Date
     * @return \StructType\Expense_Credit_Card_Transaction_Request_CriteriaType
     */
    public function setCharge_Date_From_Date($charge_Date_From_Date = null)
    {
        // validation for constraint: string
        if (!is_null($charge_Date_From_Date) && !is_string($charge_Date_From_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($charge_Date_From_Date, true), gettype($charge_Date_From_Date)), __LINE__);
        }
        $this->Charge_Date_From_Date = $charge_Date_From_Date;
        return $this;
    }
    /**
     * Get Charge_Date_To_Date value
     * @return string|null
     */
    public function getCharge_Date_To_Date()
    {
        return $this->Charge_Date_To_Date;
    }
    /**
     * Set Charge_Date_To_Date value
     * @param string $charge_Date_To_Date
     * @return \StructType\Expense_Credit_Card_Transaction_Request_CriteriaType
     */
    public function setCharge_Date_To_Date($charge_Date_To_Date = null)
    {
        // validation for constraint: string
        if (!is_null($charge_Date_To_Date) && !is_string($charge_Date_To_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($charge_Date_To_Date, true), gettype($charge_Date_To_Date)), __LINE__);
        }
        $this->Charge_Date_To_Date = $charge_Date_To_Date;
        return $this;
    }
}
