<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Currency_Rate_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Currency conversion rate data.
 * @subpackage Structs
 */
class Currency_Rate_DataType extends AbstractStructBase
{
    /**
     * The Ledger_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter a ledger currency for any specified currency override. | You can't override currency because the transaction currency or one of the ledger currencies are the same. | The ledger currency you entered is not defined in your
     * company set up. Enter a defined ledger currency, or update your set up. | Ledger Currency.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Ledger_Currency_Reference;
    /**
     * The Is_Primary
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether this is the primary ledger. This field is read-only, and Workday ignores this field on a Put or Submit.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Is_Primary;
    /**
     * The Rate_Override
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the currency exchange rate has been overwritten or not.This information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Rate_Override;
    /**
     * The Document_Currency_Conversion_Rate
     * Meta information extracted from the WSDL
     * - documentation: For a foreign currency invoice, this is the currency conversion rate for the accounting document ledger.This information is for outbound purposes only and is not processed on inbound Workday Web Services requests. | Supplier refund
     * currency conversion rate
     * - base: xsd:decimal
     * - fractionDigits: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 24
     * @var float
     */
    public $Document_Currency_Conversion_Rate;
    /**
     * The Currency_Rate_Manual_Override
     * Meta information extracted from the WSDL
     * - documentation: For a foreign currency invoice, this allows you to directly override the currency conversion rate that will be used. | Currency rate manual override.
     * - base: xsd:decimal
     * - fractionDigits: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 24
     * @var float
     */
    public $Currency_Rate_Manual_Override;
    /**
     * The Default_Currency_Rate
     * Meta information extracted from the WSDL
     * - documentation: For a foreign currency invoice, this is the default currency rate.This information is for outbound purposes only and is not processed on inbound Workday Web Services requests. | Default currency rate.
     * - base: xsd:decimal
     * - fractionDigits: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 32
     * @var float
     */
    public $Default_Currency_Rate;
    /**
     * The Currency_Rate_Type_Override_Reference
     * Meta information extracted from the WSDL
     * - documentation: Override rate type for Business Document.
     * - minOccurs: 0
     * @var \StructType\Currency_Rate_TypeObjectType
     */
    public $Currency_Rate_Type_Override_Reference;
    /**
     * The Default_Rate_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default rate type reference
     * - minOccurs: 0
     * @var \StructType\Currency_Rate_TypeObjectType
     */
    public $Default_Rate_Type_Reference;
    /**
     * The Currency_Rate_Date_Override
     * Meta information extracted from the WSDL
     * - documentation: Currency rate date override.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency_Rate_Date_Override;
    /**
     * The Currency_Rate_Lookup_Override
     * Meta information extracted from the WSDL
     * - documentation: For a foreign currency invoice, this is currency exchange rate derived based on the currency rate type override or currency rate date override.This information is for outbound purposes only and is not processed on inbound Workday Web
     * Services requests. | Currency rate lookup override.
     * - base: xsd:decimal
     * - fractionDigits: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 24
     * @var float
     */
    public $Currency_Rate_Lookup_Override;
    /**
     * The Rate_Basis_Date
     * Meta information extracted from the WSDL
     * - documentation: Default rate basis date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Rate_Basis_Date;
    /**
     * The Manual_Override_Percent
     * Meta information extracted from the WSDL
     * - documentation: For a foreign currency invoice, this is the percentage of the currency rate manual override against the default currency rate.This information is for outbound purposes only and is not processed on inbound Workday Web Services
     * requests. | Manual override percent.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Manual_Override_Percent;
    /**
     * Constructor method for Currency_Rate_DataType
     * @uses Currency_Rate_DataType::setLedger_Currency_Reference()
     * @uses Currency_Rate_DataType::setIs_Primary()
     * @uses Currency_Rate_DataType::setRate_Override()
     * @uses Currency_Rate_DataType::setDocument_Currency_Conversion_Rate()
     * @uses Currency_Rate_DataType::setCurrency_Rate_Manual_Override()
     * @uses Currency_Rate_DataType::setDefault_Currency_Rate()
     * @uses Currency_Rate_DataType::setCurrency_Rate_Type_Override_Reference()
     * @uses Currency_Rate_DataType::setDefault_Rate_Type_Reference()
     * @uses Currency_Rate_DataType::setCurrency_Rate_Date_Override()
     * @uses Currency_Rate_DataType::setCurrency_Rate_Lookup_Override()
     * @uses Currency_Rate_DataType::setRate_Basis_Date()
     * @uses Currency_Rate_DataType::setManual_Override_Percent()
     * @param \StructType\CurrencyObjectType $ledger_Currency_Reference
     * @param bool $is_Primary
     * @param bool $rate_Override
     * @param float $document_Currency_Conversion_Rate
     * @param float $currency_Rate_Manual_Override
     * @param float $default_Currency_Rate
     * @param \StructType\Currency_Rate_TypeObjectType $currency_Rate_Type_Override_Reference
     * @param \StructType\Currency_Rate_TypeObjectType $default_Rate_Type_Reference
     * @param string $currency_Rate_Date_Override
     * @param float $currency_Rate_Lookup_Override
     * @param string $rate_Basis_Date
     * @param float $manual_Override_Percent
     */
    public function __construct(\StructType\CurrencyObjectType $ledger_Currency_Reference = null, $is_Primary = null, $rate_Override = null, $document_Currency_Conversion_Rate = null, $currency_Rate_Manual_Override = null, $default_Currency_Rate = null, \StructType\Currency_Rate_TypeObjectType $currency_Rate_Type_Override_Reference = null, \StructType\Currency_Rate_TypeObjectType $default_Rate_Type_Reference = null, $currency_Rate_Date_Override = null, $currency_Rate_Lookup_Override = null, $rate_Basis_Date = null, $manual_Override_Percent = null)
    {
        $this
            ->setLedger_Currency_Reference($ledger_Currency_Reference)
            ->setIs_Primary($is_Primary)
            ->setRate_Override($rate_Override)
            ->setDocument_Currency_Conversion_Rate($document_Currency_Conversion_Rate)
            ->setCurrency_Rate_Manual_Override($currency_Rate_Manual_Override)
            ->setDefault_Currency_Rate($default_Currency_Rate)
            ->setCurrency_Rate_Type_Override_Reference($currency_Rate_Type_Override_Reference)
            ->setDefault_Rate_Type_Reference($default_Rate_Type_Reference)
            ->setCurrency_Rate_Date_Override($currency_Rate_Date_Override)
            ->setCurrency_Rate_Lookup_Override($currency_Rate_Lookup_Override)
            ->setRate_Basis_Date($rate_Basis_Date)
            ->setManual_Override_Percent($manual_Override_Percent);
    }
    /**
     * Get Ledger_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getLedger_Currency_Reference()
    {
        return $this->Ledger_Currency_Reference;
    }
    /**
     * Set Ledger_Currency_Reference value
     * @param \StructType\CurrencyObjectType $ledger_Currency_Reference
     * @return \StructType\Currency_Rate_DataType
     */
    public function setLedger_Currency_Reference(\StructType\CurrencyObjectType $ledger_Currency_Reference = null)
    {
        $this->Ledger_Currency_Reference = $ledger_Currency_Reference;
        return $this;
    }
    /**
     * Get Is_Primary value
     * @return bool|null
     */
    public function getIs_Primary()
    {
        return $this->Is_Primary;
    }
    /**
     * Set Is_Primary value
     * @param bool $is_Primary
     * @return \StructType\Currency_Rate_DataType
     */
    public function setIs_Primary($is_Primary = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_Primary) && !is_bool($is_Primary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_Primary, true), gettype($is_Primary)), __LINE__);
        }
        $this->Is_Primary = $is_Primary;
        return $this;
    }
    /**
     * Get Rate_Override value
     * @return bool|null
     */
    public function getRate_Override()
    {
        return $this->Rate_Override;
    }
    /**
     * Set Rate_Override value
     * @param bool $rate_Override
     * @return \StructType\Currency_Rate_DataType
     */
    public function setRate_Override($rate_Override = null)
    {
        // validation for constraint: boolean
        if (!is_null($rate_Override) && !is_bool($rate_Override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rate_Override, true), gettype($rate_Override)), __LINE__);
        }
        $this->Rate_Override = $rate_Override;
        return $this;
    }
    /**
     * Get Document_Currency_Conversion_Rate value
     * @return float|null
     */
    public function getDocument_Currency_Conversion_Rate()
    {
        return $this->Document_Currency_Conversion_Rate;
    }
    /**
     * Set Document_Currency_Conversion_Rate value
     * @param float $document_Currency_Conversion_Rate
     * @return \StructType\Currency_Rate_DataType
     */
    public function setDocument_Currency_Conversion_Rate($document_Currency_Conversion_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($document_Currency_Conversion_Rate) && !(is_float($document_Currency_Conversion_Rate) || is_numeric($document_Currency_Conversion_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($document_Currency_Conversion_Rate, true), gettype($document_Currency_Conversion_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(12)
        if (!is_null($document_Currency_Conversion_Rate) && mb_strlen(mb_substr($document_Currency_Conversion_Rate, false !== mb_strpos($document_Currency_Conversion_Rate, '.') ? mb_strpos($document_Currency_Conversion_Rate, '.') + 1 : mb_strlen($document_Currency_Conversion_Rate))) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 12 fraction digits, %d given', var_export($document_Currency_Conversion_Rate, true), mb_strlen(mb_substr($document_Currency_Conversion_Rate, mb_strpos($document_Currency_Conversion_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(24)
        if (!is_null($document_Currency_Conversion_Rate) && mb_strlen(preg_replace('/(\D)/', '', $document_Currency_Conversion_Rate)) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 24 digits, "%d" given', var_export($document_Currency_Conversion_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $document_Currency_Conversion_Rate))), __LINE__);
        }
        $this->Document_Currency_Conversion_Rate = $document_Currency_Conversion_Rate;
        return $this;
    }
    /**
     * Get Currency_Rate_Manual_Override value
     * @return float|null
     */
    public function getCurrency_Rate_Manual_Override()
    {
        return $this->Currency_Rate_Manual_Override;
    }
    /**
     * Set Currency_Rate_Manual_Override value
     * @param float $currency_Rate_Manual_Override
     * @return \StructType\Currency_Rate_DataType
     */
    public function setCurrency_Rate_Manual_Override($currency_Rate_Manual_Override = null)
    {
        // validation for constraint: float
        if (!is_null($currency_Rate_Manual_Override) && !(is_float($currency_Rate_Manual_Override) || is_numeric($currency_Rate_Manual_Override))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currency_Rate_Manual_Override, true), gettype($currency_Rate_Manual_Override)), __LINE__);
        }
        // validation for constraint: fractionDigits(12)
        if (!is_null($currency_Rate_Manual_Override) && mb_strlen(mb_substr($currency_Rate_Manual_Override, false !== mb_strpos($currency_Rate_Manual_Override, '.') ? mb_strpos($currency_Rate_Manual_Override, '.') + 1 : mb_strlen($currency_Rate_Manual_Override))) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 12 fraction digits, %d given', var_export($currency_Rate_Manual_Override, true), mb_strlen(mb_substr($currency_Rate_Manual_Override, mb_strpos($currency_Rate_Manual_Override, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(24)
        if (!is_null($currency_Rate_Manual_Override) && mb_strlen(preg_replace('/(\D)/', '', $currency_Rate_Manual_Override)) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 24 digits, "%d" given', var_export($currency_Rate_Manual_Override, true), mb_strlen(preg_replace('/(\D)/', '', $currency_Rate_Manual_Override))), __LINE__);
        }
        $this->Currency_Rate_Manual_Override = $currency_Rate_Manual_Override;
        return $this;
    }
    /**
     * Get Default_Currency_Rate value
     * @return float|null
     */
    public function getDefault_Currency_Rate()
    {
        return $this->Default_Currency_Rate;
    }
    /**
     * Set Default_Currency_Rate value
     * @param float $default_Currency_Rate
     * @return \StructType\Currency_Rate_DataType
     */
    public function setDefault_Currency_Rate($default_Currency_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($default_Currency_Rate) && !(is_float($default_Currency_Rate) || is_numeric($default_Currency_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($default_Currency_Rate, true), gettype($default_Currency_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(12)
        if (!is_null($default_Currency_Rate) && mb_strlen(mb_substr($default_Currency_Rate, false !== mb_strpos($default_Currency_Rate, '.') ? mb_strpos($default_Currency_Rate, '.') + 1 : mb_strlen($default_Currency_Rate))) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 12 fraction digits, %d given', var_export($default_Currency_Rate, true), mb_strlen(mb_substr($default_Currency_Rate, mb_strpos($default_Currency_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(32)
        if (!is_null($default_Currency_Rate) && mb_strlen(preg_replace('/(\D)/', '', $default_Currency_Rate)) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 32 digits, "%d" given', var_export($default_Currency_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $default_Currency_Rate))), __LINE__);
        }
        $this->Default_Currency_Rate = $default_Currency_Rate;
        return $this;
    }
    /**
     * Get Currency_Rate_Type_Override_Reference value
     * @return \StructType\Currency_Rate_TypeObjectType|null
     */
    public function getCurrency_Rate_Type_Override_Reference()
    {
        return $this->Currency_Rate_Type_Override_Reference;
    }
    /**
     * Set Currency_Rate_Type_Override_Reference value
     * @param \StructType\Currency_Rate_TypeObjectType $currency_Rate_Type_Override_Reference
     * @return \StructType\Currency_Rate_DataType
     */
    public function setCurrency_Rate_Type_Override_Reference(\StructType\Currency_Rate_TypeObjectType $currency_Rate_Type_Override_Reference = null)
    {
        $this->Currency_Rate_Type_Override_Reference = $currency_Rate_Type_Override_Reference;
        return $this;
    }
    /**
     * Get Default_Rate_Type_Reference value
     * @return \StructType\Currency_Rate_TypeObjectType|null
     */
    public function getDefault_Rate_Type_Reference()
    {
        return $this->Default_Rate_Type_Reference;
    }
    /**
     * Set Default_Rate_Type_Reference value
     * @param \StructType\Currency_Rate_TypeObjectType $default_Rate_Type_Reference
     * @return \StructType\Currency_Rate_DataType
     */
    public function setDefault_Rate_Type_Reference(\StructType\Currency_Rate_TypeObjectType $default_Rate_Type_Reference = null)
    {
        $this->Default_Rate_Type_Reference = $default_Rate_Type_Reference;
        return $this;
    }
    /**
     * Get Currency_Rate_Date_Override value
     * @return string|null
     */
    public function getCurrency_Rate_Date_Override()
    {
        return $this->Currency_Rate_Date_Override;
    }
    /**
     * Set Currency_Rate_Date_Override value
     * @param string $currency_Rate_Date_Override
     * @return \StructType\Currency_Rate_DataType
     */
    public function setCurrency_Rate_Date_Override($currency_Rate_Date_Override = null)
    {
        // validation for constraint: string
        if (!is_null($currency_Rate_Date_Override) && !is_string($currency_Rate_Date_Override)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency_Rate_Date_Override, true), gettype($currency_Rate_Date_Override)), __LINE__);
        }
        $this->Currency_Rate_Date_Override = $currency_Rate_Date_Override;
        return $this;
    }
    /**
     * Get Currency_Rate_Lookup_Override value
     * @return float|null
     */
    public function getCurrency_Rate_Lookup_Override()
    {
        return $this->Currency_Rate_Lookup_Override;
    }
    /**
     * Set Currency_Rate_Lookup_Override value
     * @param float $currency_Rate_Lookup_Override
     * @return \StructType\Currency_Rate_DataType
     */
    public function setCurrency_Rate_Lookup_Override($currency_Rate_Lookup_Override = null)
    {
        // validation for constraint: float
        if (!is_null($currency_Rate_Lookup_Override) && !(is_float($currency_Rate_Lookup_Override) || is_numeric($currency_Rate_Lookup_Override))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currency_Rate_Lookup_Override, true), gettype($currency_Rate_Lookup_Override)), __LINE__);
        }
        // validation for constraint: fractionDigits(12)
        if (!is_null($currency_Rate_Lookup_Override) && mb_strlen(mb_substr($currency_Rate_Lookup_Override, false !== mb_strpos($currency_Rate_Lookup_Override, '.') ? mb_strpos($currency_Rate_Lookup_Override, '.') + 1 : mb_strlen($currency_Rate_Lookup_Override))) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 12 fraction digits, %d given', var_export($currency_Rate_Lookup_Override, true), mb_strlen(mb_substr($currency_Rate_Lookup_Override, mb_strpos($currency_Rate_Lookup_Override, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(24)
        if (!is_null($currency_Rate_Lookup_Override) && mb_strlen(preg_replace('/(\D)/', '', $currency_Rate_Lookup_Override)) > 24) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 24 digits, "%d" given', var_export($currency_Rate_Lookup_Override, true), mb_strlen(preg_replace('/(\D)/', '', $currency_Rate_Lookup_Override))), __LINE__);
        }
        $this->Currency_Rate_Lookup_Override = $currency_Rate_Lookup_Override;
        return $this;
    }
    /**
     * Get Rate_Basis_Date value
     * @return string|null
     */
    public function getRate_Basis_Date()
    {
        return $this->Rate_Basis_Date;
    }
    /**
     * Set Rate_Basis_Date value
     * @param string $rate_Basis_Date
     * @return \StructType\Currency_Rate_DataType
     */
    public function setRate_Basis_Date($rate_Basis_Date = null)
    {
        // validation for constraint: string
        if (!is_null($rate_Basis_Date) && !is_string($rate_Basis_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rate_Basis_Date, true), gettype($rate_Basis_Date)), __LINE__);
        }
        $this->Rate_Basis_Date = $rate_Basis_Date;
        return $this;
    }
    /**
     * Get Manual_Override_Percent value
     * @return float|null
     */
    public function getManual_Override_Percent()
    {
        return $this->Manual_Override_Percent;
    }
    /**
     * Set Manual_Override_Percent value
     * @param float $manual_Override_Percent
     * @return \StructType\Currency_Rate_DataType
     */
    public function setManual_Override_Percent($manual_Override_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($manual_Override_Percent) && !(is_float($manual_Override_Percent) || is_numeric($manual_Override_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($manual_Override_Percent, true), gettype($manual_Override_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($manual_Override_Percent) && mb_strlen(mb_substr($manual_Override_Percent, false !== mb_strpos($manual_Override_Percent, '.') ? mb_strpos($manual_Override_Percent, '.') + 1 : mb_strlen($manual_Override_Percent))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($manual_Override_Percent, true), mb_strlen(mb_substr($manual_Override_Percent, mb_strpos($manual_Override_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($manual_Override_Percent) && mb_strlen(preg_replace('/(\D)/', '', $manual_Override_Percent)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($manual_Override_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $manual_Override_Percent))), __LINE__);
        }
        $this->Manual_Override_Percent = $manual_Override_Percent;
        return $this;
    }
}
