<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Corporate_Credit_Card_Account_Response_GroupType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element around a list of fields representing the amount of data that should be included in the Corporate Credit Card Account response. If this element is not included then ALL of the Response Groups are included in the
 * response.
 * @subpackage Structs
 */
class Corporate_Credit_Card_Account_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the Corporate Credit Card Account Reference data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Corporate_Credit_Card_Account_Data
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the Corporate Credit Card Account data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Corporate_Credit_Card_Account_Data;
    /**
     * Constructor method for Corporate_Credit_Card_Account_Response_GroupType
     * @uses Corporate_Credit_Card_Account_Response_GroupType::setInclude_Reference()
     * @uses Corporate_Credit_Card_Account_Response_GroupType::setInclude_Corporate_Credit_Card_Account_Data()
     * @param bool $include_Reference
     * @param bool $include_Corporate_Credit_Card_Account_Data
     */
    public function __construct($include_Reference = null, $include_Corporate_Credit_Card_Account_Data = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Corporate_Credit_Card_Account_Data($include_Corporate_Credit_Card_Account_Data);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Corporate_Credit_Card_Account_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Corporate_Credit_Card_Account_Data value
     * @return bool|null
     */
    public function getInclude_Corporate_Credit_Card_Account_Data()
    {
        return $this->Include_Corporate_Credit_Card_Account_Data;
    }
    /**
     * Set Include_Corporate_Credit_Card_Account_Data value
     * @param bool $include_Corporate_Credit_Card_Account_Data
     * @return \StructType\Corporate_Credit_Card_Account_Response_GroupType
     */
    public function setInclude_Corporate_Credit_Card_Account_Data($include_Corporate_Credit_Card_Account_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Corporate_Credit_Card_Account_Data) && !is_bool($include_Corporate_Credit_Card_Account_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Corporate_Credit_Card_Account_Data, true), gettype($include_Corporate_Credit_Card_Account_Data)), __LINE__);
        }
        $this->Include_Corporate_Credit_Card_Account_Data = $include_Corporate_Credit_Card_Account_Data;
        return $this;
    }
}
