<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Filter_DateTimeZone_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: DateTimeZone value for filter.
 * @subpackage Structs
 */
class Filter_DateTimeZone_DataType extends AbstractStructBase
{
    /**
     * The Filter_DateTime
     * Meta information extracted from the WSDL
     * - documentation: DateTime value for DateTimeZone Filter.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Filter_DateTime;
    /**
     * The Filter_TimeZone_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to TimeZone for DateTimeZone Filter.
     * - minOccurs: 0
     * @var \StructType\Time_ZoneObjectType
     */
    public $Filter_TimeZone_Reference;
    /**
     * Constructor method for Filter_DateTimeZone_DataType
     * @uses Filter_DateTimeZone_DataType::setFilter_DateTime()
     * @uses Filter_DateTimeZone_DataType::setFilter_TimeZone_Reference()
     * @param string $filter_DateTime
     * @param \StructType\Time_ZoneObjectType $filter_TimeZone_Reference
     */
    public function __construct($filter_DateTime = null, \StructType\Time_ZoneObjectType $filter_TimeZone_Reference = null)
    {
        $this
            ->setFilter_DateTime($filter_DateTime)
            ->setFilter_TimeZone_Reference($filter_TimeZone_Reference);
    }
    /**
     * Get Filter_DateTime value
     * @return string|null
     */
    public function getFilter_DateTime()
    {
        return $this->Filter_DateTime;
    }
    /**
     * Set Filter_DateTime value
     * @param string $filter_DateTime
     * @return \StructType\Filter_DateTimeZone_DataType
     */
    public function setFilter_DateTime($filter_DateTime = null)
    {
        // validation for constraint: string
        if (!is_null($filter_DateTime) && !is_string($filter_DateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filter_DateTime, true), gettype($filter_DateTime)), __LINE__);
        }
        $this->Filter_DateTime = $filter_DateTime;
        return $this;
    }
    /**
     * Get Filter_TimeZone_Reference value
     * @return \StructType\Time_ZoneObjectType|null
     */
    public function getFilter_TimeZone_Reference()
    {
        return $this->Filter_TimeZone_Reference;
    }
    /**
     * Set Filter_TimeZone_Reference value
     * @param \StructType\Time_ZoneObjectType $filter_TimeZone_Reference
     * @return \StructType\Filter_DateTimeZone_DataType
     */
    public function setFilter_TimeZone_Reference(\StructType\Time_ZoneObjectType $filter_TimeZone_Reference = null)
    {
        $this->Filter_TimeZone_Reference = $filter_TimeZone_Reference;
        return $this;
    }
}
