<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Spend_Category_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Spend Category Instance and Data
 * @subpackage Structs
 */
class Spend_Category_Response_DataType extends AbstractStructBase
{
    /**
     * The Resource_Category
     * Meta information extracted from the WSDL
     * - documentation: Spend Category
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryType[]
     */
    public $Resource_Category;
    /**
     * Constructor method for Spend_Category_Response_DataType
     * @uses Spend_Category_Response_DataType::setResource_Category()
     * @param \StructType\Spend_CategoryType[] $resource_Category
     */
    public function __construct(array $resource_Category = array())
    {
        $this
            ->setResource_Category($resource_Category);
    }
    /**
     * Get Resource_Category value
     * @return \StructType\Spend_CategoryType[]|null
     */
    public function getResource_Category()
    {
        return $this->Resource_Category;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Category method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Category method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_CategoryForArrayConstraintsFromSetResource_Category(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_Category_Response_DataTypeResource_CategoryItem) {
            // validation for constraint: itemType
            if (!$spend_Category_Response_DataTypeResource_CategoryItem instanceof \StructType\Spend_CategoryType) {
                $invalidValues[] = is_object($spend_Category_Response_DataTypeResource_CategoryItem) ? get_class($spend_Category_Response_DataTypeResource_CategoryItem) : sprintf('%s(%s)', gettype($spend_Category_Response_DataTypeResource_CategoryItem), var_export($spend_Category_Response_DataTypeResource_CategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Category property can only contain items of type \StructType\Spend_CategoryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Category value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryType[] $resource_Category
     * @return \StructType\Spend_Category_Response_DataType
     */
    public function setResource_Category(array $resource_Category = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_CategoryArrayErrorMessage = self::validateResource_CategoryForArrayConstraintsFromSetResource_Category($resource_Category))) {
            throw new \InvalidArgumentException($resource_CategoryArrayErrorMessage, __LINE__);
        }
        $this->Resource_Category = $resource_Category;
        return $this;
    }
    /**
     * Add item to Resource_Category value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryType $item
     * @return \StructType\Spend_Category_Response_DataType
     */
    public function addToResource_Category(\StructType\Spend_CategoryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_CategoryType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Category property can only contain items of type \StructType\Spend_CategoryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Category[] = $item;
        return $this;
    }
}
