<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFQ_Response_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that captures RFQ Response Line information
 * @subpackage Structs
 */
class RFQ_Response_Line_DataType extends AbstractStructBase
{
    /**
     * The RFQ_Response_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the RFQ Response Line.
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Response_LineObjectType
     */
    public $RFQ_Response_Line_Reference;
    /**
     * The RFQ_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the RFQ line to which the response was recorded for.
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_LineObjectType
     */
    public $RFQ_Line_Reference;
    /**
     * The Line_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Request for Quote Line Type Reference
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_Line_TypeObjectType
     */
    public $Line_Type_Reference;
    /**
     * The RFQ_Line_Number
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Line Number.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 5
     * @var float
     */
    public $RFQ_Line_Number;
    /**
     * The Item_Descriptor_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item on the Request for Quote Line.
     * - minOccurs: 0
     * @var \StructType\Item_DescriptorObjectType
     */
    public $Item_Descriptor_Reference;
    /**
     * The Line_Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Item Description on the Request for Quote Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Line_Item_Description;
    /**
     * The Response_Line_Description
     * Meta information extracted from the WSDL
     * - documentation: The Response Line Item Description on the RFQ Response Line
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Response_Line_Description;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Category on Request for Quote Line.
     * - minOccurs: 0
     * @var \StructType\Accounting_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The No_Bid
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate where bid is made for a RFQ line when submitting the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $No_Bid;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit of Measure on Request for Quote Line.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Target_Price
     * Meta information extracted from the WSDL
     * - documentation: Target Price. | Target Price recorded on Request for Quote Line. | Target Price of the RFQ Line
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Target_Price;
    /**
     * The Requested_Delivery_Date
     * Meta information extracted from the WSDL
     * - documentation: Enter a Requested Delivery Date that is on or after the RFQ Document Date.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Requested_Delivery_Date;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start Date on Request for Quote Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: End Date on Request for Quote Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The RFQ_Line_Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo recorded on Request for Quote Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RFQ_Line_Memo;
    /**
     * The Response_Price
     * Meta information extracted from the WSDL
     * - documentation: Response Price recorded on RFQ Response Line. | Response Price provided by the supplier. | Response Price on RFQ Response Line
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Response_Price;
    /**
     * The Response_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Response Quantity recorded on RFQ Response Line. | Response Quantity as entered by the supplier..
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Response_Quantity;
    /**
     * The Response_Lead_Time
     * Meta information extracted from the WSDL
     * - documentation: Lead Time recorded on RFQ Response Line.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Response_Lead_Time;
    /**
     * The Response_Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo recorded on RFQ Response Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Response_Memo;
    /**
     * The RFQ_Line_Bid_Response_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that captures responses to line level bid requirements.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RFQ_Header_or_Line_Bid_Response_DataType[]
     */
    public $RFQ_Line_Bid_Response_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for RFQ_Response_Line_DataType
     * @uses RFQ_Response_Line_DataType::setRFQ_Response_Line_Reference()
     * @uses RFQ_Response_Line_DataType::setRFQ_Line_Reference()
     * @uses RFQ_Response_Line_DataType::setLine_Type_Reference()
     * @uses RFQ_Response_Line_DataType::setRFQ_Line_Number()
     * @uses RFQ_Response_Line_DataType::setItem_Descriptor_Reference()
     * @uses RFQ_Response_Line_DataType::setLine_Item_Description()
     * @uses RFQ_Response_Line_DataType::setResponse_Line_Description()
     * @uses RFQ_Response_Line_DataType::setSpend_Category_Reference()
     * @uses RFQ_Response_Line_DataType::setNo_Bid()
     * @uses RFQ_Response_Line_DataType::setQuantity()
     * @uses RFQ_Response_Line_DataType::setUnit_of_Measure_Reference()
     * @uses RFQ_Response_Line_DataType::setTarget_Price()
     * @uses RFQ_Response_Line_DataType::setRequested_Delivery_Date()
     * @uses RFQ_Response_Line_DataType::setStart_Date()
     * @uses RFQ_Response_Line_DataType::setEnd_Date()
     * @uses RFQ_Response_Line_DataType::setRFQ_Line_Memo()
     * @uses RFQ_Response_Line_DataType::setResponse_Price()
     * @uses RFQ_Response_Line_DataType::setResponse_Quantity()
     * @uses RFQ_Response_Line_DataType::setResponse_Lead_Time()
     * @uses RFQ_Response_Line_DataType::setResponse_Memo()
     * @uses RFQ_Response_Line_DataType::setRFQ_Line_Bid_Response_Data()
     * @uses RFQ_Response_Line_DataType::setAttachment_Data()
     * @param \StructType\Request_for_Quote_Response_LineObjectType $rFQ_Response_Line_Reference
     * @param \StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference
     * @param \StructType\Request_for_Quote_Line_TypeObjectType $line_Type_Reference
     * @param float $rFQ_Line_Number
     * @param \StructType\Item_DescriptorObjectType $item_Descriptor_Reference
     * @param string $line_Item_Description
     * @param string $response_Line_Description
     * @param \StructType\Accounting_CategoryObjectType $spend_Category_Reference
     * @param bool $no_Bid
     * @param float $quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $target_Price
     * @param string $requested_Delivery_Date
     * @param string $start_Date
     * @param string $end_Date
     * @param string $rFQ_Line_Memo
     * @param float $response_Price
     * @param float $response_Quantity
     * @param float $response_Lead_Time
     * @param string $response_Memo
     * @param \StructType\RFQ_Header_or_Line_Bid_Response_DataType[] $rFQ_Line_Bid_Response_Data
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     */
    public function __construct(\StructType\Request_for_Quote_Response_LineObjectType $rFQ_Response_Line_Reference = null, \StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference = null, \StructType\Request_for_Quote_Line_TypeObjectType $line_Type_Reference = null, $rFQ_Line_Number = null, \StructType\Item_DescriptorObjectType $item_Descriptor_Reference = null, $line_Item_Description = null, $response_Line_Description = null, \StructType\Accounting_CategoryObjectType $spend_Category_Reference = null, $no_Bid = null, $quantity = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $target_Price = null, $requested_Delivery_Date = null, $start_Date = null, $end_Date = null, $rFQ_Line_Memo = null, $response_Price = null, $response_Quantity = null, $response_Lead_Time = null, $response_Memo = null, array $rFQ_Line_Bid_Response_Data = array(), array $attachment_Data = array())
    {
        $this
            ->setRFQ_Response_Line_Reference($rFQ_Response_Line_Reference)
            ->setRFQ_Line_Reference($rFQ_Line_Reference)
            ->setLine_Type_Reference($line_Type_Reference)
            ->setRFQ_Line_Number($rFQ_Line_Number)
            ->setItem_Descriptor_Reference($item_Descriptor_Reference)
            ->setLine_Item_Description($line_Item_Description)
            ->setResponse_Line_Description($response_Line_Description)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setNo_Bid($no_Bid)
            ->setQuantity($quantity)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setTarget_Price($target_Price)
            ->setRequested_Delivery_Date($requested_Delivery_Date)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setRFQ_Line_Memo($rFQ_Line_Memo)
            ->setResponse_Price($response_Price)
            ->setResponse_Quantity($response_Quantity)
            ->setResponse_Lead_Time($response_Lead_Time)
            ->setResponse_Memo($response_Memo)
            ->setRFQ_Line_Bid_Response_Data($rFQ_Line_Bid_Response_Data)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get RFQ_Response_Line_Reference value
     * @return \StructType\Request_for_Quote_Response_LineObjectType|null
     */
    public function getRFQ_Response_Line_Reference()
    {
        return $this->RFQ_Response_Line_Reference;
    }
    /**
     * Set RFQ_Response_Line_Reference value
     * @param \StructType\Request_for_Quote_Response_LineObjectType $rFQ_Response_Line_Reference
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setRFQ_Response_Line_Reference(\StructType\Request_for_Quote_Response_LineObjectType $rFQ_Response_Line_Reference = null)
    {
        $this->RFQ_Response_Line_Reference = $rFQ_Response_Line_Reference;
        return $this;
    }
    /**
     * Get RFQ_Line_Reference value
     * @return \StructType\Request_for_Quote_LineObjectType|null
     */
    public function getRFQ_Line_Reference()
    {
        return $this->RFQ_Line_Reference;
    }
    /**
     * Set RFQ_Line_Reference value
     * @param \StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setRFQ_Line_Reference(\StructType\Request_for_Quote_LineObjectType $rFQ_Line_Reference = null)
    {
        $this->RFQ_Line_Reference = $rFQ_Line_Reference;
        return $this;
    }
    /**
     * Get Line_Type_Reference value
     * @return \StructType\Request_for_Quote_Line_TypeObjectType|null
     */
    public function getLine_Type_Reference()
    {
        return $this->Line_Type_Reference;
    }
    /**
     * Set Line_Type_Reference value
     * @param \StructType\Request_for_Quote_Line_TypeObjectType $line_Type_Reference
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setLine_Type_Reference(\StructType\Request_for_Quote_Line_TypeObjectType $line_Type_Reference = null)
    {
        $this->Line_Type_Reference = $line_Type_Reference;
        return $this;
    }
    /**
     * Get RFQ_Line_Number value
     * @return float|null
     */
    public function getRFQ_Line_Number()
    {
        return $this->RFQ_Line_Number;
    }
    /**
     * Set RFQ_Line_Number value
     * @param float $rFQ_Line_Number
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setRFQ_Line_Number($rFQ_Line_Number = null)
    {
        // validation for constraint: float
        if (!is_null($rFQ_Line_Number) && !(is_float($rFQ_Line_Number) || is_numeric($rFQ_Line_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rFQ_Line_Number, true), gettype($rFQ_Line_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($rFQ_Line_Number) && mb_strlen(mb_substr($rFQ_Line_Number, false !== mb_strpos($rFQ_Line_Number, '.') ? mb_strpos($rFQ_Line_Number, '.') + 1 : mb_strlen($rFQ_Line_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($rFQ_Line_Number, true), mb_strlen(mb_substr($rFQ_Line_Number, mb_strpos($rFQ_Line_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($rFQ_Line_Number) && $rFQ_Line_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($rFQ_Line_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($rFQ_Line_Number) && mb_strlen(preg_replace('/(\D)/', '', $rFQ_Line_Number)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($rFQ_Line_Number, true), mb_strlen(preg_replace('/(\D)/', '', $rFQ_Line_Number))), __LINE__);
        }
        $this->RFQ_Line_Number = $rFQ_Line_Number;
        return $this;
    }
    /**
     * Get Item_Descriptor_Reference value
     * @return \StructType\Item_DescriptorObjectType|null
     */
    public function getItem_Descriptor_Reference()
    {
        return $this->Item_Descriptor_Reference;
    }
    /**
     * Set Item_Descriptor_Reference value
     * @param \StructType\Item_DescriptorObjectType $item_Descriptor_Reference
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setItem_Descriptor_Reference(\StructType\Item_DescriptorObjectType $item_Descriptor_Reference = null)
    {
        $this->Item_Descriptor_Reference = $item_Descriptor_Reference;
        return $this;
    }
    /**
     * Get Line_Item_Description value
     * @return string|null
     */
    public function getLine_Item_Description()
    {
        return $this->Line_Item_Description;
    }
    /**
     * Set Line_Item_Description value
     * @param string $line_Item_Description
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setLine_Item_Description($line_Item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($line_Item_Description) && !is_string($line_Item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($line_Item_Description, true), gettype($line_Item_Description)), __LINE__);
        }
        $this->Line_Item_Description = $line_Item_Description;
        return $this;
    }
    /**
     * Get Response_Line_Description value
     * @return string|null
     */
    public function getResponse_Line_Description()
    {
        return $this->Response_Line_Description;
    }
    /**
     * Set Response_Line_Description value
     * @param string $response_Line_Description
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setResponse_Line_Description($response_Line_Description = null)
    {
        // validation for constraint: string
        if (!is_null($response_Line_Description) && !is_string($response_Line_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response_Line_Description, true), gettype($response_Line_Description)), __LINE__);
        }
        $this->Response_Line_Description = $response_Line_Description;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Accounting_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Accounting_CategoryObjectType $spend_Category_Reference
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setSpend_Category_Reference(\StructType\Accounting_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get No_Bid value
     * @return bool|null
     */
    public function getNo_Bid()
    {
        return $this->No_Bid;
    }
    /**
     * Set No_Bid value
     * @param bool $no_Bid
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setNo_Bid($no_Bid = null)
    {
        // validation for constraint: boolean
        if (!is_null($no_Bid) && !is_bool($no_Bid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($no_Bid, true), gettype($no_Bid)), __LINE__);
        }
        $this->No_Bid = $no_Bid;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Target_Price value
     * @return float|null
     */
    public function getTarget_Price()
    {
        return $this->Target_Price;
    }
    /**
     * Set Target_Price value
     * @param float $target_Price
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setTarget_Price($target_Price = null)
    {
        // validation for constraint: float
        if (!is_null($target_Price) && !(is_float($target_Price) || is_numeric($target_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($target_Price, true), gettype($target_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($target_Price) && mb_strlen(mb_substr($target_Price, false !== mb_strpos($target_Price, '.') ? mb_strpos($target_Price, '.') + 1 : mb_strlen($target_Price))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($target_Price, true), mb_strlen(mb_substr($target_Price, mb_strpos($target_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($target_Price) && $target_Price < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($target_Price, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($target_Price) && mb_strlen(preg_replace('/(\D)/', '', $target_Price)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($target_Price, true), mb_strlen(preg_replace('/(\D)/', '', $target_Price))), __LINE__);
        }
        $this->Target_Price = $target_Price;
        return $this;
    }
    /**
     * Get Requested_Delivery_Date value
     * @return string|null
     */
    public function getRequested_Delivery_Date()
    {
        return $this->Requested_Delivery_Date;
    }
    /**
     * Set Requested_Delivery_Date value
     * @param string $requested_Delivery_Date
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setRequested_Delivery_Date($requested_Delivery_Date = null)
    {
        // validation for constraint: string
        if (!is_null($requested_Delivery_Date) && !is_string($requested_Delivery_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requested_Delivery_Date, true), gettype($requested_Delivery_Date)), __LINE__);
        }
        $this->Requested_Delivery_Date = $requested_Delivery_Date;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get RFQ_Line_Memo value
     * @return string|null
     */
    public function getRFQ_Line_Memo()
    {
        return $this->RFQ_Line_Memo;
    }
    /**
     * Set RFQ_Line_Memo value
     * @param string $rFQ_Line_Memo
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setRFQ_Line_Memo($rFQ_Line_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($rFQ_Line_Memo) && !is_string($rFQ_Line_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFQ_Line_Memo, true), gettype($rFQ_Line_Memo)), __LINE__);
        }
        $this->RFQ_Line_Memo = $rFQ_Line_Memo;
        return $this;
    }
    /**
     * Get Response_Price value
     * @return float|null
     */
    public function getResponse_Price()
    {
        return $this->Response_Price;
    }
    /**
     * Set Response_Price value
     * @param float $response_Price
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setResponse_Price($response_Price = null)
    {
        // validation for constraint: float
        if (!is_null($response_Price) && !(is_float($response_Price) || is_numeric($response_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($response_Price, true), gettype($response_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($response_Price) && mb_strlen(mb_substr($response_Price, false !== mb_strpos($response_Price, '.') ? mb_strpos($response_Price, '.') + 1 : mb_strlen($response_Price))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($response_Price, true), mb_strlen(mb_substr($response_Price, mb_strpos($response_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($response_Price) && $response_Price < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($response_Price, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($response_Price) && mb_strlen(preg_replace('/(\D)/', '', $response_Price)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($response_Price, true), mb_strlen(preg_replace('/(\D)/', '', $response_Price))), __LINE__);
        }
        $this->Response_Price = $response_Price;
        return $this;
    }
    /**
     * Get Response_Quantity value
     * @return float|null
     */
    public function getResponse_Quantity()
    {
        return $this->Response_Quantity;
    }
    /**
     * Set Response_Quantity value
     * @param float $response_Quantity
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setResponse_Quantity($response_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($response_Quantity) && !(is_float($response_Quantity) || is_numeric($response_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($response_Quantity, true), gettype($response_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($response_Quantity) && mb_strlen(mb_substr($response_Quantity, false !== mb_strpos($response_Quantity, '.') ? mb_strpos($response_Quantity, '.') + 1 : mb_strlen($response_Quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($response_Quantity, true), mb_strlen(mb_substr($response_Quantity, mb_strpos($response_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($response_Quantity) && $response_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($response_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($response_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $response_Quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($response_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $response_Quantity))), __LINE__);
        }
        $this->Response_Quantity = $response_Quantity;
        return $this;
    }
    /**
     * Get Response_Lead_Time value
     * @return float|null
     */
    public function getResponse_Lead_Time()
    {
        return $this->Response_Lead_Time;
    }
    /**
     * Set Response_Lead_Time value
     * @param float $response_Lead_Time
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setResponse_Lead_Time($response_Lead_Time = null)
    {
        // validation for constraint: float
        if (!is_null($response_Lead_Time) && !(is_float($response_Lead_Time) || is_numeric($response_Lead_Time))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($response_Lead_Time, true), gettype($response_Lead_Time)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($response_Lead_Time) && mb_strlen(mb_substr($response_Lead_Time, false !== mb_strpos($response_Lead_Time, '.') ? mb_strpos($response_Lead_Time, '.') + 1 : mb_strlen($response_Lead_Time))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($response_Lead_Time, true), mb_strlen(mb_substr($response_Lead_Time, mb_strpos($response_Lead_Time, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($response_Lead_Time) && $response_Lead_Time < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($response_Lead_Time, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($response_Lead_Time) && mb_strlen(preg_replace('/(\D)/', '', $response_Lead_Time)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($response_Lead_Time, true), mb_strlen(preg_replace('/(\D)/', '', $response_Lead_Time))), __LINE__);
        }
        $this->Response_Lead_Time = $response_Lead_Time;
        return $this;
    }
    /**
     * Get Response_Memo value
     * @return string|null
     */
    public function getResponse_Memo()
    {
        return $this->Response_Memo;
    }
    /**
     * Set Response_Memo value
     * @param string $response_Memo
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setResponse_Memo($response_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($response_Memo) && !is_string($response_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response_Memo, true), gettype($response_Memo)), __LINE__);
        }
        $this->Response_Memo = $response_Memo;
        return $this;
    }
    /**
     * Get RFQ_Line_Bid_Response_Data value
     * @return \StructType\RFQ_Header_or_Line_Bid_Response_DataType[]|null
     */
    public function getRFQ_Line_Bid_Response_Data()
    {
        return $this->RFQ_Line_Bid_Response_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRFQ_Line_Bid_Response_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRFQ_Line_Bid_Response_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRFQ_Line_Bid_Response_DataForArrayConstraintsFromSetRFQ_Line_Bid_Response_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFQ_Response_Line_DataTypeRFQ_Line_Bid_Response_DataItem) {
            // validation for constraint: itemType
            if (!$rFQ_Response_Line_DataTypeRFQ_Line_Bid_Response_DataItem instanceof \StructType\RFQ_Header_or_Line_Bid_Response_DataType) {
                $invalidValues[] = is_object($rFQ_Response_Line_DataTypeRFQ_Line_Bid_Response_DataItem) ? get_class($rFQ_Response_Line_DataTypeRFQ_Line_Bid_Response_DataItem) : sprintf('%s(%s)', gettype($rFQ_Response_Line_DataTypeRFQ_Line_Bid_Response_DataItem), var_export($rFQ_Response_Line_DataTypeRFQ_Line_Bid_Response_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RFQ_Line_Bid_Response_Data property can only contain items of type \StructType\RFQ_Header_or_Line_Bid_Response_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RFQ_Line_Bid_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Header_or_Line_Bid_Response_DataType[] $rFQ_Line_Bid_Response_Data
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setRFQ_Line_Bid_Response_Data(array $rFQ_Line_Bid_Response_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($rFQ_Line_Bid_Response_DataArrayErrorMessage = self::validateRFQ_Line_Bid_Response_DataForArrayConstraintsFromSetRFQ_Line_Bid_Response_Data($rFQ_Line_Bid_Response_Data))) {
            throw new \InvalidArgumentException($rFQ_Line_Bid_Response_DataArrayErrorMessage, __LINE__);
        }
        $this->RFQ_Line_Bid_Response_Data = $rFQ_Line_Bid_Response_Data;
        return $this;
    }
    /**
     * Add item to RFQ_Line_Bid_Response_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\RFQ_Header_or_Line_Bid_Response_DataType $item
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function addToRFQ_Line_Bid_Response_Data(\StructType\RFQ_Header_or_Line_Bid_Response_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RFQ_Header_or_Line_Bid_Response_DataType) {
            throw new \InvalidArgumentException(sprintf('The RFQ_Line_Bid_Response_Data property can only contain items of type \StructType\RFQ_Header_or_Line_Bid_Response_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RFQ_Line_Bid_Response_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rFQ_Response_Line_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$rFQ_Response_Line_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($rFQ_Response_Line_DataTypeAttachment_DataItem) ? get_class($rFQ_Response_Line_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($rFQ_Response_Line_DataTypeAttachment_DataItem), var_export($rFQ_Response_Line_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\RFQ_Response_Line_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
