<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Project_Task_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request element for putting a Project Task via a Web Service
 * @subpackage Structs
 */
class Put_Project_Task_RequestType extends AbstractStructBase
{
    /**
     * The Project_Task_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Project Task for update only purposes
     * - minOccurs: 0
     * @var \StructType\Project_TaskObjectType
     */
    public $Project_Task_Reference;
    /**
     * The Project_Task_Data
     * @var \StructType\Project_Task_DataType
     */
    public $Project_Task_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Project_Task_RequestType
     * @uses Put_Project_Task_RequestType::setProject_Task_Reference()
     * @uses Put_Project_Task_RequestType::setProject_Task_Data()
     * @uses Put_Project_Task_RequestType::setAdd_Only()
     * @uses Put_Project_Task_RequestType::setVersion()
     * @param \StructType\Project_TaskObjectType $project_Task_Reference
     * @param \StructType\Project_Task_DataType $project_Task_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Project_TaskObjectType $project_Task_Reference = null, \StructType\Project_Task_DataType $project_Task_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setProject_Task_Reference($project_Task_Reference)
            ->setProject_Task_Data($project_Task_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Project_Task_Reference value
     * @return \StructType\Project_TaskObjectType|null
     */
    public function getProject_Task_Reference()
    {
        return $this->Project_Task_Reference;
    }
    /**
     * Set Project_Task_Reference value
     * @param \StructType\Project_TaskObjectType $project_Task_Reference
     * @return \StructType\Put_Project_Task_RequestType
     */
    public function setProject_Task_Reference(\StructType\Project_TaskObjectType $project_Task_Reference = null)
    {
        $this->Project_Task_Reference = $project_Task_Reference;
        return $this;
    }
    /**
     * Get Project_Task_Data value
     * @return \StructType\Project_Task_DataType|null
     */
    public function getProject_Task_Data()
    {
        return $this->Project_Task_Data;
    }
    /**
     * Set Project_Task_Data value
     * @param \StructType\Project_Task_DataType $project_Task_Data
     * @return \StructType\Put_Project_Task_RequestType
     */
    public function setProject_Task_Data(\StructType\Project_Task_DataType $project_Task_Data = null)
    {
        $this->Project_Task_Data = $project_Task_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Project_Task_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Project_Task_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
