<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Standard_Cost_Rate_SheetType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element that includes Project Role Standard Cost Rate Sheet Instance and Data
 * @subpackage Structs
 */
class Project_Standard_Cost_Rate_SheetType extends AbstractStructBase
{
    /**
     * The Project_Standard_Cost_Rate_Sheet_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Role Standard Cost Rate Sheet Reference
     * - minOccurs: 0
     * @var \StructType\Project_Standard_Cost_Rate_SheetObjectType
     */
    public $Project_Standard_Cost_Rate_Sheet_Reference;
    /**
     * The Project_Standard_Cost_Rate_Sheet_Data
     * Meta information extracted from the WSDL
     * - documentation: Project Standard Cost Rate Sheet Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_Standard_Cost_Rate_Sheet_DataType[]
     */
    public $Project_Standard_Cost_Rate_Sheet_Data;
    /**
     * Constructor method for Project_Standard_Cost_Rate_SheetType
     * @uses Project_Standard_Cost_Rate_SheetType::setProject_Standard_Cost_Rate_Sheet_Reference()
     * @uses Project_Standard_Cost_Rate_SheetType::setProject_Standard_Cost_Rate_Sheet_Data()
     * @param \StructType\Project_Standard_Cost_Rate_SheetObjectType $project_Standard_Cost_Rate_Sheet_Reference
     * @param \StructType\Project_Standard_Cost_Rate_Sheet_DataType[] $project_Standard_Cost_Rate_Sheet_Data
     */
    public function __construct(\StructType\Project_Standard_Cost_Rate_SheetObjectType $project_Standard_Cost_Rate_Sheet_Reference = null, array $project_Standard_Cost_Rate_Sheet_Data = array())
    {
        $this
            ->setProject_Standard_Cost_Rate_Sheet_Reference($project_Standard_Cost_Rate_Sheet_Reference)
            ->setProject_Standard_Cost_Rate_Sheet_Data($project_Standard_Cost_Rate_Sheet_Data);
    }
    /**
     * Get Project_Standard_Cost_Rate_Sheet_Reference value
     * @return \StructType\Project_Standard_Cost_Rate_SheetObjectType|null
     */
    public function getProject_Standard_Cost_Rate_Sheet_Reference()
    {
        return $this->Project_Standard_Cost_Rate_Sheet_Reference;
    }
    /**
     * Set Project_Standard_Cost_Rate_Sheet_Reference value
     * @param \StructType\Project_Standard_Cost_Rate_SheetObjectType $project_Standard_Cost_Rate_Sheet_Reference
     * @return \StructType\Project_Standard_Cost_Rate_SheetType
     */
    public function setProject_Standard_Cost_Rate_Sheet_Reference(\StructType\Project_Standard_Cost_Rate_SheetObjectType $project_Standard_Cost_Rate_Sheet_Reference = null)
    {
        $this->Project_Standard_Cost_Rate_Sheet_Reference = $project_Standard_Cost_Rate_Sheet_Reference;
        return $this;
    }
    /**
     * Get Project_Standard_Cost_Rate_Sheet_Data value
     * @return \StructType\Project_Standard_Cost_Rate_Sheet_DataType[]|null
     */
    public function getProject_Standard_Cost_Rate_Sheet_Data()
    {
        return $this->Project_Standard_Cost_Rate_Sheet_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Standard_Cost_Rate_Sheet_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Standard_Cost_Rate_Sheet_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_Standard_Cost_Rate_Sheet_DataForArrayConstraintsFromSetProject_Standard_Cost_Rate_Sheet_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Standard_Cost_Rate_SheetTypeProject_Standard_Cost_Rate_Sheet_DataItem) {
            // validation for constraint: itemType
            if (!$project_Standard_Cost_Rate_SheetTypeProject_Standard_Cost_Rate_Sheet_DataItem instanceof \StructType\Project_Standard_Cost_Rate_Sheet_DataType) {
                $invalidValues[] = is_object($project_Standard_Cost_Rate_SheetTypeProject_Standard_Cost_Rate_Sheet_DataItem) ? get_class($project_Standard_Cost_Rate_SheetTypeProject_Standard_Cost_Rate_Sheet_DataItem) : sprintf('%s(%s)', gettype($project_Standard_Cost_Rate_SheetTypeProject_Standard_Cost_Rate_Sheet_DataItem), var_export($project_Standard_Cost_Rate_SheetTypeProject_Standard_Cost_Rate_Sheet_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Standard_Cost_Rate_Sheet_Data property can only contain items of type \StructType\Project_Standard_Cost_Rate_Sheet_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Standard_Cost_Rate_Sheet_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Standard_Cost_Rate_Sheet_DataType[] $project_Standard_Cost_Rate_Sheet_Data
     * @return \StructType\Project_Standard_Cost_Rate_SheetType
     */
    public function setProject_Standard_Cost_Rate_Sheet_Data(array $project_Standard_Cost_Rate_Sheet_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($project_Standard_Cost_Rate_Sheet_DataArrayErrorMessage = self::validateProject_Standard_Cost_Rate_Sheet_DataForArrayConstraintsFromSetProject_Standard_Cost_Rate_Sheet_Data($project_Standard_Cost_Rate_Sheet_Data))) {
            throw new \InvalidArgumentException($project_Standard_Cost_Rate_Sheet_DataArrayErrorMessage, __LINE__);
        }
        $this->Project_Standard_Cost_Rate_Sheet_Data = $project_Standard_Cost_Rate_Sheet_Data;
        return $this;
    }
    /**
     * Add item to Project_Standard_Cost_Rate_Sheet_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_Standard_Cost_Rate_Sheet_DataType $item
     * @return \StructType\Project_Standard_Cost_Rate_SheetType
     */
    public function addToProject_Standard_Cost_Rate_Sheet_Data(\StructType\Project_Standard_Cost_Rate_Sheet_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_Standard_Cost_Rate_Sheet_DataType) {
            throw new \InvalidArgumentException(sprintf('The Project_Standard_Cost_Rate_Sheet_Data property can only contain items of type \StructType\Project_Standard_Cost_Rate_Sheet_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Standard_Cost_Rate_Sheet_Data[] = $item;
        return $this;
    }
}
