<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Order_From_Supplier_Connection_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Element contains individual Order-From Supplier Connection attributes
 * @subpackage Structs
 */
class Order_From_Supplier_Connection_Line_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Connection_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Connection Reference
     * - minOccurs: 0
     * @var \StructType\Order_From_Supplier_ConnectionObjectType
     */
    public $Supplier_Connection_Reference;
    /**
     * The Supplier_Connection_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Connection ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Connection_ID;
    /**
     * The Supplier_Connection_Name
     * Meta information extracted from the WSDL
     * - documentation: Supplier Connection Name
     * - maxOccurs: 1
     * @var string
     */
    public $Supplier_Connection_Name;
    /**
     * The Default_For_PO_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default for Order Type
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Order_TypeObjectType[]
     */
    public $Default_For_PO_Type_Reference;
    /**
     * The Shipping_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipping Method Reference
     * - minOccurs: 0
     * @var \StructType\Shipping_MethodObjectType
     */
    public $Shipping_Method_Reference;
    /**
     * The Shipping_Terms_Reference
     * Meta information extracted from the WSDL
     * - documentation: Shipping Terms Reference
     * - minOccurs: 0
     * @var \StructType\Shipping_TermsObjectType
     */
    public $Shipping_Terms_Reference;
    /**
     * The Purchase_Order_Issue_Option_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Order Issue Option
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Issue_OptionObjectType
     */
    public $Purchase_Order_Issue_Option_Reference;
    /**
     * The Default_PO_Issue_Email_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Order_From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType[]
     */
    public $Default_PO_Issue_Email_Data;
    /**
     * The Remit_To_Supplier_Connection_Reference
     * Meta information extracted from the WSDL
     * - documentation: Default Remit-To Connection
     * - minOccurs: 0
     * @var \StructType\Remit_To_Supplier_ConnectionObjectType
     */
    public $Remit_To_Supplier_Connection_Reference;
    /**
     * The Order_From_Address_Reference_Reference
     * Meta information extracted from the WSDL
     * - documentation: Order-From Address
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Order_From_Address_Reference_Reference;
    /**
     * The Alternate_Name_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Order_From_Connection_Alternate_Name_DataType[]
     */
    public $Alternate_Name_Data;
    /**
     * The Is_Default
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate if the Supplier Connection is the Default one
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Is_Default;
    /**
     * The Is_Inactive
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate if the Supplier Connection is inactive
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Is_Inactive;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Order from Connection Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * Constructor method for Order_From_Supplier_Connection_Line_DataType
     * @uses Order_From_Supplier_Connection_Line_DataType::setSupplier_Connection_Reference()
     * @uses Order_From_Supplier_Connection_Line_DataType::setSupplier_Connection_ID()
     * @uses Order_From_Supplier_Connection_Line_DataType::setSupplier_Connection_Name()
     * @uses Order_From_Supplier_Connection_Line_DataType::setDefault_For_PO_Type_Reference()
     * @uses Order_From_Supplier_Connection_Line_DataType::setShipping_Method_Reference()
     * @uses Order_From_Supplier_Connection_Line_DataType::setShipping_Terms_Reference()
     * @uses Order_From_Supplier_Connection_Line_DataType::setPurchase_Order_Issue_Option_Reference()
     * @uses Order_From_Supplier_Connection_Line_DataType::setDefault_PO_Issue_Email_Data()
     * @uses Order_From_Supplier_Connection_Line_DataType::setRemit_To_Supplier_Connection_Reference()
     * @uses Order_From_Supplier_Connection_Line_DataType::setOrder_From_Address_Reference_Reference()
     * @uses Order_From_Supplier_Connection_Line_DataType::setAlternate_Name_Data()
     * @uses Order_From_Supplier_Connection_Line_DataType::setIs_Default()
     * @uses Order_From_Supplier_Connection_Line_DataType::setIs_Inactive()
     * @uses Order_From_Supplier_Connection_Line_DataType::setMemo()
     * @param \StructType\Order_From_Supplier_ConnectionObjectType $supplier_Connection_Reference
     * @param string $supplier_Connection_ID
     * @param string $supplier_Connection_Name
     * @param \StructType\Order_TypeObjectType[] $default_For_PO_Type_Reference
     * @param \StructType\Shipping_MethodObjectType $shipping_Method_Reference
     * @param \StructType\Shipping_TermsObjectType $shipping_Terms_Reference
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference
     * @param \StructType\Order_From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType[] $default_PO_Issue_Email_Data
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $remit_To_Supplier_Connection_Reference
     * @param \StructType\Address_ReferenceObjectType $order_From_Address_Reference_Reference
     * @param \StructType\Order_From_Connection_Alternate_Name_DataType[] $alternate_Name_Data
     * @param bool $is_Default
     * @param bool $is_Inactive
     * @param string $memo
     */
    public function __construct(\StructType\Order_From_Supplier_ConnectionObjectType $supplier_Connection_Reference = null, $supplier_Connection_ID = null, $supplier_Connection_Name = null, array $default_For_PO_Type_Reference = array(), \StructType\Shipping_MethodObjectType $shipping_Method_Reference = null, \StructType\Shipping_TermsObjectType $shipping_Terms_Reference = null, \StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference = null, array $default_PO_Issue_Email_Data = array(), \StructType\Remit_To_Supplier_ConnectionObjectType $remit_To_Supplier_Connection_Reference = null, \StructType\Address_ReferenceObjectType $order_From_Address_Reference_Reference = null, array $alternate_Name_Data = array(), $is_Default = null, $is_Inactive = null, $memo = null)
    {
        $this
            ->setSupplier_Connection_Reference($supplier_Connection_Reference)
            ->setSupplier_Connection_ID($supplier_Connection_ID)
            ->setSupplier_Connection_Name($supplier_Connection_Name)
            ->setDefault_For_PO_Type_Reference($default_For_PO_Type_Reference)
            ->setShipping_Method_Reference($shipping_Method_Reference)
            ->setShipping_Terms_Reference($shipping_Terms_Reference)
            ->setPurchase_Order_Issue_Option_Reference($purchase_Order_Issue_Option_Reference)
            ->setDefault_PO_Issue_Email_Data($default_PO_Issue_Email_Data)
            ->setRemit_To_Supplier_Connection_Reference($remit_To_Supplier_Connection_Reference)
            ->setOrder_From_Address_Reference_Reference($order_From_Address_Reference_Reference)
            ->setAlternate_Name_Data($alternate_Name_Data)
            ->setIs_Default($is_Default)
            ->setIs_Inactive($is_Inactive)
            ->setMemo($memo);
    }
    /**
     * Get Supplier_Connection_Reference value
     * @return \StructType\Order_From_Supplier_ConnectionObjectType|null
     */
    public function getSupplier_Connection_Reference()
    {
        return $this->Supplier_Connection_Reference;
    }
    /**
     * Set Supplier_Connection_Reference value
     * @param \StructType\Order_From_Supplier_ConnectionObjectType $supplier_Connection_Reference
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function setSupplier_Connection_Reference(\StructType\Order_From_Supplier_ConnectionObjectType $supplier_Connection_Reference = null)
    {
        $this->Supplier_Connection_Reference = $supplier_Connection_Reference;
        return $this;
    }
    /**
     * Get Supplier_Connection_ID value
     * @return string|null
     */
    public function getSupplier_Connection_ID()
    {
        return $this->Supplier_Connection_ID;
    }
    /**
     * Set Supplier_Connection_ID value
     * @param string $supplier_Connection_ID
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function setSupplier_Connection_ID($supplier_Connection_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Connection_ID) && !is_string($supplier_Connection_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Connection_ID, true), gettype($supplier_Connection_ID)), __LINE__);
        }
        $this->Supplier_Connection_ID = $supplier_Connection_ID;
        return $this;
    }
    /**
     * Get Supplier_Connection_Name value
     * @return string|null
     */
    public function getSupplier_Connection_Name()
    {
        return $this->Supplier_Connection_Name;
    }
    /**
     * Set Supplier_Connection_Name value
     * @param string $supplier_Connection_Name
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function setSupplier_Connection_Name($supplier_Connection_Name = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Connection_Name) && !is_string($supplier_Connection_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Connection_Name, true), gettype($supplier_Connection_Name)), __LINE__);
        }
        $this->Supplier_Connection_Name = $supplier_Connection_Name;
        return $this;
    }
    /**
     * Get Default_For_PO_Type_Reference value
     * @return \StructType\Order_TypeObjectType[]|null
     */
    public function getDefault_For_PO_Type_Reference()
    {
        return $this->Default_For_PO_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setDefault_For_PO_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDefault_For_PO_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDefault_For_PO_Type_ReferenceForArrayConstraintsFromSetDefault_For_PO_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $order_From_Supplier_Connection_Line_DataTypeDefault_For_PO_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$order_From_Supplier_Connection_Line_DataTypeDefault_For_PO_Type_ReferenceItem instanceof \StructType\Order_TypeObjectType) {
                $invalidValues[] = is_object($order_From_Supplier_Connection_Line_DataTypeDefault_For_PO_Type_ReferenceItem) ? get_class($order_From_Supplier_Connection_Line_DataTypeDefault_For_PO_Type_ReferenceItem) : sprintf('%s(%s)', gettype($order_From_Supplier_Connection_Line_DataTypeDefault_For_PO_Type_ReferenceItem), var_export($order_From_Supplier_Connection_Line_DataTypeDefault_For_PO_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Default_For_PO_Type_Reference property can only contain items of type \StructType\Order_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Default_For_PO_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Order_TypeObjectType[] $default_For_PO_Type_Reference
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function setDefault_For_PO_Type_Reference(array $default_For_PO_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($default_For_PO_Type_ReferenceArrayErrorMessage = self::validateDefault_For_PO_Type_ReferenceForArrayConstraintsFromSetDefault_For_PO_Type_Reference($default_For_PO_Type_Reference))) {
            throw new \InvalidArgumentException($default_For_PO_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Default_For_PO_Type_Reference = $default_For_PO_Type_Reference;
        return $this;
    }
    /**
     * Add item to Default_For_PO_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Order_TypeObjectType $item
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function addToDefault_For_PO_Type_Reference(\StructType\Order_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Order_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Default_For_PO_Type_Reference property can only contain items of type \StructType\Order_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Default_For_PO_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Shipping_Method_Reference value
     * @return \StructType\Shipping_MethodObjectType|null
     */
    public function getShipping_Method_Reference()
    {
        return $this->Shipping_Method_Reference;
    }
    /**
     * Set Shipping_Method_Reference value
     * @param \StructType\Shipping_MethodObjectType $shipping_Method_Reference
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function setShipping_Method_Reference(\StructType\Shipping_MethodObjectType $shipping_Method_Reference = null)
    {
        $this->Shipping_Method_Reference = $shipping_Method_Reference;
        return $this;
    }
    /**
     * Get Shipping_Terms_Reference value
     * @return \StructType\Shipping_TermsObjectType|null
     */
    public function getShipping_Terms_Reference()
    {
        return $this->Shipping_Terms_Reference;
    }
    /**
     * Set Shipping_Terms_Reference value
     * @param \StructType\Shipping_TermsObjectType $shipping_Terms_Reference
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function setShipping_Terms_Reference(\StructType\Shipping_TermsObjectType $shipping_Terms_Reference = null)
    {
        $this->Shipping_Terms_Reference = $shipping_Terms_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Issue_Option_Reference value
     * @return \StructType\Purchase_Order_Issue_OptionObjectType|null
     */
    public function getPurchase_Order_Issue_Option_Reference()
    {
        return $this->Purchase_Order_Issue_Option_Reference;
    }
    /**
     * Set Purchase_Order_Issue_Option_Reference value
     * @param \StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function setPurchase_Order_Issue_Option_Reference(\StructType\Purchase_Order_Issue_OptionObjectType $purchase_Order_Issue_Option_Reference = null)
    {
        $this->Purchase_Order_Issue_Option_Reference = $purchase_Order_Issue_Option_Reference;
        return $this;
    }
    /**
     * Get Default_PO_Issue_Email_Data value
     * @return \StructType\Order_From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType[]|null
     */
    public function getDefault_PO_Issue_Email_Data()
    {
        return $this->Default_PO_Issue_Email_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setDefault_PO_Issue_Email_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDefault_PO_Issue_Email_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDefault_PO_Issue_Email_DataForArrayConstraintsFromSetDefault_PO_Issue_Email_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $order_From_Supplier_Connection_Line_DataTypeDefault_PO_Issue_Email_DataItem) {
            // validation for constraint: itemType
            if (!$order_From_Supplier_Connection_Line_DataTypeDefault_PO_Issue_Email_DataItem instanceof \StructType\Order_From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType) {
                $invalidValues[] = is_object($order_From_Supplier_Connection_Line_DataTypeDefault_PO_Issue_Email_DataItem) ? get_class($order_From_Supplier_Connection_Line_DataTypeDefault_PO_Issue_Email_DataItem) : sprintf('%s(%s)', gettype($order_From_Supplier_Connection_Line_DataTypeDefault_PO_Issue_Email_DataItem), var_export($order_From_Supplier_Connection_Line_DataTypeDefault_PO_Issue_Email_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Default_PO_Issue_Email_Data property can only contain items of type \StructType\Order_From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Default_PO_Issue_Email_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Order_From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType[] $default_PO_Issue_Email_Data
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function setDefault_PO_Issue_Email_Data(array $default_PO_Issue_Email_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($default_PO_Issue_Email_DataArrayErrorMessage = self::validateDefault_PO_Issue_Email_DataForArrayConstraintsFromSetDefault_PO_Issue_Email_Data($default_PO_Issue_Email_Data))) {
            throw new \InvalidArgumentException($default_PO_Issue_Email_DataArrayErrorMessage, __LINE__);
        }
        $this->Default_PO_Issue_Email_Data = $default_PO_Issue_Email_Data;
        return $this;
    }
    /**
     * Add item to Default_PO_Issue_Email_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Order_From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType $item
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function addToDefault_PO_Issue_Email_Data(\StructType\Order_From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Order_From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType) {
            throw new \InvalidArgumentException(sprintf('The Default_PO_Issue_Email_Data property can only contain items of type \StructType\Order_From_Supplier_Connection_Default_PO_Issue_Email_ReferenceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Default_PO_Issue_Email_Data[] = $item;
        return $this;
    }
    /**
     * Get Remit_To_Supplier_Connection_Reference value
     * @return \StructType\Remit_To_Supplier_ConnectionObjectType|null
     */
    public function getRemit_To_Supplier_Connection_Reference()
    {
        return $this->Remit_To_Supplier_Connection_Reference;
    }
    /**
     * Set Remit_To_Supplier_Connection_Reference value
     * @param \StructType\Remit_To_Supplier_ConnectionObjectType $remit_To_Supplier_Connection_Reference
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function setRemit_To_Supplier_Connection_Reference(\StructType\Remit_To_Supplier_ConnectionObjectType $remit_To_Supplier_Connection_Reference = null)
    {
        $this->Remit_To_Supplier_Connection_Reference = $remit_To_Supplier_Connection_Reference;
        return $this;
    }
    /**
     * Get Order_From_Address_Reference_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getOrder_From_Address_Reference_Reference()
    {
        return $this->Order_From_Address_Reference_Reference;
    }
    /**
     * Set Order_From_Address_Reference_Reference value
     * @param \StructType\Address_ReferenceObjectType $order_From_Address_Reference_Reference
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function setOrder_From_Address_Reference_Reference(\StructType\Address_ReferenceObjectType $order_From_Address_Reference_Reference = null)
    {
        $this->Order_From_Address_Reference_Reference = $order_From_Address_Reference_Reference;
        return $this;
    }
    /**
     * Get Alternate_Name_Data value
     * @return \StructType\Order_From_Connection_Alternate_Name_DataType[]|null
     */
    public function getAlternate_Name_Data()
    {
        return $this->Alternate_Name_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Name_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Name_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Name_DataForArrayConstraintsFromSetAlternate_Name_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $order_From_Supplier_Connection_Line_DataTypeAlternate_Name_DataItem) {
            // validation for constraint: itemType
            if (!$order_From_Supplier_Connection_Line_DataTypeAlternate_Name_DataItem instanceof \StructType\Order_From_Connection_Alternate_Name_DataType) {
                $invalidValues[] = is_object($order_From_Supplier_Connection_Line_DataTypeAlternate_Name_DataItem) ? get_class($order_From_Supplier_Connection_Line_DataTypeAlternate_Name_DataItem) : sprintf('%s(%s)', gettype($order_From_Supplier_Connection_Line_DataTypeAlternate_Name_DataItem), var_export($order_From_Supplier_Connection_Line_DataTypeAlternate_Name_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Name_Data property can only contain items of type \StructType\Order_From_Connection_Alternate_Name_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Name_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Order_From_Connection_Alternate_Name_DataType[] $alternate_Name_Data
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function setAlternate_Name_Data(array $alternate_Name_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Name_DataArrayErrorMessage = self::validateAlternate_Name_DataForArrayConstraintsFromSetAlternate_Name_Data($alternate_Name_Data))) {
            throw new \InvalidArgumentException($alternate_Name_DataArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Name_Data = $alternate_Name_Data;
        return $this;
    }
    /**
     * Add item to Alternate_Name_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Order_From_Connection_Alternate_Name_DataType $item
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function addToAlternate_Name_Data(\StructType\Order_From_Connection_Alternate_Name_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Order_From_Connection_Alternate_Name_DataType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Name_Data property can only contain items of type \StructType\Order_From_Connection_Alternate_Name_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Name_Data[] = $item;
        return $this;
    }
    /**
     * Get Is_Default value
     * @return bool|null
     */
    public function getIs_Default()
    {
        return $this->Is_Default;
    }
    /**
     * Set Is_Default value
     * @param bool $is_Default
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function setIs_Default($is_Default = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_Default) && !is_bool($is_Default)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_Default, true), gettype($is_Default)), __LINE__);
        }
        $this->Is_Default = $is_Default;
        return $this;
    }
    /**
     * Get Is_Inactive value
     * @return bool|null
     */
    public function getIs_Inactive()
    {
        return $this->Is_Inactive;
    }
    /**
     * Set Is_Inactive value
     * @param bool $is_Inactive
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function setIs_Inactive($is_Inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($is_Inactive) && !is_bool($is_Inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($is_Inactive, true), gettype($is_Inactive)), __LINE__);
        }
        $this->Is_Inactive = $is_Inactive;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Order_From_Supplier_Connection_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
}
