<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Commodity_Code_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains references to existing Commodity Codes to be retrieved. Please note that this is mutually exclusive with the Request Criteria element.
 * @subpackage Structs
 */
class Commodity_Code_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Commodity_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Commodity Code.
     * - maxOccurs: unbounded
     * @var \StructType\Commodity_CodeObjectType[]
     */
    public $Commodity_Code_Reference;
    /**
     * Constructor method for Commodity_Code_Request_ReferencesType
     * @uses Commodity_Code_Request_ReferencesType::setCommodity_Code_Reference()
     * @param \StructType\Commodity_CodeObjectType[] $commodity_Code_Reference
     */
    public function __construct(array $commodity_Code_Reference = array())
    {
        $this
            ->setCommodity_Code_Reference($commodity_Code_Reference);
    }
    /**
     * Get Commodity_Code_Reference value
     * @return \StructType\Commodity_CodeObjectType[]|null
     */
    public function getCommodity_Code_Reference()
    {
        return $this->Commodity_Code_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCommodity_Code_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommodity_Code_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommodity_Code_ReferenceForArrayConstraintsFromSetCommodity_Code_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commodity_Code_Request_ReferencesTypeCommodity_Code_ReferenceItem) {
            // validation for constraint: itemType
            if (!$commodity_Code_Request_ReferencesTypeCommodity_Code_ReferenceItem instanceof \StructType\Commodity_CodeObjectType) {
                $invalidValues[] = is_object($commodity_Code_Request_ReferencesTypeCommodity_Code_ReferenceItem) ? get_class($commodity_Code_Request_ReferencesTypeCommodity_Code_ReferenceItem) : sprintf('%s(%s)', gettype($commodity_Code_Request_ReferencesTypeCommodity_Code_ReferenceItem), var_export($commodity_Code_Request_ReferencesTypeCommodity_Code_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commodity_Code_Reference property can only contain items of type \StructType\Commodity_CodeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commodity_Code_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Commodity_CodeObjectType[] $commodity_Code_Reference
     * @return \StructType\Commodity_Code_Request_ReferencesType
     */
    public function setCommodity_Code_Reference(array $commodity_Code_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($commodity_Code_ReferenceArrayErrorMessage = self::validateCommodity_Code_ReferenceForArrayConstraintsFromSetCommodity_Code_Reference($commodity_Code_Reference))) {
            throw new \InvalidArgumentException($commodity_Code_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Commodity_Code_Reference = $commodity_Code_Reference;
        return $this;
    }
    /**
     * Add item to Commodity_Code_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Commodity_CodeObjectType $item
     * @return \StructType\Commodity_Code_Request_ReferencesType
     */
    public function addToCommodity_Code_Reference(\StructType\Commodity_CodeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Commodity_CodeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Commodity_Code_Reference property can only contain items of type \StructType\Commodity_CodeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commodity_Code_Reference[] = $item;
        return $this;
    }
}
