<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Catalog_Item_for_Supplier_Contract_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Supplier Catalog data.
 * @subpackage Structs
 */
class Catalog_Item_for_Supplier_Contract_DataType extends AbstractStructBase
{
    /**
     * The Catalog_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Reference
     * - minOccurs: 0
     * @var \StructType\Catalog_ItemObjectType
     */
    public $Catalog_Item_Reference;
    /**
     * The Item_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Item Identifier for the Catalog Item.
     * - maxOccurs: 1
     * @var string
     */
    public $Item_Identifier;
    /**
     * The Currently_Active
     * Meta information extracted from the WSDL
     * - documentation: Is the Catalog Item currently Active
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Currently_Active;
    /**
     * The Current_Default_Unit_Price
     * Meta information extracted from the WSDL
     * - documentation: Current unit price related to the default ordering unit of measure for the catalog item. | The current price of the default ordering UOM for the catalog item.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Current_Default_Unit_Price;
    /**
     * The Default_Ordering_Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: The default ordering unit of measure for the catalog item.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Default_Ordering_Unit_of_Measure_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Spend Category.
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Item Description
     * - maxOccurs: 1
     * @var string
     */
    public $Item_Description;
    /**
     * The Purchase_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the linked Purchase Item for the catalog item.
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType
     */
    public $Purchase_Item_Reference;
    /**
     * The Base_Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Base Unit of Measure Reference
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Base_Unit_of_Measure_Reference;
    /**
     * The Packaging_String
     * Meta information extracted from the WSDL
     * - documentation: The packaging string for the catalog item.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Packaging_String;
    /**
     * The Lead_Time
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Lead Time | Catalog or Supplier Item Lead Time | Lead time for the UOM of the Catalog Item. | Lead time for the UOM of the supplier item. | Lead time for the supplier item | Lead time for the JIT UOM of the Catalog or
     * Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items. | Lead time for the Bulk UOM of the Catalog or Supplier
     * Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Lead_Time;
    /**
     * The Item_URL
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item URL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_URL;
    /**
     * The Item_Tag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Tag Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_TagObjectType[]
     */
    public $Item_Tag_Reference;
    /**
     * The Alternate_Item_Identifiers_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Alternate_Item_Identifiers_DataType[]
     */
    public $Alternate_Item_Identifiers_Data;
    /**
     * The Primary_Image_Data
     * Meta information extracted from the WSDL
     * - documentation: Primary Image for Item
     * - minOccurs: 0
     * @var \StructType\Primary_Image_DataType
     */
    public $Primary_Image_Data;
    /**
     * The Additional_Image_Data
     * Meta information extracted from the WSDL
     * - documentation: Additional Image for Item
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Additional_Image_DataType[]
     */
    public $Additional_Image_Data;
    /**
     * The Pricing_History
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Catalog_Item_Data_for_Catalog_DataType[]
     */
    public $Pricing_History;
    /**
     * Constructor method for Catalog_Item_for_Supplier_Contract_DataType
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setCatalog_Item_Reference()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setItem_Identifier()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setCurrently_Active()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setCurrent_Default_Unit_Price()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setDefault_Ordering_Unit_of_Measure_Reference()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setSpend_Category_Reference()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setItem_Description()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setPurchase_Item_Reference()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setBase_Unit_of_Measure_Reference()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setPackaging_String()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setLead_Time()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setItem_URL()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setItem_Tag_Reference()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setAlternate_Item_Identifiers_Data()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setPrimary_Image_Data()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setAdditional_Image_Data()
     * @uses Catalog_Item_for_Supplier_Contract_DataType::setPricing_History()
     * @param \StructType\Catalog_ItemObjectType $catalog_Item_Reference
     * @param string $item_Identifier
     * @param bool $currently_Active
     * @param float $current_Default_Unit_Price
     * @param \StructType\Unit_of_MeasureObjectType $default_Ordering_Unit_of_Measure_Reference
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param string $item_Description
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @param \StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference
     * @param string $packaging_String
     * @param float $lead_Time
     * @param string $item_URL
     * @param \StructType\Item_TagObjectType[] $item_Tag_Reference
     * @param \StructType\Alternate_Item_Identifiers_DataType[] $alternate_Item_Identifiers_Data
     * @param \StructType\Primary_Image_DataType $primary_Image_Data
     * @param \StructType\Additional_Image_DataType[] $additional_Image_Data
     * @param \StructType\Catalog_Item_Data_for_Catalog_DataType[] $pricing_History
     */
    public function __construct(\StructType\Catalog_ItemObjectType $catalog_Item_Reference = null, $item_Identifier = null, $currently_Active = null, $current_Default_Unit_Price = null, \StructType\Unit_of_MeasureObjectType $default_Ordering_Unit_of_Measure_Reference = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, $item_Description = null, \StructType\Purchase_ItemObjectType $purchase_Item_Reference = null, \StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference = null, $packaging_String = null, $lead_Time = null, $item_URL = null, array $item_Tag_Reference = array(), array $alternate_Item_Identifiers_Data = array(), \StructType\Primary_Image_DataType $primary_Image_Data = null, array $additional_Image_Data = array(), array $pricing_History = array())
    {
        $this
            ->setCatalog_Item_Reference($catalog_Item_Reference)
            ->setItem_Identifier($item_Identifier)
            ->setCurrently_Active($currently_Active)
            ->setCurrent_Default_Unit_Price($current_Default_Unit_Price)
            ->setDefault_Ordering_Unit_of_Measure_Reference($default_Ordering_Unit_of_Measure_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setItem_Description($item_Description)
            ->setPurchase_Item_Reference($purchase_Item_Reference)
            ->setBase_Unit_of_Measure_Reference($base_Unit_of_Measure_Reference)
            ->setPackaging_String($packaging_String)
            ->setLead_Time($lead_Time)
            ->setItem_URL($item_URL)
            ->setItem_Tag_Reference($item_Tag_Reference)
            ->setAlternate_Item_Identifiers_Data($alternate_Item_Identifiers_Data)
            ->setPrimary_Image_Data($primary_Image_Data)
            ->setAdditional_Image_Data($additional_Image_Data)
            ->setPricing_History($pricing_History);
    }
    /**
     * Get Catalog_Item_Reference value
     * @return \StructType\Catalog_ItemObjectType|null
     */
    public function getCatalog_Item_Reference()
    {
        return $this->Catalog_Item_Reference;
    }
    /**
     * Set Catalog_Item_Reference value
     * @param \StructType\Catalog_ItemObjectType $catalog_Item_Reference
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setCatalog_Item_Reference(\StructType\Catalog_ItemObjectType $catalog_Item_Reference = null)
    {
        $this->Catalog_Item_Reference = $catalog_Item_Reference;
        return $this;
    }
    /**
     * Get Item_Identifier value
     * @return string|null
     */
    public function getItem_Identifier()
    {
        return $this->Item_Identifier;
    }
    /**
     * Set Item_Identifier value
     * @param string $item_Identifier
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setItem_Identifier($item_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($item_Identifier) && !is_string($item_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Identifier, true), gettype($item_Identifier)), __LINE__);
        }
        $this->Item_Identifier = $item_Identifier;
        return $this;
    }
    /**
     * Get Currently_Active value
     * @return bool|null
     */
    public function getCurrently_Active()
    {
        return $this->Currently_Active;
    }
    /**
     * Set Currently_Active value
     * @param bool $currently_Active
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setCurrently_Active($currently_Active = null)
    {
        // validation for constraint: boolean
        if (!is_null($currently_Active) && !is_bool($currently_Active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($currently_Active, true), gettype($currently_Active)), __LINE__);
        }
        $this->Currently_Active = $currently_Active;
        return $this;
    }
    /**
     * Get Current_Default_Unit_Price value
     * @return float|null
     */
    public function getCurrent_Default_Unit_Price()
    {
        return $this->Current_Default_Unit_Price;
    }
    /**
     * Set Current_Default_Unit_Price value
     * @param float $current_Default_Unit_Price
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setCurrent_Default_Unit_Price($current_Default_Unit_Price = null)
    {
        // validation for constraint: float
        if (!is_null($current_Default_Unit_Price) && !(is_float($current_Default_Unit_Price) || is_numeric($current_Default_Unit_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($current_Default_Unit_Price, true), gettype($current_Default_Unit_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($current_Default_Unit_Price) && mb_strlen(mb_substr($current_Default_Unit_Price, false !== mb_strpos($current_Default_Unit_Price, '.') ? mb_strpos($current_Default_Unit_Price, '.') + 1 : mb_strlen($current_Default_Unit_Price))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($current_Default_Unit_Price, true), mb_strlen(mb_substr($current_Default_Unit_Price, mb_strpos($current_Default_Unit_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($current_Default_Unit_Price) && mb_strlen(preg_replace('/(\D)/', '', $current_Default_Unit_Price)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($current_Default_Unit_Price, true), mb_strlen(preg_replace('/(\D)/', '', $current_Default_Unit_Price))), __LINE__);
        }
        $this->Current_Default_Unit_Price = $current_Default_Unit_Price;
        return $this;
    }
    /**
     * Get Default_Ordering_Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getDefault_Ordering_Unit_of_Measure_Reference()
    {
        return $this->Default_Ordering_Unit_of_Measure_Reference;
    }
    /**
     * Set Default_Ordering_Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $default_Ordering_Unit_of_Measure_Reference
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setDefault_Ordering_Unit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $default_Ordering_Unit_of_Measure_Reference = null)
    {
        $this->Default_Ordering_Unit_of_Measure_Reference = $default_Ordering_Unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Purchase_Item_Reference value
     * @return \StructType\Purchase_ItemObjectType|null
     */
    public function getPurchase_Item_Reference()
    {
        return $this->Purchase_Item_Reference;
    }
    /**
     * Set Purchase_Item_Reference value
     * @param \StructType\Purchase_ItemObjectType $purchase_Item_Reference
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setPurchase_Item_Reference(\StructType\Purchase_ItemObjectType $purchase_Item_Reference = null)
    {
        $this->Purchase_Item_Reference = $purchase_Item_Reference;
        return $this;
    }
    /**
     * Get Base_Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getBase_Unit_of_Measure_Reference()
    {
        return $this->Base_Unit_of_Measure_Reference;
    }
    /**
     * Set Base_Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setBase_Unit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $base_Unit_of_Measure_Reference = null)
    {
        $this->Base_Unit_of_Measure_Reference = $base_Unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Packaging_String value
     * @return string|null
     */
    public function getPackaging_String()
    {
        return $this->Packaging_String;
    }
    /**
     * Set Packaging_String value
     * @param string $packaging_String
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setPackaging_String($packaging_String = null)
    {
        // validation for constraint: string
        if (!is_null($packaging_String) && !is_string($packaging_String)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packaging_String, true), gettype($packaging_String)), __LINE__);
        }
        $this->Packaging_String = $packaging_String;
        return $this;
    }
    /**
     * Get Lead_Time value
     * @return float|null
     */
    public function getLead_Time()
    {
        return $this->Lead_Time;
    }
    /**
     * Set Lead_Time value
     * @param float $lead_Time
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setLead_Time($lead_Time = null)
    {
        // validation for constraint: float
        if (!is_null($lead_Time) && !(is_float($lead_Time) || is_numeric($lead_Time))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lead_Time, true), gettype($lead_Time)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($lead_Time) && mb_strlen(mb_substr($lead_Time, false !== mb_strpos($lead_Time, '.') ? mb_strpos($lead_Time, '.') + 1 : mb_strlen($lead_Time))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($lead_Time, true), mb_strlen(mb_substr($lead_Time, mb_strpos($lead_Time, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($lead_Time) && $lead_Time < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($lead_Time, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($lead_Time) && mb_strlen(preg_replace('/(\D)/', '', $lead_Time)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($lead_Time, true), mb_strlen(preg_replace('/(\D)/', '', $lead_Time))), __LINE__);
        }
        $this->Lead_Time = $lead_Time;
        return $this;
    }
    /**
     * Get Item_URL value
     * @return string|null
     */
    public function getItem_URL()
    {
        return $this->Item_URL;
    }
    /**
     * Set Item_URL value
     * @param string $item_URL
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setItem_URL($item_URL = null)
    {
        // validation for constraint: string
        if (!is_null($item_URL) && !is_string($item_URL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_URL, true), gettype($item_URL)), __LINE__);
        }
        $this->Item_URL = $item_URL;
        return $this;
    }
    /**
     * Get Item_Tag_Reference value
     * @return \StructType\Item_TagObjectType[]|null
     */
    public function getItem_Tag_Reference()
    {
        return $this->Item_Tag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Tag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Tag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Tag_ReferenceForArrayConstraintsFromSetItem_Tag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Item_for_Supplier_Contract_DataTypeItem_Tag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$catalog_Item_for_Supplier_Contract_DataTypeItem_Tag_ReferenceItem instanceof \StructType\Item_TagObjectType) {
                $invalidValues[] = is_object($catalog_Item_for_Supplier_Contract_DataTypeItem_Tag_ReferenceItem) ? get_class($catalog_Item_for_Supplier_Contract_DataTypeItem_Tag_ReferenceItem) : sprintf('%s(%s)', gettype($catalog_Item_for_Supplier_Contract_DataTypeItem_Tag_ReferenceItem), var_export($catalog_Item_for_Supplier_Contract_DataTypeItem_Tag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Tag_Reference property can only contain items of type \StructType\Item_TagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_TagObjectType[] $item_Tag_Reference
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setItem_Tag_Reference(array $item_Tag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Tag_ReferenceArrayErrorMessage = self::validateItem_Tag_ReferenceForArrayConstraintsFromSetItem_Tag_Reference($item_Tag_Reference))) {
            throw new \InvalidArgumentException($item_Tag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Tag_Reference = $item_Tag_Reference;
        return $this;
    }
    /**
     * Add item to Item_Tag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_TagObjectType $item
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function addToItem_Tag_Reference(\StructType\Item_TagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_TagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Tag_Reference property can only contain items of type \StructType\Item_TagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Tag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Alternate_Item_Identifiers_Data value
     * @return \StructType\Alternate_Item_Identifiers_DataType[]|null
     */
    public function getAlternate_Item_Identifiers_Data()
    {
        return $this->Alternate_Item_Identifiers_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Item_Identifiers_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Item_Identifiers_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Item_Identifiers_DataForArrayConstraintsFromSetAlternate_Item_Identifiers_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Item_for_Supplier_Contract_DataTypeAlternate_Item_Identifiers_DataItem) {
            // validation for constraint: itemType
            if (!$catalog_Item_for_Supplier_Contract_DataTypeAlternate_Item_Identifiers_DataItem instanceof \StructType\Alternate_Item_Identifiers_DataType) {
                $invalidValues[] = is_object($catalog_Item_for_Supplier_Contract_DataTypeAlternate_Item_Identifiers_DataItem) ? get_class($catalog_Item_for_Supplier_Contract_DataTypeAlternate_Item_Identifiers_DataItem) : sprintf('%s(%s)', gettype($catalog_Item_for_Supplier_Contract_DataTypeAlternate_Item_Identifiers_DataItem), var_export($catalog_Item_for_Supplier_Contract_DataTypeAlternate_Item_Identifiers_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Item_Identifiers_Data property can only contain items of type \StructType\Alternate_Item_Identifiers_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Item_Identifiers_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Item_Identifiers_DataType[] $alternate_Item_Identifiers_Data
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setAlternate_Item_Identifiers_Data(array $alternate_Item_Identifiers_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Item_Identifiers_DataArrayErrorMessage = self::validateAlternate_Item_Identifiers_DataForArrayConstraintsFromSetAlternate_Item_Identifiers_Data($alternate_Item_Identifiers_Data))) {
            throw new \InvalidArgumentException($alternate_Item_Identifiers_DataArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Item_Identifiers_Data = $alternate_Item_Identifiers_Data;
        return $this;
    }
    /**
     * Add item to Alternate_Item_Identifiers_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Item_Identifiers_DataType $item
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function addToAlternate_Item_Identifiers_Data(\StructType\Alternate_Item_Identifiers_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Alternate_Item_Identifiers_DataType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Item_Identifiers_Data property can only contain items of type \StructType\Alternate_Item_Identifiers_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Item_Identifiers_Data[] = $item;
        return $this;
    }
    /**
     * Get Primary_Image_Data value
     * @return \StructType\Primary_Image_DataType|null
     */
    public function getPrimary_Image_Data()
    {
        return $this->Primary_Image_Data;
    }
    /**
     * Set Primary_Image_Data value
     * @param \StructType\Primary_Image_DataType $primary_Image_Data
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setPrimary_Image_Data(\StructType\Primary_Image_DataType $primary_Image_Data = null)
    {
        $this->Primary_Image_Data = $primary_Image_Data;
        return $this;
    }
    /**
     * Get Additional_Image_Data value
     * @return \StructType\Additional_Image_DataType[]|null
     */
    public function getAdditional_Image_Data()
    {
        return $this->Additional_Image_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Image_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Image_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_Image_DataForArrayConstraintsFromSetAdditional_Image_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Item_for_Supplier_Contract_DataTypeAdditional_Image_DataItem) {
            // validation for constraint: itemType
            if (!$catalog_Item_for_Supplier_Contract_DataTypeAdditional_Image_DataItem instanceof \StructType\Additional_Image_DataType) {
                $invalidValues[] = is_object($catalog_Item_for_Supplier_Contract_DataTypeAdditional_Image_DataItem) ? get_class($catalog_Item_for_Supplier_Contract_DataTypeAdditional_Image_DataItem) : sprintf('%s(%s)', gettype($catalog_Item_for_Supplier_Contract_DataTypeAdditional_Image_DataItem), var_export($catalog_Item_for_Supplier_Contract_DataTypeAdditional_Image_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Image_Data property can only contain items of type \StructType\Additional_Image_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Image_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Additional_Image_DataType[] $additional_Image_Data
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setAdditional_Image_Data(array $additional_Image_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_Image_DataArrayErrorMessage = self::validateAdditional_Image_DataForArrayConstraintsFromSetAdditional_Image_Data($additional_Image_Data))) {
            throw new \InvalidArgumentException($additional_Image_DataArrayErrorMessage, __LINE__);
        }
        $this->Additional_Image_Data = $additional_Image_Data;
        return $this;
    }
    /**
     * Add item to Additional_Image_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Additional_Image_DataType $item
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function addToAdditional_Image_Data(\StructType\Additional_Image_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Additional_Image_DataType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Image_Data property can only contain items of type \StructType\Additional_Image_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Image_Data[] = $item;
        return $this;
    }
    /**
     * Get Pricing_History value
     * @return \StructType\Catalog_Item_Data_for_Catalog_DataType[]|null
     */
    public function getPricing_History()
    {
        return $this->Pricing_History;
    }
    /**
     * This method is responsible for validating the values passed to the setPricing_History method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricing_History method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricing_HistoryForArrayConstraintsFromSetPricing_History(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Item_for_Supplier_Contract_DataTypePricing_HistoryItem) {
            // validation for constraint: itemType
            if (!$catalog_Item_for_Supplier_Contract_DataTypePricing_HistoryItem instanceof \StructType\Catalog_Item_Data_for_Catalog_DataType) {
                $invalidValues[] = is_object($catalog_Item_for_Supplier_Contract_DataTypePricing_HistoryItem) ? get_class($catalog_Item_for_Supplier_Contract_DataTypePricing_HistoryItem) : sprintf('%s(%s)', gettype($catalog_Item_for_Supplier_Contract_DataTypePricing_HistoryItem), var_export($catalog_Item_for_Supplier_Contract_DataTypePricing_HistoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Pricing_History property can only contain items of type \StructType\Catalog_Item_Data_for_Catalog_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Pricing_History value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Item_Data_for_Catalog_DataType[] $pricing_History
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function setPricing_History(array $pricing_History = array())
    {
        // validation for constraint: array
        if ('' !== ($pricing_HistoryArrayErrorMessage = self::validatePricing_HistoryForArrayConstraintsFromSetPricing_History($pricing_History))) {
            throw new \InvalidArgumentException($pricing_HistoryArrayErrorMessage, __LINE__);
        }
        $this->Pricing_History = $pricing_History;
        return $this;
    }
    /**
     * Add item to Pricing_History value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_Item_Data_for_Catalog_DataType $item
     * @return \StructType\Catalog_Item_for_Supplier_Contract_DataType
     */
    public function addToPricing_History(\StructType\Catalog_Item_Data_for_Catalog_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Catalog_Item_Data_for_Catalog_DataType) {
            throw new \InvalidArgumentException(sprintf('The Pricing_History property can only contain items of type \StructType\Catalog_Item_Data_for_Catalog_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Pricing_History[] = $item;
        return $this;
    }
}
