<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Transfer_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Either Worker, Location, or Worktags must change to be able to transfer the asset. | Element containing Business Asset Transfer details.
 * @subpackage Structs
 */
class Asset_Transfer_DataType extends AbstractStructBase
{
    /**
     * The Transfer_Date
     * Meta information extracted from the WSDL
     * - documentation: The transfer date must be less than or equal to today's date. | The transaction effective date of the Asset Transfer. The date must be greater than or equal to the Asset's acquisition date and must not be prior to the last issued
     * date. If the Business Asset is Depreciable, the Ledger Period must exist for the date specified.
     * - maxOccurs: 1
     * @var string
     */
    public $Transfer_Date;
    /**
     * The Transfer_To_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing worker or custodian of the business asset
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Transfer_To_Worker_Reference;
    /**
     * The Default_Location_and_Worktags_from_Worker
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Location and Worktags values will be defaulted from the Worker specified. 1=default; 2=do not defaultIf defaulting is requested, a Worker must be specified while Location and Worktags are blank.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Default_Location_and_Worktags_from_Worker;
    /**
     * The Keep_Location_and_Worktags_from_Business_Asset
     * Meta information extracted from the WSDL
     * - documentation: You must first configure the Maintain Worktag Type Precedences task to Not Default Worker Organization Assignments as Worktags for Business Asset.Indicates whether the Location and Worktags of the Business Asset remain.If you set
     * this field to True, Location and Worktags must be blank. If Default Location and Worktags from Worker are also set to True, Workday merges the Asset Worktags with the Worker Worktags.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Keep_Location_and_Worktags_from_Business_Asset;
    /**
     * The Transfer_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the location of the business asset
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Transfer_To_Location_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation
     * when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Asset_Transfer_Comments
     * Meta information extracted from the WSDL
     * - documentation: Enter comments when necessary for asset transfer reason.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Asset_Transfer_Comments;
    /**
     * The Keep_Worktags_of_Asset_Shares
     * Meta information extracted from the WSDL
     * - documentation: Boolean that when checked will keep the current Asset Share Worktags, if unchecked the worktags will be overridden.
     * @var bool
     */
    public $Keep_Worktags_of_Asset_Shares;
    /**
     * Constructor method for Asset_Transfer_DataType
     * @uses Asset_Transfer_DataType::setTransfer_Date()
     * @uses Asset_Transfer_DataType::setTransfer_To_Worker_Reference()
     * @uses Asset_Transfer_DataType::setDefault_Location_and_Worktags_from_Worker()
     * @uses Asset_Transfer_DataType::setKeep_Location_and_Worktags_from_Business_Asset()
     * @uses Asset_Transfer_DataType::setTransfer_To_Location_Reference()
     * @uses Asset_Transfer_DataType::setWorktags_Reference()
     * @uses Asset_Transfer_DataType::setAsset_Transfer_Comments()
     * @uses Asset_Transfer_DataType::setKeep_Worktags_of_Asset_Shares()
     * @param string $transfer_Date
     * @param \StructType\WorkerObjectType $transfer_To_Worker_Reference
     * @param bool $default_Location_and_Worktags_from_Worker
     * @param bool $keep_Location_and_Worktags_from_Business_Asset
     * @param \StructType\LocationObjectType $transfer_To_Location_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param string $asset_Transfer_Comments
     * @param bool $keep_Worktags_of_Asset_Shares
     */
    public function __construct($transfer_Date = null, \StructType\WorkerObjectType $transfer_To_Worker_Reference = null, $default_Location_and_Worktags_from_Worker = null, $keep_Location_and_Worktags_from_Business_Asset = null, \StructType\LocationObjectType $transfer_To_Location_Reference = null, array $worktags_Reference = array(), $asset_Transfer_Comments = null, $keep_Worktags_of_Asset_Shares = null)
    {
        $this
            ->setTransfer_Date($transfer_Date)
            ->setTransfer_To_Worker_Reference($transfer_To_Worker_Reference)
            ->setDefault_Location_and_Worktags_from_Worker($default_Location_and_Worktags_from_Worker)
            ->setKeep_Location_and_Worktags_from_Business_Asset($keep_Location_and_Worktags_from_Business_Asset)
            ->setTransfer_To_Location_Reference($transfer_To_Location_Reference)
            ->setWorktags_Reference($worktags_Reference)
            ->setAsset_Transfer_Comments($asset_Transfer_Comments)
            ->setKeep_Worktags_of_Asset_Shares($keep_Worktags_of_Asset_Shares);
    }
    /**
     * Get Transfer_Date value
     * @return string|null
     */
    public function getTransfer_Date()
    {
        return $this->Transfer_Date;
    }
    /**
     * Set Transfer_Date value
     * @param string $transfer_Date
     * @return \StructType\Asset_Transfer_DataType
     */
    public function setTransfer_Date($transfer_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transfer_Date) && !is_string($transfer_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transfer_Date, true), gettype($transfer_Date)), __LINE__);
        }
        $this->Transfer_Date = $transfer_Date;
        return $this;
    }
    /**
     * Get Transfer_To_Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getTransfer_To_Worker_Reference()
    {
        return $this->Transfer_To_Worker_Reference;
    }
    /**
     * Set Transfer_To_Worker_Reference value
     * @param \StructType\WorkerObjectType $transfer_To_Worker_Reference
     * @return \StructType\Asset_Transfer_DataType
     */
    public function setTransfer_To_Worker_Reference(\StructType\WorkerObjectType $transfer_To_Worker_Reference = null)
    {
        $this->Transfer_To_Worker_Reference = $transfer_To_Worker_Reference;
        return $this;
    }
    /**
     * Get Default_Location_and_Worktags_from_Worker value
     * @return bool|null
     */
    public function getDefault_Location_and_Worktags_from_Worker()
    {
        return $this->Default_Location_and_Worktags_from_Worker;
    }
    /**
     * Set Default_Location_and_Worktags_from_Worker value
     * @param bool $default_Location_and_Worktags_from_Worker
     * @return \StructType\Asset_Transfer_DataType
     */
    public function setDefault_Location_and_Worktags_from_Worker($default_Location_and_Worktags_from_Worker = null)
    {
        // validation for constraint: boolean
        if (!is_null($default_Location_and_Worktags_from_Worker) && !is_bool($default_Location_and_Worktags_from_Worker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($default_Location_and_Worktags_from_Worker, true), gettype($default_Location_and_Worktags_from_Worker)), __LINE__);
        }
        $this->Default_Location_and_Worktags_from_Worker = $default_Location_and_Worktags_from_Worker;
        return $this;
    }
    /**
     * Get Keep_Location_and_Worktags_from_Business_Asset value
     * @return bool|null
     */
    public function getKeep_Location_and_Worktags_from_Business_Asset()
    {
        return $this->Keep_Location_and_Worktags_from_Business_Asset;
    }
    /**
     * Set Keep_Location_and_Worktags_from_Business_Asset value
     * @param bool $keep_Location_and_Worktags_from_Business_Asset
     * @return \StructType\Asset_Transfer_DataType
     */
    public function setKeep_Location_and_Worktags_from_Business_Asset($keep_Location_and_Worktags_from_Business_Asset = null)
    {
        // validation for constraint: boolean
        if (!is_null($keep_Location_and_Worktags_from_Business_Asset) && !is_bool($keep_Location_and_Worktags_from_Business_Asset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keep_Location_and_Worktags_from_Business_Asset, true), gettype($keep_Location_and_Worktags_from_Business_Asset)), __LINE__);
        }
        $this->Keep_Location_and_Worktags_from_Business_Asset = $keep_Location_and_Worktags_from_Business_Asset;
        return $this;
    }
    /**
     * Get Transfer_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getTransfer_To_Location_Reference()
    {
        return $this->Transfer_To_Location_Reference;
    }
    /**
     * Set Transfer_To_Location_Reference value
     * @param \StructType\LocationObjectType $transfer_To_Location_Reference
     * @return \StructType\Asset_Transfer_DataType
     */
    public function setTransfer_To_Location_Reference(\StructType\LocationObjectType $transfer_To_Location_Reference = null)
    {
        $this->Transfer_To_Location_Reference = $transfer_To_Location_Reference;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Transfer_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Transfer_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($asset_Transfer_DataTypeWorktags_ReferenceItem) ? get_class($asset_Transfer_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Transfer_DataTypeWorktags_ReferenceItem), var_export($asset_Transfer_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Asset_Transfer_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Asset_Transfer_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Asset_Transfer_Comments value
     * @return string|null
     */
    public function getAsset_Transfer_Comments()
    {
        return $this->Asset_Transfer_Comments;
    }
    /**
     * Set Asset_Transfer_Comments value
     * @param string $asset_Transfer_Comments
     * @return \StructType\Asset_Transfer_DataType
     */
    public function setAsset_Transfer_Comments($asset_Transfer_Comments = null)
    {
        // validation for constraint: string
        if (!is_null($asset_Transfer_Comments) && !is_string($asset_Transfer_Comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asset_Transfer_Comments, true), gettype($asset_Transfer_Comments)), __LINE__);
        }
        $this->Asset_Transfer_Comments = $asset_Transfer_Comments;
        return $this;
    }
    /**
     * Get Keep_Worktags_of_Asset_Shares value
     * @return bool|null
     */
    public function getKeep_Worktags_of_Asset_Shares()
    {
        return $this->Keep_Worktags_of_Asset_Shares;
    }
    /**
     * Set Keep_Worktags_of_Asset_Shares value
     * @param bool $keep_Worktags_of_Asset_Shares
     * @return \StructType\Asset_Transfer_DataType
     */
    public function setKeep_Worktags_of_Asset_Shares($keep_Worktags_of_Asset_Shares = null)
    {
        // validation for constraint: boolean
        if (!is_null($keep_Worktags_of_Asset_Shares) && !is_bool($keep_Worktags_of_Asset_Shares)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keep_Worktags_of_Asset_Shares, true), gettype($keep_Worktags_of_Asset_Shares)), __LINE__);
        }
        $this->Keep_Worktags_of_Asset_Shares = $keep_Worktags_of_Asset_Shares;
        return $this;
    }
}
