<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Schedule_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Supplier Invoice Schedule Request References
 * @subpackage Structs
 */
class Supplier_Invoice_Schedule_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Schedule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Schedule References.
     * - maxOccurs: unbounded
     * @var \StructType\Supplier_Invoice_ScheduleObjectType[]
     */
    public $Supplier_Invoice_Schedule_Reference;
    /**
     * Constructor method for Supplier_Invoice_Schedule_Request_ReferencesType
     * @uses Supplier_Invoice_Schedule_Request_ReferencesType::setSupplier_Invoice_Schedule_Reference()
     * @param \StructType\Supplier_Invoice_ScheduleObjectType[] $supplier_Invoice_Schedule_Reference
     */
    public function __construct(array $supplier_Invoice_Schedule_Reference = array())
    {
        $this
            ->setSupplier_Invoice_Schedule_Reference($supplier_Invoice_Schedule_Reference);
    }
    /**
     * Get Supplier_Invoice_Schedule_Reference value
     * @return \StructType\Supplier_Invoice_ScheduleObjectType[]|null
     */
    public function getSupplier_Invoice_Schedule_Reference()
    {
        return $this->Supplier_Invoice_Schedule_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Schedule_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Schedule_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Schedule_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Schedule_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Schedule_Request_ReferencesTypeSupplier_Invoice_Schedule_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Schedule_Request_ReferencesTypeSupplier_Invoice_Schedule_ReferenceItem instanceof \StructType\Supplier_Invoice_ScheduleObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Schedule_Request_ReferencesTypeSupplier_Invoice_Schedule_ReferenceItem) ? get_class($supplier_Invoice_Schedule_Request_ReferencesTypeSupplier_Invoice_Schedule_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Schedule_Request_ReferencesTypeSupplier_Invoice_Schedule_ReferenceItem), var_export($supplier_Invoice_Schedule_Request_ReferencesTypeSupplier_Invoice_Schedule_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Schedule_Reference property can only contain items of type \StructType\Supplier_Invoice_ScheduleObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Schedule_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_ScheduleObjectType[] $supplier_Invoice_Schedule_Reference
     * @return \StructType\Supplier_Invoice_Schedule_Request_ReferencesType
     */
    public function setSupplier_Invoice_Schedule_Reference(array $supplier_Invoice_Schedule_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Schedule_ReferenceArrayErrorMessage = self::validateSupplier_Invoice_Schedule_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Schedule_Reference($supplier_Invoice_Schedule_Reference))) {
            throw new \InvalidArgumentException($supplier_Invoice_Schedule_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Schedule_Reference = $supplier_Invoice_Schedule_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Schedule_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_ScheduleObjectType $item
     * @return \StructType\Supplier_Invoice_Schedule_Request_ReferencesType
     */
    public function addToSupplier_Invoice_Schedule_Reference(\StructType\Supplier_Invoice_ScheduleObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_ScheduleObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Schedule_Reference property can only contain items of type \StructType\Supplier_Invoice_ScheduleObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Schedule_Reference[] = $item;
        return $this;
    }
}
