<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Supplier_Invoice_Request_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Web Service is set to Add Only; documents cannot be resubmitted. | Element containing Supplier Invoice Request Business Processing Options, Supplier Invoice Request reference for update. Flag to indicate if this operation is add
 * only, and all Supplier Invoice Request data items required to create a complete Supplier Invoice Request
 * @subpackage Structs
 */
class Submit_Supplier_Invoice_Request_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Request_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Invoice Request for update only purpose
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_RequestObjectType
     */
    public $Supplier_Invoice_Request_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Supplier_Invoice_Request_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Request Data
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Request_Data_InboundType
     */
    public $Supplier_Invoice_Request_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Supplier_Invoice_Request_RequestType
     * @uses Submit_Supplier_Invoice_Request_RequestType::setSupplier_Invoice_Request_Reference()
     * @uses Submit_Supplier_Invoice_Request_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Supplier_Invoice_Request_RequestType::setSupplier_Invoice_Request_Data()
     * @uses Submit_Supplier_Invoice_Request_RequestType::setAdd_Only()
     * @uses Submit_Supplier_Invoice_Request_RequestType::setVersion()
     * @param \StructType\Supplier_Invoice_RequestObjectType $supplier_Invoice_Request_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Supplier_Invoice_Request_Data_InboundType $supplier_Invoice_Request_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Supplier_Invoice_RequestObjectType $supplier_Invoice_Request_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Supplier_Invoice_Request_Data_InboundType $supplier_Invoice_Request_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setSupplier_Invoice_Request_Reference($supplier_Invoice_Request_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setSupplier_Invoice_Request_Data($supplier_Invoice_Request_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Invoice_Request_Reference value
     * @return \StructType\Supplier_Invoice_RequestObjectType|null
     */
    public function getSupplier_Invoice_Request_Reference()
    {
        return $this->Supplier_Invoice_Request_Reference;
    }
    /**
     * Set Supplier_Invoice_Request_Reference value
     * @param \StructType\Supplier_Invoice_RequestObjectType $supplier_Invoice_Request_Reference
     * @return \StructType\Submit_Supplier_Invoice_Request_RequestType
     */
    public function setSupplier_Invoice_Request_Reference(\StructType\Supplier_Invoice_RequestObjectType $supplier_Invoice_Request_Reference = null)
    {
        $this->Supplier_Invoice_Request_Reference = $supplier_Invoice_Request_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Supplier_Invoice_Request_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Request_Data value
     * @return \StructType\Supplier_Invoice_Request_Data_InboundType|null
     */
    public function getSupplier_Invoice_Request_Data()
    {
        return $this->Supplier_Invoice_Request_Data;
    }
    /**
     * Set Supplier_Invoice_Request_Data value
     * @param \StructType\Supplier_Invoice_Request_Data_InboundType $supplier_Invoice_Request_Data
     * @return \StructType\Submit_Supplier_Invoice_Request_RequestType
     */
    public function setSupplier_Invoice_Request_Data(\StructType\Supplier_Invoice_Request_Data_InboundType $supplier_Invoice_Request_Data = null)
    {
        $this->Supplier_Invoice_Request_Data = $supplier_Invoice_Request_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Supplier_Invoice_Request_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Supplier_Invoice_Request_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
