<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Project_Asset_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Response after Putting a Project Asset.
 * @subpackage Structs
 */
class Put_Project_Asset_ResponseType extends AbstractStructBase
{
    /**
     * The Project_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Asset Reference
     * - minOccurs: 0
     * @var \StructType\Project_AssetObjectType
     */
    public $Project_Asset_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Project_Asset_ResponseType
     * @uses Put_Project_Asset_ResponseType::setProject_Asset_Reference()
     * @uses Put_Project_Asset_ResponseType::setVersion()
     * @param \StructType\Project_AssetObjectType $project_Asset_Reference
     * @param string $version
     */
    public function __construct(\StructType\Project_AssetObjectType $project_Asset_Reference = null, $version = null)
    {
        $this
            ->setProject_Asset_Reference($project_Asset_Reference)
            ->setVersion($version);
    }
    /**
     * Get Project_Asset_Reference value
     * @return \StructType\Project_AssetObjectType|null
     */
    public function getProject_Asset_Reference()
    {
        return $this->Project_Asset_Reference;
    }
    /**
     * Set Project_Asset_Reference value
     * @param \StructType\Project_AssetObjectType $project_Asset_Reference
     * @return \StructType\Put_Project_Asset_ResponseType
     */
    public function setProject_Asset_Reference(\StructType\Project_AssetObjectType $project_Asset_Reference = null)
    {
        $this->Project_Asset_Reference = $project_Asset_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Project_Asset_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
