<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transfer_Pricing_Rate_Sheet_Snapshot_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains transfer pricing rate sheet snapshot data based on the request parameters or submits data.
 * @subpackage Structs
 */
class Transfer_Pricing_Rate_Sheet_Snapshot_DataType extends AbstractStructBase
{
    /**
     * The Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Effective Date
     * - maxOccurs: 1
     * @var string
     */
    public $Effective_Date;
    /**
     * The Transfer_Pricing_Default_Rate_Or_Percent
     * Meta information extracted from the WSDL
     * - documentation: Retrieves or submits the default rate or percent of transfer pricing. If the transfer pricing rate basis is selected as custom rate, it is the default rate; otherwise, it is the default percent.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 15
     * @var float
     */
    public $Transfer_Pricing_Default_Rate_Or_Percent;
    /**
     * The Transfer_Pricing_Rate_Basis_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contains the transfer pricing rate basis, comprised of either the Custom Rate or the Standard Cost Rate Sheet. Required for the Put web service.
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Transfer_Pricing_Rate_Basis_Reference;
    /**
     * The Transfer_Pricing_Rate_Sheet_Detail_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the transfer pricing rate sheet details data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType[]
     */
    public $Transfer_Pricing_Rate_Sheet_Detail_Data;
    /**
     * Constructor method for Transfer_Pricing_Rate_Sheet_Snapshot_DataType
     * @uses Transfer_Pricing_Rate_Sheet_Snapshot_DataType::setEffective_Date()
     * @uses Transfer_Pricing_Rate_Sheet_Snapshot_DataType::setTransfer_Pricing_Default_Rate_Or_Percent()
     * @uses Transfer_Pricing_Rate_Sheet_Snapshot_DataType::setTransfer_Pricing_Rate_Basis_Reference()
     * @uses Transfer_Pricing_Rate_Sheet_Snapshot_DataType::setTransfer_Pricing_Rate_Sheet_Detail_Data()
     * @param string $effective_Date
     * @param float $transfer_Pricing_Default_Rate_Or_Percent
     * @param \StructType\Unique_IdentifierObjectType $transfer_Pricing_Rate_Basis_Reference
     * @param \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType[] $transfer_Pricing_Rate_Sheet_Detail_Data
     */
    public function __construct($effective_Date = null, $transfer_Pricing_Default_Rate_Or_Percent = null, \StructType\Unique_IdentifierObjectType $transfer_Pricing_Rate_Basis_Reference = null, array $transfer_Pricing_Rate_Sheet_Detail_Data = array())
    {
        $this
            ->setEffective_Date($effective_Date)
            ->setTransfer_Pricing_Default_Rate_Or_Percent($transfer_Pricing_Default_Rate_Or_Percent)
            ->setTransfer_Pricing_Rate_Basis_Reference($transfer_Pricing_Rate_Basis_Reference)
            ->setTransfer_Pricing_Rate_Sheet_Detail_Data($transfer_Pricing_Rate_Sheet_Detail_Data);
    }
    /**
     * Get Effective_Date value
     * @return string|null
     */
    public function getEffective_Date()
    {
        return $this->Effective_Date;
    }
    /**
     * Set Effective_Date value
     * @param string $effective_Date
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Snapshot_DataType
     */
    public function setEffective_Date($effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($effective_Date) && !is_string($effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effective_Date, true), gettype($effective_Date)), __LINE__);
        }
        $this->Effective_Date = $effective_Date;
        return $this;
    }
    /**
     * Get Transfer_Pricing_Default_Rate_Or_Percent value
     * @return float|null
     */
    public function getTransfer_Pricing_Default_Rate_Or_Percent()
    {
        return $this->Transfer_Pricing_Default_Rate_Or_Percent;
    }
    /**
     * Set Transfer_Pricing_Default_Rate_Or_Percent value
     * @param float $transfer_Pricing_Default_Rate_Or_Percent
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Snapshot_DataType
     */
    public function setTransfer_Pricing_Default_Rate_Or_Percent($transfer_Pricing_Default_Rate_Or_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($transfer_Pricing_Default_Rate_Or_Percent) && !(is_float($transfer_Pricing_Default_Rate_Or_Percent) || is_numeric($transfer_Pricing_Default_Rate_Or_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($transfer_Pricing_Default_Rate_Or_Percent, true), gettype($transfer_Pricing_Default_Rate_Or_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($transfer_Pricing_Default_Rate_Or_Percent) && mb_strlen(mb_substr($transfer_Pricing_Default_Rate_Or_Percent, false !== mb_strpos($transfer_Pricing_Default_Rate_Or_Percent, '.') ? mb_strpos($transfer_Pricing_Default_Rate_Or_Percent, '.') + 1 : mb_strlen($transfer_Pricing_Default_Rate_Or_Percent))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($transfer_Pricing_Default_Rate_Or_Percent, true), mb_strlen(mb_substr($transfer_Pricing_Default_Rate_Or_Percent, mb_strpos($transfer_Pricing_Default_Rate_Or_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($transfer_Pricing_Default_Rate_Or_Percent) && mb_strlen(preg_replace('/(\D)/', '', $transfer_Pricing_Default_Rate_Or_Percent)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($transfer_Pricing_Default_Rate_Or_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $transfer_Pricing_Default_Rate_Or_Percent))), __LINE__);
        }
        $this->Transfer_Pricing_Default_Rate_Or_Percent = $transfer_Pricing_Default_Rate_Or_Percent;
        return $this;
    }
    /**
     * Get Transfer_Pricing_Rate_Basis_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getTransfer_Pricing_Rate_Basis_Reference()
    {
        return $this->Transfer_Pricing_Rate_Basis_Reference;
    }
    /**
     * Set Transfer_Pricing_Rate_Basis_Reference value
     * @param \StructType\Unique_IdentifierObjectType $transfer_Pricing_Rate_Basis_Reference
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Snapshot_DataType
     */
    public function setTransfer_Pricing_Rate_Basis_Reference(\StructType\Unique_IdentifierObjectType $transfer_Pricing_Rate_Basis_Reference = null)
    {
        $this->Transfer_Pricing_Rate_Basis_Reference = $transfer_Pricing_Rate_Basis_Reference;
        return $this;
    }
    /**
     * Get Transfer_Pricing_Rate_Sheet_Detail_Data value
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType[]|null
     */
    public function getTransfer_Pricing_Rate_Sheet_Detail_Data()
    {
        return $this->Transfer_Pricing_Rate_Sheet_Detail_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTransfer_Pricing_Rate_Sheet_Detail_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransfer_Pricing_Rate_Sheet_Detail_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransfer_Pricing_Rate_Sheet_Detail_DataForArrayConstraintsFromSetTransfer_Pricing_Rate_Sheet_Detail_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transfer_Pricing_Rate_Sheet_Snapshot_DataTypeTransfer_Pricing_Rate_Sheet_Detail_DataItem) {
            // validation for constraint: itemType
            if (!$transfer_Pricing_Rate_Sheet_Snapshot_DataTypeTransfer_Pricing_Rate_Sheet_Detail_DataItem instanceof \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType) {
                $invalidValues[] = is_object($transfer_Pricing_Rate_Sheet_Snapshot_DataTypeTransfer_Pricing_Rate_Sheet_Detail_DataItem) ? get_class($transfer_Pricing_Rate_Sheet_Snapshot_DataTypeTransfer_Pricing_Rate_Sheet_Detail_DataItem) : sprintf('%s(%s)', gettype($transfer_Pricing_Rate_Sheet_Snapshot_DataTypeTransfer_Pricing_Rate_Sheet_Detail_DataItem), var_export($transfer_Pricing_Rate_Sheet_Snapshot_DataTypeTransfer_Pricing_Rate_Sheet_Detail_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Transfer_Pricing_Rate_Sheet_Detail_Data property can only contain items of type \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Transfer_Pricing_Rate_Sheet_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType[] $transfer_Pricing_Rate_Sheet_Detail_Data
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Snapshot_DataType
     */
    public function setTransfer_Pricing_Rate_Sheet_Detail_Data(array $transfer_Pricing_Rate_Sheet_Detail_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($transfer_Pricing_Rate_Sheet_Detail_DataArrayErrorMessage = self::validateTransfer_Pricing_Rate_Sheet_Detail_DataForArrayConstraintsFromSetTransfer_Pricing_Rate_Sheet_Detail_Data($transfer_Pricing_Rate_Sheet_Detail_Data))) {
            throw new \InvalidArgumentException($transfer_Pricing_Rate_Sheet_Detail_DataArrayErrorMessage, __LINE__);
        }
        $this->Transfer_Pricing_Rate_Sheet_Detail_Data = $transfer_Pricing_Rate_Sheet_Detail_Data;
        return $this;
    }
    /**
     * Add item to Transfer_Pricing_Rate_Sheet_Detail_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType $item
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Snapshot_DataType
     */
    public function addToTransfer_Pricing_Rate_Sheet_Detail_Data(\StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType) {
            throw new \InvalidArgumentException(sprintf('The Transfer_Pricing_Rate_Sheet_Detail_Data property can only contain items of type \StructType\Transfer_Pricing_Rate_Sheet_Detail_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Transfer_Pricing_Rate_Sheet_Detail_Data[] = $item;
        return $this;
    }
}
