<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Work_Queue_Tag_Assignment_RuleType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element holding data for supplier invoice work queue tag assignment rule.
 * @subpackage Structs
 */
class Supplier_Invoice_Work_Queue_Tag_Assignment_RuleType extends AbstractStructBase
{
    /**
     * The Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Invoice Work Queue Assignment Rule.
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_RuleObjectType
     */
    public $Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference;
    /**
     * The Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data
     * Meta information extracted from the WSDL
     * - documentation: Element holding supplier invoice work queue tag assignment rule data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType[]
     */
    public $Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data;
    /**
     * Constructor method for Supplier_Invoice_Work_Queue_Tag_Assignment_RuleType
     * @uses Supplier_Invoice_Work_Queue_Tag_Assignment_RuleType::setSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference()
     * @uses Supplier_Invoice_Work_Queue_Tag_Assignment_RuleType::setSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data()
     * @param \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_RuleObjectType $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference
     * @param \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType[] $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data
     */
    public function __construct(\StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_RuleObjectType $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference = null, array $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data = array())
    {
        $this
            ->setSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference)
            ->setSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data);
    }
    /**
     * Get Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference value
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_RuleObjectType|null
     */
    public function getSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference()
    {
        return $this->Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference;
    }
    /**
     * Set Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference value
     * @param \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_RuleObjectType $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_RuleType
     */
    public function setSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference(\StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_RuleObjectType $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference = null)
    {
        $this->Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference = $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Reference;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data value
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType[]|null
     */
    public function getSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data()
    {
        return $this->Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataForArrayConstraintsFromSetSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Work_Queue_Tag_Assignment_RuleTypeSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Work_Queue_Tag_Assignment_RuleTypeSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataItem instanceof \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType) {
                $invalidValues[] = is_object($supplier_Invoice_Work_Queue_Tag_Assignment_RuleTypeSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataItem) ? get_class($supplier_Invoice_Work_Queue_Tag_Assignment_RuleTypeSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Work_Queue_Tag_Assignment_RuleTypeSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataItem), var_export($supplier_Invoice_Work_Queue_Tag_Assignment_RuleTypeSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType[] $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_RuleType
     */
    public function setSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data(array $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataArrayErrorMessage = self::validateSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataForArrayConstraintsFromSetSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data))) {
            throw new \InvalidArgumentException($supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data = $supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType $item
     * @return \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_RuleType
     */
    public function addToSupplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data(\StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Work_Queue_Tag_Assignment_Rule_Data[] = $item;
        return $this;
    }
}
