<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resume_Asset_Depreciation_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Returns the asset that had its depreciation resumed.
 * @subpackage Structs
 */
class Resume_Asset_Depreciation_ResponseType extends AbstractStructBase
{
    /**
     * The Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: Returns the asset that had its depreciation resumed.
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType
     */
    public $Asset_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Resume_Asset_Depreciation_ResponseType
     * @uses Resume_Asset_Depreciation_ResponseType::setAsset_Reference()
     * @uses Resume_Asset_Depreciation_ResponseType::setVersion()
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @param string $version
     */
    public function __construct(\StructType\Business_AssetObjectType $asset_Reference = null, $version = null)
    {
        $this
            ->setAsset_Reference($asset_Reference)
            ->setVersion($version);
    }
    /**
     * Get Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getAsset_Reference()
    {
        return $this->Asset_Reference;
    }
    /**
     * Set Asset_Reference value
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @return \StructType\Resume_Asset_Depreciation_ResponseType
     */
    public function setAsset_Reference(\StructType\Business_AssetObjectType $asset_Reference = null)
    {
        $this->Asset_Reference = $asset_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Resume_Asset_Depreciation_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
