<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Plan_for_RequirementsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Requirement(s) from Resource Plan(s) elements including Parameter , reference field (CRF) and Instance values.
 * @subpackage Structs
 */
class Resource_Plan_for_RequirementsType extends AbstractStructBase
{
    /**
     * The Resource_Plan_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resource Plan Reference
     * - minOccurs: 0
     * @var \StructType\Project_Resource_PlanObjectType
     */
    public $Resource_Plan_Reference;
    /**
     * The Resource_Plan_Requirement_Data
     * Meta information extracted from the WSDL
     * - documentation: Resource Plan Requirement Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_Plan_Requirement_DataType[]
     */
    public $Resource_Plan_Requirement_Data;
    /**
     * Constructor method for Resource_Plan_for_RequirementsType
     * @uses Resource_Plan_for_RequirementsType::setResource_Plan_Reference()
     * @uses Resource_Plan_for_RequirementsType::setResource_Plan_Requirement_Data()
     * @param \StructType\Project_Resource_PlanObjectType $resource_Plan_Reference
     * @param \StructType\Resource_Plan_Requirement_DataType[] $resource_Plan_Requirement_Data
     */
    public function __construct(\StructType\Project_Resource_PlanObjectType $resource_Plan_Reference = null, array $resource_Plan_Requirement_Data = array())
    {
        $this
            ->setResource_Plan_Reference($resource_Plan_Reference)
            ->setResource_Plan_Requirement_Data($resource_Plan_Requirement_Data);
    }
    /**
     * Get Resource_Plan_Reference value
     * @return \StructType\Project_Resource_PlanObjectType|null
     */
    public function getResource_Plan_Reference()
    {
        return $this->Resource_Plan_Reference;
    }
    /**
     * Set Resource_Plan_Reference value
     * @param \StructType\Project_Resource_PlanObjectType $resource_Plan_Reference
     * @return \StructType\Resource_Plan_for_RequirementsType
     */
    public function setResource_Plan_Reference(\StructType\Project_Resource_PlanObjectType $resource_Plan_Reference = null)
    {
        $this->Resource_Plan_Reference = $resource_Plan_Reference;
        return $this;
    }
    /**
     * Get Resource_Plan_Requirement_Data value
     * @return \StructType\Resource_Plan_Requirement_DataType[]|null
     */
    public function getResource_Plan_Requirement_Data()
    {
        return $this->Resource_Plan_Requirement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Plan_Requirement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Plan_Requirement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Plan_Requirement_DataForArrayConstraintsFromSetResource_Plan_Requirement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Plan_for_RequirementsTypeResource_Plan_Requirement_DataItem) {
            // validation for constraint: itemType
            if (!$resource_Plan_for_RequirementsTypeResource_Plan_Requirement_DataItem instanceof \StructType\Resource_Plan_Requirement_DataType) {
                $invalidValues[] = is_object($resource_Plan_for_RequirementsTypeResource_Plan_Requirement_DataItem) ? get_class($resource_Plan_for_RequirementsTypeResource_Plan_Requirement_DataItem) : sprintf('%s(%s)', gettype($resource_Plan_for_RequirementsTypeResource_Plan_Requirement_DataItem), var_export($resource_Plan_for_RequirementsTypeResource_Plan_Requirement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Plan_Requirement_Data property can only contain items of type \StructType\Resource_Plan_Requirement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Plan_Requirement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Plan_Requirement_DataType[] $resource_Plan_Requirement_Data
     * @return \StructType\Resource_Plan_for_RequirementsType
     */
    public function setResource_Plan_Requirement_Data(array $resource_Plan_Requirement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Plan_Requirement_DataArrayErrorMessage = self::validateResource_Plan_Requirement_DataForArrayConstraintsFromSetResource_Plan_Requirement_Data($resource_Plan_Requirement_Data))) {
            throw new \InvalidArgumentException($resource_Plan_Requirement_DataArrayErrorMessage, __LINE__);
        }
        $this->Resource_Plan_Requirement_Data = $resource_Plan_Requirement_Data;
        return $this;
    }
    /**
     * Add item to Resource_Plan_Requirement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Plan_Requirement_DataType $item
     * @return \StructType\Resource_Plan_for_RequirementsType
     */
    public function addToResource_Plan_Requirement_Data(\StructType\Resource_Plan_Requirement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Plan_Requirement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Plan_Requirement_Data property can only contain items of type \StructType\Resource_Plan_Requirement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Plan_Requirement_Data[] = $item;
        return $this;
    }
}
