<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_Acknowledgement_Response_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Purchase Order Acknowledgements Response Data
 * @subpackage Structs
 */
class Purchase_Order_Acknowledgement_Response_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Acknowledgement
     * Meta information extracted from the WSDL
     * - documentation: Element containing Purchase Order Acknowledgement Data and all Purchase Order Acknowledgement Lines.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Acknowledgement_OutboundType[]
     */
    public $Purchase_Order_Acknowledgement;
    /**
     * Constructor method for Purchase_Order_Acknowledgement_Response_DataType
     * @uses Purchase_Order_Acknowledgement_Response_DataType::setPurchase_Order_Acknowledgement()
     * @param \StructType\Purchase_Order_Acknowledgement_OutboundType[] $purchase_Order_Acknowledgement
     */
    public function __construct(array $purchase_Order_Acknowledgement = array())
    {
        $this
            ->setPurchase_Order_Acknowledgement($purchase_Order_Acknowledgement);
    }
    /**
     * Get Purchase_Order_Acknowledgement value
     * @return \StructType\Purchase_Order_Acknowledgement_OutboundType[]|null
     */
    public function getPurchase_Order_Acknowledgement()
    {
        return $this->Purchase_Order_Acknowledgement;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Acknowledgement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Acknowledgement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_AcknowledgementForArrayConstraintsFromSetPurchase_Order_Acknowledgement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Acknowledgement_Response_DataTypePurchase_Order_AcknowledgementItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Acknowledgement_Response_DataTypePurchase_Order_AcknowledgementItem instanceof \StructType\Purchase_Order_Acknowledgement_OutboundType) {
                $invalidValues[] = is_object($purchase_Order_Acknowledgement_Response_DataTypePurchase_Order_AcknowledgementItem) ? get_class($purchase_Order_Acknowledgement_Response_DataTypePurchase_Order_AcknowledgementItem) : sprintf('%s(%s)', gettype($purchase_Order_Acknowledgement_Response_DataTypePurchase_Order_AcknowledgementItem), var_export($purchase_Order_Acknowledgement_Response_DataTypePurchase_Order_AcknowledgementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Acknowledgement property can only contain items of type \StructType\Purchase_Order_Acknowledgement_OutboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Acknowledgement value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Acknowledgement_OutboundType[] $purchase_Order_Acknowledgement
     * @return \StructType\Purchase_Order_Acknowledgement_Response_DataType
     */
    public function setPurchase_Order_Acknowledgement(array $purchase_Order_Acknowledgement = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_AcknowledgementArrayErrorMessage = self::validatePurchase_Order_AcknowledgementForArrayConstraintsFromSetPurchase_Order_Acknowledgement($purchase_Order_Acknowledgement))) {
            throw new \InvalidArgumentException($purchase_Order_AcknowledgementArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Acknowledgement = $purchase_Order_Acknowledgement;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Acknowledgement value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Acknowledgement_OutboundType $item
     * @return \StructType\Purchase_Order_Acknowledgement_Response_DataType
     */
    public function addToPurchase_Order_Acknowledgement(\StructType\Purchase_Order_Acknowledgement_OutboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_Acknowledgement_OutboundType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Acknowledgement property can only contain items of type \StructType\Purchase_Order_Acknowledgement_OutboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Acknowledgement[] = $item;
        return $this;
    }
}
